/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.io.*;
import java.util.Hashtable;

import org.apache.log4j.Logger;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.12.2.1 $
 */
class KeyMapFile extends KeyMap
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (KeyMapFile.class);


   /**
    * Constructor for class KeyMapFile
    *
    * @param aKeytable  No description provided
    */
   public KeyMapFile (Hashtable aKeytable)
   {
      keyhash = aKeytable;
   }


   /**
    * Constructor for class KeyMapFile
    *
    * @param aReader  No description provided
    */
   public KeyMapFile (Reader aReader)
   {
      keyhash = new Hashtable();
      StreamTokenizer st = new StreamTokenizer (new BufferedReader (aReader));
      int keyCode;
      int keyMod;
      String actName;
      st.slashSlashComments (true);
      while (true)
      {
         try
         {
            ioassert (st.nextToken() == StreamTokenizer.TT_NUMBER);
            keyMod = (int) st.nval;
            if (keyMod < 0)
            {
               break;
            }
            ioassert (st.nextToken() == StreamTokenizer.TT_NUMBER);
            keyCode = (int) st.nval;
            ioassert (st.nextToken() == StreamTokenizer.TT_WORD);
            actName = st.sval;
            keyhash.put (new KeyObject (keyMod, keyCode), actName);
         }
         catch (IOException e)
         {
            if (log.isInfoEnabled())
            {
               log.info ("Error in keyboard configuration file at line"
                  + st.lineno());
            }
            break;
         }
      }

      if (log.isInfoEnabled())
      {
         log.info ("Finished reading keyboard definition - read "
            + keyhash.size() + " entries");
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param flag          No description provided
    * @throws IOException  Exception description not provided
    */
   private void ioassert (boolean flag) throws IOException
   {
      if (!flag)
      {
         throw new IOException();
      }
   }

}

/*
 * $Log: KeyMapFile.java,v $
 * Revision 1.12.2.1  2005/09/30 18:57:14  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
