/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.11 $
 */
public class Manifesto
{

// manifest data

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector entries = new Vector();

// read a manifest from a file

   /**
    * Constructor for class Manifesto
    *
    * @param is            No description provided
    * @throws IOException  Exception description not provided
    */
   public Manifesto (InputStream is) throws IOException
   {
      for (; ; )
      {
         ManifestItem m = new ManifestItem();
         if (m.read (is))
         {
            entries.addElement (m);
         }
         else
         {
            break;
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void dump()
   {
      Enumeration enumeration = entries();
      while (enumeration.hasMoreElements())
      {
         ManifestItem mi = (ManifestItem) enumeration.nextElement();
         System.out.println (mi.toString());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Enumeration entries()
   {
      return entries.elements();
   }

}

/*
 * $Log: Manifesto.java,v $
 * Revision 1.11  2004/11/08 19:16:17  trinet
 * changed saving of FSAProperties, added String support for Maps in BasicIncrement, some cleanup
 *
 */
