/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public class TextFrame extends JFrame implements WindowListener
{
   // the parent

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   mpEDIT mpEdit;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   ResourceBundle strings;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   DocMan docMan;

   // these three .. no four! .. four objects form the main window

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JScrollBar horiz;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JScrollBar vert;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextMenu textMenu;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextCanvas textCanvas;
   //   private ToolBar toolBar;

   /**
    * Constructor for class TextFrame
    *
    * @param mpe    No description provided
    * @param str    No description provided
    * @param pr     No description provided
    * @param doc    No description provided
    * @param ruler  No description provided
    */
   public TextFrame (mpEDIT mpe, ResourceBundle str, Properties pr, DocMan doc, Ruler ruler)
   {
      super.setTitle ("mpEDIT");

      mpEdit = mpe;
      strings = str;
      docMan = doc;

      //      toolBar = new ToolBar ();
      //getContentPane().add ("North", toolBar);

      vert = new JScrollBar (Adjustable.VERTICAL);
      getContentPane().add ("East", vert);

      horiz = new JScrollBar (Adjustable.HORIZONTAL);
      getContentPane().add ("South", horiz);

      textCanvas = new TextCanvas (mpe, doc, this, horiz, vert, ruler);
      getContentPane().add ("Center", textCanvas);

      textMenu = new TextMenu (mpEdit, strings, docMan, this);
      setJMenuBar (textMenu);

      addWindowListener (this);

   }


   /**
    * Get the canvas attribute of the TextFrame object
    *
    * @return   The canvas value
    */
   public TextCanvas getCanvas()
   {
      return textCanvas;
   }


   /**
    * Get the place attribute of the TextFrame object
    *
    * @param size  No description provided
    * @return      The place value
    */
   public Point getPlace (Dimension size)
   {
      return mpEdit.getPlace (size);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void clearCanvas()
   {
      textCanvas.clear();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void redoCanvas()
   {
      textCanvas.redoCanvas();
      textCanvas.repaint();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void legalizeCursor()
   {
      textCanvas.legalizeCursor();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void release_cursor()
   {
      textCanvas.release_cursor();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void pause_cursor()
   {
      textCanvas.pause_cursor();
   }


   /**
    * Sets the pos attribute of the TextFrame object
    *
    * @param tp  The new pos value
    */
   public void setPos (TextPosition tp)
   {
      textCanvas.setPos (tp);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param line  No description provided
    */
   public void showLine (int line)
   {
      textCanvas.Goto (line + 1); // showLine is 0-based, Goto is 1-based

   }


   /**
    * Sets the readOnly attribute of the TextFrame object
    *
    * @param readOnly  The new readOnly value
    */
   public void setReadOnly (boolean readOnly)
   {
      // this would be enough for menus and toolbars in future, but
      // we may want to notify somebody else - some readOnly led
      // or something  - AB
      textCanvas.setReadOnly (readOnly);
   }

   // add current filename to window title

   /**
    * Sets the title attribute of the TextFrame object
    *
    * @param name  The new title value
    */
   public void setTitle (String name)
   {
      super.setTitle ("mpEDIT - " + name);
   }

   // add the 1.1 WindowListener stuff

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   long activeMillis = 0;


   /**
    * Get the activeMillis attribute of the TextFrame object
    *
    * @return   The activeMillis value
    */
   public long getActiveMillis()
   {
      return activeMillis;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeiconified (WindowEvent event)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowIconified (WindowEvent event)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowActivated (WindowEvent event)
   {
      activeMillis = System.currentTimeMillis();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeactivated (WindowEvent event)
   {
      activeMillis = 0;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowOpened (WindowEvent event)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosed (WindowEvent event)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosing (WindowEvent event)
   {
      docMan.closeFrame (this);
   }
}

/*
 * $Log: TextFrame.java,v $
 * Revision 1.13  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
