/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.datatransfer.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;

import javax.swing.*;

import org.apache.log4j.Logger;


/**
 * TextMenu is a fairly large class which creates and first handles events from all menus.
 * This may all change when I add toobars.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.17.2.1 $
 */
public class TextMenu extends JMenuBar
    implements ActionListener,
   ClipboardOwner
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (TextMenu.class);

   // remember who our friends are

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private mpEDIT mpEdit;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextFrame textFrame;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextCanvas textCanvas;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DocMan docMan;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ResourceBundle strings;

   // internal data

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JMenu fileMenu;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JMenu editMenu;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JMenu optionMenu;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JMenu windowMenu;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JMenu helpMenu;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Clipboard clipboard;

   // constructor puts together UI

   /**
    * Constructor for class TextMenu
    *
    * @param mpe  No description provided
    * @param str  No description provided
    * @param doc  No description provided
    * @param tf   No description provided
    */
   public TextMenu (mpEDIT mpe, ResourceBundle str, DocMan doc, TextFrame tf)
   {
      super();

      mpEdit = mpe;
      strings = str;
      docMan = doc;
      //      toolBar = b;
      textFrame = tf;
      textCanvas = textFrame.getCanvas();

      clipboard = textFrame.getToolkit().getSystemClipboard();

      makeFileMenu();
      makeEditMenu();
      makeOptionMenu();
      makeWindowMenu();
      makeHelpMenu();

      docMan.addTextMenu (this);
      textCanvas.setTextMenu (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: mksoft $
    * @version   $Revision: 1.17.2.1 $
    */
   private class MenuItemControl implements PropertyChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      JMenuItem menuItem;


      /**
       * Constructor for class MenuItemControl
       *
       * @param mi  No description provided
       */
      public MenuItemControl (JMenuItem mi)
      {
         menuItem = mi;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param evt  No description provided
       */
      public void propertyChange (PropertyChangeEvent evt)
      {
         if (evt.getPropertyName().equals (MpAction.ENABLED))
         {
            menuItem.setEnabled ( ((Boolean) evt.getNewValue()).booleanValue());
         }
         else if (evt.getPropertyName().equals (MpAction.NAME))
         {
            menuItem.setText ((String) evt.getNewValue());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param actionId  No description provided
    * @return          No description provided
    */
   private JMenuItem makeMenuItem (String actionId)
   {
      MpAction action = textCanvas.getMpAction (actionId);
      if (action == null)
      {
         if (log.isInfoEnabled())
         {
            log.info ("Non existent action requested for menu: " +
               actionId);
         }
         return new JMenuItem ("UNKNOWN!!!");
      }
      JMenuItem mi = new JMenuItem (action.getName());
      mi.addActionListener (action);
      action.addPropertyChangeListener (new MenuItemControl (mi));
      return mi;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void makeFileMenu()
   {
      fileMenu = new JMenu ("File");
      fileMenu.getPopupMenu().setLightWeightPopupEnabled (false);

      fileMenu.add (makeMenuItem ("document-save"));
      fileMenu.addSeparator();
      fileMenu.add (makeMenuItem ("document-print-dialog"));
      fileMenu.addSeparator();
      fileMenu.add (makeMenuItem ("frame-close"));

      add (fileMenu);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void makeEditMenu()
   {
      editMenu = new JMenu ("Edit");
      editMenu.getPopupMenu().setLightWeightPopupEnabled (false);
      editMenu.add (makeMenuItem ("undo"));
      editMenu.add (makeMenuItem ("redo"));
      editMenu.addSeparator();
      editMenu.add (makeMenuItem ("selection-copy"));
      editMenu.add (makeMenuItem ("selection-cut"));
      editMenu.add (makeMenuItem ("buffer-paste"));
      editMenu.addSeparator();
      editMenu.add (makeMenuItem ("find-dialog"));
      editMenu.add (makeMenuItem ("replace-dialog"));
      editMenu.add (makeMenuItem ("goto-dialog"));

      add (editMenu);
   }

   // beans

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void makeOptionMenu()
   {
      optionMenu = new JMenu ("Options");
      optionMenu.getPopupMenu().setLightWeightPopupEnabled (false);
      optionMenu.add (makeMenuItem ("properties-dialog"));

      add (optionMenu);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void makeWindowMenu()
   {
      windowMenu = new JMenu ("Window");
      windowMenu.getPopupMenu().setLightWeightPopupEnabled (false);
      windowMenu.add (makeMenuItem ("frame-clone"));
      add (windowMenu);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void makeHelpMenu()
   {
      helpMenu = new JMenu ("Help");
      helpMenu.getPopupMenu().setLightWeightPopupEnabled (false);
      helpMenu.add (makeMenuItem ("help-about-dialog"));
      add (helpMenu);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean toolButtonIgnore()
   {
      // ignore buttons if frame has been active < 100 milliseconds

      long time = textFrame.getActiveMillis();

      if (time == 0)
      {
         return true;
      }

      return  ( (System.currentTimeMillis() - time) < 100);
   }


   // action handler, part of std java event handling

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   public void actionPerformed (ActionEvent evt)
   {
      String cmd = evt.getActionCommand();

      if (cmd == null)
      {
         return;
      }

      // the only actions now handled by this class are beans

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param pat  No description provided
    */
   public void CloseFindDialog (String pat)
   {
      mpEdit.addSearchPattern (pat);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param pat  No description provided
    * @param rep  No description provided
    */
   public void CloseReplaceDialog (String pat, String rep)
   {
      mpEdit.addSearchPattern (pat);
      mpEdit.addSearchPattern (rep);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param clipboard  No description provided
    * @param contents   No description provided
    */
   public void lostOwnership (Clipboard clipboard, Transferable contents)
   {
   }


   /**
    * Get the strings attribute of the TextMenu object
    *
    * @return   The strings value
    */
   ResourceBundle getStrings()
   {
      return strings;
   }


   /**
    * Get the clipboard attribute of the TextMenu object
    *
    * @return   The clipboard value
    */
   Clipboard getClipboard()
   {
      return clipboard;
   }

}

/*
 * $Log: TextMenu.java,v $
 * Revision 1.17.2.1  2005/09/30 18:57:15  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
