/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.packagediagrams.unparse;

import java.util.Set;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.ColumnRowLayout;
import de.uni_paderborn.fujaba.fsa.swing.DiagramKindJComboBoxLabel;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.packagediagrams.DiagramUsage;
import de.uni_paderborn.fujaba.packagediagrams.PackageDiagram;


/**
 * Class for displaying a {@link DiagramUsage} on screen. A DiagramUsage is a reference to
 * a Diagram from within a Package Diagram.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.29.2.1 $
 * @see       DiagramUsage
 * @see       PackageDiagram
 */
public class UMDiagramUsage extends AbstractUnparseModule
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMDiagramUsage.class);


   /**
    * Get the childProperties attribute of the UMDiagramUsage object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      // props.add("diagram");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      if (log.isInfoEnabled())
      {
         log.info ("Trying to unparse diagram usage " + incr);
      }
      FSAPanel panel = null;
      DiagramUsage usage = (DiagramUsage) incr;

      // the main panel for the UsecaseActor
      panel = new FSAPanel (incr, getMainFsaName(), parent.getJComponent());
      DiagramUsage tempUsage = (DiagramUsage) incr;
      if (tempUsage.getX() != -1)
      {
         panel.setLocation (tempUsage.getX(), tempUsage.getY());
      }

      panel.setLayout (new ColumnRowLayout (2, ColumnRowLayout.COLUMN));
      panel.setOpaque (false);
      // panel.setBorder (new LineBorder (Color.black));

      // place in a layer relative to other Use Case Diagram components
      /*
       *  panel.setLayer (LAYER);
       *  panel.setDragLayer (DRAG_LAYER);
       */
      // Create a combobox for diagramchoosing.
      FSAComboBoxLabel iconLabel = new FSAComboBoxLabel (incr,
         "diagramKind",
         panel.getJComponent(),
         new DiagramKindJComboBoxLabel());
      iconLabel.addToUpdater (iconLabel.createDefaultUpdater());
      iconLabel.setForeground (FSAObject.COLOR_FOREGROUND);
      iconLabel.setBackground (FSAObject.COLOR_BACKGROUND);
      panel.addToChildren (iconLabel);

      // the usage's name, centered
      FSATextFieldLabel usageNameTextField = new FSATextFieldLabel (usage, "name", panel.getJComponent());
      usageNameTextField.setHorizontalAlignment (SwingConstants.CENTER);
      usageNameTextField.setOpaque (false);

      // default updater handles text changes
      usageNameTextField.addToUpdater
          (usageNameTextField.createDefaultUpdater());
      panel.addToChildren (usageNameTextField);

      // add mouse listener for moving and selecting
      JComponent jPanel = panel.getJComponent();
      AscendDescendMouseHandler.addMouseInputListener (jPanel, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DragMouseListener.get());

      return panel;
   }


   /**
    * Get the containerForProperty attribute of the UMDiagramUsage object
    *
    * @param name  No description provided
    * @return      The containerForProperty value
    */
   public String getContainerForProperty (String name)
   {
      // By default, diagram shall not be shown within the package diagram
      // someone should add an option to enable this on demand
      //
      // if ("diagram".equals (name))
      // {
      //   return getMainFsaName();
      // }
      return super.getContainerForProperty (name);
   }
}

/*
 * $Log: UMDiagramUsage.java,v $
 * Revision 1.29.2.1  2005/09/30 18:57:35  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
