/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences;

import java.beans.PropertyChangeListener;



/**
 * Provides an abstract definition for an options class.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.6 $
 */
public abstract class AbstractPreferences
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean modified;


   /**
    * Constructor for class AbstractPreferences
    */
   public AbstractPreferences()
   {
      modified = false;
   } // AbstractPreferences


   /**
    * Get the modified attribute of the AbstractPreferences object
    *
    * @return   The modified value
    */
   public boolean isModified()
   {
      return modified;
   } // isModified


   /**
    * Sets the modified attribute of the AbstractPreferences object
    *
    * @param value  The new modified value
    */
   public void setModified (boolean value)
   {
      modified = value;
   } // resetModified


   /**
    * Sets the defaults attribute of the AbstractPreferences object
    */
   public abstract void setDefaults();


   /**
    * To be overridden by inheriting classes. Method call should be delegated like this: PreferencesProperties.get(PROPERTY_KEY).addPropertyChangeListener(propertyName,
    * listener); with the appropreate PROPERTY_KEY of the Fujaba core or the plugin.
    *
    * @param propertyName  The name of the property to listen for
    * @param listener      The property listener
    */
   public void addPropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // do not uncomment!
      // PreferencesProperties.get(PROPERTY_KEY).addPropertyChangeListener(propertyName, listener);
   }


   /**
    * To be overridden by inheriting classes. Method call should be delegated like this: PreferencesProperties.get(PROPERTY_KEY).removePropertyChangeListener(propertyName,
    * listener); with the appropreate PROPERTY_KEY of the Fujaba core or the plugin.
    *
    * @param propertyName  The name of the property to listen for
    * @param listener      The property listener
    */
   public void removePropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // do not uncomment!
      // PreferencesProperties.get(PROPERTY_KEY).removePropertyChangeListener(propertyName, listener);
   }
}

/*
 * $Log: AbstractPreferences.java,v $
 * Revision 1.6  2004/10/20 17:50:07  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
