/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.18 $
 */
public class GeneralPreferences extends AbstractPreferences
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PROPERTY_NAME = "General.";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String WORKSPACE_FOLDER = "WorkspaceFolder";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String TEMPORARY_FOLDER = "TemporaryFolder";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String VIEW_FILTER_FOLDER = "ViewFilterFolder";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String JDK_FOLDER = "JDKFolder";
   /**
    * Property for ignoring wrong/missing JDK Folder
    */
   private final static String JDK_FOLDER_IGNORE = "JDKFolderIgnore";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String USE_EXT_EDITOR = "UseExtEditor";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String EXTERNAL_EDITOR = "ExternalEditor";

   /**
    * versioning
    */
   public final static String REPOSITORY_ACTIVATED = "RepositoryActivated";
   /**
    * recover
    */
   public final static String RECOVER_ACTIVATED = "RecoverActivated";
   /**
    * fpr (buttons in gui)
    */
   public final static String FPR_ACTIVATED = "FPRActivated";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CREATE_PROJECT_BACKUP = "CreateProjectBackup";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String EXPORT_TO_WORKSPACE_FOLDER = "ExportToWorkspaceFolder";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String EXPORT_TO_PROJECT_FOLDER = "ExportToProjectFolder";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String EXPORT_TO_TEMPORARY_FOLDER = "ExportToTemporaryFolder";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String COMMAND_LINE_PARSING = "CommandLineParsing";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PROCESS_HISTORY = "ProcessHistory";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LOOK_AND_FEEL = "LookAndFeel";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String DEF_WORKSPACE_FOLDER = System.getProperty ("user.home");
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String DEF_TEMPORARY_FOLDER = System.getProperty ("java.io.tmpdir");
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String DEF_VIEW_FILTER_FOLDER = DEF_WORKSPACE_FOLDER + System.getProperty ("file.separator") + "filters";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String DEF_JDK_FOLDER = "";
   /**
    * Default for wrong/missing JDK folder
    */
   private final static boolean DEF_JDK_FOLDER_IGNORE = false;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_USE_EXT_EDITOR = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String DEF_EXTERNAL_EDITOR = "";

   /**
    * versioning
    */
   private final static boolean DEF_REPOSITORY_ACTIVATED = false;

   /**
    * recover
    */
   private final static boolean DEF_RECOVER_ACTIVATED = false;

   /**
    * fpr (buttons in gui)
    */
   private final static boolean DEF_FPR_ACTIVATED = true;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_CREATE_PROJECT_BACKUP = true;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_EXPORT_TO_WORKSPACE_FOLDER = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_EXPORT_TO_PROJECT_FOLDER = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_EXPORT_TO_TEMPORARY_FOLDER = false;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_COMMAND_LINE_PARSING = true;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String DEF_LOOK_AND_FEEL = "Metal";

   /**
    * This is the singleton instance.
    */
   private static GeneralPreferences theOptionsGeneral;


   /**
    * This is a singleton class. Use get() to get an instance from this class.
    */
   private GeneralPreferences() { }


   /**
    * @return   the singleton instance
    */
   public static GeneralPreferences get()
   {
      if (theOptionsGeneral == null)
      {
         theOptionsGeneral = new GeneralPreferences();
      }

      return theOptionsGeneral;
   }


   /**
    * @see   AbstractPreferences#setDefaults()
    */
   public void setDefaults()
   {
      PreferencesProperties options = PreferencesProperties.get();

      options.putSetting (PROPERTY_NAME + WORKSPACE_FOLDER, DEF_WORKSPACE_FOLDER);
      options.putSetting (PROPERTY_NAME + TEMPORARY_FOLDER, DEF_TEMPORARY_FOLDER);
      options.putSetting (PROPERTY_NAME + VIEW_FILTER_FOLDER, DEF_VIEW_FILTER_FOLDER);
      options.putSetting (PROPERTY_NAME + JDK_FOLDER, DEF_JDK_FOLDER);
      options.putSetting (PROPERTY_NAME + JDK_FOLDER_IGNORE, DEF_JDK_FOLDER_IGNORE);

      options.putSetting (PROPERTY_NAME + USE_EXT_EDITOR, DEF_USE_EXT_EDITOR);
      options.putSetting (PROPERTY_NAME + EXTERNAL_EDITOR, DEF_EXTERNAL_EDITOR);

      options.putSetting (PROPERTY_NAME + REPOSITORY_ACTIVATED, DEF_REPOSITORY_ACTIVATED);
      options.putSetting (PROPERTY_NAME + CREATE_PROJECT_BACKUP, DEF_CREATE_PROJECT_BACKUP);

      options.putSetting (PROPERTY_NAME + EXPORT_TO_WORKSPACE_FOLDER, DEF_EXPORT_TO_WORKSPACE_FOLDER);
      options.putSetting (PROPERTY_NAME + EXPORT_TO_PROJECT_FOLDER, DEF_EXPORT_TO_PROJECT_FOLDER);
      options.putSetting (PROPERTY_NAME + EXPORT_TO_TEMPORARY_FOLDER, DEF_EXPORT_TO_TEMPORARY_FOLDER);

      options.putSetting (PROPERTY_NAME + COMMAND_LINE_PARSING, DEF_COMMAND_LINE_PARSING);
   }


   // ----------------------------------------------------------------------------
   // property change support
   // ----------------------------------------------------------------------------

   /**
    * Access method for an one to n association.
    *
    * @param propertyName  The object added.
    * @param listener      The object added.
    */
   public void addPropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().addPropertyChangeListener (propertyName, listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param propertyName  No description provided
    * @param listener      No description provided
    */
   public void removePropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().removePropertyChangeListener (propertyName, listener);
   }


   // ----------------------------------------------------------------------------
   // getter and setter for the properties
   // ----------------------------------------------------------------------------

   /**
    * Sets the workspaceFolder attribute of the GeneralPreferences object
    *
    * @param value  The new workspaceFolder value
    */
   public void setWorkspaceFolder (String value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + WORKSPACE_FOLDER, value);
      setModified (true);
   }


   /**
    * Get the workspaceFolder attribute of the GeneralPreferences object
    *
    * @return   The workspaceFolder value
    */
   public String getWorkspaceFolder()
   {
      return PreferencesProperties.get().getSetting (PROPERTY_NAME + WORKSPACE_FOLDER, DEF_WORKSPACE_FOLDER);
   }


   /**
    * Sets the temporaryFolder attribute of the GeneralPreferences object
    *
    * @param value  The new temporaryFolder value
    */
   public void setTemporaryFolder (String value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + TEMPORARY_FOLDER, value);
      setModified (true);
   }


   /**
    * Get the temporaryFolder attribute of the GeneralPreferences object
    *
    * @return   The temporaryFolder value
    */
   public String getTemporaryFolder()
   {
      return PreferencesProperties.get().getSetting (PROPERTY_NAME + TEMPORARY_FOLDER, DEF_TEMPORARY_FOLDER);
   }


   /**
    * Sets the viewFilterFolder attribute of the GeneralPreferences object
    *
    * @param value  The new viewFilterFolder value
    */
   public void setViewFilterFolder (String value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + VIEW_FILTER_FOLDER, value);
      setModified (true);
   }


   /**
    * Get the viewFilterFolder attribute of the GeneralPreferences object
    *
    * @return   The viewFilterFolder value
    */
   public String getViewFilterFolder()
   {
      return PreferencesProperties.get().getSetting (PROPERTY_NAME + VIEW_FILTER_FOLDER, DEF_VIEW_FILTER_FOLDER);
   }


   /**
    * Sets the jdkFolder attribute of the GeneralPreferences object
    *
    * @param value  The new jdkFolder value
    */
   public void setJDKFolder (String value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + JDK_FOLDER, value);
      setModified (true);
   }


   /**
    * Get the jdkFolder attribute of the GeneralPreferences object
    *
    * @return   The jdkFolder value
    */
   public String getJDKFolder()
   {
      String jdkFolder = PreferencesProperties.get().getSetting (PROPERTY_NAME + JDK_FOLDER, DEF_JDK_FOLDER);

      String checkedJdkFolder = checkJDKFolder (jdkFolder);
      if (!jdkFolder.equals (checkedJdkFolder))
      {
         setJDKFolder (checkedJdkFolder);
         PreferencesProperties.saveAll();
      }
      return checkedJdkFolder;
   }


   /**
    * Sets the jdkFoldeIgnored attribute of the GeneralPreferences object
    *
    * @param value  The new jdkFolderIgnored value
    */
   public void setJDKFolderIgnored (boolean value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + JDK_FOLDER_IGNORE, value);
      setModified (true);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param jdkFolder  No description provided
    * @return           No description provided
    */
   private String checkJDKFolder (String jdkFolder)
   {
      if (!isJDKFolderIgnored())
      {
         String message;
         if (jdkFolder.length() > 0)
         {
            //check if path exists
            File jdk = new File (jdkFolder);
            if (jdk.isDirectory())
            {
               //try to find tools.jar in the jdk
               File toolsjar = new File (jdkFolder + System.getProperty ("file.separator") + "lib" + System.getProperty ("file.separator") + "tools.jar");
               if (toolsjar.exists())
               {
                  //everything is fine
                  message = null;
               }
               else
               {
                  //tools.jar not in jdk folder
                  message = "The file 'tools.jar' was not found in the library folder of the JDK. Please specify the path\n" +
                     "to a valid JDK (in Fujaba under Options/Preferences). Some plugins (e.g. DOBS) and the default";
               }
            }
            else
            {
               //jdk folder incorrect path
               message = "The JDK folder that was specified (in Fujaba under Options/Preferences) does not exist! Please specify the path\n" +
                  "to a valid JDK. Some plugins (e.g. DOBS) and the default compiler require the tools.jar that comes with the JDK.";
            }
         }
         else
         {
            //jdk folder not specified
            message = "The JDK folder is not set. Please specify the path to a valid JDK (in Fujaba under Options/Preferences).\n" +
               "Some plugins (e.g. DOBS) and the default compiler require the tools.jar that comes with the JDK.";
         }
         if (message != null)
         {
            final String specify = "Specify now";
            final String ignoreForever = "Ignore forever";
            final String ignore = "Ignore";
            final String[] choices = new String[]{specify, ignoreForever, ignore};

            final int choice = JOptionPane.showOptionDialog (FrameMain.get(), message, "JDK Folder", 0, JOptionPane.QUESTION_MESSAGE, null, choices, specify);
            if (choice == 0)
            {
               // create a filechooser
               File file = new File (System.getProperty ("user.dir"), "*.*");
               JFileChooser fileChooser = new JFileChooser (file);
               fileChooser.setFileSelectionMode (JFileChooser.DIRECTORIES_ONLY);
               final File dir = new File (jdkFolder);
               if (dir.isDirectory())
               {
                  fileChooser.setCurrentDirectory (dir);
               }

               // open the filechooser
               if (fileChooser.showOpenDialog (FrameMain.get().getFrame()) == JFileChooser.APPROVE_OPTION)
               {
                  file = fileChooser.getSelectedFile();
                  if (file.exists())
                  {
                     jdkFolder = checkJDKFolder (file.getPath());
                  }
               }
               else
               {
                  jdkFolder = checkJDKFolder (jdkFolder);
               }
            }
            else if (choice == 1)
            {
               setJDKFolderIgnored (true);
               PreferencesProperties.saveAll();
            }
         }
      }
      return jdkFolder;
   }


   /**
    * Get the jDKFolderIgnored attribute of the GeneralPreferences object
    *
    * @return   The jDKFolderIgnored value
    */
   public boolean isJDKFolderIgnored()
   {
      return Boolean.valueOf (PreferencesProperties.get().getSetting (PROPERTY_NAME + JDK_FOLDER_IGNORE, "" + DEF_JDK_FOLDER_IGNORE)).booleanValue();
   }


   /**
    * Sets the useExtEditor attribute of the GeneralPreferences object
    *
    * @param value  The new useExtEditor value
    */
   public void setUseExtEditor (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + USE_EXT_EDITOR, DEF_USE_EXT_EDITOR) != value)
      {
         options.putSetting (PROPERTY_NAME + USE_EXT_EDITOR, value);
         setModified (true);
      }
   }


   /**
    * Get the useExtEditor attribute of the GeneralPreferences object
    *
    * @return   The useExtEditor value
    */
   public boolean isUseExtEditor()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + USE_EXT_EDITOR, DEF_USE_EXT_EDITOR);
   }


   /**
    * Sets the externalEditor attribute of the GeneralPreferences object
    *
    * @param value  The new externalEditor value
    */
   public void setExternalEditor (String value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + EXTERNAL_EDITOR, value);
      setModified (true);
   }


   /**
    * Get the externalEditor attribute of the GeneralPreferences object
    *
    * @return   The externalEditor value
    */
   public String getExternalEditor()
   {
      return PreferencesProperties.get().getSetting (PROPERTY_NAME + EXTERNAL_EDITOR, DEF_EXTERNAL_EDITOR);
   }


   /**
    * Sets the repositoryActivated attribute of the GeneralPreferences object
    *
    * @param value  The new repositoryActivated value
    */
   public void setRepositoryActivated (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + REPOSITORY_ACTIVATED, DEF_REPOSITORY_ACTIVATED) != value)
      {
         options.putSetting (PROPERTY_NAME + REPOSITORY_ACTIVATED, value);
         setModified (true);
      }
   }


   /**
    * Get the repositoryActivated attribute of the GeneralPreferences object
    *
    * @return   The repositoryActivated value
    */
   public boolean isRepositoryActivated()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + REPOSITORY_ACTIVATED, DEF_REPOSITORY_ACTIVATED);
   }


   /**
    * @param value  true to activate recover (save immediaty)
    */
   public void setRecoverActivated (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + RECOVER_ACTIVATED, DEF_RECOVER_ACTIVATED) != value)
      {
         options.putSetting (PROPERTY_NAME + RECOVER_ACTIVATED, value);
         setModified (true);
      }
   }


   /**
    * @return   true if recover (save immediately) is activated
    */
   public boolean isRecoverActivated()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + RECOVER_ACTIVATED, DEF_RECOVER_ACTIVATED);
   }


   /**
    * @param value  true to activate fpr save buttons
    */
   public void setFPRActivated (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + FPR_ACTIVATED, DEF_FPR_ACTIVATED) != value)
      {
         options.putSetting (PROPERTY_NAME + FPR_ACTIVATED, value);
         setModified (true);
      }
   }


   /**
    * @return   true if saving as fpr should be possible (by gui)
    */
   public boolean isFPRActivated()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + FPR_ACTIVATED, DEF_FPR_ACTIVATED);
   }


   /**
    * Sets the createProjectBackup attribute of the GeneralPreferences object
    *
    * @param value  The new createProjectBackup value
    */
   public void setCreateProjectBackup (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + CREATE_PROJECT_BACKUP, DEF_CREATE_PROJECT_BACKUP) != value)
      {
         options.putSetting (PROPERTY_NAME + CREATE_PROJECT_BACKUP, value);
         setModified (true);
      }
   }


   /**
    * Get the createProjectBackup attribute of the GeneralPreferences object
    *
    * @return   The createProjectBackup value
    */
   public boolean isCreateProjectBackup()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + CREATE_PROJECT_BACKUP, DEF_CREATE_PROJECT_BACKUP);
   }


   /**
    * Sets the exportToWorkspaceFolder attribute of the GeneralPreferences object
    *
    * @param value  The new exportToWorkspaceFolder value
    */
   public void setExportToWorkspaceFolder (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + EXPORT_TO_WORKSPACE_FOLDER, DEF_EXPORT_TO_WORKSPACE_FOLDER) != value)
      {
         options.putSetting (PROPERTY_NAME + EXPORT_TO_WORKSPACE_FOLDER, value);
         setModified (true);
      }
   }


   /**
    * Get the exportToWorkspaceFolder attribute of the GeneralPreferences object
    *
    * @return   The exportToWorkspaceFolder value
    */
   public boolean isExportToWorkspaceFolder()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + EXPORT_TO_WORKSPACE_FOLDER, DEF_EXPORT_TO_WORKSPACE_FOLDER);
   }


   /**
    * Sets the exportToProjectFolder attribute of the GeneralPreferences object
    *
    * @param value  The new exportToProjectFolder value
    */
   public void setExportToProjectFolder (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + EXPORT_TO_PROJECT_FOLDER, DEF_EXPORT_TO_PROJECT_FOLDER) != value)
      {
         options.putSetting (PROPERTY_NAME + EXPORT_TO_PROJECT_FOLDER, value);
         setModified (true);
      }
   }


   /**
    * Get the exportToProjectFolder attribute of the GeneralPreferences object
    *
    * @return   The exportToProjectFolder value
    */
   public boolean isExportToProjectFolder()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + EXPORT_TO_PROJECT_FOLDER, DEF_EXPORT_TO_PROJECT_FOLDER);
   }


   /**
    * Sets the exportToTemporaryFolder attribute of the GeneralPreferences object
    *
    * @param value  The new exportToTemporaryFolder value
    */
   public void setExportToTemporaryFolder (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + EXPORT_TO_TEMPORARY_FOLDER, DEF_EXPORT_TO_TEMPORARY_FOLDER) != value)
      {
         options.putSetting (PROPERTY_NAME + EXPORT_TO_TEMPORARY_FOLDER, value);
         setModified (true);
      }
   }


   /**
    * Get the exportToTemporaryFolder attribute of the GeneralPreferences object
    *
    * @return   The exportToTemporaryFolder value
    */
   public boolean isExportToTemporaryFolder()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + EXPORT_TO_TEMPORARY_FOLDER, DEF_EXPORT_TO_TEMPORARY_FOLDER);
   }


   /**
    * Sets the commandLineParsing attribute of the GeneralPreferences object
    *
    * @param value  The new commandLineParsing value
    */
   public void setCommandLineParsing (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + COMMAND_LINE_PARSING, DEF_COMMAND_LINE_PARSING) != value)
      {
         options.putSetting (PROPERTY_NAME + COMMAND_LINE_PARSING, value);
         setModified (true);
      }
   }


   /**
    * Get the commandLineParsing attribute of the GeneralPreferences object
    *
    * @return   The commandLineParsing value
    */
   public boolean isCommandLineParsing()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + COMMAND_LINE_PARSING, DEF_COMMAND_LINE_PARSING);
   }


   /**
    * This method sets the pathnames for the ProcessOutputViewer History ComboBox.
    *
    * @param value  The new processHistory value
    */
   public void setProcessHistory (Vector value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + PROCESS_HISTORY, value);
      setModified (true);
   }


   /**
    * This method provides the pathnames for the ProcessOutputViewer History ComboBox.
    *
    * @return   The processHistory value
    */
   public Vector getProcessHistory()
   {
      return PreferencesProperties.get().getVectorSetting (PROPERTY_NAME + PROCESS_HISTORY);
   }


   /**
    * Sets the lookAndFeel attribute of the GeneralPreferences object
    *
    * @param value  The new lookAndFeel value
    */
   public void setLookAndFeel (String value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + LOOK_AND_FEEL, value);
      setModified (true);
   }


   /**
    * Get the lookAndFeel attribute of the GeneralPreferences object
    *
    * @return   The lookAndFeel value
    */
   public String getLookAndFeel()
   {
      return PreferencesProperties.get().getSetting (PROPERTY_NAME + LOOK_AND_FEEL, DEF_LOOK_AND_FEEL);
   }


   /**
    * Returns the folder where generated files are saved.
    *
    * @return   The export folder
    */
   public String getExportFolder()
   {
      if (isExportToWorkspaceFolder())
      {
         return getWorkspaceFolder();
      }
      else if (isExportToProjectFolder())
      {
         return UMLProject.get().getRootDir();
      }
      else
      {
         return getTemporaryFolder();
      }
   }
}

/*
 * $Log: GeneralPreferences.java,v $
 * Revision 1.18  2004/11/17 13:52:45  lowende
 * Methods reordered.
 *
 */
