/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences;

import java.beans.PropertyChangeListener;
import java.util.Hashtable;

import javax.swing.*;

import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class IconsPreferences extends AbstractPreferences
{
   /**
    * This is the properties key for Fujaba's properties.
    */
   public final static String PROPERTY_NAME = "Icons.";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CURRENT_DIR = "CurrentDirectory";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String VIS_ICONS = "VisibilityIcons.";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DOBS_CLASSES = "DobsClasses.";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PUB_METH = "public method";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PUB_FIELD = "public attribute";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PROT_METH = "protected method";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PROT_FIELD = "protected attribute";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PRIV_METH = "private method";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PRIV_FIELD = "private attribute";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PACK_METH = "package method";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PACK_FIELD = "package attribute";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String USER_FIELD = "user attribute";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NO_ENTRY = "no entry";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DEF_CURRENT_DIR = System.getProperty ("user.home");

   /**
    * Indicates, that visibilityIcons have changed in runtime. Don't save this attribute.
    */
   private static boolean visibilityIconsDirty;

   /**
    * The instance of this singleton class. Use OptionsIconChooser.get() to get an instance
    * of this class.
    *
    * @see   #get
    */
   private static IconsPreferences options;


   /**
    * The <B>private</B> constructor for this class. Use OptionsIconChooser.get() to get an
    * instance of this class.
    *
    * @see   #get
    */
   private IconsPreferences()
   {
      visibilityIconsDirty = false;
   } // OptionsIconChooser


   /**
    * This method provides the user the singleton instance of this class.
    *
    * @return   No description provided
    */
   public static synchronized IconsPreferences get()
   {
      if (options == null)
      {
         options = new IconsPreferences();

      }

      return options;
   } // get


   /**
    * Set the default values for all options.
    */
   public synchronized void setDefaults()
   {
      PreferencesProperties options = PreferencesProperties.get();

      Hashtable visIcons = new Hashtable();
      visIcons.put (PUB_METH, "de/uni_paderborn/fujaba/app/images/PublicMethod.gif");
      visIcons.put (PROT_METH, "de/uni_paderborn/fujaba/app/images/ProtectedMethod.gif");
      visIcons.put (PRIV_METH, "de/uni_paderborn/fujaba/app/images/PrivateMethod.gif");
      visIcons.put (PACK_METH, "de/uni_paderborn/fujaba/app/images/PackageMethod.gif");
      visIcons.put (PUB_FIELD, "de/uni_paderborn/fujaba/app/images/PublicAttribute.gif");
      visIcons.put (PROT_FIELD, "de/uni_paderborn/fujaba/app/images/ProtectedAttribute.gif");
      visIcons.put (PRIV_FIELD, "de/uni_paderborn/fujaba/app/images/PrivateAttribute.gif");
      visIcons.put (PACK_FIELD, "de/uni_paderborn/fujaba/app/images/PackageAttribute.gif");
      visIcons.put (USER_FIELD, "de/uni_paderborn/fujaba/app/images/UserAttribute.gif");

      options.putSetting (PROPERTY_NAME, VIS_ICONS, visIcons);
      options.putSetting (PROPERTY_NAME + VIS_ICONS + CURRENT_DIR, DEF_CURRENT_DIR);
      options.putSetting (PROPERTY_NAME + DOBS_CLASSES + CURRENT_DIR, DEF_CURRENT_DIR);
   } // setDefaults


   // ----------------------------------------------------------------------------
   // property change support
   // ----------------------------------------------------------------------------

   /**
    * Access method for an one to n association.
    *
    * @param propertyName  The object added.
    * @param listener      The object added.
    */
   public void addPropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().addPropertyChangeListener (propertyName, listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param propertyName  No description provided
    * @param listener      No description provided
    */
   public void removePropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().removePropertyChangeListener (propertyName, listener);
   }


   // ----------------------------------------------------------------------------
   // getter and setter for the properties
   // ----------------------------------------------------------------------------

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key        No description provided
    * @param hashtable  No description provided
    */
   public synchronized void putHashtableItem (String key, Hashtable hashtable)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME, key, hashtable);
      setModified (true);
      if (key.equals (VIS_ICONS))
      {
         setVisibilityIconsDirty (true);
      }
   } // putHashtableItem


   /**
    * Get the hashtableItem attribute of the OptionsIconChooser object
    *
    * @param key  No description provided
    * @return     The hashtableItem value
    */
   public synchronized Hashtable getHashtableItem (String key)
   {
      return PreferencesProperties.get().getHashtableSetting (PROPERTY_NAME, key);
   } // getHashtableItem


   /**
    * Sets the currentDir attribute of the OptionsIconChooser object
    *
    * @param key    The new currentDir value
    * @param value  The new currentDir value
    */
   public synchronized void setCurrentDir (String key, String value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (!options.getSetting (PROPERTY_NAME + key + CURRENT_DIR, DEF_CURRENT_DIR).equals (value))
      {
         options.putSetting (PROPERTY_NAME + key + CURRENT_DIR, value);
         setModified (true);
      }
   } // setCurrentDir


   /**
    * Get the currentDir attribute of the OptionsIconChooser object
    *
    * @param key  No description provided
    * @return     The currentDir value
    */
   public synchronized String getCurrentDir (String key)
   {
      return PreferencesProperties.get().getSetting (PROPERTY_NAME + key + CURRENT_DIR, DEF_CURRENT_DIR);
   } // getCurrentDir


   /**
    * Sets the visibilityIconsDirty attribute of the OptionsIconChooser object
    *
    * @param dirty  The new visibilityIconsDirty value
    */
   public synchronized void setVisibilityIconsDirty (boolean dirty)
   {
      visibilityIconsDirty = dirty;
   } // setVisibilityIconsDirty


   /**
    * Get the visibilityIconsDirty attribute of the OptionsIconChooser object
    *
    * @return   The visibilityIconsDirty value
    */
   public synchronized boolean isVisibilityIconsDirty()
   {
      return visibilityIconsDirty;
   } // isVisibilityIconsDirty


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Hashtable visibilityIconPaths;


   /**
    * Get the visibilityIcon attribute of the OptionsIconChooser object
    *
    * @param visibility  No description provided
    * @return            The visibilityIcon value
    */
   public synchronized ImageIcon getVisibilityIcon (String visibility)
   {
      ImageResourceManager imgManager = ImageResourceManager.get();

      ImageIcon tmpIcon = null;
      if ( (visibilityIconPaths == null) ||
          (isVisibilityIconsDirty()))
      {
         visibilityIconPaths = getHashtableItem (IconsPreferences.VIS_ICONS);
         setVisibilityIconsDirty (false);
      }

      String iconPath = (String) visibilityIconPaths.get (visibility);

      tmpIcon = imgManager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, iconPath);

      return tmpIcon;
   } // getVisibilityIcon

}

/*
 * $Log: IconsPreferences.java,v $
 * Revision 1.8  2004/10/20 17:50:07  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
