/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.awt.*;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.preferences.JavaPreferences;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.7 $
 */
public class JavaPreferencesPanel extends PreferencesPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField prefixTextField;


   /**
    * Constructor for class JavaPreferencesPanel
    */
   public JavaPreferencesPanel()
   {
      setLayout (new BorderLayout());

      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (gridBagLayout);

      // add codegeneration panel
      JPanel pathsPanel = createCodeGenerationPanel();
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.weightx = 1;
      mainPanel.add (pathsPanel, constraints);

      add (mainPanel, BorderLayout.NORTH);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createCodeGenerationPanel()
   {
      JPanel panel = new JPanel();

      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      panel.setLayout (gridBagLayout);
      panel.setBorder (new TitledBorder ("Java Code Generation"));

      JLabel prefixLabel = new JLabel ("Variables prefix:");
      constraints.insets = new Insets (3, 8, 0, 3);
      panel.add (prefixLabel, constraints);

      prefixTextField = new JTextField();
      prefixTextField.setToolTipText ("This prefix is used for local variables in generated methods.");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (3, 3, 0, 3);
      constraints.weightx = 1;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      panel.add (prefixTextField, constraints);

//		dlrTargetCheckBox = new JCheckBox ("Generate Java design level references");
//		dlrTargetCheckBox.setToolTipText("Files for design level debugging with Dobs are generated.");
//		constraints.fill = GridBagConstraints.NONE;
//		panel.add(dlrTargetCheckBox, constraints);

      return panel;
   }


   /**
    * @return   The preferredTabName value
    * @see      de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#getPreferredTabName()
    */
   public String getPreferredTabName()
   {
      return "Java";
   }


   /**
    * @see   de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#setPreferences()
    */
   public void setPreferences()
   {
      JavaPreferences options = JavaPreferences.get();

      prefixTextField.setText (options.getInternalVariablePrefix());
   }


   /**
    * @see   de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#setDefaults()
    */
   public void setDefaults()
   {
      JavaPreferences.get().setDefaults();
      setPreferences();
   }


   /**
    * @see   de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#okPressed()
    */
   public void okPressed()
   {
      JavaPreferences options = JavaPreferences.get();

      options.setInternalVariablePrefix (prefixTextField.getText());
   }

}

/*
 * $Log: JavaPreferencesPanel.java,v $
 * Revision 1.7  2004/10/20 17:50:08  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
