/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.48 $
 */
public class UMLCardinality extends UMLIncrement implements FCardinality
{

   /**
    * Constructor for class UMLCardinality
    */
   public UMLCardinality()
   {
      super();
   }


   /**
    * Constructor for class UMLCardinality
    *
    * @param cardString  No description provided
    */
   public UMLCardinality (String cardString)
   {
      this (cardString, null);
   }


   /**
    * Constructor for class UMLCardinality
    *
    * @param cardString  No description provided
    * @param revCard     No description provided
    */
   public UMLCardinality (String cardString, UMLRole revCard)
   {
      super();
      setCardString (cardString);
      setRevCard (revCard);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String cardString = null;


   /**
    * Get the lowerBound attribute of the UMLCardinality object
    *
    * @return   The lowerBound value
    */
   public int getLowerBound()
   {
      if ( (cardString != null) &&  (cardString.length() > 0))
      {
         char c = cardString.charAt (0);
         if ( (c < '0') ||  (c > '9'))
         {
            return 0;
         }
         else
         {
            int result = 0;

            for (int i = 0; i < cardString.length(); i++)
            {
               c = cardString.charAt (i);
               if ( ('0' <= c && c <= '9'))
               {
                  result = result * 10 + c - '0';
               }
               else
               {
                  return result;
               }
            }
            return result;
         }
      }
      else
      {
         return 1;
      }
   }


   /**
    * Get the upperBound attribute of the UMLCardinality object
    *
    * @return   The upperBound value
    */
   public int getUpperBound()
   {
      if ( (cardString != null) &&  (cardString.length() > 0))
      {
         char c = cardString.charAt (cardString.length() - 1);
         if ( (c < '0') ||  (c > '9'))
         {
            return Integer.MAX_VALUE; // infinity

         }
         else
         {
            int result = 0;
            int multi = 1;

            for (int i = cardString.length() - 1; i >= 0; i--)
            {
               c = cardString.charAt (i);
               if ( ('0' <= c && c <= '9'))
               {
                  result =  (c - '0') * multi + result;
                  multi *= 10;
               }
               else
               {
                  return result;
               }
            }
            return result;
         }
      }
      else
      {
         return 1;
      }
   }


   /**
    * Get the cardString attribute of the UMLCardinality object
    *
    * @return   The cardString value
    */
   public String getCardString()
   {
      return cardString;
   }


   /**
    * Sets the cardString attribute of the UMLCardinality object
    *
    * @param strg  The new cardString value
    */
   public void setCardString (String strg)
   {
      if ( (this.cardString == null && strg != null) ||
          (this.cardString != null && !this.cardString.equals (strg)))
      {
         String oldValue = this.cardString;
         this.cardString = strg;
         firePropertyChange (CARD_STRING_PROPERTY, oldValue, strg);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLRole revCard = null; // reverse UMLCardinality card


   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the revCard attribute of the UMLCardinality object
    *
    * @return   The revCard value
    */
   public UMLRole getRevCard()
   {
      return revCard;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FCardinality#getFRevCard()
    */
   /**
    * Get the fRevCard attribute of the UMLCardinality object
    *
    * @return   The fRevCard value
    */
   public FRole getFRevCard()
   {
      return getRevCard();
   }
   // TODO-END

   /**
    * Sets the revCard attribute of the UMLCardinality object
    *
    * @param revCard  The new revCard value
    */
   public void setRevCard (FRole revCard)
   {
      if ( (this.revCard == null && revCard != null) ||
          (this.revCard != null && !this.revCard.equals (revCard)))
      { // new partner
         UMLRole oldRevCard = this.revCard;
         if (this.revCard != null)
         { // inform old partner
            this.revCard = null;
            oldRevCard.setCard (null);
         }
         this.revCard = (UMLRole) revCard;
         if (this.revCard != null)
         { // inform new partner
            this.revCard.setCard (this);
         }
         firePropertyChange (REV_CARD_PROPERTY, oldRevCard, revCard);
      }
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      setRevCard (null);
      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      return getRevCard();
   }

}

/*
 * $Log: UMLCardinality.java,v $
 * Revision 1.48  2005/02/14 14:28:19  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
