/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;




/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.46 $
 */
public class UMLStoryActivity extends UMLActivity
{
   /**
    * Constructor for class UMLStoryActivity
    */
   public UMLStoryActivity()
   {
      super();
   }


   /**
    * Constructor for class UMLStoryActivity
    *
    * @param forEach       No description provided
    * @param storyPattern  No description provided
    */
   public UMLStoryActivity (boolean forEach,
                            UMLStoryPattern storyPattern)
   {
      super();
      setForEach (forEach);
      setStoryPattern (storyPattern);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String textComment;


   /**
    * Get the textComment attribute of the UMLStoryActivity object
    *
    * @return   The textComment value
    */
   public String getTextComment()
   {
      return textComment;
   }


   /**
    * Sets the textComment attribute of the UMLStoryActivity object
    *
    * @param textComment  The new textComment value
    */
   public void setTextComment (String textComment)
   {
      if ( (this.textComment == null) ||  (this.textComment != null && !this.textComment.equals (textComment)))
      {
         String oldComment = this.textComment;
         this.textComment = textComment;
         firePropertyChange ("textComment", oldComment, textComment);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean forEach = false;


   /**
    * Get the forEach attribute of the UMLStoryActivity object
    *
    * @return   The forEach value
    */
   public boolean isForEach()
   {
      return forEach;
   }


   /**
    * Sets the forEach attribute of the UMLStoryActivity object
    *
    * @param forEach  The new forEach value
    */
   public void setForEach (boolean forEach)
   {
      boolean oldValue = this.forEach;
      this.forEach = forEach;
      firePropertyChange ("forEach", oldValue, forEach);
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLStoryPattern storyPattern;


   /**
    * Get the storyPattern attribute of the UMLStoryActivity object
    *
    * @return   The storyPattern value
    */
   public UMLStoryPattern getStoryPattern()
   {
      return storyPattern;
   }


   /**
    * Sets the storyPattern attribute of the UMLStoryActivity object
    *
    * @param storyPattern  The new storyPattern value
    */
   public void setStoryPattern (UMLStoryPattern storyPattern)
   {
      if (this.storyPattern != storyPattern)
      {
         UMLStoryPattern oldValue = this.storyPattern;
         if (this.storyPattern != null)
         {
            this.storyPattern = null;
            oldValue.setRevStoryPattern (null);
         }
         this.storyPattern = storyPattern;
         if (storyPattern != null)
         {
            storyPattern.setRevStoryPattern (this);
         }
         firePropertyChange ("storyPattern", oldValue, storyPattern);
      }
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      //----- remove the story-pattern of this activity
      UMLStoryPattern storyPattern = getStoryPattern();
      if (storyPattern != null)
      {
         storyPattern.removeYou();
      }

      setRevStory (null);

      super.removeYou();
   }


   /**
    * Get the text attribute of the UMLStoryActivity object
    *
    * @return   The text value
    */
   public String getText()
   {
      if (getStoryPattern() != null)
      {
         return getStoryPattern().getName();
      }
      return "STORY";
   }

   // ######################################################################

   /**
    * 1 story 0..1 UMLStoryActivity --------------------- UMLComplexState + +
    */
   private transient UMLComplexState revStory; // reverse attribute story


   /**
    * Get the revStory attribute of the UMLStoryActivity object
    *
    * @return   The revStory value
    */
   public UMLComplexState getRevStory()
   {
      return revStory;
   } // getRevStory


   /**
    * Sets the revStory attribute of the UMLStoryActivity object
    *
    * @param revStory  The new revStory value
    */
   public void setRevStory (UMLComplexState revStory)
   {
      if (this.revStory != revStory)
      {
         UMLComplexState oldValue = this.revStory;
         if (this.revStory != null)
         {
            this.revStory = null;
            oldValue.setStory (null);
         }
         this.revStory = revStory;
         if (revStory != null)
         {
            revStory.setStory (this);
         }
         firePropertyChange ("revStory", oldValue, revStory);
      }
   } // setRevStory


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("UMLStoryActivity[name=");
      result.append (getName());
      result.append (",pattern=");
      result.append (getStoryPattern());
      result.append ("]");

      return result.toString();
   }

}

/*
 * $Log: UMLStoryActivity.java,v $
 * Revision 1.46  2004/11/03 11:47:55  lowende
 * Javadoc warnings removed.
 *
 */
