/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Enumeration;
import java.util.NoSuchElementException;


/**
 * use this class to iterate over the UML-tree to get a special kind of uml-object (tgtClass)
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.14.2.4 $
 */
public class UMLTreeEnumeration implements Enumeration
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLTreeEnumeration enumNextLevel = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Object currentObject = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Enumeration enumIncr = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Class tgtClass = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean descendOnMatch;


   /**
    *Constructor for class UMLTreeEnumeration
    *
    * @param incr      No description provided
    * @param tgtClass  No description provided
    */
   UMLTreeEnumeration (UMLIncrement incr, Class tgtClass)
   {
      this (incr, tgtClass, false);
   }


   /**
    * @param incr            the UMLIncrement to start with
    * @param tgtClass        the class-type you are searching for
    * @param descendOnMatch  No description provided
    */
   UMLTreeEnumeration (UMLIncrement incr, Class tgtClass, boolean descendOnMatch)
   {
      this.enumIncr = incr.elementsOfAllChildren();
      this.tgtClass = tgtClass;
      this.descendOnMatch = descendOnMatch;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean hasMoreElements()
   {
      // end this loop, if we find no object or
      //                   we find a object with the specified class-type
      while (this.currentObject == null)
      {
         if (this.enumNextLevel == null)
         {
            // we are in this level -> has this level more elements?
            if (!this.enumIncr.hasMoreElements())
            {
               // there are no elements in this level
               return false;
            }
            // get the next element of this level
            this.currentObject = this.enumIncr.nextElement();
            // check if this element has the type of tgtClass
            if (tgtClass.isInstance (this.currentObject))
            {
               if (descendOnMatch)
               {
                  this.enumNextLevel = new UMLTreeEnumeration ((UMLIncrement) this.currentObject, tgtClass);
               }
               // this level has more elements and the next one is stored in this.currentObjec
               return true;
            }
            else
            {
               // we find something else, so search this thing for classes with type tgtclasses
               this.enumNextLevel = new UMLTreeEnumeration ((UMLIncrement) this.currentObject, tgtClass, descendOnMatch);
               // at this time we find no class with type tgtClass
               this.currentObject = null;
            }
         }
         else
         {
            // we are in the next level -> has the next level more elements ?
            if (this.enumNextLevel.hasMoreElements())
            {
               // there are still tgtClasses -> so get them
               this.currentObject = this.enumNextLevel.nextElement();
            }
            else
            {
               // There are no tgtClasses in the next level -> leave the next level
               this.currentObject = null;
               this.enumNextLevel = null;
            }
         }
      }
      return true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object nextElement()
   {
      if (this.currentObject == null)
      {
         throw new NoSuchElementException();
      }
      Object result = this.currentObject;
      this.currentObject = null;
      return result;
   }
}

/*
 * $Log: UMLTreeEnumeration.java,v $
 * Revision 1.14.2.4  2005/12/15 15:21:47  creckord
 * - FujabaApp can determine the Fujaba install location now
 * - Template dir and default plugin dir are determined based on install location instead of current dir
 *
 * - UMLCollabStat has an int number for its sequence number now instead of noText
 * - hopefully fixed UMLCollabStats losing/messing up their order and number between save & load
 * - threadId is honored by renumbering methods and GUI
 *
 * - FTreeEnumeration can enumerate elements nested in other elements of target type now
 * - iterator/elementsOfClasses in FProject returns inner classes now, too
 *
 * - UMLClass doesn't lose inner classes anymore (hopefully)
 *
 */
