/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.uml.*;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class GotoMethodDeclarationAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      UMLActivityDiagram diagram = null;

      if (event.getSource() instanceof UMLActivityDiagram)
      {
         diagram = (UMLActivityDiagram) event.getSource();
      }
      if (event.getSource() instanceof UMLStatementActivity)
      {
         diagram =  ((UMLStatementActivity) event.getSource()).getActivityDiagram();
      }
      else if (event.getSource() instanceof UMLStoryPattern)
      {
         diagram =  ( ((UMLStoryPattern) event.getSource()).getRevStoryPattern()).getActivityDiagram();
      }
      else if (event.getSource() instanceof UMLObject)
      {
         diagram =  ((UMLStoryPattern)  ((UMLObject) event.getSource()).getFirstFromDiagrams()).getRevStoryPattern().getActivityDiagram();
      }
      else if (event.getSource() instanceof UMLLink)
      {
         diagram =  ((UMLStoryPattern)  ((UMLLink) event.getSource()).getFirstFromDiagrams()).getRevStoryPattern().getActivityDiagram();
      }

      FrameMain gui = UMLProject.get().getGui();

      if (gui != null &&
         diagram != null &&
         diagram.getStartActivity() != null &&
         diagram.getStartActivity().getSpecClass() != null)
      {
         Iterator iter = diagram.getStartActivity().getSpecClass().iteratorOfDiagrams();

         if (iter != null && iter.hasNext())
         {
            gui.selectTreeItem (iter.next());
         }
      }
   }
}

/*
 * $Log: GotoMethodDeclarationAction.java,v $
 * Revision 1.12  2004/10/20 17:50:17  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
