/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.uml.*;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.13.2.2 $
 */
public class ShowCommentAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve
    * documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      Object originalSource = event.getSource();
      Object source;

      // items that should be affected are stored in here
      HashSet storage = new HashSet();
      HashSet tmpSourceSet = new HashSet();

      // make shure source is an iterator
      if (! (originalSource instanceof Iterator))
      {
         tmpSourceSet.add (originalSource);
         source = tmpSourceSet.iterator();
      }
      else
      {
         source = originalSource;
      }

      Iterator iter = (Iterator) source;

      ////////////////////////////////
      // FILTER-PART
      // handle multiple source-objects
      while (iter.hasNext())
      {
         source = iter.next();

         if (source instanceof UMLCommentary)
         {
            storage.add (source);
         }
         else if (source instanceof UMLStartActivity)
         {
            UMLStartActivity start = (UMLStartActivity) source;
            UMLMethod method = start.getSpec();

            if (method != null)
            {
               if (method.getComment() != null)
               {
                  storage.add (method.getComment());
               }
            }

         }
         else if (source instanceof UMLIncrement)
         {
            UMLIncrement incr = (UMLIncrement) source;

            if (incr.getComment() != null)
            {
               storage.add (incr.getComment());
            }
         }
      }
      //
      ////////////////////////////////

      Iterator storageIterator = storage.iterator();
      UMLCommentary commentary;
      boolean atLeastOneCommentaryChanged = false;

      while (storageIterator.hasNext())
      {
         commentary = (UMLCommentary) storageIterator.next();

         commentary.setVisible (!commentary.isVisible());
         atLeastOneCommentaryChanged = true;
      }

      if (atLeastOneCommentaryChanged)
      {
         UMLProject.get().refreshDisplay();
      }
   }
}

/*
 * $Log: ShowCommentAction.java,v $
 * Revision 1.13.2.2  2005/08/23 08:24:47  lowende
 * Removed compile warnings.
 *
 */
