/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.dialogs;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.app.PanelColumnLayout;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Dialog for merging two selected classes
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.12 $
 */
public class MergeClassesDialog extends JDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton radio1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton radio2;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLClass class1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLClass class2;


   /**
    * Constructor for class MergeClassesDialog
    *
    * @param f       No description provided
    * @param clazz1  No description provided
    * @param clazz2  No description provided
    */
   public MergeClassesDialog (JFrame f, UMLClass clazz1, UMLClass clazz2)
   {
      super (f, "Merge two selected classes", true);

      class1 = clazz1;
      class2 = clazz2;

      JPanel container = new JPanel();
      container.setLayout (new BorderLayout());

      JPanel mergePane = new JPanel();

      mergePane.setBorder (new TitledBorder ("Merge Two Classes"));
      mergePane.setLayout (new PanelColumnLayout());

      JLabel label = new JLabel ("Please select the new merged class");
      mergePane.add (label);

      // Create two radio buttons.
      radio1 = new JRadioButton (class1.getName());
      radio1.setSelected (true);

      radio2 = new JRadioButton (class2.getName());
      radio2.setSelected (false);

      // Group the radio buttons.
      ButtonGroup group = new ButtonGroup();
      group.add (radio1);
      group.add (radio2);

      // Add the buttons to the panel.
      mergePane.add (radio1);
      mergePane.add (radio2);

      container.add ("Center", mergePane);

      // add the merge and cancel buttons

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.RIGHT));

      JButton ok = new JButton ("Merge");
      ok.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               OKPressed();
            }
         }
         );

      JButton cancel = new JButton ("Cancel");
      cancel.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               CancelPressed();
            }
         }
         );
      buttonPanel.add (ok);
      buttonPanel.add (cancel);

      container.add ("South", buttonPanel);

      getRootPane().setDefaultButton (ok);
      getContentPane().add (container);

      pack();
      centerDialog();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void centerDialog()
   {
      Dimension screenSize = this.getToolkit().getScreenSize();
      Dimension size = this.getSize();

      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;

      this.setLocation (x, y);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void OKPressed()
   {
      UMLClass source;
      UMLClass target;

      // find the source and target

      if (radio1.isSelected())
      {
         source = class2;
         target = class1;
      }
      else
      {
         source = class1;
         target = class2;
      }

      // now merge the two classes
      Enumeration enumRoles = source.elementsOfRoles();
      Enumeration enumSuperclass = source.elementsOfRevSubclass();
      Enumeration enumSubclass = source.elementsOfRevSuperclass();

      // copy all attributs to the target
      UMLAttr attr;
      Iterator iter = source.iteratorOfAttrs();
      while (iter.hasNext())
      {
         attr = (UMLAttr) iter.next();
         source.removeFromAttrs (attr);
         target.addToAttrs (attr);
      }

      //copy all methods to the target
      UMLMethod method;
      iter = source.iteratorOfMethods();
      while (iter.hasNext())
      {
         method = (UMLMethod) iter.next();
         source.removeFromMethods (method);
         target.addToMethods (method);
      }

      //copy all roles to the target

      UMLRole role;
      while (enumRoles.hasMoreElements())
      {
         role = (UMLRole) enumRoles.nextElement();
         role.setTarget (target);

      }

      //copy the generalizations

      UMLGeneralization general;

      // at first to all subclasses
      while (enumSubclass.hasMoreElements())
      {
         general = (UMLGeneralization) enumSubclass.nextElement();
         if (general.getSubclass() == target)
         {
            general.removeYou();
         }
         else
         {
            general.setSuperclass (target);
         }
      }

      // then to all superclasses
      while (enumSuperclass.hasMoreElements())
      {
         general = (UMLGeneralization) enumSuperclass.nextElement();
         if (general.getSuperclass() == target)
         {
            general.removeYou();
         }
         else
         {
            general.setSubclass (target);
         }
      }

      //delete the source-class
      source.removeYou();

      this.setVisible (false);
   }


   /**
    * Cancel is pressed, so don't create or complete any pattern.
    */
   public void CancelPressed()
   {
      this.setVisible (false);
   }
}

/*
 * $Log: MergeClassesDialog.java,v $
 * Revision 1.12  2004/10/20 17:50:20  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
