/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.gui;

import java.util.*;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;

import de.uni_paderborn.fujaba.app.FrameDecorator;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.TreeNodeComparator;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.lib.userinterface.UserInterfaceManager;


/**
 * This class handles the change of the user interface, if a diagram was selected.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.23 $
 */
public class FrameDecoratorUMLActivityDiagram extends FrameDecorator
{
   /**
    * Checks wether decorator is responsible for the given diagram. Changes the visibility
    * of menus/toolbars. Called, if diagram is entered.
    *
    * @param diag  No description provided
    */
   public void enterDiagram (ASGDiagram diag)
   {
      setVisibilityOfUserInterface (diag, true);
   } // enterDiagram


   /**
    * Checks wether decorator is responsible for the given diagram. Changes the visibility
    * of menus/toolbars. Called, if diagram is entered.
    *
    * @param diag  No description provided
    */
   public void leaveDiagram (ASGDiagram diag)
   {
      setVisibilityOfUserInterface (diag, false);
   } // leaveDiagram


   /**
    * Sets the visibilityOfUserInterface attribute of the FrameDecoratorUMLActivityDiagram
    * object
    *
    * @param diag     The new visibilityOfUserInterface value
    * @param visible  The new visibilityOfUserInterface value
    */
   private void setVisibilityOfUserInterface (ASGDiagram diag, boolean visible)
   {
      while (diag != null && diag instanceof ViewDiagram)
      {
         diag =  ((ViewDiagram) diag).getDiagram();
      }

      UserInterfaceManager uiManager = UserInterfaceManager.get();
      JMenu menu = uiManager.getFromMenus ("activityDiagramMenu");
      JToolBar toolBar = uiManager.getFromToolBars ("activityDiagramToolBar");

      if (diag != null && diag instanceof UMLActivityDiagram)
      {
         if (menu != null)
         {
            menu.setVisible (visible);
            menu.setEnabled (visible);
         }

         if (toolBar != null)
         {
            if (visible)
            {
               FrameMain.get().getCurrentInternalFrame().addDiagramToolBar (toolBar);
            }
            else
            {
               //FrameMain.get().getInternalFrame (diag).removeDiagramToolBar (toolBar);
            }
         }
      }
   } // setVisibilityOfUserInterface


   /**
    * Get the treeNode attribute of the FrameDecoratorUMLActivityDiagram object
    *
    * @param diagEnum  No description provided
    * @return          The treeNode value
    */
   public DefaultMutableTreeNode getTreeNode (Enumeration diagEnum)
   {
      DefaultMutableTreeNode node = new DefaultMutableTreeNode ("Activity diagrams");

      ASGDiagram diag;
      UMLActivityDiagram activityDiag;
      UMLClass tmpClass = null;
      UMLMethod tmpMethod = null;

      UMLStereotypeManager stereotypeManager = UMLStereotypeManager.get();
      if (!stereotypeManager.hasKeyInStereotypes (UMLStereotypeManager.REFERENCE))
      {
         stereotypeManager.addToStereotypes (new UMLStereotype (UMLStereotypeManager.REFERENCE));
      }
      UMLStereotype referenceType = UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.REFERENCE);

      DefaultMutableTreeNode tmpNode = null;
      DefaultMutableTreeNode subNode = null;
      Vector tmpVector = null;
      TreeSet nodeSet = new TreeSet (new TreeNodeComparator());

      TreeSet nodeSet2 = null;

      TreeMap classNodes = new TreeMap();
      TreeMap methodNodes = new TreeMap();
      TreeMap internalSet = new TreeMap();

      while (diagEnum.hasMoreElements())
      {
         diag = (ASGDiagram) diagEnum.nextElement();

         if ( (diag instanceof UMLActivityDiagram) &&
            ! (diag instanceof UMLStatechart))
         {
            activityDiag = (UMLActivityDiagram) diag;

            try
            {
               UMLStartActivity startActivity = activityDiag.getStartActivity();
               tmpMethod = startActivity.getSpec();
               if (tmpMethod == null)
               {
                  tmpClass = startActivity.getRevStartOfStateChart();
               }
               else
               {
                  tmpClass = tmpMethod.getParent();
               }
            }
            catch (Exception except)
            {
               tmpClass = null;
            }

            if (tmpClass != null)
            {
               if (tmpClass.hasInStereotypes (referenceType))
               {
                  tmpVector = (Vector) classNodes.get (tmpClass);
                  if (tmpVector != null)
                  {
                     tmpNode = (DefaultMutableTreeNode) tmpVector.get (0);
                     tmpNode.removeFromParent();
                  }
               }
               else
               {
                  // are there methods for the class, yet?
                  tmpVector = (Vector) classNodes.get (tmpClass);
                  if (tmpVector == null)
                  {
                     // create a new node for the class
                     tmpNode = new DefaultMutableTreeNode (tmpClass);

                     // create subnode for internal methods by default
                     subNode = new DefaultMutableTreeNode ("internal");
                     tmpNode.add (subNode);

                     tmpVector = new Vector();
                     tmpVector.add (tmpNode);
                     tmpVector.add (subNode);
                     classNodes.put (tmpClass, tmpVector);
                     nodeSet.add (tmpNode);
                  }
                  tmpNode = (DefaultMutableTreeNode) tmpVector.get (0);
                  if ( (tmpMethod != null)
                     &&  (tmpMethod.getDisplayLevel() == FDeclaration.CODE_DISPLAY_LEVEL))
                  {
                     nodeSet2 = (TreeSet) internalSet.get (tmpNode.toString());
                     if (nodeSet2 == null)
                     {
                        nodeSet2 = new TreeSet (new TreeNodeComparator());
                        internalSet.put (tmpNode.toString(), nodeSet2);
                     }

                     tmpNode = (DefaultMutableTreeNode) tmpVector.get (1);
                  }
                  else
                  {
                     nodeSet2 = (TreeSet) methodNodes.get (tmpNode.toString());
                     if (nodeSet2 == null)
                     {
                        nodeSet2 = new TreeSet (new TreeNodeComparator());
                        methodNodes.put (tmpNode.toString(), nodeSet2);
                     }

                  }

                  DefaultMutableTreeNode childNode = getTreeNode (diag);
                  nodeSet2.add (childNode);
               }
            }
            else
            {
               DefaultMutableTreeNode childNode = getTreeNode (diag);

               nodeSet2 = (TreeSet) methodNodes.get (node.toString());
               if (nodeSet2 == null)
               {
                  nodeSet2 = new TreeSet (new TreeNodeComparator());
                  methodNodes.put (node.toString(), nodeSet2);
               }

               nodeSet2.add (childNode);
            }
         }
      }

      Iterator iter = nodeSet.iterator();
      while (iter.hasNext())
      {
         DefaultMutableTreeNode theNode = (DefaultMutableTreeNode) iter.next();
         node.add (theNode);

         DefaultMutableTreeNode inner = (DefaultMutableTreeNode)
            theNode.getChildAt (0);

         if (inner != null)
         {
            nodeSet2 = (TreeSet) internalSet.get (theNode.toString());

            if (nodeSet2 != null)
            {
               Iterator iter2 = nodeSet2.iterator();
               while (iter2.hasNext())
               {
                  inner.add ((DefaultMutableTreeNode) iter2.next());
               }
            }
         }

         nodeSet2 = (TreeSet) methodNodes.get (theNode.toString());

         if (nodeSet2 != null)
         {
            Iterator iter2 = nodeSet2.iterator();
            while (iter2.hasNext())
            {
               theNode.add ((DefaultMutableTreeNode) iter2.next());
            }
         }
      }

      nodeSet2 = (TreeSet) methodNodes.get (node.toString());

      if (nodeSet2 != null)
      {
         iter = nodeSet2.iterator();
         while (iter.hasNext())
         {
            node.add ((DefaultMutableTreeNode) iter.next());
         }
      }

      //delete empty internal nodes
      Iterator classNodeIter = classNodes.values().iterator();
      while (classNodeIter.hasNext())
      {
         Vector nodes = (Vector) classNodeIter.next();
         DefaultMutableTreeNode intNode = (DefaultMutableTreeNode) nodes.get (1);
         if (intNode.getChildCount() == 0)
         {
            intNode.removeFromParent();
         }
      }

      return node;
   }


   /**
    * Get the treeNode attribute of the FrameDecoratorUMLActivityDiagram object
    *
    * @param diag  No description provided
    * @return      The treeNode value
    */
   public DefaultMutableTreeNode getTreeNode (UMLDiagram diag)
   {
      //FIX ME: Workaround for old dis-structures to have views of
      //inner diagrams. They are just shown in the tree and can be
      //shown there as normal diagrams.
      //
      //In the future the desired view to show should simply replace
      //the inner diagram in its activity - Will come with new FSAs...
      DefaultMutableTreeNode node = super.getTreeNode (diag);
      DefaultMutableTreeNode inners = new DefaultMutableTreeNode ("Inner Diagrams");
      TreeSet innerSet = new TreeSet (new TreeNodeComparator());

      Iterator iter = diag.iteratorOfElements();
      while (iter.hasNext())
      {
         ASGElement asgElement = (ASGElement) iter.next();

         if (asgElement instanceof UMLStoryActivity &&
             ((UMLStoryActivity) asgElement).getStoryPattern() != null)
         {
            innerSet.add (super.getTreeNode ( ((UMLStoryActivity) asgElement).getStoryPattern()));
         }
         else if (asgElement instanceof UMLComplexState)
         {
            UMLComplexState state = (UMLComplexState) asgElement;
            if (state.getStory() != null && state.getStory().getStoryPattern() != null)
            {
               innerSet.add (super.getTreeNode (state.getStory().getStoryPattern()));
            }
            Iterator activityIter = state.iteratorOfContains();
            while (activityIter.hasNext())
            {
               innerSet.add (getTreeNode ((UMLDiagram) activityIter.next()));
            }
         }
      }

      iter = innerSet.iterator();
      while (iter.hasNext())
      {
         inners.add ((DefaultMutableTreeNode) iter.next());
      } // end of while ()

      if (inners.getChildCount() > 0)
      {
         node.insert (inners, 0);
      }
      return node;
   } // getTreeNode

}

/*
 * $Log: FrameDecoratorUMLActivityDiagram.java,v $
 * Revision 1.23  2004/10/20 19:51:23  schneider
 * fixed doubled constants - UMLDeclarationInterface deprecated
 *
 */
