/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Iterator;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.FSALabel;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.actions.EditStereotypesAction;
import de.uni_paderborn.lib.basic.ImageResourceManager;


/**
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.7.2.1 $ $Date: 2005/09/30 18:56:53 $
 */
public class StereotypeLabel extends FSALabel
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (StereotypeLabel.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   UMLIncrement increment;


   /**
    * Constructor for class StereotypeLabel
    *
    * @param incr             No description provided
    * @param parentComponent  No description provided
    */
   public StereotypeLabel (UMLIncrement incr, JComponent parentComponent)
   {
      super (incr, "stereotypes", parentComponent);
      increment = incr;
      updateTooltip();
      incr.addPropertyChangeListener (
         new PropertyChangeListener()
         {
            /**
             * This method gets called when a bound property is changed.
             *
             * @param evt  A PropertyChangeEvent object describing the event source and the
             *      property that has changed.
             */

            public void propertyChange (PropertyChangeEvent evt)
            {
               updateTooltip();
            }
         });
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void updateTooltip()
   {
      StringBuffer tooltip = new StringBuffer();
      for (Iterator it = increment.iteratorOfStereotypes(); it.hasNext(); )
      {
         UMLStereotype stereotype = (UMLStereotype) it.next();
         if (tooltip.length() > 0)
         {
            tooltip.append (" ");
         }
         tooltip.append ("<<");
         tooltip.append (stereotype.getText());
         tooltip.append (">>");
      }
      getJComponent().setToolTipText (tooltip.toString());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JComponent createJComponent()
   {
      ImageIcon icon = findStereotypesIcon();
      JLabel label = new JLabel (icon);
      if (icon == null)
      {
         label.setText (" (stereotypes)");
      }
      label.setOpaque (false);

      label.addMouseListener (
         new MouseAdapter()
         {
            /**
             * Invoked when the mouse has been clicked on a component.
             *
             * @param e  No description provided
             */
            public void mouseClicked (MouseEvent e)
            {
               if (!e.isPopupTrigger())
               {
                  new EditStereotypesAction().actionPerformed (new ActionEvent (increment, ActionEvent.ACTION_PERFORMED, "click"));
               }
            }
         });

      return  (label);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private ImageIcon findStereotypesIcon()
   {
      final URL iconurl = getClass().getClassLoader().getResource ("de/uni_paderborn/fujaba/uml/images/Stereotypes.gif");
      if (iconurl != null)
      {
         ImageIcon icon = ImageResourceManager.get().getImageIcon (iconurl);
         return icon;
      }
      else
      {
         log.error ("stereotypes icon not found.");
         return null;
      }
   }
}

/*
 * $Log: StereotypeLabel.java,v $
 * Revision 1.7.2.1  2005/09/30 18:56:53  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
