/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.util.Set;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.ColumnRowLayout;
import de.uni_paderborn.fujaba.fsa.swing.border.LineBorder;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.AbstractUpdater;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.update.ClassCompartmentVisibilityUpdater;
import de.uni_paderborn.fujaba.uml.update.UMLAbstractUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.16.2.1 $
 */
public class UMActivity extends AbstractUnparseModule
{
   /**
    * Get the childProperties attribute of the UMActivity object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      props.add ("exit");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLClass clazz = (UMLClass) incr;

      // the main component for the class
      FSASeparatedPanel panel = new FSASeparatedPanel (incr, getMainFsaName(), parent.getJComponent(), false);
//      panel.setTransientProperties (false);
      panel.setBorder (new LineBorder (ColorsPreferences.get().DEFAULT_FOREGROUND));

      JComponent jPanel = panel.getJComponent();
      jPanel.addKeyListener (ArrowMoveListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, ComponentCursorListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, ComponentBorderListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DragMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DoubleClickMouseListener.get());
      SelectionListenerHelper.addSelectionListener (jPanel, BorderHighlighter.get());
      SelectionListenerHelper.addSelectionListener (jPanel, ArrowMoveListener.get());

      // -------------------------
      // the panel for exit
      // -------------------------
      FSAPanel tmpPanel = new FSAPanel (incr, "exitPanel", panel.getJComponent());
      tmpPanel.setLayout (new ColumnRowLayout (1, ColumnRowLayout.COLUMN));

      // compartment observer for the class.
      AbstractUpdater updater = new ClassCompartmentVisibilityUpdater (incr, "exit");
      tmpPanel.addToUpdater (updater);

      // -------------------------
      // the name field.
      // -------------------------
      FSAUnderlinedObject namePanel = new FSAUnderlinedObject (incr, "classNamePanel", panel.getJComponent());
      namePanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.COLUMN));

      FSATextFieldLabel classNameTextField = new FSATextFieldLabel (incr, "name", namePanel.getJComponent());

      // default updater handles text changes
      updater = classNameTextField.createDefaultUpdater();
      classNameTextField.addToUpdater (updater);

      // observer for the abstract flag of the class
      // and centering the text.
      updater = new UMLAbstractUpdater (classNameTextField, clazz);
      classNameTextField.setHorizontalAlignment (SwingConstants.CENTER);

      panel.addSeparator();

      return panel;
   }


   /**
    * Get the containerForProperty attribute of the UMClass object
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      // get unparse target for elements of a property

      // all UMLMethods that are added to the UMLClass fire a "methods"-propertyChange.
      // The target where they should be unparsed is determined by that name
      // so "methodPanel" is the correct result
      if ("exit".equals (property))
      {
         return "exitPanel";
      }
      return super.getContainerForProperty (property);
   }
}

/*
 * $Log: UMActivity.java,v $
 * Revision 1.16.2.1  2005/05/30 15:33:44  fklar
 * adjusted to FSA-changes ... calling constructor, that takes transientProperties as argument to save initial-location
 *
 */
