/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSATextFieldLabel;
import de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.uml.UMLCardinality;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.16 $
 */
public class UMCardinality extends AbstractUnparseModule
{
   /**
    * Constructor for class UMCardinality
    */
   public UMCardinality()
   {
      super ("cardString");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLCardinality card = (UMLCardinality) incr;

      //create role
      FSATextFieldLabel cardLabel = new FSATextFieldLabel (card, getMainFsaName(), parent.getJComponent());
      cardLabel.addToUpdater (cardLabel.createDefaultUpdater());
      cardLabel.getJComponent().setOpaque (false);
      SelectionListenerHelper.addSelectionListener (cardLabel.getJComponent(), ForegroundHighlighter.get());
      Font tmpFont = FontContainer.getFont (FontContainer.DEFAULT_FONT, -2);
      cardLabel.setFont (tmpFont);

      // hide if reference
      if (card.getRevCard().getPartnerRole().getAdornment() == FRole.REFERENCE)
      {
         cardLabel.setVisible (false);
      }

      // add listener to hide cardinality in case of a reference
      AdornmentPropertyChangeListener listener = new AdornmentPropertyChangeListener (cardLabel);
      card.getRevCard().getPartnerRole().addPropertyChangeListener ("adornment", listener);

      return cardLabel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.16 $ $Date: 2004/11/21 22:01:00 $
    */
   public class AdornmentPropertyChangeListener implements PropertyChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private FSATextFieldLabel cardLabel;


      /**
       * Constructor for class AdornmentPropertyChangeListener
       *
       * @param label  No description provided
       */
      public AdornmentPropertyChangeListener (FSATextFieldLabel label)
      {
         cardLabel = label;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void propertyChange (PropertyChangeEvent event)
      {
         if ("adornment".equals (event.getPropertyName()))
         {
            if ( ((Integer) event.getNewValue()).intValue() == FRole.REFERENCE)
            {
               cardLabel.setVisible (false);
            }
            else
            {
               cardLabel.setVisible (true);
            }
         }
      }
   }
}

/*
 * $Log: UMCardinality.java,v $
 * Revision 1.16  2004/11/21 22:01:00  trinet
 * removed saving of unparse information for UMLCardinality
 *
 */
