/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;

import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.ColumnRowLayout;
import de.uni_paderborn.fujaba.fsa.swing.UMLTypeListComboBoxModel;
import de.uni_paderborn.fujaba.fsa.swing.border.CrossBorder;
import de.uni_paderborn.fujaba.fsa.swing.border.LineBorder;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.uml.UMLObject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.55.2.2 $
 */
public class UMObject extends AbstractUnparseModule
{

   /**
    * Get the childProperties attribute of the UMObject object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      props.add ("attrs");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLObject object = (UMLObject) incr;

      FSASeparatedPanel objectPanel = new FSASeparatedPanel (incr, getMainFsaName(), parent.getJComponent(), false);
//      objectPanel.setTransientProperties (false);
      objectPanel.setOpaque (true);

      // Listeners for
      // - moving the object's display component.
      // - resizing the object's display component.
      JComponent objectPanelJComponent = objectPanel.getJComponent();
      objectPanelJComponent.addKeyListener (ArrowMoveListener.get());
      AscendDescendMouseHandler.addMouseInputListener (objectPanelJComponent, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (objectPanelJComponent, DragMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (objectPanelJComponent, DoubleClickMouseListener.get());
      SelectionListenerHelper.addSelectionListener (objectPanelJComponent, BorderHighlighter.get());
      SelectionListenerHelper.addSelectionListener (objectPanelJComponent, ArrowMoveListener.get());

      // -------------------------
      // the default icon
      // -------------------------
      FSAPanel tmpPanel = new FSAPanel (incr, "iconPanel", objectPanel.getJComponent());
      FSALabel iconLabel = new FSALabel (incr, "icon", tmpPanel.getJComponent());

      AbstractUpdater updater = new LogicToFsaUpdater();
      Translator trans = StringToIconTranslator.get();
      updater.setTranslator (trans);
      updater.setLogicAttrName ("currentIcon");
      updater.setFsaAttrName ("icon");
      updater.setLogicObject (object);

      iconLabel.addToUpdater (updater);

      updater = new VisibilityUpdater (object, "currentIcon");
      tmpPanel.addToUpdater (updater);

      // create the title of the object:
      // - name
      // - type of the object if it is not bound.
      tmpPanel = new FSAPanel (incr, "object", objectPanelJComponent);
      tmpPanel.setLayout (new FlowLayout (FlowLayout.CENTER, 0, 0));
      tmpPanel.setOpaque (false);

      FSAUnderlinedObject titlePanel = new FSAUnderlinedObject (incr, "titlePanel", tmpPanel.getJComponent());
      titlePanel.setLayout (new ColumnRowLayout (2, ColumnRowLayout.ROW));
      titlePanel.setLineInsets (new Insets (0, 0, 3, 0));
      titlePanel.setUnderlined (true);
      titlePanel.setOpaque (false);

      // the name of the object.
      FSATextFieldLabel nameLabel = new FSATextFieldLabel (incr, "objectName", titlePanel.getJComponent());
      nameLabel.addToUpdater (nameLabel.createDefaultUpdater());
      nameLabel.setOpaque (false);

      // the type of the object.
      // - Updater to set the panel visible if the object is not bound.
      // - Updater if the type of the object changes.
      FSAPanel typePanel = new FSAPanel (incr, "objectTypePanel", titlePanel.getJComponent());
      typePanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
      typePanel.setOpaque (false);

      FSALabel colonLabel = new FSALabel (incr, "colon", typePanel.getJComponent());
      colonLabel.setText (":");
      colonLabel.setOpaque (false);

      FSAComboBoxLabel typeLabel = new FSAComboBoxLabel (incr, "objectType", typePanel.getJComponent());
      typeLabel.setModel (UMLTypeListComboBoxModel.get());
      typeLabel.setOpaque (false);

      updater = new VisibilityUpdater (incr, "bound");
      updater.setTranslator (new BooleanObjectTranslator (Boolean.TRUE, Boolean.FALSE));
      typePanel.addToUpdater (updater);

      updater = typeLabel.createDefaultUpdater();
      updater.setLogicAttrName ("instanceOf");
      typeLabel.addToUpdater (updater);

      // the typecast of the object.
      FSAPanel assignPanel = new FSAPanel (incr, "typeCastPanel", titlePanel.getJComponent());
      assignPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
      assignPanel.setOpaque (false);

      colonLabel = new FSALabel (incr, ":=", assignPanel.getJComponent());
      colonLabel.setText (":= ");
      colonLabel.setOpaque (false);

      FSAPanel castPanel = new FSAPanel (incr, assignPanel.getJComponent());
      castPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
      castPanel.setOpaque (false);

      colonLabel = new FSALabel (incr, "(", castPanel.getJComponent());
      colonLabel.setText ("(");
      colonLabel.setOpaque (false);

      FSALabel typecasttypeLabel = new FSALabel (incr, "objectType", castPanel.getJComponent());
      typecasttypeLabel.setOpaque (false);

      updater = typecasttypeLabel.createDefaultUpdater();
      typecasttypeLabel.addToUpdater (updater);

      colonLabel = new FSALabel (incr, ")", castPanel.getJComponent());
      colonLabel.setText (") ");
      colonLabel.setOpaque (false);

      FSALabel typecastLabel = new FSALabel (incr, "typeCastSource", assignPanel.getJComponent());
      typecastLabel.setBold (true);
      typecastLabel.setOpaque (false);

      updater = typecastLabel.createDefaultUpdater();
      typecastLabel.addToUpdater (updater);

      updater = new VisibilityUpdater (object, "checkTypeCast");
      castPanel.addToUpdater (updater);

      updater = new VisibilityUpdater (object, "typeCastSource");
      assignPanel.addToUpdater (updater);

      // all components of the title are bold.
      titlePanel.setBold (true);

      objectPanel.addSeparator();

      // The attribute panel.
      // add the panel to the collapsable components.
      FSAPanel tmpCollapsable;
      tmpCollapsable = new FSACollapsable (incr, "attrConstraints", objectPanel.getJComponent());
      updater = new VisibilityUpdater (incr, "attrs");
      tmpCollapsable.addToUpdater (updater);
      tmpCollapsable.setLayout (new ColumnRowLayout (1, ColumnRowLayout.COLUMN));

      setBorder (object, objectPanel);
      BorderUpdater bu = new BorderUpdater (objectPanel);
      object.addPropertyChangeListener ("modifier", bu);
      object.addPropertyChangeListener ("type", bu);
      object.addPropertyChangeListener ("negative", bu);

      tmpPanel.addToUpdater (new LogicToFsaSizeUpdater (object));

      return objectPanel;
   }


   /**
    * Get the containerForProperty attribute of the UMObject object
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      // get unparse target for elements of a property
      if ("attrs".equals (property))
      {
         return "attrConstraints";
      }

      return super.getContainerForProperty (property);
   }


   /**
    * Sets the border attribute of the UMObject object
    *
    * @param object       the object for which a border should be set
    * @param objectPanel  The new border value
    */
   public void setBorder (UMLObject object, FSASeparatedPanel objectPanel)
   {
      if ( (object != null) &&  (objectPanel != null))
      {
         Border innerBorder = FSABorderFactory.get().getNormalBorder();
         Border outerBorder = null;

         int type = object.getType();
         int modifier = object.getModifier();

         if (modifier == UMLObject.NONE)
         {
            if (type == UMLObject.NORM)
            {
               innerBorder = FSABorderFactory.get().getNormalBorder();
            }
            else if (type == UMLObject.NEGATIVE)
            {
               Color borderColor = FSAObject.COLOR_FOREGROUND;
               innerBorder = new CompoundBorder (new LineBorder (borderColor), new CrossBorder (borderColor));
            }
            else if (type == UMLObject.OPTIONAL)
            {
               innerBorder = FSABorderFactory.get().getOptionalBorder();
            }
            else if (type == UMLObject.SET)
            {
               innerBorder = FSABorderFactory.get().getSetBorder();
            }
         }
         else if (modifier == UMLObject.CREATE)
         {
            outerBorder = FSABorderFactory.get().getCreateBorder();
            if (type == UMLObject.NORM)
            {
               innerBorder = FSABorderFactory.get().getCreateLineBorder();
            }
            else if (type == UMLObject.OPTIONAL)
            {
               innerBorder = FSABorderFactory.get().getCreateOptionalBorder();
            }
         }
         else if (modifier == UMLObject.DELETE)
         {
            outerBorder = FSABorderFactory.get().getDeleteBorder();
            if (type == UMLObject.NORM)
            {
               innerBorder = FSABorderFactory.get().getDeleteLineBorder();
            }
            else if (type == UMLObject.OPTIONAL)
            {
               innerBorder = FSABorderFactory.get().getDeleteOptionalBorder();
            }
            else if (type == UMLObject.SET)
            {
               innerBorder = FSABorderFactory.get().getDeleteSetBorder();
            }
         }

         CompoundBorder compoundBorder = new CompoundBorder (outerBorder, innerBorder);
         objectPanel.setBorder (compoundBorder);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.55.2.2 $
    */
   private class BorderUpdater implements PropertyChangeListener
   {

      /**
       * Constructor for class BorderUpdater
       *
       * @param objectPanel  No description provided
       */
      BorderUpdater (FSASeparatedPanel objectPanel)
      {
         this.objectPanel = objectPanel;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      FSASeparatedPanel objectPanel;


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void propertyChange (PropertyChangeEvent event)
      {
         String propertyName = event.getPropertyName();
         if ("modifier".equals (propertyName) ||
            "type".equals (propertyName) ||
            "negative".equals (propertyName))
         {
            UMLObject object = (UMLObject) event.getSource();
            setBorder (object, objectPanel);
         }
      }
   }
}

/*
 * $Log: UMObject.java,v $
 * Revision 1.55.2.2  2006/02/16 09:23:40  creckord
 * Optional Create enabled in GUI and Unparser
 *
 */
