/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;
import java.util.Set;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.update.AdornmentUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.29.2.1 $
 */
public class UMRole extends AbstractUnparseModule
{
   /**
    * Get the childProperties attribute of the UMRole object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      props.add ("card");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLRole role = (UMLRole) incr;

      //create role
      FSAGrab grab = new FSAGrab (incr, getMainFsaName(), parent.getJComponent());
//      grab.setTransientProperties (false);
      PanelGrabUI ui = (PanelGrabUI) PanelGrabUI.createUI (grab.getJComponent());
      grab.setUI (ui);
      grab.getJComponent().setOpaque (false);
      SelectionListenerHelper.addSelectionListener (grab.getJComponent(),
         SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));
      grab.addToUpdater (new GrabTargetUpdater (role, "target"));

      FSAPanel adornPanel = new FSAPanel (role, "adornmentPanel", grab.getJComponent());
      adornPanel.getJComponent().setLayout (new GridLayout (1, 1));
      adornPanel.getJComponent().setOpaque (false);

      SelectionListenerHelper.addSelectionListener (adornPanel.getJComponent(),
         SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));
      SelectionListenerHelper.addSelectionListener (adornPanel.getJComponent(),
         SelectionPropagationListener.get (SelectionPropagationListener.PARENT));
      AscendDescendMouseHandler.addMouseInputListener (adornPanel.getJComponent(), SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (adornPanel.getJComponent(), GrabMouseListener.get());
      ui.setGrabComponent (adornPanel.getJComponent());

      FSATextFieldLabel nameLabel = new FSATextFieldLabel (role, "name", grab.getJComponent());
      nameLabel.addToUpdater (new VisibilityUpdater (role, "name"));
      nameLabel.addToUpdater (nameLabel.createDefaultUpdater());
      nameLabel.getJComponent().setOpaque (false);
      nameLabel.getJComponent().setVisible (LayoutPreferences.get().isShowRoleNames());
      Font tmpFont = FontContainer.getFont (FontContainer.DEFAULT_FONT, -2);
      nameLabel.setFont (tmpFont);
      SelectionListenerHelper.addSelectionListener (nameLabel.getJComponent(), ForegroundHighlighter.get());
      if (!LayoutPreferences.get().isShowRoleNames())
      {
         SelectionListenerHelper.addSelectionListener (nameLabel.getJComponent(), VisibilityHighlighter.get());
      }

      FSAPanel cardPanel = new FSAPanel (role, "cardPanel", grab.getJComponent());
      cardPanel.addToUpdater (new VisibilityUpdater (role, "card"));
      cardPanel.getJComponent().setLayout (new GridLayout (1, 1));
      cardPanel.getJComponent().setOpaque (false);

      SelectionListenerHelper.addSelectionListener (cardPanel.getJComponent(),
         SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));

      RoleLayout layout = new RoleLayout ((JGrab) grab.getJComponent(), adornPanel.getJComponent(),
         nameLabel.getJComponent(), cardPanel.getJComponent());
      grab.getJComponent().setLayout (layout);

      grab.addToUpdater (new AdornmentUpdater (role));

      return grab;
   }


   /**
    * Get the containerForProperty attribute of the UMRole object
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      if ("card".equals (property))
      {
         return "cardPanel";
      }
      else if ("qualifier".equals (property))
      {
         return "adornmentPanel";
      }

      return super.getContainerForProperty (property);
   }
}

/*
 * $Log: UMRole.java,v $
 * Revision 1.29.2.1  2005/05/30 15:33:44  fklar
 * adjusted to FSA-changes ... calling constructor, that takes transientProperties as argument to save initial-location
 *
 */
