/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;
import java.util.Set;

import javax.swing.*;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLTransition;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.33 $
 */
public class UMTransition extends UMConnection
{
   /**
    * Get the childProperties attribute of the UMTransition object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      props.add ("guard");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLTransition transition = (UMLTransition) incr;

      // the new line
      FSAPolyLine line = (FSAPolyLine) super.create (parent, incr);
      line.setTransientProperties (false);

      UMLActivity entry = transition.getRevExit();
      UMLActivity exit = transition.getRevEntry();

      if (entry == null || exit == null)
      {
         return line;
      }

      // take care that entry and exit are unparsed
      // these are the objects that definitely exist now
      JBendLine bendLine = (JBendLine) line.getJComponent();
      Container lineParent = bendLine.getParent();

      // create grab at entry object
      FSAEntryGrab fsaEGrab = new FSAEntryGrab (incr, "entryGrab", (JComponent) lineParent);
      Translator translator = new LogicFsaTranslator (line, 1);
      AbstractUpdater updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("revExit");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (transition);
      fsaEGrab.addToUpdater (updater);

      JGrab grab = (JGrab) fsaEGrab.getJComponent();
      line.setStartBend (fsaEGrab);
      grab.setVisible (false);

      // now the exitFsa
      // create grab at entry object
      FSAGrab fsaGrab = new FSAGrab (incr, "exitGrab", (JComponent) lineParent);
      updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("revEntry");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (transition);
      fsaGrab.addToUpdater (updater);

      grab = (JGrab) fsaGrab.getJComponent();
      grab.setUI ((BendUI) ArrowGrabUI.createUI (grab));
       ((ArrowGrabUI) grab.getUI()).setArrow ((JArrowHead) UMArrowHead.TRANSITION.clone());
      SelectionListenerHelper.addSelectionListener (grab, ForegroundHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, GrabMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (grab, SelectionMouseListener.get());

      line.setEndBend (fsaGrab);

      FSAPanel panel = new FSAPanel (incr, "textPanel", bendLine);
      panel.setOpaque (false);
      JComponent jPanel = panel.getJComponent();

      Font tmpFont = FontContainer.getFont (FontContainer.DEFAULT_FONT, -1);

      FSATextFieldLabel label = new FSATextFieldLabel (incr, "event", jPanel);
      label.setOpaque (false);
      label.addToUpdater (label.createDefaultUpdater());
      label.getJComponent().setFont (tmpFont);

      FSALabel tmpLabel = new FSALabel (incr, "/", jPanel);
      tmpLabel.addToUpdater (new VisibilityUpdater (incr, "action"));
      tmpLabel.setText ("/");
      tmpLabel.getJComponent().setFont (tmpFont);

      label = new FSATextFieldLabel (incr, "action", jPanel);
      label.setOpaque (false);
      label.addToUpdater (label.createDefaultUpdater());
      label.getJComponent().setFont (tmpFont);

      if (bendLine.getLayout() instanceof LayoutManager2)
      {
          ((LayoutManager2) bendLine.getLayout()).
            addLayoutComponent (jPanel, new LineDecoratorConstraints (bendLine, 0.5, 8));
      }

      return line;
   }


   /**
    * Get the containerForProperty attribute of the UMTransition object
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      return "textPanel";
   }
}

/*
 * $Log: UMTransition.java,v $
 * Revision 1.33  2004/11/20 15:55:08  trinet
 * added flag to avoid unnecessary saving of unparse information
 *
 */
