/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.io.*;
import java.util.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.basic.*;
import de.upb.tools.fca.FDuplicatedTreeMap;
import de.upb.tools.fca.FTreeSet;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.15.2.1 $
 */
public abstract class AbstractConfigurableFilter extends AbstractFilter implements ConfigurableFilter
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (AbstractConfigurableFilter.class);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return                             No description provided
    * @throws CloneNotSupportedException  Exception description not provided
    */
   public Object clone() throws CloneNotSupportedException
   {
      return super.clone();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param is  No description provided
    */
   public void readSettings (Reader is)
   {
      BasicIncrement currentIncr = null;
      BufferedReader fr = null;
      String line;
      String className = null;
      String instanceID = null;
      int objectHashTableLength = 0;
      int lineNum = 0;
      int objCount = 0;

      Hashtable objectHashTable = null;
      StringTokenizer lineTok;
      FDuplicatedTreeMap attributeHashTable = new FDuplicatedTreeMap();
      boolean notYetWarned = true;

      try
      {
         fr = new BufferedReader (is, 32768);

         // Now parse the rest of the file
         while (fr.ready())
         {
            lineNum++;
            line = fr.readLine();

            lineTok = new StringTokenizer (line, ";");
            lineTok.nextToken();

            switch (line.charAt (0))
            {
               case '#': // documentation

                  break;
               case '-': // file specific variables

                  String variable = lineTok.nextToken();
                  if (variable.compareTo ("HashTableLength") == 0)
                  {
                     objectHashTableLength = new Integer (lineTok.nextToken())
                        .intValue();
                     objectHashTable = new Hashtable
                         (objectHashTableLength * 2);
                  }
                  else if (variable.compareTo ("InstanceID") == 0)
                  {
                     instanceID = lineTok.nextToken();
                  }
                  break;
               case '+': // hashtable entry

                  if (objectHashTable == null)
                  {
                     throw new Exception
                         ("Hashtable entry found,\n"
                        + "but there is no hashtable created yet!");
                  }
                  else if (instanceID == null)
                  {
                     throw new Exception
                         ("Hashtable entry found,\n"
                        + "but no instance ID to compare with yet!");
                  }
                  String strg = lineTok.nextToken();

                  className = lineTok.nextToken();
                  Object o = null;
                  if (instanceID.compareTo (strg) == 0)
                  {
                     if (className.compareTo (this.getClass().getName()) != 0)
                     {
                        log.error ("Instance ID fits, but class name does not!");
                     }

                     o = this;
                  }
                  else
                  {
                     try
                     {
                        o = ClassMap.get().forName (className).newInstance();
                     }
                     catch (Exception e)
                     {
                     }
                     finally
                     {
                        if (o == null)
                        {
                           log.error
                               ("ERROR in line " + lineNum + ": Could not execute\n   "
                              + "Class.forName (" + className + ").newInstance (); \n"
                              + "Perhaps class " + className
                              + " has no standard (parameterless) constructor?");
                        }
                     }
                  }
                  if (o != null)
                  {
                     objectHashTable.put (strg, o);
                  }
                  break;
               case '*': // object reference
                  // is this the very first time?

                  if (notYetWarned)
                  {
                     // check HashTable size.
                     if (objectHashTable.size() != objectHashTableLength)
                     {
                        log.error ("WARNING:Object reference found,");
                        log.error ("\nbut the hashtable is not complete!");
                     }

                     notYetWarned = false;
                  }

                  if (currentIncr != null)
                  {
                     currentIncr.readAttributes (objectHashTable, attributeHashTable);
                     attributeHashTable.clear();

                     objCount++;
                  }
                  currentIncr = (BasicIncrement) objectHashTable.get (lineTok.nextToken());
                  break;
               case '~': // attribute reference

                  if (currentIncr == null)
                  {
                     throw new Exception ("Attribute reference found,\nbut no current increment is set!");
                  }
                  attributeHashTable.put (lineTok.nextToken(), lineTok);

                  break;
            } // switch

         } // while fpr file has more lines

         if (currentIncr != null)
         {
            currentIncr.readAttributes (objectHashTable, attributeHashTable);
         }

      }
      catch (Exception e)
      {
         e.printStackTrace();
         throw new RuntimeException ("An error occured in line " + Integer.toString (lineNum) + " while reading the settings file." +
            "\nMessage: " + e);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param os  No description provided
    */
   public void writeSettings (Writer os)
   {
      BufferedWriter fw = null;
      int objectTablePos = 0;

      StringBuffer outputData = new StringBuffer (131072);
      FTreeSet savedIncrements = new FTreeSet (FujabaComparator.getLessBasicIncr());

      try
      {
         // write the header at the beginning of the file
         outputData.append ("-;InstanceID;" + this.getID() + "\n");
         objectTablePos = outputData.length();
         outputData.append ("# Object references\n");

         // write every class and their attributes to the StringBuffer
         // if (log.isInfoEnabled()) log.info ("saving project...");
         writeClassToStringBuffer (outputData, savedIncrements);

         // If everything is ok, insert the table [ID, objectType] at the
         // beginning of the StringBuffer
         //if (log.isInfoEnabled()) log.info ("Inserting hash table");
         StringBuffer objectTable = new StringBuffer (16384);
         Iterator iter = savedIncrements.iterator();
         BasicIncrement incr;

         objectTable = objectTable.append ("# HashTable of this File\n");
         objectTable = objectTable.append ("-;HashTableLength;" +
            Integer.toString (savedIncrements.size()) + "\n");
         while (iter.hasNext())
         {
            incr = (BasicIncrement) iter.next();
            objectTable = objectTable.append ("+;" + incr.getID() + ";"
               + incr.getClass().getName()
               + "\n");
         }
         outputData.insert (objectTablePos, objectTable);

         // now write the StringBuffer to the file
         fw = new BufferedWriter (os);
         fw.write (outputData.toString(), 0, outputData.length());
      }
      catch (Exception e)
      {
         log.error (e.getMessage());
         e.printStackTrace();
         throw new RuntimeException ("An error occured while writing the file " +
            "\nMessage : " + e.getMessage());
      }
      finally
      {
         try
         {
            fw.flush();
         }
         catch (Exception e)
         {
            log.error (e.getMessage()
               + "\n"
               + outputData);
            e.printStackTrace();

            throw new RuntimeException (e.getMessage());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name = null;


   /**
    * Get the name attribute of the AbstractConfigurableFilter object
    *
    * @return   The name value
    */
   public String getName()
   {
      if (name != null)
      {
         return name;
      }

      return super.getName();
   }


   /**
    * Sets the name attribute of the AbstractConfigurableFilter object
    *
    * @param name  The new name value
    */
   public void setName (String name)
   {
      if ( (this.name != null && !this.name.equals (name)) ||  (name != null && !name.equals (this.name)))
      {
         String oldName = getName();
         this.name = name;
         if (FilterManager.get().getFromFilters (oldName) == this)
         {
            FilterManager.get().removeKeyFromFilters (oldName);
            FilterManager.get().addToFilters (this);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String description = null;


   /**
    * Get the description attribute of the AbstractConfigurableFilter object
    *
    * @return   The description value
    */
   public String getDescription()
   {
      return description;
   }


   /**
    * Sets the description attribute of the AbstractConfigurableFilter object
    *
    * @param description  The new description value
    */
   public void setDescription (String description)
   {
      this.description = description;
   }


   /**
    * Get the editor attribute of the AbstractConfigurableFilter object
    *
    * @return   The editor value
    */
   public FilterEditor getEditor()
   {
      return new DefaultFilterEditor (this);
   }
}

/*
 * $Log: AbstractConfigurableFilter.java,v $
 * Revision 1.15.2.1  2005/09/30 18:57:04  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
