/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import javax.swing.*;


/**
 * The FilterEditor is the interface through which a ConfigurableFilter can be configured with
 * the JPanel that the Editor defines as editor in the Gui.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 * @see       de.uni_paderborn.fujaba.views.ConfigurableFilter
 */
public interface FilterEditor
{
   /**
    * @return   a Panel to configure the Filter
    */
   public JPanel getEditorPanel();


   /**
    * read the values from the filter and initialize the Panel with it
    *
    * @see   #getEditorPanel
    * @see   #setValues
    */
   public void getValues();


   /**
    * get the values from the editor panel and set these values in the Filter
    *
    * @see   #getEditorPanel
    * @see   #getValues
    */
   public void setValues();


   /**
    * define the filter that is to be edited
    *
    * @param filter  The new filter value
    */
   public void setFilter (ConfigurableFilter filter);


   /**
    * @return   the filter to be edited
    */
   public ConfigurableFilter getFilter();


   /**
    * Returns a new Filter of the same class as the filter returned by getFilter().<p>
    *
    * The new Filter is initialized with the values of the Editor Panel
    *
    * @return   a new filter with the values of the panel
    */
   public ConfigurableFilter getNewFilter();
}

/*
 * $Log: FilterEditor.java,v $
 * Revision 1.10  2004/10/20 17:50:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
