/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views;

import java.util.HashSet;
import java.util.Iterator;

import de.uni_paderborn.fujaba.uml.UMLDiagramItem;


/**
 * Container for UMLDiagramItem-instances to allow Filter-specification with Storydiagrams
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class ItemSet extends HashSet
{
   /**
    * <pre>
    *          0..1                      N
    * ItemSet ----------------------------- UMLDiagramItem
    *                                items
    * </pre>
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToItems (UMLDiagramItem value)
   {
      boolean changed = false;

      if (value != null)
      {
         changed = add (value);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInItems (UMLDiagramItem value)
   {
      return  ( (value != null) &&
         contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfItems()
   {
      return iterator();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfItems()
   {
      return size();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromItems (UMLDiagramItem value)
   {
      boolean changed = false;

      if (value != null)
      {
         changed = remove (value);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromItems()
   {
      this.clear();
   }
}

/*
 * $Log: ItemSet.java,v $
 * Revision 1.11  2004/10/20 17:50:30  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
