/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.beans;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.*;

import javax.swing.*;
import javax.swing.plaf.basic.BasicArrowButton;


/**
 * This class is a Panel holding a NumbertTextField It adds two Buttons to the TextField; one
 * Button to increase the value of the TextField and one Button to decrease the value of the
 * TextField And it sets the TextFields NumberFormat accordingly
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 * @see       de.uni_paderborn.fujaba.views.beans.NumberTextField
 */
public class NumberInputField extends JPanel implements SwingConstants
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel mainPanel = new JPanel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private NumberTextField input;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton up;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton down;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel buttonPanel = new JPanel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Number incrValue = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static IntervalNumberFormat integerParser;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static IntervalNumberFormat byteParser;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static IntervalNumberFormat longParser;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static IntervalNumberFormat shortParser;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static IntervalNumberFormat doubleParser;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static IntervalNumberFormat floatParser;

   static
   {
      integerParser = new IntervalNumberFormat (Integer.MIN_VALUE, Integer.MAX_VALUE);
      integerParser.setParseIntegerOnly (true);
      byteParser = new IntervalNumberFormat (Byte.MIN_VALUE, Byte.MAX_VALUE);
      byteParser.setParseIntegerOnly (true);
      longParser = new IntervalNumberFormat (Long.MIN_VALUE, Long.MAX_VALUE);
      longParser.setParseIntegerOnly (true);
      shortParser = new IntervalNumberFormat (Short.MIN_VALUE, Short.MAX_VALUE);
      shortParser.setParseIntegerOnly (true);
      doubleParser = new IntervalNumberFormat (-Double.MAX_VALUE, Double.MAX_VALUE);
      floatParser = new IntervalNumberFormat (-Float.MAX_VALUE, Float.MAX_VALUE);
   }


   /**
    * Constructor for class NumberInputField
    */
   public NumberInputField()
   {
      this (6);
   }


   /**
    * Constructor for class NumberInputField
    *
    * @param colums  No description provided
    */
   public NumberInputField (int colums)
   {
      super();
      setLayout (new FlowLayout (FlowLayout.RIGHT, 0, 0));
      input = new NumberTextField (colums);
      add (input);
      add (buttonPanel);
      buttonPanel.setLayout (new GridLayout (2, 1));

      up = new ArrowButton (NORTH, this);
      down = new ArrowButton (SOUTH, this);
      up.addActionListener (upAction);
      down.addActionListener (downAction);

      buttonPanel.add (up);
      buttonPanel.add (down);
      setIncrValue (new Integer (1));
   }


   /**
    * Sets the value attribute of the NumberInputField object
    *
    * @param value  The new value value
    */
   public void setValue (Number value)
   {
      input.setValue (value);
   }


   /**
    * Get the value attribute of the NumberInputField object
    *
    * @return   The value value
    */
   public Number getValue()
   {
      return input.getValue();
   }


   /**
    * Sets the incrValue attribute of the NumberInputField object
    *
    * @param value  The new incrValue value
    */
   public void setIncrValue (Number value)
   {
      if (value == null || value.doubleValue() == 0)
      {
         up.setEnabled (false);
         down.setEnabled (false);
      }
      else
      {
         up.setEnabled (true);
         down.setEnabled (true);
      }

      incrValue = value;
   }


   /**
    * Get the incrValue attribute of the NumberInputField object
    *
    * @return   The incrValue value
    */
   public Number getIncrValue()
   {
      return incrValue;
   }


   /**
    * Get the inputField attribute of the NumberInputField object
    *
    * @return   The inputField value
    */
   protected NumberTextField getInputField()
   {
      return input;
   }


   /**
    * Sets the enabled attribute of the NumberInputField object
    *
    * @param flag  The new enabled value
    */
   public void setEnabled (boolean flag)
   {
      super.setEnabled (flag);
      mainPanel.setEnabled (flag);
      up.setEnabled (flag);
      down.setEnabled (flag);
      buttonPanel.setEnabled (flag);
      input.setEnabled (flag);
   }


   /**
    * Sets the numberType attribute of the NumberInputField object
    *
    * @param type  The new numberType value
    */
   public void setNumberType (Class type)
   {
      if (type == Integer.TYPE || type == Integer.class)
      {
         getInputField().setParser (integerParser);
      }
      else if (type == Byte.TYPE || type == Byte.class)
      {
         getInputField().setParser (byteParser);
      }
      else if (type == Short.TYPE || type == Short.class)
      {
         getInputField().setParser (shortParser);
      }
      else if (type == Long.TYPE || type == Long.class)
      {
         getInputField().setParser (longParser);
      }
      else if (type == Double.TYPE || type == Double.class)
      {
         getInputField().setParser (doubleParser);
      }
      else if (type == Float.TYPE || type == Float.class)
      {
         getInputField().setParser (floatParser);
      }
      else
      {
         throw new RuntimeException ("Class type is not a subclass or subtype of Number");
      }
   }


   // --------------------- ActionListeners for Up-/Down-Buttons -------------------
   // *INDENT-OFF*
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static ActionListener upAction =
      new ActionListener()
      {
         public void actionPerformed (ActionEvent e)
         {
            NumberInputField source = (NumberInputField)  ((Component) e.getSource()).getParent().getParent();
            double oldValue = source.getDoubleValue();
            double incrValue = source.getDoubleIncrValue();
            Double newValue = new Double (oldValue + incrValue);

            source.setValue (newValue);
         }
      };

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static ActionListener downAction =
      new ActionListener()
      {
         public void actionPerformed (ActionEvent e)
         {
            NumberInputField source = (NumberInputField)  ((Component) e.getSource()).getParent().getParent();
            double oldValue = source.getDoubleValue();
            double incrValue = source.getDoubleIncrValue();
            Double newValue = new Double (oldValue - incrValue);

            source.setValue (newValue);
         }
      };
   // *INDENT-ON*

   // --------------- Convenience-Methods for different Number-Types ----------------
   /**
    * Sets the value attribute of the NumberInputField object
    *
    * @param value  The new value value
    */
   public void setValue (int value)
   {
      setValue (new Integer (value));
   }


   /**
    * Sets the value attribute of the NumberInputField object
    *
    * @param value  The new value value
    */
   public void setValue (double value)
   {
      setValue (new Double (value));
   }


   /**
    * Sets the value attribute of the NumberInputField object
    *
    * @param value  The new value value
    */
   public void setValue (float value)
   {
      setValue (new Float (value));
   }


   /**
    * Sets the value attribute of the NumberInputField object
    *
    * @param value  The new value value
    */
   public void setValue (long value)
   {
      setValue (new Long (value));
   }


   /**
    * Sets the value attribute of the NumberInputField object
    *
    * @param value  The new value value
    */
   public void setValue (short value)
   {
      setValue (new Short (value));
   }


   /**
    * Sets the value attribute of the NumberInputField object
    *
    * @param value  The new value value
    */
   public void setValue (byte value)
   {
      setValue (new Byte (value));
   }


   /**
    * Get the integerValue attribute of the NumberInputField object
    *
    * @return   The integerValue value
    */
   public int getIntegerValue()
   {
      Number value = getValue();

      return value == null ? 0 : value.intValue();
   }


   /**
    * Get the byteValue attribute of the NumberInputField object
    *
    * @return   The byteValue value
    */
   public byte getByteValue()
   {
      Number value = getValue();

      return value == null ? 0 : value.byteValue();
   }


   /**
    * Get the shortValue attribute of the NumberInputField object
    *
    * @return   The shortValue value
    */
   public short getShortValue()
   {
      Number value = getValue();

      return value == null ? 0 : value.shortValue();
   }


   /**
    * Get the longValue attribute of the NumberInputField object
    *
    * @return   The longValue value
    */
   public long getLongValue()
   {
      Number value = getValue();

      return value == null ? 0 : value.longValue();
   }


   /**
    * Get the doubleValue attribute of the NumberInputField object
    *
    * @return   The doubleValue value
    */
   public double getDoubleValue()
   {
      Number value = getValue();

      return value == null ? 0 : value.doubleValue();
   }


   /**
    * Get the floatValue attribute of the NumberInputField object
    *
    * @return   The floatValue value
    */
   public float getFloatValue()
   {
      Number value = getValue();

      return value == null ? 0 : value.floatValue();
   }


   /**
    * Sets the incrValue attribute of the NumberInputField object
    *
    * @param value  The new incrValue value
    */
   public void setIncrValue (int value)
   {
      setIncrValue (new Integer (value));
   }


   /**
    * Sets the incrValue attribute of the NumberInputField object
    *
    * @param value  The new incrValue value
    */
   public void setIncrValue (double value)
   {
      setIncrValue (new Double (value));
   }


   /**
    * Sets the incrValue attribute of the NumberInputField object
    *
    * @param value  The new incrValue value
    */
   public void setIncrValue (float value)
   {
      setIncrValue (new Float (value));
   }


   /**
    * Sets the incrValue attribute of the NumberInputField object
    *
    * @param value  The new incrValue value
    */
   public void setIncrValue (long value)
   {
      setIncrValue (new Long (value));
   }


   /**
    * Sets the incrValue attribute of the NumberInputField object
    *
    * @param value  The new incrValue value
    */
   public void setIncrValue (short value)
   {
      setIncrValue (new Short (value));
   }


   /**
    * Sets the incrValue attribute of the NumberInputField object
    *
    * @param value  The new incrValue value
    */
   public void setIncrValue (byte value)
   {
      setIncrValue (new Byte (value));
   }


   /**
    * Get the integerIncrValue attribute of the NumberInputField object
    *
    * @return   The integerIncrValue value
    */
   public int getIntegerIncrValue()
   {
      Number value = getIncrValue();

      return value == null ? 0 : value.intValue();
   }


   /**
    * Get the byteIncrValue attribute of the NumberInputField object
    *
    * @return   The byteIncrValue value
    */
   public byte getByteIncrValue()
   {
      Number value = getIncrValue();

      return value == null ? 0 : value.byteValue();
   }


   /**
    * Get the shortIncrValue attribute of the NumberInputField object
    *
    * @return   The shortIncrValue value
    */
   public short getShortIncrValue()
   {
      Number value = getIncrValue();

      return value == null ? 0 : value.shortValue();
   }


   /**
    * Get the longIncrValue attribute of the NumberInputField object
    *
    * @return   The longIncrValue value
    */
   public long getLongIncrValue()
   {
      Number value = getIncrValue();

      return value == null ? 0 : value.longValue();
   }


   /**
    * Get the doubleIncrValue attribute of the NumberInputField object
    *
    * @return   The doubleIncrValue value
    */
   public double getDoubleIncrValue()
   {
      Number value = getIncrValue();

      return value == null ? 0 : value.doubleValue();
   }


   /**
    * Get the floatIncrValue attribute of the NumberInputField object
    *
    * @return   The floatIncrValue value
    */
   public float getFloatIncrValue()
   {
      Number value = getIncrValue();

      return value == null ? 0 : value.floatValue();
   }

}

// ----------------------------- A NumberFormat ----------------------------------

/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
class IntervalNumberFormat extends NumberFormat
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static NumberFormat delegate = NumberFormat.getNumberInstance();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private double min = Double.NEGATIVE_INFINITY;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private double max = Double.POSITIVE_INFINITY;


   /**
    * Constructor for class IntervalNumberFormat
    */
   public IntervalNumberFormat()
   {
      super();
   }


   /**
    * Constructor for class IntervalNumberFormat
    *
    * @param min  No description provided
    * @param max  No description provided
    */
   public IntervalNumberFormat (double min, double max)
   {
      this();
      this.min = min;
      this.max = max;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param number      No description provided
    * @param toAppendTo  No description provided
    * @param pos         No description provided
    * @return            No description provided
    */
   public StringBuffer format (double number, StringBuffer toAppendTo, FieldPosition pos)
   {
      return delegate.format (number, toAppendTo, pos);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param number      No description provided
    * @param toAppendTo  No description provided
    * @param pos         No description provided
    * @return            No description provided
    */
   public StringBuffer format (long number, StringBuffer toAppendTo, FieldPosition pos)
   {
      return delegate.format (number, toAppendTo, pos);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param text           No description provided
    * @param parsePosition  No description provided
    * @return               No description provided
    */
   public Number parse (String text, ParsePosition parsePosition)
   {
      Number result = delegate.parse (text, parsePosition);

      if (result == null || result.doubleValue() < min || result.doubleValue() > max)
      {
         parsePosition.setErrorIndex (text.length());
         parsePosition.setIndex (0);
         result = null;
      }

      return result;
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
class ArrowButton extends BasicArrowButton
{


   /**
    * Constructor for class ArrowButton
    *
    * @param direction  No description provided
    * @param client     No description provided
    */
   public ArrowButton (int direction, JComponent client)
   {
      super (direction);
      setClient (client);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Component client = null;


   /**
    * Sets the client attribute of the ArrowButton object
    *
    * @param client  The new client value
    * @return        No description provided
    */
   public boolean setClient (Component client)
   {
      if (this.client != client)
      {
         this.client = client;
         revalidate();
         repaint();
         return true;
      }
      return false;
   }


   /**
    * Get the client attribute of the ArrowButton object
    *
    * @return   The client value
    */
   public Component getClient()
   {
      return client;
   }


   /**
    * Get the preferredSize attribute of the ArrowButton object
    *
    * @return   The preferredSize value
    */
   public Dimension getPreferredSize()
   {
      Component client = getClient();
      if (client == null)
      {
         return super.getPreferredSize();
      }
      else
      {
         int height = client.getHeight();
         return new Dimension (height / 2, height / 2);
      }
   }
}

/*
 * $Log: NumberInputField.java,v $
 * Revision 1.10  2004/10/20 17:50:31  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
