/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.cf;

import de.uni_paderborn.fujaba.metamodel.FDiagramItem;
import de.uni_paderborn.fujaba.uml.UMLConnection;
import de.uni_paderborn.fujaba.uml.UMLDiagramItem;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
public class CFTransition extends UMLConnection implements Cloneable
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Object clone()
   {
      return new CFTransition();
   }


   /**
    * <pre>
    *          N                            0..1
    * CFTransition ----------------------------- CFNode
    *          exits     source
    * </pre>
    */
   private CFNode source;


   /**
    * Sets the sourceConnector attribute of the CFTransition object
    *
    * @param item  The new sourceConnector value
    * @return      No description provided
    */
   public boolean setSourceConnector (FDiagramItem item)
   {
      return setSource ((CFNode) item);
   }


   /**
    * Get the sourceConnector attribute of the CFTransition object
    *
    * @return   The sourceConnector value
    */
   public UMLDiagramItem getSourceConnector()
   {
      return getSource();
   }


   /**
    * Sets the source attribute of the CFTransition object
    *
    * @param value  The new source value
    * @return       No description provided
    */
   public boolean setSource (CFNode value)
   {
      if (this.source != value)
      {
         if (this.source != null)
         {
            CFNode oldValue = this.source;
            this.source = null;
            oldValue.removeFromExits (this);
         }
         this.source = value;
         if (value != null)
         {
            this.source.addToExits (this);
         }

         return true;
      }

      return false;
   }


   /**
    * Get the source attribute of the CFTransition object
    *
    * @return   The source value
    */
   public CFNode getSource()
   {
      return this.source;
   }


   /**
    * <pre>
    *          N                            0..1
    * CFTransition ----------------------------- CFNode
    *          entries     target
    * </pre>
    */
   private CFNode target;


   /**
    * Sets the targetConnector attribute of the CFTransition object
    *
    * @param item  The new targetConnector value
    * @return      No description provided
    */
   public boolean setTargetConnector (FDiagramItem item)
   {
      return setTarget ((CFNode) item);
   }


   /**
    * Get the targetConnector attribute of the CFTransition object
    *
    * @return   The targetConnector value
    */
   public UMLDiagramItem getTargetConnector()
   {
      return getTarget();
   }


   /**
    * Sets the target attribute of the CFTransition object
    *
    * @param value  The new target value
    * @return       No description provided
    */
   public boolean setTarget (CFNode value)
   {
      if (this.target != value)
      {
         if (this.target != null)
         {
            CFNode oldValue = this.target;
            this.target = null;
            oldValue.removeFromEntries (this);
         }
         this.target = value;
         if (value != null)
         {
            this.target.addToEntries (this);
         }

         return true;
      }

      return false;
   }


   /**
    * Get the target attribute of the CFTransition object
    *
    * @return   The target value
    */
   public CFNode getTarget()
   {
      return this.target;
   }

}

/*
 * $Log: CFTransition.java,v $
 * Revision 1.10  2004/10/20 17:50:32  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
