/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.gui;

import java.awt.*;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.*;
import javax.swing.border.BevelBorder;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialogPanel;
import de.uni_paderborn.fujaba.views.*;


/**
 * A Dialog to customize and import Filters
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
public class FilterEditorDialog extends FujabaDialog implements WindowListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JPanel mainPanel = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTabbedPane tabPane = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FilterInfoPanel filterTabPanel = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FilterEditorPanel editTabPanel = null;


   /**
    * Constructor for class FilterEditorDialog
    *
    * @param parentFrame  No description provided
    */
   public FilterEditorDialog (JFrame parentFrame)
   {
      super (parentFrame);
      setModal (true);
      addWindowListener (this);
      guiBuild();
   }


   /**
    * Creates a new instance of FilterEditorDialog with the given title.
    *
    * @param sTitle       the title for the new frame.
    * @param parentFrame  No description provided
    */
   public FilterEditorDialog (JFrame parentFrame, String sTitle)
   {
      this (parentFrame);
      setTitle (sTitle);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void guiBuild()
   {
      JPanel buttons = guiPanelCloseHelp();
      mainPanel = createMainPanel();
      mainPanel.add (buttons, BorderLayout.SOUTH);
      getContentPane().add (mainPanel);
      setModel (FilterManager.get().getPrototypeListModel (null));
      setRenderer (FilterManager.getListCellRenderer());
      pack();
      setSize (540, 430);
      unparse();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Filter currentFilter = null;


   /**
    * Sets the currentFilter attribute of the FilterEditorDialog object
    *
    * @param filter  The new currentFilter value
    */
   public void setCurrentFilter (Filter filter)
   {
      if (this.currentFilter != filter)
      {
         this.currentFilter = filter;
         unparse();
      }
   }


   /**
    * Get the currentFilter attribute of the FilterEditorDialog object
    *
    * @return   The currentFilter value
    */
   public Filter getCurrentFilter()
   {
      return currentFilter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createMainPanel()
   {
      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (new BorderLayout (0, 0));

      tabPane = createTabPane();
      mainPanel.add (BorderLayout.CENTER, tabPane);

      return mainPanel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JTabbedPane createTabPane()
   {
      JTabbedPane tabPane = new JTabbedPane();
      tabPane.setBorder (new BevelBorder (BevelBorder.RAISED));
      FujabaDialogPanel[] tabs = createTabs();
      for (int i = 0; i < tabs.length; i++)
      {
         tabPane.addTab (tabs[i].getName(), tabs[i]);
         //tabPane.setTitleAt(i, tabs[i].getName());
      }
      tabPane.setSelectedIndex (0);
      tabPane.setEnabledAt (tabPane.indexOfComponent (editTabPanel), false);
      //tabPane.addChangeListener (this);

      return tabPane;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private FujabaDialogPanel[] createTabs()
   {
      filterTabPanel = new FilterInfoPanel (this);
      editTabPanel = new FilterEditorPanel (this);
      editTabPanel.setGlobalEditor (true);
      return new FujabaDialogPanel[]
         {
         filterTabPanel, editTabPanel
         };
   }


   /**
    * set the ListCellRenderer to use for the filter list
    *
    * @param renderer  The new renderer value
    */
   public void setRenderer (ListCellRenderer renderer)
   {
      filterTabPanel.setRenderer (renderer);
      editTabPanel.setRenderer (renderer);
   }


   /**
    * get the ListCellRenderer to use for the filter list
    *
    * @return   The renderer value
    */
   public ListCellRenderer getRenderer()
   {
      return filterTabPanel.getRenderer();
   }


   /**
    * set the model to use for the filter list
    *
    * @param model  The new model value
    */
   public void setModel (ComboBoxModel model)
   {
      filterTabPanel.setModel (model);
      editTabPanel.setModel (model);
   }


   /**
    * get the model to use for the filter list
    *
    * @return   The model value
    */
   public ComboBoxModel getModel()
   {
      return filterTabPanel.getModel();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void parse()
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      filterTabPanel.unparse();
      editTabPanel.unparse();
      tabPane.setEnabledAt (tabPane.indexOfComponent (editTabPanel),
         getCurrentFilter() instanceof ConfigurableFilter);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowActivated (WindowEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowDeactivated (WindowEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowIconified (WindowEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowDeiconified (WindowEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowClosing (WindowEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowOpened (WindowEvent e)
   {
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void windowClosed (WindowEvent e)
   {
      ComboBoxModel model = getModel();

      if (model != null && model instanceof FilterManager.FMListModel)
      {
         setModel (new DefaultComboBoxModel());
          ((FilterManager.FMListModel) model).removeYou();
      }
   }
}

/*
 * $Log: FilterEditorDialog.java,v $
 * Revision 1.13  2004/10/20 17:50:33  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
