/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.views.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Iterator;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.*;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * Dialog to create or edit Views
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.22 $
 */
public class ViewEditorDialog extends PropertyEditor implements ActionListener,
   ItemListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DefaultListModel definitionsModel = new DefaultListModel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DefaultComboBoxModel viewModel = new DefaultComboBoxModel();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField nameField = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEList viewDefsList = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox targetComboBox = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton addDefButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton editDefButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton removeDefButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton addViewButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton removeViewButton = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton setNameButton = null;


   /**
    * Constructor for class ViewEditorDialog
    *
    * @param frame  No description provided
    */
   public ViewEditorDialog (JFrame frame)
   {
      super (frame);
      this.setTitle ("Add/edit View");

      initPE();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   public void additionalProperties (PEEditPanel panel)
   {
      PEColumn column = new PEColumn (this);
      column.add (createDiagramPanel());
      column.add (createDefinitionPanel());
      panel.add (column);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createDefinitionPanel()
   {
      PEColumn column = new PEColumn (this);
      column.setBorder (new TitledBorder ("View Definitions"));

      PEColumn main = new PEColumn (this);

      viewDefsList = new PEList (this, "View Definitions");
      viewDefsList.setStatus ("Select a ViewDefinition to edit");
      viewDefsList.getList().setModel (definitionsModel);
      viewDefsList.getList().setCellRenderer (new ViewDefinitionRenderer());

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.CENTER));
      addDefButton = new JButton();
      addDefButton.setText ("Add");
      addDefButton.setActionCommand ("addViewDefinition");
      addDefButton.addActionListener (this);

      editDefButton = new JButton();
      editDefButton.setText ("Edit");
      editDefButton.setActionCommand ("editViewDefinition");
      editDefButton.addActionListener (this);

      removeDefButton = new JButton();
      removeDefButton.setText ("Remove");
      removeDefButton.setActionCommand ("removeViewDefinition");
      removeDefButton.addActionListener (this);

      buttonPanel.add (addDefButton);
      buttonPanel.add (editDefButton);
      buttonPanel.add (removeDefButton);

      main.add (viewDefsList);
      main.add (buttonPanel);

      column.add (main);

      return column;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createDiagramPanel()
   {
      PEColumn column = new PEColumn (this);
      column.setBorder (new TitledBorder ("Target Diagram"));

      PEColumn main = new PEColumn (this);

      PECombo targetCombo = new PECombo (this, "Select View");
      targetComboBox = targetCombo.getComboBox();
      targetComboBox.setModel (viewModel);
      targetComboBox.addItemListener (this);

      nameField = new PETextField (this, "Enter name for view diagram");
      nameField.setEnabled (false);
      nameField.addActionListener (this);

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.CENTER));
      addViewButton = new JButton();
      addViewButton.setText ("Create New");
      addViewButton.setActionCommand ("addView");
      addViewButton.addActionListener (this);

      removeViewButton = new JButton();
      removeViewButton.setText ("Remove");
      removeViewButton.setActionCommand ("removeView");
      removeViewButton.addActionListener (this);

      setNameButton = new JButton();
      setNameButton.setText ("Apply Name");
      setNameButton.setActionCommand ("diagramName");
      setNameButton.addActionListener (this);
      setNameButton.setEnabled (false);

      buttonPanel.add (addViewButton);
      buttonPanel.add (removeViewButton);
      buttonPanel.add (setNameButton);

      //main .add(new JLabel("Select/Rename View")) ;
      main.add (targetCombo);
      main.add (nameField);
      main.add (buttonPanel);

      column.add (main);
      return column;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void parse() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      ASGElement incr = getIncrement();

      if (incr != null && incr instanceof UMLDiagram)
      {
         UMLDiagram diag = (UMLDiagram) incr;

         Iterator viewIter = diag.iteratorOfViews();
         while (viewIter.hasNext())
         {
            ViewDiagram view = (ViewDiagram) viewIter.next();
            targetComboBox.addItem (view);
         }
         if (diag instanceof ViewDiagram)
         {
            targetComboBox.addItem (diag);
            setTarget ((ViewDiagram) diag);
         }
         else if (viewModel.getSize() > 0)
         {
            setTarget ((ViewDiagram) viewModel.getElementAt (0));
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void cancel() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ViewDiagram target = null;


   /**
    * Sets the target attribute of the ViewEditorDialog object
    *
    * @param data  The new target value
    */
   private void setTarget (ViewDiagram data)
   {
      if (this.target != data)
      {
         this.target = data;
         targetComboBox.setSelectedItem (data);
         nameField.setEnabled (data != null);
         setNameButton.setEnabled (data != null);

         if (data != null)
         {
            nameField.setText (data.getName());
            try
            {
               FrameMain.get().selectTreeItem (data);
            }
            catch (Exception e)
            {
            }
         }
         else
         {
            nameField.setText ("");
            try
            {
               FrameMain.get().selectTreeItem (getIncrement());
            }
            catch (Exception e)
            {
            }
         }

         fillDefinitionList();
      }
   }


   /**
    * Get the target attribute of the ViewEditorDialog object
    *
    * @return   The target value
    */
   private ViewDiagram getTarget()
   {
      return target;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void fillDefinitionList()
   {
      ViewDiagram data = getTarget();
      definitionsModel.clear();
      if (data == null)
      {
         return;
      }

      Iterator iter = data.iteratorOfViewDefinitions();
      while (iter.hasNext())
      {
         ViewDefinition def = (ViewDefinition) iter.next();
         definitionsModel.addElement (def);
      }
      if (definitionsModel.size() > 0)
      {
         viewDefsList.getList().setSelectedIndex (0);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param data  No description provided
    * @return      No description provided
    */
   private String createUniqueName (ViewDiagram data)
   {
      Iterator iter = null;
      boolean found = false;
      UMLDiagram diag = data.getDiagram();
      if (diag != null)
      {
         iter = diag.iteratorOfViews();
         while (iter.hasNext() && !found)
         {
            ViewDiagram tmpData = (ViewDiagram) iter.next();
            if (tmpData != data && tmpData.getName() != null && tmpData.getName().equals (data.getName()))
            {
               found = true;
            }
         }
         if (found)
         {
            int counter = 0;
            String name = data.getName();
            if (name.lastIndexOf ("<") > -1 && name.lastIndexOf (">") > name.lastIndexOf ("<"))
            {
               String numText = name.substring (name.lastIndexOf ("<") + 1, name.lastIndexOf (">"));
               try
               {
                  counter = Integer.parseInt (numText);
                  name = name.substring (0, name.lastIndexOf ("<")).trim();
               }
               catch (Exception e)
               {
               }
            }
            while (found)
            {
               counter++;
               found = false;
               iter = diag.iteratorOfViews();
               while (iter.hasNext() && !found)
               {
                  ViewDiagram tmpData = (ViewDiagram) iter.next();
                  if (tmpData != data && tmpData.getName() != null && tmpData.getName().equals (data.getName() + " <" + counter + ">"))
                  {
                     found = true;
                  }
               }
            }
            data.setName (data.getName() + " <" + counter + ">");
         }
      }
      return data.getName();
   }


   /**
    * Listener method for the views list
    *
    * @param e  No description provided
    */
   public void itemStateChanged (ItemEvent e)
   {
      setTarget ((ViewDiagram) targetComboBox.getSelectedItem());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      String command = e.getActionCommand();

      if ("addViewDefinition".equals (command))
      {
         addDefinitionAction();
      }
      else if ("editViewDefinition".equals (command))
      {
         editDefinitionAction();
      }
      else if ("removeViewDefinition".equals (command))
      {
         removeDefinitionAction();
      }
      else if ("addView".equals (command))
      {
         addViewAction();
      }
      else if ("removeView".equals (command))
      {
         removeViewAction();
      }
      else if ("diagramName".equals (command) || e.getSource() == nameField)
      {
         diagramNameAction();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void diagramNameAction()
   {
      ViewDiagram data = getTarget();
      if (data == null)
      {
         return;
      }

      String newName = nameField.getText();
      String oldName = data.getName();

      if (oldName != null)
      {
         oldName = oldName.trim();
      }

      if (newName != null && !newName.trim().equals (oldName))
      {
         try
         {
            data.setName (newName.trim());
            createUniqueName (data);
            FrameMain.get().createNewTreeItems();
            FrameMain.get().selectTreeItem (data);
         }
         finally
         {
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void removeViewAction()
   {
      ViewDiagram diag = getTarget();
      if (diag == null)
      {
         return;
      }

      int result = JOptionPane.showConfirmDialog (this,
         "Really delete this View?", "Delete View",
         JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);

      if (result == JOptionPane.YES_OPTION)
      {
         boolean update = false;
         UMLDiagram source = diag.getDiagram();
         if (diag == getIncrement())
         {
            update = true;
         }
         targetComboBox.removeItem (diag);
         removeView (diag);
         if (update)
         {
            setIncrement (source);
         }
      }
   }


   /**
    * Access method for an one to n association.
    */
   private void addViewAction()
   {
      ViewDiagram result = null;
      UMLDiagram source = (UMLDiagram) getIncrement();
      if (source == null)
      {
         return;
      }

      String name = nameField.getText();
      if (name == null || name.trim().length() == 0 || getTarget() != null && name.equals (getTarget().getName()))
      {
         name = "Unnamed View";
      }
      try
      {
         result = new ViewDiagram (name, (UMLProject) source.getProject());
         result.setDiagram (source);
         createUniqueName (result);
         FrameMain.get().createNewTreeItems();
         FrameMain.get().selectTreeItem (result);
      }
      finally
      {
      }

      targetComboBox.addItem (result);
      targetComboBox.setSelectedItem (result);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void removeDefinitionAction()
   {
      Object selected = viewDefsList.getList().getSelectedValue();
      if (selected instanceof ViewDefinition)
      {
         ViewDefinition def = (ViewDefinition) selected;
         definitionsModel.removeElement (selected);
         def.removeYou();
         UMLProject.get().refreshDisplay();
      }
   }


   /**
    * Access method for an one to n association.
    */
   private void addDefinitionAction()
   {
      ViewDefinition newDef = new ViewDefinition();
      newDef.setName ("<Unnamed Definition>");
      ViewDefinitionDialog dialog = new ViewDefinitionDialog (null);
      UMLDiagram source = (UMLDiagram) getIncrement();
      if (source != null && source == getTarget())
      {
         source =  ((ViewDiagram) source).getDiagram();
      }
      dialog.addToSourceDiagrams (source);
      dialog.setView (newDef);
      dialog.showCentered();
      if (dialog.getPressedButton() == FujabaDialog.OK)
      {
         if (getTarget() != null)
         {
            getTarget().addToViewDefinitions (newDef);
            definitionsModel.addElement (newDef);
            UMLProject.get().refreshDisplay();
         }
         else
         {
            newDef.removeYou();
         }
      }
      else
      {
         newDef.removeYou();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void editDefinitionAction()
   {
      ViewDefinition def = (ViewDefinition) viewDefsList.getList().getSelectedValue();

      if (def == null)
      {
         return;
      }

      ViewDefinitionDialog dialog = new ViewDefinitionDialog (null);
      UMLDiagram source = null;
      if (def.getDiagram() != null)
      {
         source = def.getDiagram();
         if ( ((ViewDiagram) source).getDiagram() != null)
         {
            source =  ((ViewDiagram) source).getDiagram();
         }
         else if ( ((ViewDiagram) source).getDiagram() != null)
         {
            source =  ((ViewDiagram) source).getDiagram();
         }
      }
      else
      {
         source = (UMLDiagram) getIncrement();
      }

      dialog.addToSourceDiagrams (source);
      dialog.setView (def);
      dialog.showCentered();
      viewDefsList.repaint();
      UMLProject.get().refreshDisplay();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag  No description provided
    */
   private void removeView (ViewDiagram diag)
   {
      try
      {
         Iterator iter = diag.iteratorOfViews();
         while (iter.hasNext())
         {
            ViewDiagram tmpDiag = (ViewDiagram) iter.next();
            removeSubView (tmpDiag);
         }
         UMLDiagram source = diag.getDiagram();
         diag.removeYou();
         FrameMain.get().createNewTreeItems();
         if (source == null)
         {
            source = (UMLDiagram) getIncrement();
            if (source == diag)
            {
               source = null;
            }
         }

         if (source != null)
         {
            FrameMain.get().selectTreeItem (source);
         }

         System.gc();
      }
      finally
      {
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag  No description provided
    */
   private void removeSubView (ViewDiagram diag)
   {
      try
      {
         Iterator iter = diag.iteratorOfViews();
         while (iter.hasNext())
         {
            ViewDiagram tmpDiag = (ViewDiagram) iter.next();
            removeSubView (tmpDiag);
         }
         diag.removeYou();
      }
      finally
      {
      }
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.22 $
 */
class ViewDefinitionRenderer extends DefaultListCellRenderer
{


   /**
    * Get the listCellRendererComponent attribute of the ViewDefinitionRenderer object
    *
    * @param list          No description provided
    * @param value         No description provided
    * @param index         No description provided
    * @param isSelected    No description provided
    * @param cellHasFocus  No description provided
    * @return              The listCellRendererComponent value
    */
   public Component getListCellRendererComponent (JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
   {
      if (value == null || ! (value instanceof ViewDefinition))
      {
         return super.getListCellRendererComponent (list, value, index, isSelected, cellHasFocus);
      }

      ViewDefinition def = (ViewDefinition) value;

      String name = "<null>";

      if (def.getName() != null)
      {
         name = def.getName();
      }

      if (def.getFilter() != null)
      {
         if (def.getFilter().getName() != null)
         {
            name += ": " + def.getFilter().getName();
         }

         String className = def.getFilter().getClass().getName();
         int lastDot = className.lastIndexOf (".");
         if (lastDot > -1)
         {
            className = className.substring (lastDot + 1);
         }

         name += "[" + className + "]";
      }
      return super.getListCellRendererComponent (list,
         name + "(" +  (def.getContext() > -1 ? String.valueOf (def.getContext()) : "Max") + "-Context)",
         index, isSelected, cellHasFocus);
   }

}

/*
 * $Log: ViewEditorDialog.java,v $
 * Revision 1.22  2004/10/22 16:41:44  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
