package de.upb.inferenceengine.engines;

import de.upb.tools.fca.FEmptyIterator;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLArray;

public class ArrayReferenceEngine
extends GFRNEngine
{
   private  ArrayReferenceEngine()
   {
   }

   private static ArrayReferenceEngine theArrayReferenceEngine;

   public static ArrayReferenceEngine get()
   {
      if (theArrayReferenceEngine == null)
      {
         theArrayReferenceEngine = new ArrayReferenceEngine ();
      }
      return theArrayReferenceEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation arrayReference = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         arrayReference = this.annotateUsingTrigger_UMLArrayRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( arrayReference != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (arrayReference) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            arrayReference = this.annotateUsingFieldRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( arrayReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (arrayReference) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               arrayReference = this.annotateUsingReferencingClassRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( arrayReference != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (arrayReference) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  arrayReference = this.annotateUsingReferencesRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               return (arrayReference) ;
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingFieldRole(ASGElement asgElement)
   {
      ArrayReferenceAnnotation arrayReference = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterReferencingFieldAnnotationsArrayReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLArray fieldType = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
             
            // explicit type cast
            referencingField = (UMLAttr) fujaba__tmpTypeCastObject ;
             
            // bind fieldType: UMLArray
            fujaba__TmpObject = referencingField.getAttrType () ;
            JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLArray ) ;
            fieldType = (UMLArray) fujaba__TmpObject ;
             
            // bind referencingClass: UMLClass
            referencingClass = referencingField.getParent () ;
            JavaSDM.ensure ( referencingClass != null ) ;
             
            // bind referredClass: UMLClass
            fujaba__TmpObject = fieldType.getArrayType () ;
            JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
            referredClass = (UMLClass) fujaba__TmpObject ;
             
            // check isomorphic binding
            JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
             
            {
               //  for each flow
               try
               {
                  fujaba__Success = false ;
                   
                  // check object referencingClass is really bound
                  JavaSDM.ensure ( referencingClass != null ) ;
                   
                  // check object referredClass is really bound
                  JavaSDM.ensure ( referredClass != null ) ;
                   
                  // check isomorphic binding
                  JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                   
                  // check object referencingField is really bound
                  JavaSDM.ensure ( referencingField != null ) ;
                   
                  // bind arrayReference: ArrayReferenceAnnotation
                  fujaba__IterReferencingFieldAnnotationsArrayReference = referencingField.iteratorOfAnnotations () ;
                  while ( !(fujaba__Success) && fujaba__IterReferencingFieldAnnotationsArrayReference.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsArrayReference.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof ArrayReferenceAnnotation ) ;
                        arrayReference = (ArrayReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between arrayReference and referencingField
                        JavaSDM.ensure ( arrayReference.hasInElements ("field", referencingField) ) ;
                         
                        // check To-Many-Link 'elements' between arrayReference and referencingClass
                        JavaSDM.ensure ( arrayReference.hasInElements ("referencingClass", referencingClass) ) ;
                         
                        // check To-Many-Link 'elements' between arrayReference and referredClass
                        JavaSDM.ensure ( arrayReference.hasInElements ("references", referredClass) ) ;
                         
                        fujaba__Success = true ;
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( !(fujaba__Success) )
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // check object referencingClass is really bound
                     JavaSDM.ensure ( referencingClass != null ) ;
                      
                     // check object referredClass is really bound
                     JavaSDM.ensure ( referredClass != null ) ;
                      
                     // check isomorphic binding
                     JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                      
                     // check object referencingField is really bound
                     JavaSDM.ensure ( referencingField != null ) ;
                      
                     // check object fieldType is really bound
                     JavaSDM.ensure ( fieldType != null ) ;
                      
                     // create object
                     arrayReference = new ArrayReferenceAnnotation ( ) ;
                      
                     // assign statement
                     arrayReference.setClassification (0);
                      
                     // create link
                     arrayReference.addToElements ("referencingClass", referencingClass);
                      
                     // create link
                     arrayReference.addToElements ("references", referredClass);
                      
                     // create link
                     arrayReference.addToElements ("field", referencingField);
                      
                     // create link
                     arrayReference.addToBoundObjects ("fieldType", fieldType);
                      
                     // create link
                     arrayReference.addToBoundObjects ("referencingField", referencingField);
                      
                     // create link
                     arrayReference.addToBoundObjects ("referencingClass", referencingClass);
                      
                     // create link
                     arrayReference.addToBoundObjects ("referredClass", referredClass);
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  try
                  {
                     fujaba__Success = false ;
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (arrayReference) ;
               }
            } //  end for each flow
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object arrayReference is really bound
            JavaSDM.ensure ( arrayReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("field", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (arrayReference) ;
   }


   private GFRNAnnotation annotateUsingReferencesRole(ASGElement asgElement)
   {
      ArrayReferenceAnnotation arrayReference = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterFieldTypeRevAttrTypeReferencingField = null ;
      Iterator fujaba__IterReferencingClassAnnotationsArrayReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLArray fieldType = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referredClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind fieldType: UMLArray
            fieldType = referredClass.getRevArrayType () ;
            JavaSDM.ensure ( fieldType != null ) ;
             
            // bind referencingField: UMLAttr
            fujaba__IterFieldTypeRevAttrTypeReferencingField = fieldType.iteratorOfRevAttrType () ;
            while ( fujaba__IterFieldTypeRevAttrTypeReferencingField.hasNext () )
            {
               try
               {
                  referencingField = (UMLAttr) fujaba__IterFieldTypeRevAttrTypeReferencingField.next () ;
                   
                  // bind referencingClass: UMLClass
                  referencingClass = referencingField.getParent () ;
                  JavaSDM.ensure ( referencingClass != null ) ;
                   
                  // check isomorphic binding
                  JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object referencingClass is really bound
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // check object referredClass is really bound
                        JavaSDM.ensure ( referredClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                         
                        // check object referencingField is really bound
                        JavaSDM.ensure ( referencingField != null ) ;
                         
                        // bind arrayReference: ArrayReferenceAnnotation
                        fujaba__IterReferencingClassAnnotationsArrayReference = referencingClass.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterReferencingClassAnnotationsArrayReference.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReferencingClassAnnotationsArrayReference.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ArrayReferenceAnnotation ) ;
                              arrayReference = (ArrayReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between arrayReference and referencingClass
                              JavaSDM.ensure ( arrayReference.hasInElements ("referencingClass", referencingClass) ) ;
                               
                              // check To-Many-Link 'elements' between arrayReference and referredClass
                              JavaSDM.ensure ( arrayReference.hasInElements ("references", referredClass) ) ;
                               
                              // check To-Many-Link 'elements' between arrayReference and referencingField
                              JavaSDM.ensure ( arrayReference.hasInElements ("field", referencingField) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object referencingClass is really bound
                           JavaSDM.ensure ( referencingClass != null ) ;
                            
                           // check object referredClass is really bound
                           JavaSDM.ensure ( referredClass != null ) ;
                            
                           // check isomorphic binding
                           JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                            
                           // check object referencingField is really bound
                           JavaSDM.ensure ( referencingField != null ) ;
                            
                           // check object fieldType is really bound
                           JavaSDM.ensure ( fieldType != null ) ;
                            
                           // create object
                           arrayReference = new ArrayReferenceAnnotation ( ) ;
                            
                           // assign statement
                           arrayReference.setClassification (0);
                            
                           // create link
                           arrayReference.addToElements ("referencingClass", referencingClass);
                            
                           // create link
                           arrayReference.addToElements ("references", referredClass);
                            
                           // create link
                           arrayReference.addToElements ("field", referencingField);
                            
                           // create link
                           arrayReference.addToBoundObjects ("fieldType", fieldType);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referencingField", referencingField);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referencingClass", referencingClass);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referredClass", referredClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (arrayReference) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object arrayReference is really bound
            JavaSDM.ensure ( arrayReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("references", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (arrayReference) ;
   }


   private GFRNAnnotation annotateUsingReferencingClassRole(ASGElement asgElement)
   {
      ArrayReferenceAnnotation arrayReference = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterReferencingClassAttrsReferencingField = null ;
      Iterator fujaba__IterReferredClassAnnotationsArrayReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLArray fieldType = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("referencingClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referencingClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind referencingField: UMLAttr
            fujaba__IterReferencingClassAttrsReferencingField = referencingClass.iteratorOfAttrs () ;
            while ( fujaba__IterReferencingClassAttrsReferencingField.hasNext () )
            {
               try
               {
                  referencingField = (UMLAttr) fujaba__IterReferencingClassAttrsReferencingField.next () ;
                   
                  // bind fieldType: UMLArray
                  fujaba__TmpObject = referencingField.getAttrType () ;
                  JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLArray ) ;
                  fieldType = (UMLArray) fujaba__TmpObject ;
                   
                  // bind referredClass: UMLClass
                  fujaba__TmpObject = fieldType.getArrayType () ;
                  JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  referredClass = (UMLClass) fujaba__TmpObject ;
                   
                  // check isomorphic binding
                  JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object referencingClass is really bound
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // check object referredClass is really bound
                        JavaSDM.ensure ( referredClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                         
                        // check object referencingField is really bound
                        JavaSDM.ensure ( referencingField != null ) ;
                         
                        // bind arrayReference: ArrayReferenceAnnotation
                        fujaba__IterReferredClassAnnotationsArrayReference = referredClass.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterReferredClassAnnotationsArrayReference.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReferredClassAnnotationsArrayReference.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ArrayReferenceAnnotation ) ;
                              arrayReference = (ArrayReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between arrayReference and referredClass
                              JavaSDM.ensure ( arrayReference.hasInElements ("references", referredClass) ) ;
                               
                              // check To-Many-Link 'elements' between arrayReference and referencingClass
                              JavaSDM.ensure ( arrayReference.hasInElements ("referencingClass", referencingClass) ) ;
                               
                              // check To-Many-Link 'elements' between arrayReference and referencingField
                              JavaSDM.ensure ( arrayReference.hasInElements ("field", referencingField) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object referencingClass is really bound
                           JavaSDM.ensure ( referencingClass != null ) ;
                            
                           // check object referredClass is really bound
                           JavaSDM.ensure ( referredClass != null ) ;
                            
                           // check isomorphic binding
                           JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                            
                           // check object referencingField is really bound
                           JavaSDM.ensure ( referencingField != null ) ;
                            
                           // check object fieldType is really bound
                           JavaSDM.ensure ( fieldType != null ) ;
                            
                           // create object
                           arrayReference = new ArrayReferenceAnnotation ( ) ;
                            
                           // assign statement
                           arrayReference.setClassification (0);
                            
                           // create link
                           arrayReference.addToElements ("referencingClass", referencingClass);
                            
                           // create link
                           arrayReference.addToElements ("references", referredClass);
                            
                           // create link
                           arrayReference.addToElements ("field", referencingField);
                            
                           // create link
                           arrayReference.addToBoundObjects ("fieldType", fieldType);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referencingField", referencingField);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referencingClass", referencingClass);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referredClass", referredClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (arrayReference) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object arrayReference is really bound
            JavaSDM.ensure ( arrayReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("referencingClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (arrayReference) ;
   }


   private GFRNAnnotation annotateUsingTrigger_UMLArrayRole(ASGElement asgElement)
   {
      ArrayReferenceAnnotation arrayReference = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterFieldTypeRevAttrTypeReferencingField = null ;
      Iterator fujaba__IterReferencingClassAnnotationsArrayReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLArray fieldType = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_UMLArray", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLArray ) ;
             
            // explicit type cast
            fieldType = (UMLArray) fujaba__tmpTypeCastObject ;
             
            // bind referredClass: UMLClass
            fujaba__TmpObject = fieldType.getArrayType () ;
            JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
            referredClass = (UMLClass) fujaba__TmpObject ;
             
            // bind referencingField: UMLAttr
            fujaba__IterFieldTypeRevAttrTypeReferencingField = fieldType.iteratorOfRevAttrType () ;
            while ( fujaba__IterFieldTypeRevAttrTypeReferencingField.hasNext () )
            {
               try
               {
                  referencingField = (UMLAttr) fujaba__IterFieldTypeRevAttrTypeReferencingField.next () ;
                   
                  // bind referencingClass: UMLClass
                  referencingClass = referencingField.getParent () ;
                  JavaSDM.ensure ( referencingClass != null ) ;
                   
                  // check isomorphic binding
                  JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object referencingClass is really bound
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // check object referredClass is really bound
                        JavaSDM.ensure ( referredClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                         
                        // check object referencingField is really bound
                        JavaSDM.ensure ( referencingField != null ) ;
                         
                        // bind arrayReference: ArrayReferenceAnnotation
                        fujaba__IterReferencingClassAnnotationsArrayReference = referencingClass.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterReferencingClassAnnotationsArrayReference.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReferencingClassAnnotationsArrayReference.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ArrayReferenceAnnotation ) ;
                              arrayReference = (ArrayReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between arrayReference and referencingClass
                              JavaSDM.ensure ( arrayReference.hasInElements ("referencingClass", referencingClass) ) ;
                               
                              // check To-Many-Link 'elements' between arrayReference and referredClass
                              JavaSDM.ensure ( arrayReference.hasInElements ("references", referredClass) ) ;
                               
                              // check To-Many-Link 'elements' between arrayReference and referencingField
                              JavaSDM.ensure ( arrayReference.hasInElements ("field", referencingField) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object referencingClass is really bound
                           JavaSDM.ensure ( referencingClass != null ) ;
                            
                           // check object referredClass is really bound
                           JavaSDM.ensure ( referredClass != null ) ;
                            
                           // check isomorphic binding
                           JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                            
                           // check object referencingField is really bound
                           JavaSDM.ensure ( referencingField != null ) ;
                            
                           // check object fieldType is really bound
                           JavaSDM.ensure ( fieldType != null ) ;
                            
                           // create object
                           arrayReference = new ArrayReferenceAnnotation ( ) ;
                            
                           // assign statement
                           arrayReference.setClassification (0);
                            
                           // create link
                           arrayReference.addToElements ("referencingClass", referencingClass);
                            
                           // create link
                           arrayReference.addToElements ("references", referredClass);
                            
                           // create link
                           arrayReference.addToElements ("field", referencingField);
                            
                           // create link
                           arrayReference.addToBoundObjects ("fieldType", fieldType);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referencingField", referencingField);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referencingClass", referencingClass);
                            
                           // create link
                           arrayReference.addToBoundObjects ("referredClass", referredClass);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (arrayReference) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object arrayReference is really bound
            JavaSDM.ensure ( arrayReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_UMLArray", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (arrayReference) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("referencingClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLAttr )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLArray )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_UMLArray", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      return (FEmptyIterator.get()) ;
   }


}
