package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;

public class BridgeInterfaceEngine
extends GFRNEngine
{
   private  BridgeInterfaceEngine()
   {
   }

   private static BridgeInterfaceEngine theBridgeInterfaceEngine;

   public static BridgeInterfaceEngine get()
   {
      if (theBridgeInterfaceEngine == null)
      {
         theBridgeInterfaceEngine = new BridgeInterfaceEngine ();
      }
      return theBridgeInterfaceEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation bridgeInterface = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         bridgeInterface = this.annotateUsingImplementorRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( bridgeInterface != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (bridgeInterface) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            bridgeInterface = this.annotateUsingTrigger_ReferenceRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( bridgeInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (bridgeInterface) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               bridgeInterface = this.annotateUsingAbstractionRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( bridgeInterface != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (bridgeInterface) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  bridgeInterface = this.annotateUsingTrigger_GeneralizationRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( bridgeInterface != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (bridgeInterface) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     bridgeInterface = this.annotateUsingTrigger_NeighborCallRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (bridgeInterface) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingAbstractionRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeInterfaceAnnotation bridgeInterface = null ;
      Iterator fujaba__IterAbstractionAnnotationsBridgeInterface = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization12 = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization14 = null ;
      Iterator fujaba__IterAbstractionAnnotationsReference13 = null ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterImplementorStereotypesUMLStereotype11 = null ;
      Iterator fujaba__IterNeighborCall15ElementsOperationImpl = null ;
      Iterator fujaba__IterOperationAnnotationsNeighborCall15 = null ;
      Iterator fujaba__IterReference13ElementsImplementor = null ;
      GeneralizationAnnotation generalization12 = null ;
      GeneralizationAnnotation generalization14 = null ;
      NeighborCallAnnotation neighborCall15 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference13 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
      UMLStereotype uMLStereotype11 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("abstraction", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
            while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
            {
               try
               {
                  operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                   
                  // bind reference13: ReferenceAnnotation
                  fujaba__IterAbstractionAnnotationsReference13 = abstraction.iteratorOfAnnotations () ;
                  while ( fujaba__IterAbstractionAnnotationsReference13.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAbstractionAnnotationsReference13.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                        reference13 = (ReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between reference13 and abstraction
                        JavaSDM.ensure ( reference13.hasInElements ("referencingClass", abstraction) ) ;
                         
                        // bind generalization14: GeneralizationAnnotation
                        fujaba__IterAbstractionAnnotationsGeneralization14 = abstraction.iteratorOfAnnotations () ;
                        while ( fujaba__IterAbstractionAnnotationsGeneralization14.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization14.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization14 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization14 and abstraction
                              JavaSDM.ensure ( generalization14.hasInElements ("superClass", abstraction) ) ;
                               
                              // bind neighborCall15: NeighborCallAnnotation
                              fujaba__IterOperationAnnotationsNeighborCall15 = operation.iteratorOfAnnotations () ;
                              while ( fujaba__IterOperationAnnotationsNeighborCall15.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOperationAnnotationsNeighborCall15.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall15 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall15 and operation
                                    JavaSDM.ensure ( neighborCall15.hasInElements ("caller", operation) ) ;
                                     
                                    // bind implementor: UMLClass
                                    fujaba__IterReference13ElementsImplementor = reference13.iteratorOfElements ("references") ;
                                    while ( fujaba__IterReference13ElementsImplementor.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterReference13ElementsImplementor.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          implementor = (UMLClass) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                           
                                          // check negative application condition
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // bind generalization12: GeneralizationAnnotation
                                             fujaba__IterAbstractionAnnotationsGeneralization12 = abstraction.iteratorOfAnnotations () ;
                                             while ( fujaba__IterAbstractionAnnotationsGeneralization12.hasNext () )
                                             {
                                                try
                                                {
                                                   fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization12.next () ;
                                                   JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                   generalization12 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                    
                                                   // check Reverse-Qualified-Link 'elements' between generalization12 and abstraction
                                                   JavaSDM.ensure ( generalization12.hasInElements ("subClass", abstraction) ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(generalization14.equals (generalization12)) ) ;
                                                    
                                                   // check To-Many-Link 'elements' between generalization12 and implementor
                                                   JavaSDM.ensure ( generalization12.hasInElements ("superClass", implementor) ) ;
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                }
                                             }
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          fujaba__Success = !(fujaba__Success);
                                          JavaSDM.ensure ( fujaba__Success ) ;
                                          fujaba__Success = false;
                                          // end of negative application condition
                                           
                                          // bind operationImpl: UMLMethod
                                          fujaba__IterNeighborCall15ElementsOperationImpl = neighborCall15.iteratorOfElements ("callee") ;
                                          while ( fujaba__IterNeighborCall15ElementsOperationImpl.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall15ElementsOperationImpl.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                operationImpl = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                 
                                                // check To-One-Link 'parent' between operationImpl and implementor
                                                JavaSDM.ensure ( (operationImpl.getParent () != null) && operationImpl.getParent ().equals (implementor) ) ;
                                                 
                                                // bind uMLStereotype11: UMLStereotype
                                                fujaba__IterImplementorStereotypesUMLStereotype11 = implementor.iteratorOfStereotypes () ;
                                                while ( fujaba__IterImplementorStereotypesUMLStereotype11.hasNext () )
                                                {
                                                   try
                                                   {
                                                      uMLStereotype11 = (UMLStereotype) fujaba__IterImplementorStereotypesUMLStereotype11.next () ;
                                                       
                                                      // attribute condition
                                                      JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype11.getText (), "interface") == 0) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object implementor is really bound
                                                            JavaSDM.ensure ( implementor != null ) ;
                                                             
                                                            // check object abstraction is really bound
                                                            JavaSDM.ensure ( abstraction != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                             
                                                            // bind bridgeInterface: BridgeInterfaceAnnotation
                                                            fujaba__IterAbstractionAnnotationsBridgeInterface = abstraction.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterAbstractionAnnotationsBridgeInterface.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterAbstractionAnnotationsBridgeInterface.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeInterfaceAnnotation ) ;
                                                                  bridgeInterface = (BridgeInterfaceAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between bridgeInterface and abstraction
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("abstraction", abstraction) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between bridgeInterface and implementor
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("implementor", implementor) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object implementor is really bound
                                                               JavaSDM.ensure ( implementor != null ) ;
                                                                
                                                               // check object abstraction is really bound
                                                               JavaSDM.ensure ( abstraction != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                                
                                                               // check object operation is really bound
                                                               JavaSDM.ensure ( operation != null ) ;
                                                                
                                                               // check object operationImpl is really bound
                                                               JavaSDM.ensure ( operationImpl != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                                
                                                               // create object
                                                               bridgeInterface = new BridgeInterfaceAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               bridgeInterface.setClassification (1);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operation", operation);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operationImpl", operationImpl);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object reference13 is really bound
                                                               JavaSDM.ensure ( reference13 != null ) ;
                                                                
                                                               // check object generalization14 is really bound
                                                               JavaSDM.ensure ( generalization14 != null ) ;
                                                                
                                                               // check object neighborCall15 is really bound
                                                               JavaSDM.ensure ( neighborCall15 != null ) ;
                                                                
                                                               // check object bridgeInterface is really bound
                                                               JavaSDM.ensure ( bridgeInterface != null ) ;
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (reference13);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (generalization14);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (neighborCall15);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (bridgeInterface) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridgeInterface is really bound
            JavaSDM.ensure ( bridgeInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("abstraction", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridgeInterface) ;
   }


   private GFRNAnnotation annotateUsingImplementorRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeInterfaceAnnotation bridgeInterface = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization4 = null ;
      Iterator fujaba__IterImplementorAnnotationsBridgeInterface = null ;
      Iterator fujaba__IterImplementorAnnotationsGeneralization2 = null ;
      Iterator fujaba__IterImplementorAnnotationsReference3 = null ;
      Iterator fujaba__IterImplementorMethodsOperationImpl = null ;
      Iterator fujaba__IterImplementorStereotypesUMLStereotype1 = null ;
      Iterator fujaba__IterNeighborCall5ElementsOperation = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall5 = null ;
      Iterator fujaba__IterReference3ElementsAbstraction = null ;
      GeneralizationAnnotation generalization2 = null ;
      GeneralizationAnnotation generalization4 = null ;
      NeighborCallAnnotation neighborCall5 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference3 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
      UMLStereotype uMLStereotype1 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("implementor", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
            while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
            {
               try
               {
                  operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                   
                  // bind uMLStereotype1: UMLStereotype
                  fujaba__IterImplementorStereotypesUMLStereotype1 = implementor.iteratorOfStereotypes () ;
                  while ( fujaba__IterImplementorStereotypesUMLStereotype1.hasNext () )
                  {
                     try
                     {
                        uMLStereotype1 = (UMLStereotype) fujaba__IterImplementorStereotypesUMLStereotype1.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype1.getText (), "interface") == 0) ) ;
                         
                        // bind reference3: ReferenceAnnotation
                        fujaba__IterImplementorAnnotationsReference3 = implementor.iteratorOfAnnotations () ;
                        while ( fujaba__IterImplementorAnnotationsReference3.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterImplementorAnnotationsReference3.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference3 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference3 and implementor
                              JavaSDM.ensure ( reference3.hasInElements ("references", implementor) ) ;
                               
                              // bind neighborCall5: NeighborCallAnnotation
                              fujaba__IterOperationImplAnnotationsNeighborCall5 = operationImpl.iteratorOfAnnotations () ;
                              while ( fujaba__IterOperationImplAnnotationsNeighborCall5.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall5.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall5 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall5 and operationImpl
                                    JavaSDM.ensure ( neighborCall5.hasInElements ("callee", operationImpl) ) ;
                                     
                                    // bind abstraction: UMLClass
                                    fujaba__IterReference3ElementsAbstraction = reference3.iteratorOfElements ("referencingClass") ;
                                    while ( fujaba__IterReference3ElementsAbstraction.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterReference3ElementsAbstraction.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          abstraction = (UMLClass) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                           
                                          // check negative application condition
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // bind generalization2: GeneralizationAnnotation
                                             fujaba__IterImplementorAnnotationsGeneralization2 = implementor.iteratorOfAnnotations () ;
                                             while ( fujaba__IterImplementorAnnotationsGeneralization2.hasNext () )
                                             {
                                                try
                                                {
                                                   fujaba__TmpObject = fujaba__IterImplementorAnnotationsGeneralization2.next () ;
                                                   JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                   generalization2 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                    
                                                   // check Reverse-Qualified-Link 'elements' between generalization2 and implementor
                                                   JavaSDM.ensure ( generalization2.hasInElements ("superClass", implementor) ) ;
                                                    
                                                   // check To-Many-Link 'elements' between generalization2 and abstraction
                                                   JavaSDM.ensure ( generalization2.hasInElements ("subClass", abstraction) ) ;
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                }
                                             }
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          fujaba__Success = !(fujaba__Success);
                                          JavaSDM.ensure ( fujaba__Success ) ;
                                          fujaba__Success = false;
                                          // end of negative application condition
                                           
                                          // bind operation: UMLMethod
                                          fujaba__IterNeighborCall5ElementsOperation = neighborCall5.iteratorOfElements ("caller") ;
                                          while ( fujaba__IterNeighborCall5ElementsOperation.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall5ElementsOperation.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                operation = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                                 
                                                // check To-One-Link 'parent' between operation and abstraction
                                                JavaSDM.ensure ( (operation.getParent () != null) && operation.getParent ().equals (abstraction) ) ;
                                                 
                                                // bind generalization4: GeneralizationAnnotation
                                                fujaba__IterAbstractionAnnotationsGeneralization4 = abstraction.iteratorOfAnnotations () ;
                                                while ( fujaba__IterAbstractionAnnotationsGeneralization4.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization4.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                      generalization4 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between generalization4 and abstraction
                                                      JavaSDM.ensure ( generalization4.hasInElements ("superClass", abstraction) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object implementor is really bound
                                                            JavaSDM.ensure ( implementor != null ) ;
                                                             
                                                            // check object abstraction is really bound
                                                            JavaSDM.ensure ( abstraction != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                             
                                                            // bind bridgeInterface: BridgeInterfaceAnnotation
                                                            fujaba__IterImplementorAnnotationsBridgeInterface = implementor.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterImplementorAnnotationsBridgeInterface.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterImplementorAnnotationsBridgeInterface.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeInterfaceAnnotation ) ;
                                                                  bridgeInterface = (BridgeInterfaceAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between bridgeInterface and implementor
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("implementor", implementor) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between bridgeInterface and abstraction
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("abstraction", abstraction) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object implementor is really bound
                                                               JavaSDM.ensure ( implementor != null ) ;
                                                                
                                                               // check object abstraction is really bound
                                                               JavaSDM.ensure ( abstraction != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                                
                                                               // check object operation is really bound
                                                               JavaSDM.ensure ( operation != null ) ;
                                                                
                                                               // check object operationImpl is really bound
                                                               JavaSDM.ensure ( operationImpl != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                                
                                                               // create object
                                                               bridgeInterface = new BridgeInterfaceAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               bridgeInterface.setClassification (1);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operation", operation);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operationImpl", operationImpl);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object reference3 is really bound
                                                               JavaSDM.ensure ( reference3 != null ) ;
                                                                
                                                               // check object generalization4 is really bound
                                                               JavaSDM.ensure ( generalization4 != null ) ;
                                                                
                                                               // check object neighborCall5 is really bound
                                                               JavaSDM.ensure ( neighborCall5 != null ) ;
                                                                
                                                               // check object bridgeInterface is really bound
                                                               JavaSDM.ensure ( bridgeInterface != null ) ;
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (reference3);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (generalization4);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (neighborCall5);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (bridgeInterface) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridgeInterface is really bound
            JavaSDM.ensure ( bridgeInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("implementor", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridgeInterface) ;
   }


   private GFRNAnnotation annotateUsingTrigger_GeneralizationRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeInterfaceAnnotation bridgeInterface = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization17 = null ;
      Iterator fujaba__IterAbstractionAnnotationsReference18 = null ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterGeneralization19ElementsAbstraction = null ;
      Iterator fujaba__IterImplementorAnnotationsBridgeInterface = null ;
      Iterator fujaba__IterImplementorStereotypesUMLStereotype16 = null ;
      Iterator fujaba__IterNeighborCall20ElementsOperationImpl = null ;
      Iterator fujaba__IterOperationAnnotationsNeighborCall20 = null ;
      Iterator fujaba__IterReference18ElementsImplementor = null ;
      GeneralizationAnnotation generalization17 = null ;
      GeneralizationAnnotation generalization19 = null ;
      NeighborCallAnnotation neighborCall20 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference18 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
      UMLStereotype uMLStereotype16 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization19 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization19ElementsAbstraction = generalization19.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization19ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization19ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  // bind operation: UMLMethod
                  fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
                  while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
                  {
                     try
                     {
                        operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                         
                        // bind reference18: ReferenceAnnotation
                        fujaba__IterAbstractionAnnotationsReference18 = abstraction.iteratorOfAnnotations () ;
                        while ( fujaba__IterAbstractionAnnotationsReference18.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAbstractionAnnotationsReference18.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference18 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference18 and abstraction
                              JavaSDM.ensure ( reference18.hasInElements ("referencingClass", abstraction) ) ;
                               
                              // bind neighborCall20: NeighborCallAnnotation
                              fujaba__IterOperationAnnotationsNeighborCall20 = operation.iteratorOfAnnotations () ;
                              while ( fujaba__IterOperationAnnotationsNeighborCall20.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOperationAnnotationsNeighborCall20.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall20 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall20 and operation
                                    JavaSDM.ensure ( neighborCall20.hasInElements ("caller", operation) ) ;
                                     
                                    // bind implementor: UMLClass
                                    fujaba__IterReference18ElementsImplementor = reference18.iteratorOfElements ("references") ;
                                    while ( fujaba__IterReference18ElementsImplementor.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterReference18ElementsImplementor.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          implementor = (UMLClass) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                                           
                                          // check negative application condition
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // bind generalization17: GeneralizationAnnotation
                                             fujaba__IterAbstractionAnnotationsGeneralization17 = abstraction.iteratorOfAnnotations () ;
                                             while ( fujaba__IterAbstractionAnnotationsGeneralization17.hasNext () )
                                             {
                                                try
                                                {
                                                   fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization17.next () ;
                                                   JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                   generalization17 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                    
                                                   // check Reverse-Qualified-Link 'elements' between generalization17 and abstraction
                                                   JavaSDM.ensure ( generalization17.hasInElements ("subClass", abstraction) ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(generalization19.equals (generalization17)) ) ;
                                                    
                                                   // check To-Many-Link 'elements' between generalization17 and implementor
                                                   JavaSDM.ensure ( generalization17.hasInElements ("superClass", implementor) ) ;
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                }
                                             }
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          fujaba__Success = !(fujaba__Success);
                                          JavaSDM.ensure ( fujaba__Success ) ;
                                          fujaba__Success = false;
                                          // end of negative application condition
                                           
                                          // bind operationImpl: UMLMethod
                                          fujaba__IterNeighborCall20ElementsOperationImpl = neighborCall20.iteratorOfElements ("callee") ;
                                          while ( fujaba__IterNeighborCall20ElementsOperationImpl.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall20ElementsOperationImpl.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                operationImpl = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                 
                                                // check To-One-Link 'parent' between operationImpl and implementor
                                                JavaSDM.ensure ( (operationImpl.getParent () != null) && operationImpl.getParent ().equals (implementor) ) ;
                                                 
                                                // bind uMLStereotype16: UMLStereotype
                                                fujaba__IterImplementorStereotypesUMLStereotype16 = implementor.iteratorOfStereotypes () ;
                                                while ( fujaba__IterImplementorStereotypesUMLStereotype16.hasNext () )
                                                {
                                                   try
                                                   {
                                                      uMLStereotype16 = (UMLStereotype) fujaba__IterImplementorStereotypesUMLStereotype16.next () ;
                                                       
                                                      // attribute condition
                                                      JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype16.getText (), "interface") == 0) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object implementor is really bound
                                                            JavaSDM.ensure ( implementor != null ) ;
                                                             
                                                            // check object abstraction is really bound
                                                            JavaSDM.ensure ( abstraction != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                             
                                                            // bind bridgeInterface: BridgeInterfaceAnnotation
                                                            fujaba__IterImplementorAnnotationsBridgeInterface = implementor.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterImplementorAnnotationsBridgeInterface.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterImplementorAnnotationsBridgeInterface.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeInterfaceAnnotation ) ;
                                                                  bridgeInterface = (BridgeInterfaceAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between bridgeInterface and implementor
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("implementor", implementor) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between bridgeInterface and abstraction
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("abstraction", abstraction) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object implementor is really bound
                                                               JavaSDM.ensure ( implementor != null ) ;
                                                                
                                                               // check object abstraction is really bound
                                                               JavaSDM.ensure ( abstraction != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                                
                                                               // check object operation is really bound
                                                               JavaSDM.ensure ( operation != null ) ;
                                                                
                                                               // check object operationImpl is really bound
                                                               JavaSDM.ensure ( operationImpl != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                                
                                                               // create object
                                                               bridgeInterface = new BridgeInterfaceAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               bridgeInterface.setClassification (1);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operation", operation);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operationImpl", operationImpl);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object reference18 is really bound
                                                               JavaSDM.ensure ( reference18 != null ) ;
                                                                
                                                               // check object generalization19 is really bound
                                                               JavaSDM.ensure ( generalization19 != null ) ;
                                                                
                                                               // check object neighborCall20 is really bound
                                                               JavaSDM.ensure ( neighborCall20 != null ) ;
                                                                
                                                               // check object bridgeInterface is really bound
                                                               JavaSDM.ensure ( bridgeInterface != null ) ;
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (reference18);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (generalization19);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (neighborCall20);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (bridgeInterface) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridgeInterface is really bound
            JavaSDM.ensure ( bridgeInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Generalization", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridgeInterface) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeInterfaceAnnotation bridgeInterface = null ;
      Iterator fujaba__IterAbstractionAnnotationsBridgeInterface = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization22 = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization24 = null ;
      Iterator fujaba__IterAbstractionAnnotationsReference23 = null ;
      Iterator fujaba__IterImplementorStereotypesUMLStereotype21 = null ;
      Iterator fujaba__IterNeighborCall25ElementsOperation = null ;
      Iterator fujaba__IterNeighborCall25ElementsOperationImpl = null ;
      GeneralizationAnnotation generalization22 = null ;
      GeneralizationAnnotation generalization24 = null ;
      NeighborCallAnnotation neighborCall25 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference23 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
      UMLStereotype uMLStereotype21 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall25 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterNeighborCall25ElementsOperation = neighborCall25.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall25ElementsOperation.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall25ElementsOperation.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operation = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind abstraction: UMLClass
                  abstraction = operation.getParent () ;
                  JavaSDM.ensure ( abstraction != null ) ;
                   
                  // bind operationImpl: UMLMethod
                  fujaba__IterNeighborCall25ElementsOperationImpl = neighborCall25.iteratorOfElements ("callee") ;
                  while ( fujaba__IterNeighborCall25ElementsOperationImpl.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNeighborCall25ElementsOperationImpl.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        operationImpl = (UMLMethod) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                         
                        // bind implementor: UMLClass
                        implementor = operationImpl.getParent () ;
                        JavaSDM.ensure ( implementor != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(abstraction.equals (implementor)) ) ;
                         
                        // bind reference23: ReferenceAnnotation
                        fujaba__IterAbstractionAnnotationsReference23 = abstraction.iteratorOfAnnotations () ;
                        while ( fujaba__IterAbstractionAnnotationsReference23.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAbstractionAnnotationsReference23.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference23 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference23 and abstraction
                              JavaSDM.ensure ( reference23.hasInElements ("referencingClass", abstraction) ) ;
                               
                              // check To-Many-Link 'elements' between reference23 and implementor
                              JavaSDM.ensure ( reference23.hasInElements ("references", implementor) ) ;
                               
                              // bind generalization24: GeneralizationAnnotation
                              fujaba__IterAbstractionAnnotationsGeneralization24 = abstraction.iteratorOfAnnotations () ;
                              while ( fujaba__IterAbstractionAnnotationsGeneralization24.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization24.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                    generalization24 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between generalization24 and abstraction
                                    JavaSDM.ensure ( generalization24.hasInElements ("superClass", abstraction) ) ;
                                     
                                    // check negative application condition
                                    try
                                    {
                                       fujaba__Success = false ;
                                        
                                       // bind generalization22: GeneralizationAnnotation
                                       fujaba__IterAbstractionAnnotationsGeneralization22 = abstraction.iteratorOfAnnotations () ;
                                       while ( fujaba__IterAbstractionAnnotationsGeneralization22.hasNext () )
                                       {
                                          try
                                          {
                                             fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization22.next () ;
                                             JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                             generalization22 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                              
                                             // check Reverse-Qualified-Link 'elements' between generalization22 and abstraction
                                             JavaSDM.ensure ( generalization22.hasInElements ("subClass", abstraction) ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(generalization24.equals (generalization22)) ) ;
                                              
                                             // check To-Many-Link 'elements' between generalization22 and implementor
                                             JavaSDM.ensure ( generalization22.hasInElements ("superClass", implementor) ) ;
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                          }
                                       }
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                       fujaba__Success = false ;
                                    }
                                     
                                    fujaba__Success = !(fujaba__Success);
                                    JavaSDM.ensure ( fujaba__Success ) ;
                                    fujaba__Success = false;
                                    // end of negative application condition
                                     
                                    // bind uMLStereotype21: UMLStereotype
                                    fujaba__IterImplementorStereotypesUMLStereotype21 = implementor.iteratorOfStereotypes () ;
                                    while ( fujaba__IterImplementorStereotypesUMLStereotype21.hasNext () )
                                    {
                                       try
                                       {
                                          uMLStereotype21 = (UMLStereotype) fujaba__IterImplementorStereotypesUMLStereotype21.next () ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype21.getText (), "interface") == 0) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object implementor is really bound
                                                JavaSDM.ensure ( implementor != null ) ;
                                                 
                                                // check object abstraction is really bound
                                                JavaSDM.ensure ( abstraction != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                 
                                                // bind bridgeInterface: BridgeInterfaceAnnotation
                                                fujaba__IterAbstractionAnnotationsBridgeInterface = abstraction.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterAbstractionAnnotationsBridgeInterface.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterAbstractionAnnotationsBridgeInterface.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeInterfaceAnnotation ) ;
                                                      bridgeInterface = (BridgeInterfaceAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between bridgeInterface and abstraction
                                                      JavaSDM.ensure ( bridgeInterface.hasInElements ("abstraction", abstraction) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between bridgeInterface and implementor
                                                      JavaSDM.ensure ( bridgeInterface.hasInElements ("implementor", implementor) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object implementor is really bound
                                                   JavaSDM.ensure ( implementor != null ) ;
                                                    
                                                   // check object abstraction is really bound
                                                   JavaSDM.ensure ( abstraction != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                    
                                                   // check object operation is really bound
                                                   JavaSDM.ensure ( operation != null ) ;
                                                    
                                                   // check object operationImpl is really bound
                                                   JavaSDM.ensure ( operationImpl != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                    
                                                   // create object
                                                   bridgeInterface = new BridgeInterfaceAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   bridgeInterface.setClassification (1);
                                                    
                                                   // create link
                                                   bridgeInterface.addToElements ("implementor", implementor);
                                                    
                                                   // create link
                                                   bridgeInterface.addToElements ("abstraction", abstraction);
                                                    
                                                   // create link
                                                   bridgeInterface.addToBoundObjects ("implementor", implementor);
                                                    
                                                   // create link
                                                   bridgeInterface.addToBoundObjects ("abstraction", abstraction);
                                                    
                                                   // create link
                                                   bridgeInterface.addToBoundObjects ("operation", operation);
                                                    
                                                   // create link
                                                   bridgeInterface.addToBoundObjects ("operationImpl", operationImpl);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object reference23 is really bound
                                                   JavaSDM.ensure ( reference23 != null ) ;
                                                    
                                                   // check object generalization24 is really bound
                                                   JavaSDM.ensure ( generalization24 != null ) ;
                                                    
                                                   // check object neighborCall25 is really bound
                                                   JavaSDM.ensure ( neighborCall25 != null ) ;
                                                    
                                                   // check object bridgeInterface is really bound
                                                   JavaSDM.ensure ( bridgeInterface != null ) ;
                                                    
                                                   // create link
                                                   bridgeInterface.addToAntecedentAnnos (reference23);
                                                    
                                                   // create link
                                                   bridgeInterface.addToAntecedentAnnos (generalization24);
                                                    
                                                   // create link
                                                   bridgeInterface.addToAntecedentAnnos (neighborCall25);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (bridgeInterface) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridgeInterface is really bound
            JavaSDM.ensure ( bridgeInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridgeInterface) ;
   }


   private GFRNAnnotation annotateUsingTrigger_ReferenceRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BridgeInterfaceAnnotation bridgeInterface = null ;
      Iterator fujaba__IterAbstractionAnnotationsGeneralization9 = null ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterImplementorAnnotationsBridgeInterface = null ;
      Iterator fujaba__IterImplementorAnnotationsGeneralization7 = null ;
      Iterator fujaba__IterImplementorMethodsOperationImpl = null ;
      Iterator fujaba__IterImplementorStereotypesUMLStereotype6 = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall10 = null ;
      Iterator fujaba__IterReference8ElementsAbstraction = null ;
      Iterator fujaba__IterReference8ElementsImplementor = null ;
      GeneralizationAnnotation generalization7 = null ;
      GeneralizationAnnotation generalization9 = null ;
      NeighborCallAnnotation neighborCall10 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference8 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
      UMLStereotype uMLStereotype6 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference8 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference8ElementsImplementor = reference8.iteratorOfElements ("references") ;
            while ( fujaba__IterReference8ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference8ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  // bind abstraction: UMLClass
                  fujaba__IterReference8ElementsAbstraction = reference8.iteratorOfElements ("referencingClass") ;
                  while ( fujaba__IterReference8ElementsAbstraction.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReference8ElementsAbstraction.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        abstraction = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                         
                        // bind operationImpl: UMLMethod
                        fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
                        while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
                        {
                           try
                           {
                              operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                               
                              // bind uMLStereotype6: UMLStereotype
                              fujaba__IterImplementorStereotypesUMLStereotype6 = implementor.iteratorOfStereotypes () ;
                              while ( fujaba__IterImplementorStereotypesUMLStereotype6.hasNext () )
                              {
                                 try
                                 {
                                    uMLStereotype6 = (UMLStereotype) fujaba__IterImplementorStereotypesUMLStereotype6.next () ;
                                     
                                    // attribute condition
                                    JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype6.getText (), "interface") == 0) ) ;
                                     
                                    // check negative application condition
                                    try
                                    {
                                       fujaba__Success = false ;
                                        
                                       // bind generalization7: GeneralizationAnnotation
                                       fujaba__IterImplementorAnnotationsGeneralization7 = implementor.iteratorOfAnnotations () ;
                                       while ( fujaba__IterImplementorAnnotationsGeneralization7.hasNext () )
                                       {
                                          try
                                          {
                                             fujaba__TmpObject = fujaba__IterImplementorAnnotationsGeneralization7.next () ;
                                             JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                             generalization7 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                              
                                             // check Reverse-Qualified-Link 'elements' between generalization7 and implementor
                                             JavaSDM.ensure ( generalization7.hasInElements ("superClass", implementor) ) ;
                                              
                                             // check To-Many-Link 'elements' between generalization7 and abstraction
                                             JavaSDM.ensure ( generalization7.hasInElements ("subClass", abstraction) ) ;
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                          }
                                       }
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                       fujaba__Success = false ;
                                    }
                                     
                                    fujaba__Success = !(fujaba__Success);
                                    JavaSDM.ensure ( fujaba__Success ) ;
                                    fujaba__Success = false;
                                    // end of negative application condition
                                     
                                    // bind operation: UMLMethod
                                    fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
                                    while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
                                    {
                                       try
                                       {
                                          operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                           
                                          // bind generalization9: GeneralizationAnnotation
                                          fujaba__IterAbstractionAnnotationsGeneralization9 = abstraction.iteratorOfAnnotations () ;
                                          while ( fujaba__IterAbstractionAnnotationsGeneralization9.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAbstractionAnnotationsGeneralization9.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                generalization9 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between generalization9 and abstraction
                                                JavaSDM.ensure ( generalization9.hasInElements ("superClass", abstraction) ) ;
                                                 
                                                // bind neighborCall10: NeighborCallAnnotation
                                                fujaba__IterOperationImplAnnotationsNeighborCall10 = operationImpl.iteratorOfAnnotations () ;
                                                while ( fujaba__IterOperationImplAnnotationsNeighborCall10.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall10.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                      neighborCall10 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between neighborCall10 and operationImpl
                                                      JavaSDM.ensure ( neighborCall10.hasInElements ("callee", operationImpl) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between neighborCall10 and operation
                                                      JavaSDM.ensure ( neighborCall10.hasInElements ("caller", operation) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object implementor is really bound
                                                            JavaSDM.ensure ( implementor != null ) ;
                                                             
                                                            // check object abstraction is really bound
                                                            JavaSDM.ensure ( abstraction != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                             
                                                            // bind bridgeInterface: BridgeInterfaceAnnotation
                                                            fujaba__IterImplementorAnnotationsBridgeInterface = implementor.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterImplementorAnnotationsBridgeInterface.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterImplementorAnnotationsBridgeInterface.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof BridgeInterfaceAnnotation ) ;
                                                                  bridgeInterface = (BridgeInterfaceAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between bridgeInterface and implementor
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("implementor", implementor) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between bridgeInterface and abstraction
                                                                  JavaSDM.ensure ( bridgeInterface.hasInElements ("abstraction", abstraction) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object implementor is really bound
                                                               JavaSDM.ensure ( implementor != null ) ;
                                                                
                                                               // check object abstraction is really bound
                                                               JavaSDM.ensure ( abstraction != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                                                
                                                               // check object operation is really bound
                                                               JavaSDM.ensure ( operation != null ) ;
                                                                
                                                               // check object operationImpl is really bound
                                                               JavaSDM.ensure ( operationImpl != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(operation.equals (operationImpl)) ) ;
                                                                
                                                               // create object
                                                               bridgeInterface = new BridgeInterfaceAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               bridgeInterface.setClassification (1);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToElements ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("implementor", implementor);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("abstraction", abstraction);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operation", operation);
                                                                
                                                               // create link
                                                               bridgeInterface.addToBoundObjects ("operationImpl", operationImpl);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object reference8 is really bound
                                                               JavaSDM.ensure ( reference8 != null ) ;
                                                                
                                                               // check object generalization9 is really bound
                                                               JavaSDM.ensure ( generalization9 != null ) ;
                                                                
                                                               // check object neighborCall10 is really bound
                                                               JavaSDM.ensure ( neighborCall10 != null ) ;
                                                                
                                                               // check object bridgeInterface is really bound
                                                               JavaSDM.ensure ( bridgeInterface != null ) ;
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (reference8);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (generalization9);
                                                                
                                                               // create link
                                                               bridgeInterface.addToAntecedentAnnos (neighborCall10);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (bridgeInterface) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object bridgeInterface is really bound
            JavaSDM.ensure ( bridgeInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Reference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (bridgeInterface) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("implementor", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("abstraction", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof ReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractionMethodsOperation = null ;
      Iterator fujaba__IterGeneralization24ElementsAbstraction = null ;
      Iterator fujaba__IterImplementorMethodsOperationImpl = null ;
      Iterator fujaba__IterNeighborCall25ElementsOperation = null ;
      Iterator fujaba__IterNeighborCall26ElementsOperation = null ;
      Iterator fujaba__IterNeighborCall27ElementsOperation = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall26 = null ;
      Iterator fujaba__IterOperationImplAnnotationsNeighborCall27 = null ;
      Iterator fujaba__IterReference23ElementsImplementor = null ;
      GeneralizationAnnotation generalization24 = null ;
      NeighborCallAnnotation neighborCall25 = null ;
      NeighborCallAnnotation neighborCall26 = null ;
      NeighborCallAnnotation neighborCall27 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ReferenceAnnotation reference23 = null ;
      UMLClass abstraction = null ;
      UMLClass implementor = null ;
      UMLMethod operation = null ;
      UMLMethod operationImpl = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (implementor);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstraction);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference23 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference23ElementsImplementor = reference23.iteratorOfElements ("references") ;
            while ( fujaba__IterReference23ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference23ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (implementor);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization24 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization24ElementsAbstraction = generalization24.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization24ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization24ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (abstraction);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall25 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterNeighborCall25ElementsOperation = neighborCall25.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall25ElementsOperation.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall25ElementsOperation.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operation = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind abstraction: UMLClass
                  abstraction = operation.getParent () ;
                  JavaSDM.ensure ( abstraction != null ) ;
                   
                  {
                     //  for each flow
                     set.add (abstraction);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Reference") || annotation.equals ("MultiReference") || annotation.equals ("ArrayReference") || annotation.equals ("SingleReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (implementor);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstraction);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization24 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization24ElementsAbstraction = generalization24.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization24ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization24ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (abstraction);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall25 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterNeighborCall25ElementsOperation = neighborCall25.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall25ElementsOperation.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall25ElementsOperation.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operation = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind abstraction: UMLClass
                  abstraction = operation.getParent () ;
                  JavaSDM.ensure ( abstraction != null ) ;
                   
                  {
                     //  for each flow
                     set.add (abstraction);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
            while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
            {
               try
               {
                  operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                   
                  // bind neighborCall26: NeighborCallAnnotation
                  fujaba__IterOperationImplAnnotationsNeighborCall26 = operationImpl.iteratorOfAnnotations () ;
                  while ( fujaba__IterOperationImplAnnotationsNeighborCall26.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall26.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall26 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall26 and operationImpl
                        JavaSDM.ensure ( neighborCall26.hasInElements ("callee", operationImpl) ) ;
                         
                        // bind operation: UMLMethod
                        fujaba__IterNeighborCall26ElementsOperation = neighborCall26.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall26ElementsOperation.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall26ElementsOperation.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              operation = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                               
                              // bind abstraction: UMLClass
                              abstraction = operation.getParent () ;
                              JavaSDM.ensure ( abstraction != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (abstraction);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstraction);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference23 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference23ElementsImplementor = reference23.iteratorOfElements ("references") ;
            while ( fujaba__IterReference23ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference23ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  // bind operationImpl: UMLMethod
                  fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
                  while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
                  {
                     try
                     {
                        operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                         
                        // bind neighborCall27: NeighborCallAnnotation
                        fujaba__IterOperationImplAnnotationsNeighborCall27 = operationImpl.iteratorOfAnnotations () ;
                        while ( fujaba__IterOperationImplAnnotationsNeighborCall27.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterOperationImplAnnotationsNeighborCall27.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                              neighborCall27 = (NeighborCallAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between neighborCall27 and operationImpl
                              JavaSDM.ensure ( neighborCall27.hasInElements ("callee", operationImpl) ) ;
                               
                              // bind operation: UMLMethod
                              fujaba__IterNeighborCall27ElementsOperation = neighborCall27.iteratorOfElements ("caller") ;
                              while ( fujaba__IterNeighborCall27ElementsOperation.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterNeighborCall27ElementsOperation.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    operation = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(operationImpl.equals (operation)) ) ;
                                     
                                    // bind abstraction: UMLClass
                                    abstraction = operation.getParent () ;
                                    JavaSDM.ensure ( abstraction != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(implementor.equals (abstraction)) ) ;
                                     
                                    {
                                       //  for each flow
                                       set.add (abstraction);
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall27 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterNeighborCall27ElementsOperation = neighborCall27.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall27ElementsOperation.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall27ElementsOperation.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  operation = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind abstraction: UMLClass
                  abstraction = operation.getParent () ;
                  JavaSDM.ensure ( abstraction != null ) ;
                   
                  {
                     //  for each flow
                     set.add (abstraction);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            implementor = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operationImpl: UMLMethod
            fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
            while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
            {
               try
               {
                  operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                   
                  {
                     //  for each flow
                     set.add (operationImpl);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstraction = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind operation: UMLMethod
            fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
            while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
            {
               try
               {
                  operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                   
                  {
                     //  for each flow
                     set.add (operation);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference23 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind implementor: UMLClass
            fujaba__IterReference23ElementsImplementor = reference23.iteratorOfElements ("references") ;
            while ( fujaba__IterReference23ElementsImplementor.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference23ElementsImplementor.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  implementor = (UMLClass) fujaba__TmpObject ;
                   
                  // bind operationImpl: UMLMethod
                  fujaba__IterImplementorMethodsOperationImpl = implementor.iteratorOfMethods () ;
                  while ( fujaba__IterImplementorMethodsOperationImpl.hasNext () )
                  {
                     try
                     {
                        operationImpl = (UMLMethod) fujaba__IterImplementorMethodsOperationImpl.next () ;
                         
                        {
                           //  for each flow
                           set.add (operationImpl);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization24 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstraction: UMLClass
            fujaba__IterGeneralization24ElementsAbstraction = generalization24.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization24ElementsAbstraction.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization24ElementsAbstraction.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstraction = (UMLClass) fujaba__TmpObject ;
                   
                  // bind operation: UMLMethod
                  fujaba__IterAbstractionMethodsOperation = abstraction.iteratorOfMethods () ;
                  while ( fujaba__IterAbstractionMethodsOperation.hasNext () )
                  {
                     try
                     {
                        operation = (UMLMethod) fujaba__IterAbstractionMethodsOperation.next () ;
                         
                        {
                           //  for each flow
                           set.add (operation);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
