package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLClass;

public class FactoryMethodEngine
extends GFRNEngine
{
   private  FactoryMethodEngine()
   {
   }

   private static FactoryMethodEngine theFactoryMethodEngine;

   public static FactoryMethodEngine get()
   {
      if (theFactoryMethodEngine == null)
      {
         theFactoryMethodEngine = new FactoryMethodEngine ();
      }
      return theFactoryMethodEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation factoryMethod = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         factoryMethod = this.annotateUsingTrigger_CreateMethodRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( factoryMethod != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (factoryMethod) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            factoryMethod = this.annotateUsingConcreteMethodRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( factoryMethod != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (factoryMethod) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               factoryMethod = this.annotateUsingTrigger_OverridingMethodRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( factoryMethod != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (factoryMethod) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  factoryMethod = this.annotateUsingAbstractMethodRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( factoryMethod != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (factoryMethod) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     factoryMethod = this.annotateUsingProductRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (factoryMethod) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingAbstractMethodRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      CreateMethodAnnotation createMethod7 = null ;
      Iterator fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod = null ;
      Iterator fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod8 = null ;
      Iterator fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod7 = null ;
      Iterator fujaba__IterCreateMethod7ElementsProductClass = null ;
      Iterator fujaba__IterOverridingMethod8ElementsConcreteFactoryMethod = null ;
      FactoryMethodAnnotation factoryMethod = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod8 = null ;
      UMLClass productClass = null ;
      UMLMethod abstractFactoryMethod = null ;
      UMLMethod concreteFactoryMethod = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("abstractMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            abstractFactoryMethod = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (abstractFactoryMethod.isAbstract () == true) ) ;
             
            // bind overridingMethod8: OverridingMethodAnnotation
            fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod8 = abstractFactoryMethod.iteratorOfAnnotations () ;
            while ( fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod8.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod8.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                  overridingMethod8 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between overridingMethod8 and abstractFactoryMethod
                  JavaSDM.ensure ( overridingMethod8.hasInElements ("overridden", abstractFactoryMethod) ) ;
                   
                  // bind concreteFactoryMethod: UMLMethod
                  fujaba__IterOverridingMethod8ElementsConcreteFactoryMethod = overridingMethod8.iteratorOfElements ("overriding") ;
                  while ( fujaba__IterOverridingMethod8ElementsConcreteFactoryMethod.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOverridingMethod8ElementsConcreteFactoryMethod.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(abstractFactoryMethod.equals (concreteFactoryMethod)) ) ;
                         
                        // bind createMethod7: CreateMethodAnnotation
                        fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod7 = concreteFactoryMethod.iteratorOfAnnotations () ;
                        while ( fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod7.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod7.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof CreateMethodAnnotation ) ;
                              createMethod7 = (CreateMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between createMethod7 and concreteFactoryMethod
                              JavaSDM.ensure ( createMethod7.hasInElements ("method", concreteFactoryMethod) ) ;
                               
                              // bind productClass: UMLClass
                              fujaba__IterCreateMethod7ElementsProductClass = createMethod7.iteratorOfElements ("creates") ;
                              while ( fujaba__IterCreateMethod7ElementsProductClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterCreateMethod7ElementsProductClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    productClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object concreteFactoryMethod is really bound
                                          JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                           
                                          // check object abstractFactoryMethod is really bound
                                          JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                           
                                          // check object productClass is really bound
                                          JavaSDM.ensure ( productClass != null ) ;
                                           
                                          // bind factoryMethod: FactoryMethodAnnotation
                                          fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod = abstractFactoryMethod.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof FactoryMethodAnnotation ) ;
                                                factoryMethod = (FactoryMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between factoryMethod and abstractFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("abstractMethod", abstractFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and concreteFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("concreteMethod", concreteFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and productClass
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("product", productClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object concreteFactoryMethod is really bound
                                             JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                              
                                             // check object abstractFactoryMethod is really bound
                                             JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                              
                                             // check object productClass is really bound
                                             JavaSDM.ensure ( productClass != null ) ;
                                              
                                             // create object
                                             factoryMethod = new FactoryMethodAnnotation ( ) ;
                                              
                                             // assign statement
                                             factoryMethod.setClassification (1);
                                              
                                             // create link
                                             factoryMethod.addToElements ("concreteMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("abstractMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("product", productClass);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("concreteFactoryMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("abstractFactoryMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("productClass", productClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object createMethod7 is really bound
                                             JavaSDM.ensure ( createMethod7 != null ) ;
                                              
                                             // check object overridingMethod8 is really bound
                                             JavaSDM.ensure ( overridingMethod8 != null ) ;
                                              
                                             // check object factoryMethod is really bound
                                             JavaSDM.ensure ( factoryMethod != null ) ;
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (createMethod7);
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (overridingMethod8);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (factoryMethod) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object factoryMethod is really bound
            JavaSDM.ensure ( factoryMethod != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("abstractMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (factoryMethod) ;
   }


   private GFRNAnnotation annotateUsingConcreteMethodRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      CreateMethodAnnotation createMethod3 = null ;
      Iterator fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod3 = null ;
      Iterator fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod4 = null ;
      Iterator fujaba__IterCreateMethod3ElementsProductClass = null ;
      Iterator fujaba__IterOverridingMethod4ElementsAbstractFactoryMethod = null ;
      Iterator fujaba__IterProductClassAnnotationsFactoryMethod = null ;
      FactoryMethodAnnotation factoryMethod = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod4 = null ;
      UMLClass productClass = null ;
      UMLMethod abstractFactoryMethod = null ;
      UMLMethod concreteFactoryMethod = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("concreteMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            concreteFactoryMethod = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
             
            // bind createMethod3: CreateMethodAnnotation
            fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod3 = concreteFactoryMethod.iteratorOfAnnotations () ;
            while ( fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod3.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod3.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof CreateMethodAnnotation ) ;
                  createMethod3 = (CreateMethodAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between createMethod3 and concreteFactoryMethod
                  JavaSDM.ensure ( createMethod3.hasInElements ("method", concreteFactoryMethod) ) ;
                   
                  // bind overridingMethod4: OverridingMethodAnnotation
                  fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod4 = concreteFactoryMethod.iteratorOfAnnotations () ;
                  while ( fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod4.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod4.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                        overridingMethod4 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between overridingMethod4 and concreteFactoryMethod
                        JavaSDM.ensure ( overridingMethod4.hasInElements ("overriding", concreteFactoryMethod) ) ;
                         
                        // bind productClass: UMLClass
                        fujaba__IterCreateMethod3ElementsProductClass = createMethod3.iteratorOfElements ("creates") ;
                        while ( fujaba__IterCreateMethod3ElementsProductClass.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterCreateMethod3ElementsProductClass.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              productClass = (UMLClass) fujaba__TmpObject ;
                               
                              // bind abstractFactoryMethod: UMLMethod
                              fujaba__IterOverridingMethod4ElementsAbstractFactoryMethod = overridingMethod4.iteratorOfElements ("overridden") ;
                              while ( fujaba__IterOverridingMethod4ElementsAbstractFactoryMethod.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOverridingMethod4ElementsAbstractFactoryMethod.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    abstractFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // attribute condition
                                    JavaSDM.ensure ( (abstractFactoryMethod.isAbstract () == true) ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object concreteFactoryMethod is really bound
                                          JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                           
                                          // check object abstractFactoryMethod is really bound
                                          JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                           
                                          // check object productClass is really bound
                                          JavaSDM.ensure ( productClass != null ) ;
                                           
                                          // bind factoryMethod: FactoryMethodAnnotation
                                          fujaba__IterProductClassAnnotationsFactoryMethod = productClass.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterProductClassAnnotationsFactoryMethod.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterProductClassAnnotationsFactoryMethod.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof FactoryMethodAnnotation ) ;
                                                factoryMethod = (FactoryMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between factoryMethod and productClass
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("product", productClass) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and concreteFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("concreteMethod", concreteFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and abstractFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("abstractMethod", abstractFactoryMethod) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object concreteFactoryMethod is really bound
                                             JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                              
                                             // check object abstractFactoryMethod is really bound
                                             JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                              
                                             // check object productClass is really bound
                                             JavaSDM.ensure ( productClass != null ) ;
                                              
                                             // create object
                                             factoryMethod = new FactoryMethodAnnotation ( ) ;
                                              
                                             // assign statement
                                             factoryMethod.setClassification (1);
                                              
                                             // create link
                                             factoryMethod.addToElements ("concreteMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("abstractMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("product", productClass);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("concreteFactoryMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("abstractFactoryMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("productClass", productClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object createMethod3 is really bound
                                             JavaSDM.ensure ( createMethod3 != null ) ;
                                              
                                             // check object overridingMethod4 is really bound
                                             JavaSDM.ensure ( overridingMethod4 != null ) ;
                                              
                                             // check object factoryMethod is really bound
                                             JavaSDM.ensure ( factoryMethod != null ) ;
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (createMethod3);
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (overridingMethod4);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (factoryMethod) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object factoryMethod is really bound
            JavaSDM.ensure ( factoryMethod != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("concreteMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (factoryMethod) ;
   }


   private GFRNAnnotation annotateUsingProductRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      CreateMethodAnnotation createMethod9 = null ;
      Iterator fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod = null ;
      Iterator fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod10 = null ;
      Iterator fujaba__IterCreateMethod9ElementsConcreteFactoryMethod = null ;
      Iterator fujaba__IterOverridingMethod10ElementsAbstractFactoryMethod = null ;
      Iterator fujaba__IterProductClassAnnotationsCreateMethod9 = null ;
      FactoryMethodAnnotation factoryMethod = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod10 = null ;
      UMLClass productClass = null ;
      UMLMethod abstractFactoryMethod = null ;
      UMLMethod concreteFactoryMethod = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("product", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            productClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind createMethod9: CreateMethodAnnotation
            fujaba__IterProductClassAnnotationsCreateMethod9 = productClass.iteratorOfAnnotations () ;
            while ( fujaba__IterProductClassAnnotationsCreateMethod9.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterProductClassAnnotationsCreateMethod9.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof CreateMethodAnnotation ) ;
                  createMethod9 = (CreateMethodAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between createMethod9 and productClass
                  JavaSDM.ensure ( createMethod9.hasInElements ("creates", productClass) ) ;
                   
                  // bind concreteFactoryMethod: UMLMethod
                  fujaba__IterCreateMethod9ElementsConcreteFactoryMethod = createMethod9.iteratorOfElements ("method") ;
                  while ( fujaba__IterCreateMethod9ElementsConcreteFactoryMethod.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCreateMethod9ElementsConcreteFactoryMethod.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                         
                        // bind overridingMethod10: OverridingMethodAnnotation
                        fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod10 = concreteFactoryMethod.iteratorOfAnnotations () ;
                        while ( fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod10.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod10.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                              overridingMethod10 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between overridingMethod10 and concreteFactoryMethod
                              JavaSDM.ensure ( overridingMethod10.hasInElements ("overriding", concreteFactoryMethod) ) ;
                               
                              // bind abstractFactoryMethod: UMLMethod
                              fujaba__IterOverridingMethod10ElementsAbstractFactoryMethod = overridingMethod10.iteratorOfElements ("overridden") ;
                              while ( fujaba__IterOverridingMethod10ElementsAbstractFactoryMethod.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOverridingMethod10ElementsAbstractFactoryMethod.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    abstractFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // attribute condition
                                    JavaSDM.ensure ( (abstractFactoryMethod.isAbstract () == true) ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object concreteFactoryMethod is really bound
                                          JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                           
                                          // check object abstractFactoryMethod is really bound
                                          JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                           
                                          // check object productClass is really bound
                                          JavaSDM.ensure ( productClass != null ) ;
                                           
                                          // bind factoryMethod: FactoryMethodAnnotation
                                          fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod = abstractFactoryMethod.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof FactoryMethodAnnotation ) ;
                                                factoryMethod = (FactoryMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between factoryMethod and abstractFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("abstractMethod", abstractFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and concreteFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("concreteMethod", concreteFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and productClass
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("product", productClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object concreteFactoryMethod is really bound
                                             JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                              
                                             // check object abstractFactoryMethod is really bound
                                             JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                              
                                             // check object productClass is really bound
                                             JavaSDM.ensure ( productClass != null ) ;
                                              
                                             // create object
                                             factoryMethod = new FactoryMethodAnnotation ( ) ;
                                              
                                             // assign statement
                                             factoryMethod.setClassification (1);
                                              
                                             // create link
                                             factoryMethod.addToElements ("concreteMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("abstractMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("product", productClass);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("concreteFactoryMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("abstractFactoryMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("productClass", productClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object createMethod9 is really bound
                                             JavaSDM.ensure ( createMethod9 != null ) ;
                                              
                                             // check object overridingMethod10 is really bound
                                             JavaSDM.ensure ( overridingMethod10 != null ) ;
                                              
                                             // check object factoryMethod is really bound
                                             JavaSDM.ensure ( factoryMethod != null ) ;
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (createMethod9);
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (overridingMethod10);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (factoryMethod) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object factoryMethod is really bound
            JavaSDM.ensure ( factoryMethod != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("product", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (factoryMethod) ;
   }


   private GFRNAnnotation annotateUsingTrigger_CreateMethodRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      CreateMethodAnnotation createMethod1 = null ;
      Iterator fujaba__IterConcreteFactoryMethodAnnotationsFactoryMethod = null ;
      Iterator fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod2 = null ;
      Iterator fujaba__IterCreateMethod1ElementsConcreteFactoryMethod = null ;
      Iterator fujaba__IterCreateMethod1ElementsProductClass = null ;
      Iterator fujaba__IterOverridingMethod2ElementsAbstractFactoryMethod = null ;
      FactoryMethodAnnotation factoryMethod = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod2 = null ;
      UMLClass productClass = null ;
      UMLMethod abstractFactoryMethod = null ;
      UMLMethod concreteFactoryMethod = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_CreateMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof CreateMethodAnnotation ) ;
             
            // explicit type cast
            createMethod1 = (CreateMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind concreteFactoryMethod: UMLMethod
            fujaba__IterCreateMethod1ElementsConcreteFactoryMethod = createMethod1.iteratorOfElements ("method") ;
            while ( fujaba__IterCreateMethod1ElementsConcreteFactoryMethod.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterCreateMethod1ElementsConcreteFactoryMethod.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                   
                  // bind productClass: UMLClass
                  fujaba__IterCreateMethod1ElementsProductClass = createMethod1.iteratorOfElements ("creates") ;
                  while ( fujaba__IterCreateMethod1ElementsProductClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCreateMethod1ElementsProductClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        productClass = (UMLClass) fujaba__TmpObject ;
                         
                        // bind overridingMethod2: OverridingMethodAnnotation
                        fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod2 = concreteFactoryMethod.iteratorOfAnnotations () ;
                        while ( fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod2.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterConcreteFactoryMethodAnnotationsOverridingMethod2.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                              overridingMethod2 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between overridingMethod2 and concreteFactoryMethod
                              JavaSDM.ensure ( overridingMethod2.hasInElements ("overriding", concreteFactoryMethod) ) ;
                               
                              // bind abstractFactoryMethod: UMLMethod
                              fujaba__IterOverridingMethod2ElementsAbstractFactoryMethod = overridingMethod2.iteratorOfElements ("overridden") ;
                              while ( fujaba__IterOverridingMethod2ElementsAbstractFactoryMethod.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOverridingMethod2ElementsAbstractFactoryMethod.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    abstractFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // attribute condition
                                    JavaSDM.ensure ( (abstractFactoryMethod.isAbstract () == true) ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object concreteFactoryMethod is really bound
                                          JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                           
                                          // check object abstractFactoryMethod is really bound
                                          JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                           
                                          // check object productClass is really bound
                                          JavaSDM.ensure ( productClass != null ) ;
                                           
                                          // bind factoryMethod: FactoryMethodAnnotation
                                          fujaba__IterConcreteFactoryMethodAnnotationsFactoryMethod = concreteFactoryMethod.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterConcreteFactoryMethodAnnotationsFactoryMethod.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterConcreteFactoryMethodAnnotationsFactoryMethod.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof FactoryMethodAnnotation ) ;
                                                factoryMethod = (FactoryMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between factoryMethod and concreteFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("concreteMethod", concreteFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and abstractFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("abstractMethod", abstractFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and productClass
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("product", productClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object concreteFactoryMethod is really bound
                                             JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                              
                                             // check object abstractFactoryMethod is really bound
                                             JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                              
                                             // check object productClass is really bound
                                             JavaSDM.ensure ( productClass != null ) ;
                                              
                                             // create object
                                             factoryMethod = new FactoryMethodAnnotation ( ) ;
                                              
                                             // assign statement
                                             factoryMethod.setClassification (1);
                                              
                                             // create link
                                             factoryMethod.addToElements ("concreteMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("abstractMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("product", productClass);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("concreteFactoryMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("abstractFactoryMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("productClass", productClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object createMethod1 is really bound
                                             JavaSDM.ensure ( createMethod1 != null ) ;
                                              
                                             // check object overridingMethod2 is really bound
                                             JavaSDM.ensure ( overridingMethod2 != null ) ;
                                              
                                             // check object factoryMethod is really bound
                                             JavaSDM.ensure ( factoryMethod != null ) ;
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (createMethod1);
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (overridingMethod2);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (factoryMethod) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object factoryMethod is really bound
            JavaSDM.ensure ( factoryMethod != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_CreateMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (factoryMethod) ;
   }


   private GFRNAnnotation annotateUsingTrigger_OverridingMethodRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      CreateMethodAnnotation createMethod5 = null ;
      Iterator fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod = null ;
      Iterator fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod5 = null ;
      Iterator fujaba__IterCreateMethod5ElementsProductClass = null ;
      Iterator fujaba__IterOverridingMethod6ElementsAbstractFactoryMethod = null ;
      Iterator fujaba__IterOverridingMethod6ElementsConcreteFactoryMethod = null ;
      FactoryMethodAnnotation factoryMethod = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod6 = null ;
      UMLClass productClass = null ;
      UMLMethod abstractFactoryMethod = null ;
      UMLMethod concreteFactoryMethod = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod6 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind concreteFactoryMethod: UMLMethod
            fujaba__IterOverridingMethod6ElementsConcreteFactoryMethod = overridingMethod6.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod6ElementsConcreteFactoryMethod.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod6ElementsConcreteFactoryMethod.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                   
                  // bind abstractFactoryMethod: UMLMethod
                  fujaba__IterOverridingMethod6ElementsAbstractFactoryMethod = overridingMethod6.iteratorOfElements ("overridden") ;
                  while ( fujaba__IterOverridingMethod6ElementsAbstractFactoryMethod.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOverridingMethod6ElementsAbstractFactoryMethod.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        abstractFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (abstractFactoryMethod.isAbstract () == true) ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                         
                        // bind createMethod5: CreateMethodAnnotation
                        fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod5 = concreteFactoryMethod.iteratorOfAnnotations () ;
                        while ( fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod5.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterConcreteFactoryMethodAnnotationsCreateMethod5.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof CreateMethodAnnotation ) ;
                              createMethod5 = (CreateMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between createMethod5 and concreteFactoryMethod
                              JavaSDM.ensure ( createMethod5.hasInElements ("method", concreteFactoryMethod) ) ;
                               
                              // bind productClass: UMLClass
                              fujaba__IterCreateMethod5ElementsProductClass = createMethod5.iteratorOfElements ("creates") ;
                              while ( fujaba__IterCreateMethod5ElementsProductClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterCreateMethod5ElementsProductClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    productClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object concreteFactoryMethod is really bound
                                          JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                           
                                          // check object abstractFactoryMethod is really bound
                                          JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                           
                                          // check object productClass is really bound
                                          JavaSDM.ensure ( productClass != null ) ;
                                           
                                          // bind factoryMethod: FactoryMethodAnnotation
                                          fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod = abstractFactoryMethod.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAbstractFactoryMethodAnnotationsFactoryMethod.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof FactoryMethodAnnotation ) ;
                                                factoryMethod = (FactoryMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between factoryMethod and abstractFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("abstractMethod", abstractFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and concreteFactoryMethod
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("concreteMethod", concreteFactoryMethod) ) ;
                                                 
                                                // check To-Many-Link 'elements' between factoryMethod and productClass
                                                JavaSDM.ensure ( factoryMethod.hasInElements ("product", productClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object concreteFactoryMethod is really bound
                                             JavaSDM.ensure ( concreteFactoryMethod != null ) ;
                                              
                                             // check object abstractFactoryMethod is really bound
                                             JavaSDM.ensure ( abstractFactoryMethod != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(concreteFactoryMethod.equals (abstractFactoryMethod)) ) ;
                                              
                                             // check object productClass is really bound
                                             JavaSDM.ensure ( productClass != null ) ;
                                              
                                             // create object
                                             factoryMethod = new FactoryMethodAnnotation ( ) ;
                                              
                                             // assign statement
                                             factoryMethod.setClassification (1);
                                              
                                             // create link
                                             factoryMethod.addToElements ("concreteMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("abstractMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToElements ("product", productClass);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("concreteFactoryMethod", concreteFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("abstractFactoryMethod", abstractFactoryMethod);
                                              
                                             // create link
                                             factoryMethod.addToBoundObjects ("productClass", productClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object createMethod5 is really bound
                                             JavaSDM.ensure ( createMethod5 != null ) ;
                                              
                                             // check object overridingMethod6 is really bound
                                             JavaSDM.ensure ( overridingMethod6 != null ) ;
                                              
                                             // check object factoryMethod is really bound
                                             JavaSDM.ensure ( factoryMethod != null ) ;
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (createMethod5);
                                              
                                             // create link
                                             factoryMethod.addToAntecedentAnnos (overridingMethod6);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (factoryMethod) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object factoryMethod is really bound
            JavaSDM.ensure ( factoryMethod != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_OverridingMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (factoryMethod) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("concreteMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("abstractMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("product", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof CreateMethodAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_CreateMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof OverridingMethodAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      CreateMethodAnnotation createMethod12 = null ;
      Iterator fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod11 = null ;
      Iterator fujaba__IterCreateMethod12ElementsConcreteFactoryMethod = null ;
      Iterator fujaba__IterOverridingMethod11ElementsConcreteFactoryMethod = null ;
      Iterator fujaba__IterProductClassAnnotationsCreateMethod12 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod11 = null ;
      UMLClass productClass = null ;
      UMLMethod abstractFactoryMethod = null ;
      UMLMethod concreteFactoryMethod = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("CreateMethod") || annotation.equals ("CreateMethodSubType") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            concreteFactoryMethod = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (concreteFactoryMethod);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            abstractFactoryMethod = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind overridingMethod11: OverridingMethodAnnotation
            fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod11 = abstractFactoryMethod.iteratorOfAnnotations () ;
            while ( fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod11.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterAbstractFactoryMethodAnnotationsOverridingMethod11.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                  overridingMethod11 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between overridingMethod11 and abstractFactoryMethod
                  JavaSDM.ensure ( overridingMethod11.hasInElements ("overridden", abstractFactoryMethod) ) ;
                   
                  // bind concreteFactoryMethod: UMLMethod
                  fujaba__IterOverridingMethod11ElementsConcreteFactoryMethod = overridingMethod11.iteratorOfElements ("overriding") ;
                  while ( fujaba__IterOverridingMethod11ElementsConcreteFactoryMethod.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOverridingMethod11ElementsConcreteFactoryMethod.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(abstractFactoryMethod.equals (concreteFactoryMethod)) ) ;
                         
                        {
                           //  for each flow
                           set.add (concreteFactoryMethod);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            productClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (productClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod11 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind concreteFactoryMethod: UMLMethod
            fujaba__IterOverridingMethod11ElementsConcreteFactoryMethod = overridingMethod11.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod11ElementsConcreteFactoryMethod.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod11ElementsConcreteFactoryMethod.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                   
                  {
                     //  for each flow
                     set.add (concreteFactoryMethod);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("OverridingMethod") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            concreteFactoryMethod = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (concreteFactoryMethod);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            abstractFactoryMethod = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstractFactoryMethod);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            productClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind createMethod12: CreateMethodAnnotation
            fujaba__IterProductClassAnnotationsCreateMethod12 = productClass.iteratorOfAnnotations () ;
            while ( fujaba__IterProductClassAnnotationsCreateMethod12.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterProductClassAnnotationsCreateMethod12.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof CreateMethodAnnotation ) ;
                  createMethod12 = (CreateMethodAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between createMethod12 and productClass
                  JavaSDM.ensure ( createMethod12.hasInElements ("creates", productClass) ) ;
                   
                  // bind concreteFactoryMethod: UMLMethod
                  fujaba__IterCreateMethod12ElementsConcreteFactoryMethod = createMethod12.iteratorOfElements ("method") ;
                  while ( fujaba__IterCreateMethod12ElementsConcreteFactoryMethod.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCreateMethod12ElementsConcreteFactoryMethod.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                         
                        {
                           //  for each flow
                           set.add (concreteFactoryMethod);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof CreateMethodAnnotation ) ;
             
            // explicit type cast
            createMethod12 = (CreateMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind concreteFactoryMethod: UMLMethod
            fujaba__IterCreateMethod12ElementsConcreteFactoryMethod = createMethod12.iteratorOfElements ("method") ;
            while ( fujaba__IterCreateMethod12ElementsConcreteFactoryMethod.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterCreateMethod12ElementsConcreteFactoryMethod.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  concreteFactoryMethod = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (concreteFactoryMethod.isAbstract () == false) ) ;
                   
                  {
                     //  for each flow
                     set.add (concreteFactoryMethod);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
