package de.upb.inferenceengine.engines;

import de.upb.inferenceengine.visitors.*;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.upb.javaast.methodast.MethodCallNode;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.ASTRootNode;
import de.upb.javaast.methodast.IdentifierNode;
import de.upb.javaast.methodast.LoopNode;

public class MultiNeighborCallEngine
extends GFRNEngine
{
   private  MultiNeighborCallEngine()
   {
   }

   private static MultiNeighborCallEngine theMultiNeighborCallEngine;

   public static MultiNeighborCallEngine get()
   {
      if (theMultiNeighborCallEngine == null)
      {
         theMultiNeighborCallEngine = new MultiNeighborCallEngine ();
      }
      return theMultiNeighborCallEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation multiNeighborCall = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         multiNeighborCall = this.annotateUsingCallerRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( multiNeighborCall != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (multiNeighborCall) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            multiNeighborCall = this.annotateUsingTrigger_MultiReferenceRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( multiNeighborCall != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (multiNeighborCall) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               multiNeighborCall = this.annotateUsingCallerClassRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( multiNeighborCall != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (multiNeighborCall) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  multiNeighborCall = this.annotateUsingCalleeClassRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( multiNeighborCall != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (multiNeighborCall) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     multiNeighborCall = this.annotateUsingCalleeRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (multiNeighborCall) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingCalleeClassRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode7 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiNeighborCall = null ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiReference8 = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference8ElementsAttr = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode7 = null ;
      MultiNeighborCallAnnotation multiNeighborCall = null ;
      MultiReferenceAnnotation multiReference8 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr attr = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("calleeClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            calleeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
            while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                   
                  // bind multiReference8: MultiReferenceAnnotation
                  fujaba__IterCalleeClassAnnotationsMultiReference8 = calleeClass.iteratorOfAnnotations () ;
                  while ( fujaba__IterCalleeClassAnnotationsMultiReference8.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiReference8.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                        multiReference8 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between multiReference8 and calleeClass
                        JavaSDM.ensure ( multiReference8.hasInElements ("references", calleeClass) ) ;
                         
                        // bind attr: UMLAttr
                        fujaba__IterMultiReference8ElementsAttr = multiReference8.iteratorOfElements ("field") ;
                        while ( fujaba__IterMultiReference8ElementsAttr.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterMultiReference8ElementsAttr.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                              attr = (UMLAttr) fujaba__TmpObject ;
                               
                              // bind callerClass: UMLClass
                              callerClass = attr.getParent () ;
                              JavaSDM.ensure ( callerClass != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(calleeClass.equals (callerClass)) ) ;
                               
                              // bind caller: UMLMethod
                              fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                              while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                              {
                                 try
                                 {
                                    caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                                     
                                    // bind root: ASTRootNode
                                    root = caller.getASTRootNode () ;
                                    JavaSDM.ensure ( root != null ) ;
                                     
                                    // Path search between ASTRootNode and LoopNode
                                    // Bind loop : LoopNode
                                    fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                    while ( fujaba__IterRootToLoop.hasNext () )
                                    {
                                       try
                                       {
                                          loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                           
                                          // Path search between LoopNode and MethodCallNode
                                          // Bind methodCallNode7 : MethodCallNode
                                          fujaba__IterLoopToMethodCallNode7 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                          while ( fujaba__IterLoopToMethodCallNode7.hasNext () )
                                          {
                                             try
                                             {
                                                methodCallNode7 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode7.next () ;
                                                 
                                                // bind id: IdentifierNode
                                                id = methodCallNode7.getIdentifier () ;
                                                JavaSDM.ensure ( id != null ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object caller is really bound
                                                      JavaSDM.ensure ( caller != null ) ;
                                                       
                                                      // check object callee is really bound
                                                      JavaSDM.ensure ( callee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check object callerClass is really bound
                                                      JavaSDM.ensure ( callerClass != null ) ;
                                                       
                                                      // check object calleeClass is really bound
                                                      JavaSDM.ensure ( calleeClass != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                       
                                                      // bind multiNeighborCall: MultiNeighborCallAnnotation
                                                      fujaba__IterCalleeClassAnnotationsMultiNeighborCall = calleeClass.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterCalleeClassAnnotationsMultiNeighborCall.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiNeighborCall.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof MultiNeighborCallAnnotation ) ;
                                                            multiNeighborCall = (MultiNeighborCallAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between multiNeighborCall and calleeClass
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("calleeClass", calleeClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and caller
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("caller", caller) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and callee
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("callee", callee) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and callerClass
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("callerClass", callerClass) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // check object callerClass is really bound
                                                         JavaSDM.ensure ( callerClass != null ) ;
                                                          
                                                         // check object calleeClass is really bound
                                                         JavaSDM.ensure ( calleeClass != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                          
                                                         // check object attr is really bound
                                                         JavaSDM.ensure ( attr != null ) ;
                                                          
                                                         // check object root is really bound
                                                         JavaSDM.ensure ( root != null ) ;
                                                          
                                                         // check object loop is really bound
                                                         JavaSDM.ensure ( loop != null ) ;
                                                          
                                                         // check object id is really bound
                                                         JavaSDM.ensure ( id != null ) ;
                                                          
                                                         // create object
                                                         multiNeighborCall = new MultiNeighborCallAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         multiNeighborCall.setClassification (0);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("caller", caller);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("callee", callee);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("attr", attr);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("root", root);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("loop", loop);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("id", id);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object multiReference8 is really bound
                                                         JavaSDM.ensure ( multiReference8 != null ) ;
                                                          
                                                         // check object multiNeighborCall is really bound
                                                         JavaSDM.ensure ( multiNeighborCall != null ) ;
                                                          
                                                         // create link
                                                         multiNeighborCall.addToAntecedentAnnos (multiReference8);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (multiNeighborCall) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiNeighborCall is really bound
            JavaSDM.ensure ( multiNeighborCall != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("calleeClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiNeighborCall) ;
   }


   private GFRNAnnotation annotateUsingCalleeRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode9 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeClassAnnotationsMultiReference10 = null ;
      Iterator fujaba__IterCallerClassAnnotationsMultiNeighborCall = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference10ElementsAttr = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode9 = null ;
      MultiNeighborCallAnnotation multiNeighborCall = null ;
      MultiReferenceAnnotation multiReference10 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr attr = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("callee", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            callee = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind calleeClass: UMLClass
            calleeClass = callee.getParent () ;
            JavaSDM.ensure ( calleeClass != null ) ;
             
            // bind multiReference10: MultiReferenceAnnotation
            fujaba__IterCalleeClassAnnotationsMultiReference10 = calleeClass.iteratorOfAnnotations () ;
            while ( fujaba__IterCalleeClassAnnotationsMultiReference10.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsMultiReference10.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                  multiReference10 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between multiReference10 and calleeClass
                  JavaSDM.ensure ( multiReference10.hasInElements ("references", calleeClass) ) ;
                   
                  // bind attr: UMLAttr
                  fujaba__IterMultiReference10ElementsAttr = multiReference10.iteratorOfElements ("field") ;
                  while ( fujaba__IterMultiReference10ElementsAttr.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterMultiReference10ElementsAttr.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                        attr = (UMLAttr) fujaba__TmpObject ;
                         
                        // bind callerClass: UMLClass
                        callerClass = attr.getParent () ;
                        JavaSDM.ensure ( callerClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(calleeClass.equals (callerClass)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                        while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                               
                              // bind root: ASTRootNode
                              root = caller.getASTRootNode () ;
                              JavaSDM.ensure ( root != null ) ;
                               
                              // Path search between ASTRootNode and LoopNode
                              // Bind loop : LoopNode
                              fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                              while ( fujaba__IterRootToLoop.hasNext () )
                              {
                                 try
                                 {
                                    loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                     
                                    // Path search between LoopNode and MethodCallNode
                                    // Bind methodCallNode9 : MethodCallNode
                                    fujaba__IterLoopToMethodCallNode9 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                    while ( fujaba__IterLoopToMethodCallNode9.hasNext () )
                                    {
                                       try
                                       {
                                          methodCallNode9 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode9.next () ;
                                           
                                          // bind id: IdentifierNode
                                          id = methodCallNode9.getIdentifier () ;
                                          JavaSDM.ensure ( id != null ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object caller is really bound
                                                JavaSDM.ensure ( caller != null ) ;
                                                 
                                                // check object callee is really bound
                                                JavaSDM.ensure ( callee != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                 
                                                // check object callerClass is really bound
                                                JavaSDM.ensure ( callerClass != null ) ;
                                                 
                                                // check object calleeClass is really bound
                                                JavaSDM.ensure ( calleeClass != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                 
                                                // bind multiNeighborCall: MultiNeighborCallAnnotation
                                                fujaba__IterCallerClassAnnotationsMultiNeighborCall = callerClass.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterCallerClassAnnotationsMultiNeighborCall.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterCallerClassAnnotationsMultiNeighborCall.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof MultiNeighborCallAnnotation ) ;
                                                      multiNeighborCall = (MultiNeighborCallAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between multiNeighborCall and callerClass
                                                      JavaSDM.ensure ( multiNeighborCall.hasInElements ("callerClass", callerClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between multiNeighborCall and caller
                                                      JavaSDM.ensure ( multiNeighborCall.hasInElements ("caller", caller) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between multiNeighborCall and callee
                                                      JavaSDM.ensure ( multiNeighborCall.hasInElements ("callee", callee) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between multiNeighborCall and calleeClass
                                                      JavaSDM.ensure ( multiNeighborCall.hasInElements ("calleeClass", calleeClass) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // check object callerClass is really bound
                                                   JavaSDM.ensure ( callerClass != null ) ;
                                                    
                                                   // check object calleeClass is really bound
                                                   JavaSDM.ensure ( calleeClass != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                    
                                                   // check object attr is really bound
                                                   JavaSDM.ensure ( attr != null ) ;
                                                    
                                                   // check object root is really bound
                                                   JavaSDM.ensure ( root != null ) ;
                                                    
                                                   // check object loop is really bound
                                                   JavaSDM.ensure ( loop != null ) ;
                                                    
                                                   // check object id is really bound
                                                   JavaSDM.ensure ( id != null ) ;
                                                    
                                                   // create object
                                                   multiNeighborCall = new MultiNeighborCallAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   multiNeighborCall.setClassification (0);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToElements ("caller", caller);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToElements ("callee", callee);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToElements ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToElements ("calleeClass", calleeClass);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("attr", attr);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("calleeClass", calleeClass);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("callee", callee);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("root", root);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("loop", loop);
                                                    
                                                   // create link
                                                   multiNeighborCall.addToBoundObjects ("id", id);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object multiReference10 is really bound
                                                   JavaSDM.ensure ( multiReference10 != null ) ;
                                                    
                                                   // check object multiNeighborCall is really bound
                                                   JavaSDM.ensure ( multiNeighborCall != null ) ;
                                                    
                                                   // create link
                                                   multiNeighborCall.addToAntecedentAnnos (multiReference10);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (multiNeighborCall) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiNeighborCall is really bound
            JavaSDM.ensure ( multiNeighborCall != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("callee", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiNeighborCall) ;
   }


   private GFRNAnnotation annotateUsingCallerClassRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode5 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAttrAnnotationsMultiReference6 = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerAnnotationsMultiNeighborCall = null ;
      Iterator fujaba__IterCallerClassAttrsAttr = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference6ElementsCalleeClass = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode5 = null ;
      MultiNeighborCallAnnotation multiNeighborCall = null ;
      MultiReferenceAnnotation multiReference6 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr attr = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("callerClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            callerClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind attr: UMLAttr
            fujaba__IterCallerClassAttrsAttr = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsAttr.hasNext () )
            {
               try
               {
                  attr = (UMLAttr) fujaba__IterCallerClassAttrsAttr.next () ;
                   
                  // bind caller: UMLMethod
                  fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                  while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                  {
                     try
                     {
                        caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                         
                        // bind root: ASTRootNode
                        root = caller.getASTRootNode () ;
                        JavaSDM.ensure ( root != null ) ;
                         
                        // bind multiReference6: MultiReferenceAnnotation
                        fujaba__IterAttrAnnotationsMultiReference6 = attr.iteratorOfAnnotations () ;
                        while ( fujaba__IterAttrAnnotationsMultiReference6.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAttrAnnotationsMultiReference6.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                              multiReference6 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between multiReference6 and attr
                              JavaSDM.ensure ( multiReference6.hasInElements ("field", attr) ) ;
                               
                              // bind calleeClass: UMLClass
                              fujaba__IterMultiReference6ElementsCalleeClass = multiReference6.iteratorOfElements ("references") ;
                              while ( fujaba__IterMultiReference6ElementsCalleeClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterMultiReference6ElementsCalleeClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    calleeClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                     
                                    // bind callee: UMLMethod
                                    fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                                    while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                                    {
                                       try
                                       {
                                          callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                           
                                          // Path search between ASTRootNode and LoopNode
                                          // Bind loop : LoopNode
                                          fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                          while ( fujaba__IterRootToLoop.hasNext () )
                                          {
                                             try
                                             {
                                                loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                                 
                                                // Path search between LoopNode and MethodCallNode
                                                // Bind methodCallNode5 : MethodCallNode
                                                fujaba__IterLoopToMethodCallNode5 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                                while ( fujaba__IterLoopToMethodCallNode5.hasNext () )
                                                {
                                                   try
                                                   {
                                                      methodCallNode5 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode5.next () ;
                                                       
                                                      // bind id: IdentifierNode
                                                      id = methodCallNode5.getIdentifier () ;
                                                      JavaSDM.ensure ( id != null ) ;
                                                       
                                                      // constraint
                                                      JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object caller is really bound
                                                            JavaSDM.ensure ( caller != null ) ;
                                                             
                                                            // check object callee is really bound
                                                            JavaSDM.ensure ( callee != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                             
                                                            // check object callerClass is really bound
                                                            JavaSDM.ensure ( callerClass != null ) ;
                                                             
                                                            // check object calleeClass is really bound
                                                            JavaSDM.ensure ( calleeClass != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                             
                                                            // bind multiNeighborCall: MultiNeighborCallAnnotation
                                                            fujaba__IterCallerAnnotationsMultiNeighborCall = caller.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterCallerAnnotationsMultiNeighborCall.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterCallerAnnotationsMultiNeighborCall.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof MultiNeighborCallAnnotation ) ;
                                                                  multiNeighborCall = (MultiNeighborCallAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between multiNeighborCall and caller
                                                                  JavaSDM.ensure ( multiNeighborCall.hasInElements ("caller", caller) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between multiNeighborCall and callee
                                                                  JavaSDM.ensure ( multiNeighborCall.hasInElements ("callee", callee) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between multiNeighborCall and callerClass
                                                                  JavaSDM.ensure ( multiNeighborCall.hasInElements ("callerClass", callerClass) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between multiNeighborCall and calleeClass
                                                                  JavaSDM.ensure ( multiNeighborCall.hasInElements ("calleeClass", calleeClass) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // check object callerClass is really bound
                                                               JavaSDM.ensure ( callerClass != null ) ;
                                                                
                                                               // check object calleeClass is really bound
                                                               JavaSDM.ensure ( calleeClass != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                                
                                                               // check object attr is really bound
                                                               JavaSDM.ensure ( attr != null ) ;
                                                                
                                                               // check object root is really bound
                                                               JavaSDM.ensure ( root != null ) ;
                                                                
                                                               // check object loop is really bound
                                                               JavaSDM.ensure ( loop != null ) ;
                                                                
                                                               // check object id is really bound
                                                               JavaSDM.ensure ( id != null ) ;
                                                                
                                                               // create object
                                                               multiNeighborCall = new MultiNeighborCallAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               multiNeighborCall.setClassification (0);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToElements ("caller", caller);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToElements ("callee", callee);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToElements ("callerClass", callerClass);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToElements ("calleeClass", calleeClass);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("attr", attr);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("callerClass", callerClass);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("calleeClass", calleeClass);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("callee", callee);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("root", root);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("loop", loop);
                                                                
                                                               // create link
                                                               multiNeighborCall.addToBoundObjects ("id", id);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object multiReference6 is really bound
                                                               JavaSDM.ensure ( multiReference6 != null ) ;
                                                                
                                                               // check object multiNeighborCall is really bound
                                                               JavaSDM.ensure ( multiNeighborCall != null ) ;
                                                                
                                                               // create link
                                                               multiNeighborCall.addToAntecedentAnnos (multiReference6);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (multiNeighborCall) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiNeighborCall is really bound
            JavaSDM.ensure ( multiNeighborCall != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("callerClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiNeighborCall) ;
   }


   private GFRNAnnotation annotateUsingCallerRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode1 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAttrAnnotationsMultiReference2 = null ;
      Iterator fujaba__IterCalleeAnnotationsMultiNeighborCall = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassAttrsAttr = null ;
      Iterator fujaba__IterMultiReference2ElementsCalleeClass = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode1 = null ;
      MultiNeighborCallAnnotation multiNeighborCall = null ;
      MultiReferenceAnnotation multiReference2 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr attr = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("caller", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            caller = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind root: ASTRootNode
            root = caller.getASTRootNode () ;
            JavaSDM.ensure ( root != null ) ;
             
            // bind callerClass: UMLClass
            callerClass = caller.getParent () ;
            JavaSDM.ensure ( callerClass != null ) ;
             
            // bind attr: UMLAttr
            fujaba__IterCallerClassAttrsAttr = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsAttr.hasNext () )
            {
               try
               {
                  attr = (UMLAttr) fujaba__IterCallerClassAttrsAttr.next () ;
                   
                  // bind multiReference2: MultiReferenceAnnotation
                  fujaba__IterAttrAnnotationsMultiReference2 = attr.iteratorOfAnnotations () ;
                  while ( fujaba__IterAttrAnnotationsMultiReference2.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAttrAnnotationsMultiReference2.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                        multiReference2 = (MultiReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between multiReference2 and attr
                        JavaSDM.ensure ( multiReference2.hasInElements ("field", attr) ) ;
                         
                        // bind calleeClass: UMLClass
                        fujaba__IterMultiReference2ElementsCalleeClass = multiReference2.iteratorOfElements ("references") ;
                        while ( fujaba__IterMultiReference2ElementsCalleeClass.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterMultiReference2ElementsCalleeClass.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              calleeClass = (UMLClass) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                               
                              // bind callee: UMLMethod
                              fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                              while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                              {
                                 try
                                 {
                                    callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                     
                                    // Path search between ASTRootNode and LoopNode
                                    // Bind loop : LoopNode
                                    fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                    while ( fujaba__IterRootToLoop.hasNext () )
                                    {
                                       try
                                       {
                                          loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                           
                                          // Path search between LoopNode and MethodCallNode
                                          // Bind methodCallNode1 : MethodCallNode
                                          fujaba__IterLoopToMethodCallNode1 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                          while ( fujaba__IterLoopToMethodCallNode1.hasNext () )
                                          {
                                             try
                                             {
                                                methodCallNode1 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode1.next () ;
                                                 
                                                // bind id: IdentifierNode
                                                id = methodCallNode1.getIdentifier () ;
                                                JavaSDM.ensure ( id != null ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object caller is really bound
                                                      JavaSDM.ensure ( caller != null ) ;
                                                       
                                                      // check object callee is really bound
                                                      JavaSDM.ensure ( callee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check object callerClass is really bound
                                                      JavaSDM.ensure ( callerClass != null ) ;
                                                       
                                                      // check object calleeClass is really bound
                                                      JavaSDM.ensure ( calleeClass != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                       
                                                      // bind multiNeighborCall: MultiNeighborCallAnnotation
                                                      fujaba__IterCalleeAnnotationsMultiNeighborCall = callee.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterCalleeAnnotationsMultiNeighborCall.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterCalleeAnnotationsMultiNeighborCall.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof MultiNeighborCallAnnotation ) ;
                                                            multiNeighborCall = (MultiNeighborCallAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between multiNeighborCall and callee
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("callee", callee) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and caller
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("caller", caller) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and callerClass
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("callerClass", callerClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and calleeClass
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("calleeClass", calleeClass) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // check object callerClass is really bound
                                                         JavaSDM.ensure ( callerClass != null ) ;
                                                          
                                                         // check object calleeClass is really bound
                                                         JavaSDM.ensure ( calleeClass != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                          
                                                         // check object attr is really bound
                                                         JavaSDM.ensure ( attr != null ) ;
                                                          
                                                         // check object root is really bound
                                                         JavaSDM.ensure ( root != null ) ;
                                                          
                                                         // check object loop is really bound
                                                         JavaSDM.ensure ( loop != null ) ;
                                                          
                                                         // check object id is really bound
                                                         JavaSDM.ensure ( id != null ) ;
                                                          
                                                         // create object
                                                         multiNeighborCall = new MultiNeighborCallAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         multiNeighborCall.setClassification (0);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("caller", caller);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("callee", callee);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("attr", attr);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("root", root);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("loop", loop);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("id", id);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object multiReference2 is really bound
                                                         JavaSDM.ensure ( multiReference2 != null ) ;
                                                          
                                                         // check object multiNeighborCall is really bound
                                                         JavaSDM.ensure ( multiNeighborCall != null ) ;
                                                          
                                                         // create link
                                                         multiNeighborCall.addToAntecedentAnnos (multiReference2);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (multiNeighborCall) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiNeighborCall is really bound
            JavaSDM.ensure ( multiNeighborCall != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("caller", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiNeighborCall) ;
   }


   private GFRNAnnotation annotateUsingTrigger_MultiReferenceRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterLoopToMethodCallNode3 = null ;
      ASTPathVisitor fujaba__IterRootToLoop = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassAnnotationsMultiNeighborCall = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterMultiReference4ElementsAttr = null ;
      Iterator fujaba__IterMultiReference4ElementsCalleeClass = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.LoopNode loop = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode3 = null ;
      MultiNeighborCallAnnotation multiNeighborCall = null ;
      MultiReferenceAnnotation multiReference4 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr attr = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_MultiReference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof MultiReferenceAnnotation ) ;
             
            // explicit type cast
            multiReference4 = (MultiReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind attr: UMLAttr
            fujaba__IterMultiReference4ElementsAttr = multiReference4.iteratorOfElements ("field") ;
            while ( fujaba__IterMultiReference4ElementsAttr.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterMultiReference4ElementsAttr.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                  attr = (UMLAttr) fujaba__TmpObject ;
                   
                  // bind callerClass: UMLClass
                  callerClass = attr.getParent () ;
                  JavaSDM.ensure ( callerClass != null ) ;
                   
                  // bind calleeClass: UMLClass
                  fujaba__IterMultiReference4ElementsCalleeClass = multiReference4.iteratorOfElements ("references") ;
                  while ( fujaba__IterMultiReference4ElementsCalleeClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterMultiReference4ElementsCalleeClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        calleeClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                        while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                               
                              // bind root: ASTRootNode
                              root = caller.getASTRootNode () ;
                              JavaSDM.ensure ( root != null ) ;
                               
                              // bind callee: UMLMethod
                              fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                              while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                              {
                                 try
                                 {
                                    callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                     
                                    // Path search between ASTRootNode and LoopNode
                                    // Bind loop : LoopNode
                                    fujaba__IterRootToLoop = new ASTPathVisitor (root, LoopNode.class ) ;
                                    while ( fujaba__IterRootToLoop.hasNext () )
                                    {
                                       try
                                       {
                                          loop = (de.upb.javaast.methodast.LoopNode) fujaba__IterRootToLoop.next () ;
                                           
                                          // Path search between LoopNode and MethodCallNode
                                          // Bind methodCallNode3 : MethodCallNode
                                          fujaba__IterLoopToMethodCallNode3 = new ASTPathVisitor (loop, MethodCallNode.class ) ;
                                          while ( fujaba__IterLoopToMethodCallNode3.hasNext () )
                                          {
                                             try
                                             {
                                                methodCallNode3 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterLoopToMethodCallNode3.next () ;
                                                 
                                                // bind id: IdentifierNode
                                                id = methodCallNode3.getIdentifier () ;
                                                JavaSDM.ensure ( id != null ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object caller is really bound
                                                      JavaSDM.ensure ( caller != null ) ;
                                                       
                                                      // check object callee is really bound
                                                      JavaSDM.ensure ( callee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check object callerClass is really bound
                                                      JavaSDM.ensure ( callerClass != null ) ;
                                                       
                                                      // check object calleeClass is really bound
                                                      JavaSDM.ensure ( calleeClass != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                       
                                                      // bind multiNeighborCall: MultiNeighborCallAnnotation
                                                      fujaba__IterCallerClassAnnotationsMultiNeighborCall = callerClass.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterCallerClassAnnotationsMultiNeighborCall.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterCallerClassAnnotationsMultiNeighborCall.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof MultiNeighborCallAnnotation ) ;
                                                            multiNeighborCall = (MultiNeighborCallAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between multiNeighborCall and callerClass
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("callerClass", callerClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and caller
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("caller", caller) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and callee
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("callee", callee) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between multiNeighborCall and calleeClass
                                                            JavaSDM.ensure ( multiNeighborCall.hasInElements ("calleeClass", calleeClass) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // check object callerClass is really bound
                                                         JavaSDM.ensure ( callerClass != null ) ;
                                                          
                                                         // check object calleeClass is really bound
                                                         JavaSDM.ensure ( calleeClass != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                          
                                                         // check object attr is really bound
                                                         JavaSDM.ensure ( attr != null ) ;
                                                          
                                                         // check object root is really bound
                                                         JavaSDM.ensure ( root != null ) ;
                                                          
                                                         // check object loop is really bound
                                                         JavaSDM.ensure ( loop != null ) ;
                                                          
                                                         // check object id is really bound
                                                         JavaSDM.ensure ( id != null ) ;
                                                          
                                                         // create object
                                                         multiNeighborCall = new MultiNeighborCallAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         multiNeighborCall.setClassification (0);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("caller", caller);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("callee", callee);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToElements ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("attr", attr);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("root", root);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("loop", loop);
                                                          
                                                         // create link
                                                         multiNeighborCall.addToBoundObjects ("id", id);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object multiReference4 is really bound
                                                         JavaSDM.ensure ( multiReference4 != null ) ;
                                                          
                                                         // check object multiNeighborCall is really bound
                                                         JavaSDM.ensure ( multiNeighborCall != null ) ;
                                                          
                                                         // create link
                                                         multiNeighborCall.addToAntecedentAnnos (multiReference4);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (multiNeighborCall) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiNeighborCall is really bound
            JavaSDM.ensure ( multiNeighborCall != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_MultiReference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiNeighborCall) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("caller", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("callee", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("callerClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("calleeClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof MultiReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_MultiReference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCallerClassAttrsAttr = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr attr = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("MultiReference") || annotation.equals ("ArrayReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            caller = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind callerClass: UMLClass
            callerClass = caller.getParent () ;
            JavaSDM.ensure ( callerClass != null ) ;
             
            // bind attr: UMLAttr
            fujaba__IterCallerClassAttrsAttr = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsAttr.hasNext () )
            {
               try
               {
                  attr = (UMLAttr) fujaba__IterCallerClassAttrsAttr.next () ;
                   
                  {
                     //  for each flow
                     set.add (attr);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            callee = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind calleeClass: UMLClass
            calleeClass = callee.getParent () ;
            JavaSDM.ensure ( calleeClass != null ) ;
             
            {
               //  for each flow
               set.add (calleeClass);
            } //  end for each flow
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            callerClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind attr: UMLAttr
            fujaba__IterCallerClassAttrsAttr = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsAttr.hasNext () )
            {
               try
               {
                  attr = (UMLAttr) fujaba__IterCallerClassAttrsAttr.next () ;
                   
                  {
                     //  for each flow
                     set.add (attr);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            calleeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (calleeClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
