package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;

public class ObjectAdapterEngine
extends GFRNEngine
{
   private  ObjectAdapterEngine()
   {
   }

   private static ObjectAdapterEngine theObjectAdapterEngine;

   public static ObjectAdapterEngine get()
   {
      if (theObjectAdapterEngine == null)
      {
         theObjectAdapterEngine = new ObjectAdapterEngine ();
      }
      return theObjectAdapterEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation objectAdapter = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         objectAdapter = this.annotateUsingTrigger_OverridingMethodRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( objectAdapter != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (objectAdapter) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            objectAdapter = this.annotateUsingTargetRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( objectAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (objectAdapter) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               objectAdapter = this.annotateUsingTrigger_GeneralizationRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( objectAdapter != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (objectAdapter) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  objectAdapter = this.annotateUsingAdapterRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( objectAdapter != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (objectAdapter) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     objectAdapter = this.annotateUsingTrigger_NeighborCallRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  try
                  {
                     fujaba__Success = false ;
                      
                     // constraint
                     JavaSDM.ensure ( objectAdapter != null ) ;
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  if ( fujaba__Success )
                  {
                     return (objectAdapter) ;
                  }
                  else
                  {
                     try
                     {
                        fujaba__Success = false ;
                         
                        // collabStatBegin 1 is empty !
                        objectAdapter = this.annotateUsingAdapteeRole(asgElement);
                         
                        // collabStatEnd
                        fujaba__Success = true ;
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     return (objectAdapter) ;
                  }
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingAdapteeRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapteeAnnotationsObjectAdapter = null ;
      Iterator fujaba__IterAdapteeMethodsCallee = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization22 = null ;
      Iterator fujaba__IterCalleeAnnotationsNeighborCall23 = null ;
      Iterator fujaba__IterCallerAnnotationsOverridingMethod21 = null ;
      Iterator fujaba__IterNeighborCall23ElementsCaller = null ;
      Iterator fujaba__IterOverridingMethod21ElementsUMLMethod24 = null ;
      GeneralizationAnnotation generalization22 = null ;
      NeighborCallAnnotation neighborCall23 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ObjectAdapterAnnotation objectAdapter = null ;
      OverridingMethodAnnotation overridingMethod21 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod24 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("adaptee", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
            while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                   
                  // bind neighborCall23: NeighborCallAnnotation
                  fujaba__IterCalleeAnnotationsNeighborCall23 = callee.iteratorOfAnnotations () ;
                  while ( fujaba__IterCalleeAnnotationsNeighborCall23.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCalleeAnnotationsNeighborCall23.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall23 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall23 and callee
                        JavaSDM.ensure ( neighborCall23.hasInElements ("callee", callee) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterNeighborCall23ElementsCaller = neighborCall23.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall23ElementsCaller.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall23ElementsCaller.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              caller = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                               
                              // bind adapter: UMLClass
                              adapter = caller.getParent () ;
                              JavaSDM.ensure ( adapter != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(adaptee.equals (adapter)) ) ;
                               
                              // bind overridingMethod21: OverridingMethodAnnotation
                              fujaba__IterCallerAnnotationsOverridingMethod21 = caller.iteratorOfAnnotations () ;
                              while ( fujaba__IterCallerAnnotationsOverridingMethod21.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterCallerAnnotationsOverridingMethod21.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                    overridingMethod21 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between overridingMethod21 and caller
                                    JavaSDM.ensure ( overridingMethod21.hasInElements ("overriding", caller) ) ;
                                     
                                    // bind generalization22: GeneralizationAnnotation
                                    fujaba__IterAdapterAnnotationsGeneralization22 = adapter.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAdapterAnnotationsGeneralization22.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization22.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                          generalization22 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between generalization22 and adapter
                                          JavaSDM.ensure ( generalization22.hasInElements ("subClass", adapter) ) ;
                                           
                                          // bind uMLMethod24: UMLMethod
                                          fujaba__IterOverridingMethod21ElementsUMLMethod24 = overridingMethod21.iteratorOfElements ("overridden") ;
                                          while ( fujaba__IterOverridingMethod21ElementsUMLMethod24.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterOverridingMethod21ElementsUMLMethod24.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                uMLMethod24 = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // attribute condition
                                                JavaSDM.ensure ( (uMLMethod24.isAbstract () == true) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (uMLMethod24)) && !(callee.equals (uMLMethod24)) ) ;
                                                 
                                                // bind target: UMLClass
                                                target = uMLMethod24.getParent () ;
                                                JavaSDM.ensure ( target != null ) ;
                                                 
                                                // attribute condition
                                                JavaSDM.ensure ( (target.isAbstract () == true) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(adapter.equals (target)) && !(adaptee.equals (target)) ) ;
                                                 
                                                // check To-Many-Link 'elements' between generalization22 and target
                                                JavaSDM.ensure ( generalization22.hasInElements ("superClass", target) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object target is really bound
                                                      JavaSDM.ensure ( target != null ) ;
                                                       
                                                      // check object adapter is really bound
                                                      JavaSDM.ensure ( adapter != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                       
                                                      // check object adaptee is really bound
                                                      JavaSDM.ensure ( adaptee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                       
                                                      // bind objectAdapter: ObjectAdapterAnnotation
                                                      fujaba__IterAdapteeAnnotationsObjectAdapter = adaptee.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterAdapteeAnnotationsObjectAdapter.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterAdapteeAnnotationsObjectAdapter.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof ObjectAdapterAnnotation ) ;
                                                            objectAdapter = (ObjectAdapterAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between objectAdapter and adaptee
                                                            JavaSDM.ensure ( objectAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between objectAdapter and target
                                                            JavaSDM.ensure ( objectAdapter.hasInElements ("target", target) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between objectAdapter and adapter
                                                            JavaSDM.ensure ( objectAdapter.hasInElements ("adapter", adapter) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object target is really bound
                                                         JavaSDM.ensure ( target != null ) ;
                                                          
                                                         // check object adapter is really bound
                                                         JavaSDM.ensure ( adapter != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                          
                                                         // check object adaptee is really bound
                                                         JavaSDM.ensure ( adaptee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // create object
                                                         objectAdapter = new ObjectAdapterAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         objectAdapter.setClassification (1);
                                                          
                                                         // create link
                                                         objectAdapter.addToElements ("target", target);
                                                          
                                                         // create link
                                                         objectAdapter.addToElements ("adapter", adapter);
                                                          
                                                         // create link
                                                         objectAdapter.addToElements ("adaptee", adaptee);
                                                          
                                                         // create link
                                                         objectAdapter.addToBoundObjects ("target", target);
                                                          
                                                         // create link
                                                         objectAdapter.addToBoundObjects ("adapter", adapter);
                                                          
                                                         // create link
                                                         objectAdapter.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         objectAdapter.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         objectAdapter.addToBoundObjects ("adaptee", adaptee);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object overridingMethod21 is really bound
                                                         JavaSDM.ensure ( overridingMethod21 != null ) ;
                                                          
                                                         // check object generalization22 is really bound
                                                         JavaSDM.ensure ( generalization22 != null ) ;
                                                          
                                                         // check object neighborCall23 is really bound
                                                         JavaSDM.ensure ( neighborCall23 != null ) ;
                                                          
                                                         // check object objectAdapter is really bound
                                                         JavaSDM.ensure ( objectAdapter != null ) ;
                                                          
                                                         // create link
                                                         objectAdapter.addToAntecedentAnnos (overridingMethod21);
                                                          
                                                         // create link
                                                         objectAdapter.addToAntecedentAnnos (generalization22);
                                                          
                                                         // create link
                                                         objectAdapter.addToAntecedentAnnos (neighborCall23);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (objectAdapter) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object objectAdapter is really bound
            JavaSDM.ensure ( objectAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("adaptee", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (objectAdapter) ;
   }


   private GFRNAnnotation annotateUsingAdapterRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization14 = null ;
      Iterator fujaba__IterAdapterMethodsCaller = null ;
      Iterator fujaba__IterCallerAnnotationsNeighborCall15 = null ;
      Iterator fujaba__IterCallerAnnotationsOverridingMethod13 = null ;
      Iterator fujaba__IterGeneralization14ElementsTarget = null ;
      Iterator fujaba__IterNeighborCall15ElementsCallee = null ;
      Iterator fujaba__IterOverridingMethod13ElementsUMLMethod16 = null ;
      Iterator fujaba__IterTargetAnnotationsObjectAdapter = null ;
      GeneralizationAnnotation generalization14 = null ;
      NeighborCallAnnotation neighborCall15 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ObjectAdapterAnnotation objectAdapter = null ;
      OverridingMethodAnnotation overridingMethod13 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod16 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("adapter", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
            while ( fujaba__IterAdapterMethodsCaller.hasNext () )
            {
               try
               {
                  caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                   
                  // bind generalization14: GeneralizationAnnotation
                  fujaba__IterAdapterAnnotationsGeneralization14 = adapter.iteratorOfAnnotations () ;
                  while ( fujaba__IterAdapterAnnotationsGeneralization14.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization14.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization14 = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization14 and adapter
                        JavaSDM.ensure ( generalization14.hasInElements ("subClass", adapter) ) ;
                         
                        // bind overridingMethod13: OverridingMethodAnnotation
                        fujaba__IterCallerAnnotationsOverridingMethod13 = caller.iteratorOfAnnotations () ;
                        while ( fujaba__IterCallerAnnotationsOverridingMethod13.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterCallerAnnotationsOverridingMethod13.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                              overridingMethod13 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between overridingMethod13 and caller
                              JavaSDM.ensure ( overridingMethod13.hasInElements ("overriding", caller) ) ;
                               
                              // bind neighborCall15: NeighborCallAnnotation
                              fujaba__IterCallerAnnotationsNeighborCall15 = caller.iteratorOfAnnotations () ;
                              while ( fujaba__IterCallerAnnotationsNeighborCall15.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterCallerAnnotationsNeighborCall15.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall15 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall15 and caller
                                    JavaSDM.ensure ( neighborCall15.hasInElements ("caller", caller) ) ;
                                     
                                    // bind target: UMLClass
                                    fujaba__IterGeneralization14ElementsTarget = generalization14.iteratorOfElements ("superClass") ;
                                    while ( fujaba__IterGeneralization14ElementsTarget.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterGeneralization14ElementsTarget.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          target = (UMLClass) fujaba__TmpObject ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (target.isAbstract () == true) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(adapter.equals (target)) ) ;
                                           
                                          // bind uMLMethod16: UMLMethod
                                          fujaba__IterOverridingMethod13ElementsUMLMethod16 = overridingMethod13.iteratorOfElements ("overridden") ;
                                          while ( fujaba__IterOverridingMethod13ElementsUMLMethod16.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterOverridingMethod13ElementsUMLMethod16.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                uMLMethod16 = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // attribute condition
                                                JavaSDM.ensure ( (uMLMethod16.isAbstract () == true) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (uMLMethod16)) ) ;
                                                 
                                                // check To-One-Link 'parent' between uMLMethod16 and target
                                                JavaSDM.ensure ( (uMLMethod16.getParent () != null) && uMLMethod16.getParent ().equals (target) ) ;
                                                 
                                                // bind callee: UMLMethod
                                                fujaba__IterNeighborCall15ElementsCallee = neighborCall15.iteratorOfElements ("callee") ;
                                                while ( fujaba__IterNeighborCall15ElementsCallee.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterNeighborCall15ElementsCallee.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      callee = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) && !(uMLMethod16.equals (callee)) ) ;
                                                       
                                                      // bind adaptee: UMLClass
                                                      adaptee = callee.getParent () ;
                                                      JavaSDM.ensure ( adaptee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object target is really bound
                                                            JavaSDM.ensure ( target != null ) ;
                                                             
                                                            // check object adapter is really bound
                                                            JavaSDM.ensure ( adapter != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                             
                                                            // check object adaptee is really bound
                                                            JavaSDM.ensure ( adaptee != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                             
                                                            // bind objectAdapter: ObjectAdapterAnnotation
                                                            fujaba__IterTargetAnnotationsObjectAdapter = target.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterTargetAnnotationsObjectAdapter.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterTargetAnnotationsObjectAdapter.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof ObjectAdapterAnnotation ) ;
                                                                  objectAdapter = (ObjectAdapterAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between objectAdapter and target
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("target", target) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between objectAdapter and adapter
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("adapter", adapter) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between objectAdapter and adaptee
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object target is really bound
                                                               JavaSDM.ensure ( target != null ) ;
                                                                
                                                               // check object adapter is really bound
                                                               JavaSDM.ensure ( adapter != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                                
                                                               // check object adaptee is really bound
                                                               JavaSDM.ensure ( adaptee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // create object
                                                               objectAdapter = new ObjectAdapterAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               objectAdapter.setClassification (1);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("target", target);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("adapter", adapter);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("adaptee", adaptee);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("target", target);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("adapter", adapter);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("callee", callee);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object overridingMethod13 is really bound
                                                               JavaSDM.ensure ( overridingMethod13 != null ) ;
                                                                
                                                               // check object generalization14 is really bound
                                                               JavaSDM.ensure ( generalization14 != null ) ;
                                                                
                                                               // check object neighborCall15 is really bound
                                                               JavaSDM.ensure ( neighborCall15 != null ) ;
                                                                
                                                               // check object objectAdapter is really bound
                                                               JavaSDM.ensure ( objectAdapter != null ) ;
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (overridingMethod13);
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (generalization14);
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (neighborCall15);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (objectAdapter) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object objectAdapter is really bound
            JavaSDM.ensure ( objectAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("adapter", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (objectAdapter) ;
   }


   private GFRNAnnotation annotateUsingTargetRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapterAnnotationsObjectAdapter = null ;
      Iterator fujaba__IterCallerAnnotationsNeighborCall7 = null ;
      Iterator fujaba__IterGeneralization6ElementsAdapter = null ;
      Iterator fujaba__IterNeighborCall7ElementsCallee = null ;
      Iterator fujaba__IterOverridingMethod5ElementsCaller = null ;
      Iterator fujaba__IterTargetAnnotationsGeneralization6 = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod8 = null ;
      Iterator fujaba__IterUMLMethod8AnnotationsOverridingMethod5 = null ;
      GeneralizationAnnotation generalization6 = null ;
      NeighborCallAnnotation neighborCall7 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ObjectAdapterAnnotation objectAdapter = null ;
      OverridingMethodAnnotation overridingMethod5 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod8 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("target", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (target.isAbstract () == true) ) ;
             
            // bind uMLMethod8: UMLMethod
            fujaba__IterTargetMethodsUMLMethod8 = target.iteratorOfMethods () ;
            while ( fujaba__IterTargetMethodsUMLMethod8.hasNext () )
            {
               try
               {
                  uMLMethod8 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod8.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (uMLMethod8.isAbstract () == true) ) ;
                   
                  // bind generalization6: GeneralizationAnnotation
                  fujaba__IterTargetAnnotationsGeneralization6 = target.iteratorOfAnnotations () ;
                  while ( fujaba__IterTargetAnnotationsGeneralization6.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterTargetAnnotationsGeneralization6.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization6 = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization6 and target
                        JavaSDM.ensure ( generalization6.hasInElements ("superClass", target) ) ;
                         
                        // bind overridingMethod5: OverridingMethodAnnotation
                        fujaba__IterUMLMethod8AnnotationsOverridingMethod5 = uMLMethod8.iteratorOfAnnotations () ;
                        while ( fujaba__IterUMLMethod8AnnotationsOverridingMethod5.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterUMLMethod8AnnotationsOverridingMethod5.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                              overridingMethod5 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between overridingMethod5 and uMLMethod8
                              JavaSDM.ensure ( overridingMethod5.hasInElements ("overridden", uMLMethod8) ) ;
                               
                              // bind adapter: UMLClass
                              fujaba__IterGeneralization6ElementsAdapter = generalization6.iteratorOfElements ("subClass") ;
                              while ( fujaba__IterGeneralization6ElementsAdapter.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterGeneralization6ElementsAdapter.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    adapter = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                     
                                    // bind caller: UMLMethod
                                    fujaba__IterOverridingMethod5ElementsCaller = overridingMethod5.iteratorOfElements ("overriding") ;
                                    while ( fujaba__IterOverridingMethod5ElementsCaller.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterOverridingMethod5ElementsCaller.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                          caller = (UMLMethod) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(uMLMethod8.equals (caller)) ) ;
                                           
                                          // check To-One-Link 'parent' between caller and adapter
                                          JavaSDM.ensure ( (caller.getParent () != null) && caller.getParent ().equals (adapter) ) ;
                                           
                                          // bind neighborCall7: NeighborCallAnnotation
                                          fujaba__IterCallerAnnotationsNeighborCall7 = caller.iteratorOfAnnotations () ;
                                          while ( fujaba__IterCallerAnnotationsNeighborCall7.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterCallerAnnotationsNeighborCall7.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                neighborCall7 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between neighborCall7 and caller
                                                JavaSDM.ensure ( neighborCall7.hasInElements ("caller", caller) ) ;
                                                 
                                                // bind callee: UMLMethod
                                                fujaba__IterNeighborCall7ElementsCallee = neighborCall7.iteratorOfElements ("callee") ;
                                                while ( fujaba__IterNeighborCall7ElementsCallee.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterNeighborCall7ElementsCallee.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      callee = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) && !(uMLMethod8.equals (callee)) ) ;
                                                       
                                                      // bind adaptee: UMLClass
                                                      adaptee = callee.getParent () ;
                                                      JavaSDM.ensure ( adaptee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object target is really bound
                                                            JavaSDM.ensure ( target != null ) ;
                                                             
                                                            // check object adapter is really bound
                                                            JavaSDM.ensure ( adapter != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                             
                                                            // check object adaptee is really bound
                                                            JavaSDM.ensure ( adaptee != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                             
                                                            // bind objectAdapter: ObjectAdapterAnnotation
                                                            fujaba__IterAdapterAnnotationsObjectAdapter = adapter.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterAdapterAnnotationsObjectAdapter.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterAdapterAnnotationsObjectAdapter.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof ObjectAdapterAnnotation ) ;
                                                                  objectAdapter = (ObjectAdapterAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between objectAdapter and adapter
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("adapter", adapter) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between objectAdapter and target
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("target", target) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between objectAdapter and adaptee
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object target is really bound
                                                               JavaSDM.ensure ( target != null ) ;
                                                                
                                                               // check object adapter is really bound
                                                               JavaSDM.ensure ( adapter != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                                
                                                               // check object adaptee is really bound
                                                               JavaSDM.ensure ( adaptee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // create object
                                                               objectAdapter = new ObjectAdapterAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               objectAdapter.setClassification (1);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("target", target);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("adapter", adapter);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("adaptee", adaptee);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("target", target);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("adapter", adapter);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("callee", callee);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object overridingMethod5 is really bound
                                                               JavaSDM.ensure ( overridingMethod5 != null ) ;
                                                                
                                                               // check object generalization6 is really bound
                                                               JavaSDM.ensure ( generalization6 != null ) ;
                                                                
                                                               // check object neighborCall7 is really bound
                                                               JavaSDM.ensure ( neighborCall7 != null ) ;
                                                                
                                                               // check object objectAdapter is really bound
                                                               JavaSDM.ensure ( objectAdapter != null ) ;
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (overridingMethod5);
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (generalization6);
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (neighborCall7);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (objectAdapter) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object objectAdapter is really bound
            JavaSDM.ensure ( objectAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("target", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (objectAdapter) ;
   }


   private GFRNAnnotation annotateUsingTrigger_GeneralizationRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapterMethodsCaller = null ;
      Iterator fujaba__IterCallerAnnotationsNeighborCall11 = null ;
      Iterator fujaba__IterGeneralization10ElementsAdapter = null ;
      Iterator fujaba__IterGeneralization10ElementsTarget = null ;
      Iterator fujaba__IterNeighborCall11ElementsCallee = null ;
      Iterator fujaba__IterTargetAnnotationsObjectAdapter = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod12 = null ;
      Iterator fujaba__IterUMLMethod12AnnotationsOverridingMethod9 = null ;
      GeneralizationAnnotation generalization10 = null ;
      NeighborCallAnnotation neighborCall11 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ObjectAdapterAnnotation objectAdapter = null ;
      OverridingMethodAnnotation overridingMethod9 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod12 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization10 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind target: UMLClass
            fujaba__IterGeneralization10ElementsTarget = generalization10.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization10ElementsTarget.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization10ElementsTarget.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  target = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (target.isAbstract () == true) ) ;
                   
                  // bind adapter: UMLClass
                  fujaba__IterGeneralization10ElementsAdapter = generalization10.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization10ElementsAdapter.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization10ElementsAdapter.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        adapter = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                         
                        // bind uMLMethod12: UMLMethod
                        fujaba__IterTargetMethodsUMLMethod12 = target.iteratorOfMethods () ;
                        while ( fujaba__IterTargetMethodsUMLMethod12.hasNext () )
                        {
                           try
                           {
                              uMLMethod12 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod12.next () ;
                               
                              // attribute condition
                              JavaSDM.ensure ( (uMLMethod12.isAbstract () == true) ) ;
                               
                              // bind caller: UMLMethod
                              fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
                              while ( fujaba__IterAdapterMethodsCaller.hasNext () )
                              {
                                 try
                                 {
                                    caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(uMLMethod12.equals (caller)) ) ;
                                     
                                    // bind overridingMethod9: OverridingMethodAnnotation
                                    fujaba__IterUMLMethod12AnnotationsOverridingMethod9 = uMLMethod12.iteratorOfAnnotations () ;
                                    while ( fujaba__IterUMLMethod12AnnotationsOverridingMethod9.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterUMLMethod12AnnotationsOverridingMethod9.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                          overridingMethod9 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between overridingMethod9 and uMLMethod12
                                          JavaSDM.ensure ( overridingMethod9.hasInElements ("overridden", uMLMethod12) ) ;
                                           
                                          // check To-Many-Link 'elements' between overridingMethod9 and caller
                                          JavaSDM.ensure ( overridingMethod9.hasInElements ("overriding", caller) ) ;
                                           
                                          // bind neighborCall11: NeighborCallAnnotation
                                          fujaba__IterCallerAnnotationsNeighborCall11 = caller.iteratorOfAnnotations () ;
                                          while ( fujaba__IterCallerAnnotationsNeighborCall11.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterCallerAnnotationsNeighborCall11.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                neighborCall11 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between neighborCall11 and caller
                                                JavaSDM.ensure ( neighborCall11.hasInElements ("caller", caller) ) ;
                                                 
                                                // bind callee: UMLMethod
                                                fujaba__IterNeighborCall11ElementsCallee = neighborCall11.iteratorOfElements ("callee") ;
                                                while ( fujaba__IterNeighborCall11ElementsCallee.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterNeighborCall11ElementsCallee.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      callee = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) && !(uMLMethod12.equals (callee)) ) ;
                                                       
                                                      // bind adaptee: UMLClass
                                                      adaptee = callee.getParent () ;
                                                      JavaSDM.ensure ( adaptee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object target is really bound
                                                            JavaSDM.ensure ( target != null ) ;
                                                             
                                                            // check object adapter is really bound
                                                            JavaSDM.ensure ( adapter != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                             
                                                            // check object adaptee is really bound
                                                            JavaSDM.ensure ( adaptee != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                             
                                                            // bind objectAdapter: ObjectAdapterAnnotation
                                                            fujaba__IterTargetAnnotationsObjectAdapter = target.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterTargetAnnotationsObjectAdapter.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterTargetAnnotationsObjectAdapter.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof ObjectAdapterAnnotation ) ;
                                                                  objectAdapter = (ObjectAdapterAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between objectAdapter and target
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("target", target) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between objectAdapter and adapter
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("adapter", adapter) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between objectAdapter and adaptee
                                                                  JavaSDM.ensure ( objectAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object target is really bound
                                                               JavaSDM.ensure ( target != null ) ;
                                                                
                                                               // check object adapter is really bound
                                                               JavaSDM.ensure ( adapter != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                                
                                                               // check object adaptee is really bound
                                                               JavaSDM.ensure ( adaptee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                                
                                                               // check object caller is really bound
                                                               JavaSDM.ensure ( caller != null ) ;
                                                                
                                                               // check object callee is really bound
                                                               JavaSDM.ensure ( callee != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                
                                                               // create object
                                                               objectAdapter = new ObjectAdapterAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               objectAdapter.setClassification (1);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("target", target);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("adapter", adapter);
                                                                
                                                               // create link
                                                               objectAdapter.addToElements ("adaptee", adaptee);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("target", target);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("adapter", adapter);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("caller", caller);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("callee", callee);
                                                                
                                                               // create link
                                                               objectAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object overridingMethod9 is really bound
                                                               JavaSDM.ensure ( overridingMethod9 != null ) ;
                                                                
                                                               // check object generalization10 is really bound
                                                               JavaSDM.ensure ( generalization10 != null ) ;
                                                                
                                                               // check object neighborCall11 is really bound
                                                               JavaSDM.ensure ( neighborCall11 != null ) ;
                                                                
                                                               // check object objectAdapter is really bound
                                                               JavaSDM.ensure ( objectAdapter != null ) ;
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (overridingMethod9);
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (generalization10);
                                                                
                                                               // create link
                                                               objectAdapter.addToAntecedentAnnos (neighborCall11);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (objectAdapter) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object objectAdapter is really bound
            JavaSDM.ensure ( objectAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Generalization", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (objectAdapter) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization18 = null ;
      Iterator fujaba__IterCallerAnnotationsOverridingMethod17 = null ;
      Iterator fujaba__IterNeighborCall19ElementsCallee = null ;
      Iterator fujaba__IterNeighborCall19ElementsCaller = null ;
      Iterator fujaba__IterOverridingMethod17ElementsUMLMethod20 = null ;
      Iterator fujaba__IterTargetAnnotationsObjectAdapter = null ;
      GeneralizationAnnotation generalization18 = null ;
      NeighborCallAnnotation neighborCall19 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ObjectAdapterAnnotation objectAdapter = null ;
      OverridingMethodAnnotation overridingMethod17 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod20 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall19 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterNeighborCall19ElementsCaller = neighborCall19.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall19ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall19ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind adapter: UMLClass
                  adapter = caller.getParent () ;
                  JavaSDM.ensure ( adapter != null ) ;
                   
                  // bind callee: UMLMethod
                  fujaba__IterNeighborCall19ElementsCallee = neighborCall19.iteratorOfElements ("callee") ;
                  while ( fujaba__IterNeighborCall19ElementsCallee.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNeighborCall19ElementsCallee.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        callee = (UMLMethod) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                         
                        // bind adaptee: UMLClass
                        adaptee = callee.getParent () ;
                        JavaSDM.ensure ( adaptee != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(adapter.equals (adaptee)) ) ;
                         
                        // bind overridingMethod17: OverridingMethodAnnotation
                        fujaba__IterCallerAnnotationsOverridingMethod17 = caller.iteratorOfAnnotations () ;
                        while ( fujaba__IterCallerAnnotationsOverridingMethod17.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterCallerAnnotationsOverridingMethod17.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                              overridingMethod17 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between overridingMethod17 and caller
                              JavaSDM.ensure ( overridingMethod17.hasInElements ("overriding", caller) ) ;
                               
                              // bind generalization18: GeneralizationAnnotation
                              fujaba__IterAdapterAnnotationsGeneralization18 = adapter.iteratorOfAnnotations () ;
                              while ( fujaba__IterAdapterAnnotationsGeneralization18.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization18.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                    generalization18 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between generalization18 and adapter
                                    JavaSDM.ensure ( generalization18.hasInElements ("subClass", adapter) ) ;
                                     
                                    // bind uMLMethod20: UMLMethod
                                    fujaba__IterOverridingMethod17ElementsUMLMethod20 = overridingMethod17.iteratorOfElements ("overridden") ;
                                    while ( fujaba__IterOverridingMethod17ElementsUMLMethod20.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterOverridingMethod17ElementsUMLMethod20.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                          uMLMethod20 = (UMLMethod) fujaba__TmpObject ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (uMLMethod20.isAbstract () == true) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(caller.equals (uMLMethod20)) && !(callee.equals (uMLMethod20)) ) ;
                                           
                                          // bind target: UMLClass
                                          target = uMLMethod20.getParent () ;
                                          JavaSDM.ensure ( target != null ) ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (target.isAbstract () == true) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(adapter.equals (target)) && !(adaptee.equals (target)) ) ;
                                           
                                          // check To-Many-Link 'elements' between generalization18 and target
                                          JavaSDM.ensure ( generalization18.hasInElements ("superClass", target) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object target is really bound
                                                JavaSDM.ensure ( target != null ) ;
                                                 
                                                // check object adapter is really bound
                                                JavaSDM.ensure ( adapter != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                 
                                                // check object adaptee is really bound
                                                JavaSDM.ensure ( adaptee != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                 
                                                // bind objectAdapter: ObjectAdapterAnnotation
                                                fujaba__IterTargetAnnotationsObjectAdapter = target.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterTargetAnnotationsObjectAdapter.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterTargetAnnotationsObjectAdapter.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof ObjectAdapterAnnotation ) ;
                                                      objectAdapter = (ObjectAdapterAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between objectAdapter and target
                                                      JavaSDM.ensure ( objectAdapter.hasInElements ("target", target) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between objectAdapter and adapter
                                                      JavaSDM.ensure ( objectAdapter.hasInElements ("adapter", adapter) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between objectAdapter and adaptee
                                                      JavaSDM.ensure ( objectAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object target is really bound
                                                   JavaSDM.ensure ( target != null ) ;
                                                    
                                                   // check object adapter is really bound
                                                   JavaSDM.ensure ( adapter != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                    
                                                   // check object adaptee is really bound
                                                   JavaSDM.ensure ( adaptee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // create object
                                                   objectAdapter = new ObjectAdapterAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   objectAdapter.setClassification (1);
                                                    
                                                   // create link
                                                   objectAdapter.addToElements ("target", target);
                                                    
                                                   // create link
                                                   objectAdapter.addToElements ("adapter", adapter);
                                                    
                                                   // create link
                                                   objectAdapter.addToElements ("adaptee", adaptee);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("target", target);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("adapter", adapter);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("callee", callee);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("adaptee", adaptee);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object overridingMethod17 is really bound
                                                   JavaSDM.ensure ( overridingMethod17 != null ) ;
                                                    
                                                   // check object generalization18 is really bound
                                                   JavaSDM.ensure ( generalization18 != null ) ;
                                                    
                                                   // check object neighborCall19 is really bound
                                                   JavaSDM.ensure ( neighborCall19 != null ) ;
                                                    
                                                   // check object objectAdapter is really bound
                                                   JavaSDM.ensure ( objectAdapter != null ) ;
                                                    
                                                   // create link
                                                   objectAdapter.addToAntecedentAnnos (overridingMethod17);
                                                    
                                                   // create link
                                                   objectAdapter.addToAntecedentAnnos (generalization18);
                                                    
                                                   // create link
                                                   objectAdapter.addToAntecedentAnnos (neighborCall19);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (objectAdapter) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object objectAdapter is really bound
            JavaSDM.ensure ( objectAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (objectAdapter) ;
   }


   private GFRNAnnotation annotateUsingTrigger_OverridingMethodRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapteeAnnotationsObjectAdapter = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization2 = null ;
      Iterator fujaba__IterCallerAnnotationsNeighborCall3 = null ;
      Iterator fujaba__IterNeighborCall3ElementsCallee = null ;
      Iterator fujaba__IterOverridingMethod1ElementsCaller = null ;
      Iterator fujaba__IterOverridingMethod1ElementsUMLMethod4 = null ;
      GeneralizationAnnotation generalization2 = null ;
      NeighborCallAnnotation neighborCall3 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      ObjectAdapterAnnotation objectAdapter = null ;
      OverridingMethodAnnotation overridingMethod1 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod4 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod1 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterOverridingMethod1ElementsCaller = overridingMethod1.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod1ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod1ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind adapter: UMLClass
                  adapter = caller.getParent () ;
                  JavaSDM.ensure ( adapter != null ) ;
                   
                  // bind uMLMethod4: UMLMethod
                  fujaba__IterOverridingMethod1ElementsUMLMethod4 = overridingMethod1.iteratorOfElements ("overridden") ;
                  while ( fujaba__IterOverridingMethod1ElementsUMLMethod4.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOverridingMethod1ElementsUMLMethod4.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        uMLMethod4 = (UMLMethod) fujaba__TmpObject ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (uMLMethod4.isAbstract () == true) ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(caller.equals (uMLMethod4)) ) ;
                         
                        // bind target: UMLClass
                        target = uMLMethod4.getParent () ;
                        JavaSDM.ensure ( target != null ) ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (target.isAbstract () == true) ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(adapter.equals (target)) ) ;
                         
                        // bind neighborCall3: NeighborCallAnnotation
                        fujaba__IterCallerAnnotationsNeighborCall3 = caller.iteratorOfAnnotations () ;
                        while ( fujaba__IterCallerAnnotationsNeighborCall3.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterCallerAnnotationsNeighborCall3.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                              neighborCall3 = (NeighborCallAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between neighborCall3 and caller
                              JavaSDM.ensure ( neighborCall3.hasInElements ("caller", caller) ) ;
                               
                              // bind generalization2: GeneralizationAnnotation
                              fujaba__IterAdapterAnnotationsGeneralization2 = adapter.iteratorOfAnnotations () ;
                              while ( fujaba__IterAdapterAnnotationsGeneralization2.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization2.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                    generalization2 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between generalization2 and adapter
                                    JavaSDM.ensure ( generalization2.hasInElements ("subClass", adapter) ) ;
                                     
                                    // check To-Many-Link 'elements' between generalization2 and target
                                    JavaSDM.ensure ( generalization2.hasInElements ("superClass", target) ) ;
                                     
                                    // bind callee: UMLMethod
                                    fujaba__IterNeighborCall3ElementsCallee = neighborCall3.iteratorOfElements ("callee") ;
                                    while ( fujaba__IterNeighborCall3ElementsCallee.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterNeighborCall3ElementsCallee.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                          callee = (UMLMethod) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(caller.equals (callee)) && !(uMLMethod4.equals (callee)) ) ;
                                           
                                          // bind adaptee: UMLClass
                                          adaptee = callee.getParent () ;
                                          JavaSDM.ensure ( adaptee != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object target is really bound
                                                JavaSDM.ensure ( target != null ) ;
                                                 
                                                // check object adapter is really bound
                                                JavaSDM.ensure ( adapter != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                 
                                                // check object adaptee is really bound
                                                JavaSDM.ensure ( adaptee != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                 
                                                // bind objectAdapter: ObjectAdapterAnnotation
                                                fujaba__IterAdapteeAnnotationsObjectAdapter = adaptee.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterAdapteeAnnotationsObjectAdapter.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterAdapteeAnnotationsObjectAdapter.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof ObjectAdapterAnnotation ) ;
                                                      objectAdapter = (ObjectAdapterAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between objectAdapter and adaptee
                                                      JavaSDM.ensure ( objectAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between objectAdapter and target
                                                      JavaSDM.ensure ( objectAdapter.hasInElements ("target", target) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between objectAdapter and adapter
                                                      JavaSDM.ensure ( objectAdapter.hasInElements ("adapter", adapter) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object target is really bound
                                                   JavaSDM.ensure ( target != null ) ;
                                                    
                                                   // check object adapter is really bound
                                                   JavaSDM.ensure ( adapter != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                                    
                                                   // check object adaptee is really bound
                                                   JavaSDM.ensure ( adaptee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(target.equals (adaptee)) && !(adapter.equals (adaptee)) ) ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // create object
                                                   objectAdapter = new ObjectAdapterAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   objectAdapter.setClassification (1);
                                                    
                                                   // create link
                                                   objectAdapter.addToElements ("target", target);
                                                    
                                                   // create link
                                                   objectAdapter.addToElements ("adapter", adapter);
                                                    
                                                   // create link
                                                   objectAdapter.addToElements ("adaptee", adaptee);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("target", target);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("adapter", adapter);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("callee", callee);
                                                    
                                                   // create link
                                                   objectAdapter.addToBoundObjects ("adaptee", adaptee);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object overridingMethod1 is really bound
                                                   JavaSDM.ensure ( overridingMethod1 != null ) ;
                                                    
                                                   // check object generalization2 is really bound
                                                   JavaSDM.ensure ( generalization2 != null ) ;
                                                    
                                                   // check object neighborCall3 is really bound
                                                   JavaSDM.ensure ( neighborCall3 != null ) ;
                                                    
                                                   // check object objectAdapter is really bound
                                                   JavaSDM.ensure ( objectAdapter != null ) ;
                                                    
                                                   // create link
                                                   objectAdapter.addToAntecedentAnnos (overridingMethod1);
                                                    
                                                   // create link
                                                   objectAdapter.addToAntecedentAnnos (generalization2);
                                                    
                                                   // create link
                                                   objectAdapter.addToAntecedentAnnos (neighborCall3);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (objectAdapter) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object objectAdapter is really bound
            JavaSDM.ensure ( objectAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_OverridingMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (objectAdapter) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("target", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("adapter", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("adaptee", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof OverridingMethodAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapteeMethodsCallee = null ;
      Iterator fujaba__IterAdapterMethodsCaller = null ;
      Iterator fujaba__IterCalleeAnnotationsNeighborCall26 = null ;
      Iterator fujaba__IterCalleeAnnotationsNeighborCall28 = null ;
      Iterator fujaba__IterGeneralization22ElementsTarget = null ;
      Iterator fujaba__IterNeighborCall26ElementsCaller = null ;
      Iterator fujaba__IterNeighborCall28ElementsCaller = null ;
      Iterator fujaba__IterOverridingMethod21ElementsCaller = null ;
      Iterator fujaba__IterOverridingMethod30ElementsCaller = null ;
      Iterator fujaba__IterOverridingMethod32ElementsCaller = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod25 = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod27 = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod29 = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod31 = null ;
      Iterator fujaba__IterUMLMethod29AnnotationsOverridingMethod30 = null ;
      Iterator fujaba__IterUMLMethod31AnnotationsOverridingMethod32 = null ;
      GeneralizationAnnotation generalization22 = null ;
      NeighborCallAnnotation neighborCall26 = null ;
      NeighborCallAnnotation neighborCall28 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod21 = null ;
      OverridingMethodAnnotation overridingMethod30 = null ;
      OverridingMethodAnnotation overridingMethod32 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod25 = null ;
      UMLMethod uMLMethod27 = null ;
      UMLMethod uMLMethod29 = null ;
      UMLMethod uMLMethod31 = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("OverridingMethod") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod25: UMLMethod
            fujaba__IterTargetMethodsUMLMethod25 = target.iteratorOfMethods () ;
            while ( fujaba__IterTargetMethodsUMLMethod25.hasNext () )
            {
               try
               {
                  uMLMethod25 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod25.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (uMLMethod25.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (uMLMethod25);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
            while ( fujaba__IterAdapterMethodsCaller.hasNext () )
            {
               try
               {
                  caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                   
                  {
                     //  for each flow
                     set.add (caller);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
            while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                   
                  // bind neighborCall26: NeighborCallAnnotation
                  fujaba__IterCalleeAnnotationsNeighborCall26 = callee.iteratorOfAnnotations () ;
                  while ( fujaba__IterCalleeAnnotationsNeighborCall26.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCalleeAnnotationsNeighborCall26.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall26 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall26 and callee
                        JavaSDM.ensure ( neighborCall26.hasInElements ("callee", callee) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterNeighborCall26ElementsCaller = neighborCall26.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall26ElementsCaller.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall26ElementsCaller.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              caller = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (caller);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization22 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind target: UMLClass
            fujaba__IterGeneralization22ElementsTarget = generalization22.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization22ElementsTarget.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization22ElementsTarget.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  target = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (target.isAbstract () == true) ) ;
                   
                  // bind uMLMethod27: UMLMethod
                  fujaba__IterTargetMethodsUMLMethod27 = target.iteratorOfMethods () ;
                  while ( fujaba__IterTargetMethodsUMLMethod27.hasNext () )
                  {
                     try
                     {
                        uMLMethod27 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod27.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (uMLMethod27.isAbstract () == true) ) ;
                         
                        {
                           //  for each flow
                           set.add (uMLMethod27);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall26 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterNeighborCall26ElementsCaller = neighborCall26.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall26ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall26ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (caller);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (target);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (adapter);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
            while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                   
                  // bind neighborCall28: NeighborCallAnnotation
                  fujaba__IterCalleeAnnotationsNeighborCall28 = callee.iteratorOfAnnotations () ;
                  while ( fujaba__IterCalleeAnnotationsNeighborCall28.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCalleeAnnotationsNeighborCall28.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall28 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall28 and callee
                        JavaSDM.ensure ( neighborCall28.hasInElements ("callee", callee) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterNeighborCall28ElementsCaller = neighborCall28.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall28ElementsCaller.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall28ElementsCaller.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              caller = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                               
                              // bind adapter: UMLClass
                              adapter = caller.getParent () ;
                              JavaSDM.ensure ( adapter != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(adaptee.equals (adapter)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (adapter);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod21 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterOverridingMethod21ElementsCaller = overridingMethod21.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod21ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod21ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind adapter: UMLClass
                  adapter = caller.getParent () ;
                  JavaSDM.ensure ( adapter != null ) ;
                   
                  {
                     //  for each flow
                     set.add (adapter);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall28 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterNeighborCall28ElementsCaller = neighborCall28.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall28ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall28ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind adapter: UMLClass
                  adapter = caller.getParent () ;
                  JavaSDM.ensure ( adapter != null ) ;
                   
                  {
                     //  for each flow
                     set.add (adapter);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod29: UMLMethod
            fujaba__IterTargetMethodsUMLMethod29 = target.iteratorOfMethods () ;
            while ( fujaba__IterTargetMethodsUMLMethod29.hasNext () )
            {
               try
               {
                  uMLMethod29 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod29.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (uMLMethod29.isAbstract () == true) ) ;
                   
                  // bind overridingMethod30: OverridingMethodAnnotation
                  fujaba__IterUMLMethod29AnnotationsOverridingMethod30 = uMLMethod29.iteratorOfAnnotations () ;
                  while ( fujaba__IterUMLMethod29AnnotationsOverridingMethod30.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterUMLMethod29AnnotationsOverridingMethod30.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                        overridingMethod30 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between overridingMethod30 and uMLMethod29
                        JavaSDM.ensure ( overridingMethod30.hasInElements ("overridden", uMLMethod29) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterOverridingMethod30ElementsCaller = overridingMethod30.iteratorOfElements ("overriding") ;
                        while ( fujaba__IterOverridingMethod30ElementsCaller.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterOverridingMethod30ElementsCaller.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              caller = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(uMLMethod29.equals (caller)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (caller);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
            while ( fujaba__IterAdapterMethodsCaller.hasNext () )
            {
               try
               {
                  caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                   
                  {
                     //  for each flow
                     set.add (caller);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
            while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                   
                  {
                     //  for each flow
                     set.add (callee);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod30 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterOverridingMethod30ElementsCaller = overridingMethod30.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod30ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod30ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (caller);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization22 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind target: UMLClass
            fujaba__IterGeneralization22ElementsTarget = generalization22.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization22ElementsTarget.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization22ElementsTarget.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  target = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (target.isAbstract () == true) ) ;
                   
                  // bind uMLMethod31: UMLMethod
                  fujaba__IterTargetMethodsUMLMethod31 = target.iteratorOfMethods () ;
                  while ( fujaba__IterTargetMethodsUMLMethod31.hasNext () )
                  {
                     try
                     {
                        uMLMethod31 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod31.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (uMLMethod31.isAbstract () == true) ) ;
                         
                        // bind overridingMethod32: OverridingMethodAnnotation
                        fujaba__IterUMLMethod31AnnotationsOverridingMethod32 = uMLMethod31.iteratorOfAnnotations () ;
                        while ( fujaba__IterUMLMethod31AnnotationsOverridingMethod32.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterUMLMethod31AnnotationsOverridingMethod32.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                              overridingMethod32 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between overridingMethod32 and uMLMethod31
                              JavaSDM.ensure ( overridingMethod32.hasInElements ("overridden", uMLMethod31) ) ;
                               
                              // bind caller: UMLMethod
                              fujaba__IterOverridingMethod32ElementsCaller = overridingMethod32.iteratorOfElements ("overriding") ;
                              while ( fujaba__IterOverridingMethod32ElementsCaller.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterOverridingMethod32ElementsCaller.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    caller = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(uMLMethod31.equals (caller)) ) ;
                                     
                                    {
                                       //  for each flow
                                       set.add (caller);
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
