package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLParam;

public class StrategyEngine
extends GFRNEngine
{
   private  StrategyEngine()
   {
   }

   private static StrategyEngine theStrategyEngine;

   public static StrategyEngine get()
   {
      if (theStrategyEngine == null)
      {
         theStrategyEngine = new StrategyEngine ();
      }
      return theStrategyEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation strategy = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         strategy = this.annotateUsingStrategyRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( strategy != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (strategy) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            strategy = this.annotateUsingTrigger_ReferenceRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( strategy != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (strategy) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               strategy = this.annotateUsingContextRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( strategy != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (strategy) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  strategy = this.annotateUsingTrigger_NeighborCallRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( strategy != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (strategy) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     strategy = this.annotateUsingTrigger_OverridingMethodRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (strategy) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingContextRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod12 = null ;
      Iterator fujaba__IterContextAnnotationsReference9 = null ;
      Iterator fujaba__IterContextAnnotationsStrategy = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      Iterator fujaba__IterContextMethodsSetStrategy = null ;
      Iterator fujaba__IterNeighborCall10ElementsAlgorithm = null ;
      Iterator fujaba__IterRequestAnnotationsNeighborCall10 = null ;
      Iterator fujaba__IterSetStrategyParamUMLParam11 = null ;
      NeighborCallAnnotation neighborCall10 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod12 = null ;
      ReferenceAnnotation reference9 = null ;
      StrategyAnnotation strategy = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam11 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("context", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
            while ( fujaba__IterContextMethodsRequest.hasNext () )
            {
               try
               {
                  request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                   
                  // bind setStrategy: UMLMethod
                  fujaba__IterContextMethodsSetStrategy = context.iteratorOfMethods () ;
                  while ( fujaba__IterContextMethodsSetStrategy.hasNext () )
                  {
                     try
                     {
                        setStrategy = (UMLMethod) fujaba__IterContextMethodsSetStrategy.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(request.equals (setStrategy)) ) ;
                         
                        // bind reference9: ReferenceAnnotation
                        fujaba__IterContextAnnotationsReference9 = context.iteratorOfAnnotations () ;
                        while ( fujaba__IterContextAnnotationsReference9.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterContextAnnotationsReference9.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference9 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference9 and context
                              JavaSDM.ensure ( reference9.hasInElements ("referencingClass", context) ) ;
                               
                              // bind neighborCall10: NeighborCallAnnotation
                              fujaba__IterRequestAnnotationsNeighborCall10 = request.iteratorOfAnnotations () ;
                              while ( fujaba__IterRequestAnnotationsNeighborCall10.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterRequestAnnotationsNeighborCall10.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall10 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall10 and request
                                    JavaSDM.ensure ( neighborCall10.hasInElements ("caller", request) ) ;
                                     
                                    // bind uMLParam11: UMLParam
                                    fujaba__IterSetStrategyParamUMLParam11 = setStrategy.iteratorOfParam () ;
                                    while ( fujaba__IterSetStrategyParamUMLParam11.hasNext () )
                                    {
                                       try
                                       {
                                          uMLParam11 = (UMLParam) fujaba__IterSetStrategyParamUMLParam11.next () ;
                                           
                                          // bind abstractStrategy: UMLClass
                                          fujaba__TmpObject = uMLParam11.getParamType () ;
                                          JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          abstractStrategy = (UMLClass) fujaba__TmpObject ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(context.equals (abstractStrategy)) ) ;
                                           
                                          // check To-Many-Link 'elements' between reference9 and abstractStrategy
                                          JavaSDM.ensure ( reference9.hasInElements ("references", abstractStrategy) ) ;
                                           
                                          // bind algorithm: UMLMethod
                                          fujaba__IterNeighborCall10ElementsAlgorithm = neighborCall10.iteratorOfElements ("callee") ;
                                          while ( fujaba__IterNeighborCall10ElementsAlgorithm.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall10ElementsAlgorithm.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                algorithm = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // attribute condition
                                                JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(request.equals (algorithm)) && !(setStrategy.equals (algorithm)) ) ;
                                                 
                                                // check To-One-Link 'parent' between algorithm and abstractStrategy
                                                JavaSDM.ensure ( (algorithm.getParent () != null) && algorithm.getParent ().equals (abstractStrategy) ) ;
                                                 
                                                // bind overridingMethod12: OverridingMethodAnnotation
                                                fujaba__IterAlgorithmAnnotationsOverridingMethod12 = algorithm.iteratorOfAnnotations () ;
                                                while ( fujaba__IterAlgorithmAnnotationsOverridingMethod12.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod12.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                                      overridingMethod12 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between overridingMethod12 and algorithm
                                                      JavaSDM.ensure ( overridingMethod12.hasInElements ("overridden", algorithm) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object abstractStrategy is really bound
                                                            JavaSDM.ensure ( abstractStrategy != null ) ;
                                                             
                                                            // check object context is really bound
                                                            JavaSDM.ensure ( context != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                             
                                                            // bind strategy: StrategyAnnotation
                                                            fujaba__IterContextAnnotationsStrategy = context.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterContextAnnotationsStrategy.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterContextAnnotationsStrategy.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyAnnotation ) ;
                                                                  strategy = (StrategyAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between strategy and context
                                                                  JavaSDM.ensure ( strategy.hasInElements ("context", context) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between strategy and abstractStrategy
                                                                  JavaSDM.ensure ( strategy.hasInElements ("strategy", abstractStrategy) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object abstractStrategy is really bound
                                                               JavaSDM.ensure ( abstractStrategy != null ) ;
                                                                
                                                               // check object context is really bound
                                                               JavaSDM.ensure ( context != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                                
                                                               // check object algorithm is really bound
                                                               JavaSDM.ensure ( algorithm != null ) ;
                                                                
                                                               // check object request is really bound
                                                               JavaSDM.ensure ( request != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                                
                                                               // check object setStrategy is really bound
                                                               JavaSDM.ensure ( setStrategy != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                                
                                                               // create object
                                                               strategy = new StrategyAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               strategy.setClassification (1);
                                                                
                                                               // create link
                                                               strategy.addToElements ("strategy", abstractStrategy);
                                                                
                                                               // create link
                                                               strategy.addToElements ("context", context);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("algorithm", algorithm);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("context", context);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("request", request);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("setStrategy", setStrategy);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object reference9 is really bound
                                                               JavaSDM.ensure ( reference9 != null ) ;
                                                                
                                                               // check object neighborCall10 is really bound
                                                               JavaSDM.ensure ( neighborCall10 != null ) ;
                                                                
                                                               // check object overridingMethod12 is really bound
                                                               JavaSDM.ensure ( overridingMethod12 != null ) ;
                                                                
                                                               // check object strategy is really bound
                                                               JavaSDM.ensure ( strategy != null ) ;
                                                                
                                                               // create link
                                                               strategy.addToAntecedentAnnos (reference9);
                                                                
                                                               // create link
                                                               strategy.addToAntecedentAnnos (neighborCall10);
                                                                
                                                               // create link
                                                               strategy.addToAntecedentAnnos (overridingMethod12);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (strategy) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategy is really bound
            JavaSDM.ensure ( strategy != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("context", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategy) ;
   }


   private GFRNAnnotation annotateUsingStrategyRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyAnnotationsReference1 = null ;
      Iterator fujaba__IterAbstractStrategyAnnotationsStrategy = null ;
      Iterator fujaba__IterAbstractStrategyMethodsAlgorithm = null ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam3 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsNeighborCall2 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod4 = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      NeighborCallAnnotation neighborCall2 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod4 = null ;
      ReferenceAnnotation reference1 = null ;
      StrategyAnnotation strategy = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam3 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("strategy", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
             
            // bind algorithm: UMLMethod
            fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
            while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
            {
               try
               {
                  algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                   
                  // bind reference1: ReferenceAnnotation
                  fujaba__IterAbstractStrategyAnnotationsReference1 = abstractStrategy.iteratorOfAnnotations () ;
                  while ( fujaba__IterAbstractStrategyAnnotationsReference1.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsReference1.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                        reference1 = (ReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between reference1 and abstractStrategy
                        JavaSDM.ensure ( reference1.hasInElements ("references", abstractStrategy) ) ;
                         
                        // bind uMLParam3: UMLParam
                        fujaba__IterAbstractStrategyRevParamTypeUMLParam3 = abstractStrategy.iteratorOfRevParamType () ;
                        while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam3.hasNext () )
                        {
                           try
                           {
                              uMLParam3 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam3.next () ;
                               
                              // bind setStrategy: UMLMethod
                              setStrategy = uMLParam3.getRevParam () ;
                              JavaSDM.ensure ( setStrategy != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(algorithm.equals (setStrategy)) ) ;
                               
                              // bind context: UMLClass
                              context = setStrategy.getParent () ;
                              JavaSDM.ensure ( context != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                               
                              // check To-Many-Link 'elements' between reference1 and context
                              JavaSDM.ensure ( reference1.hasInElements ("referencingClass", context) ) ;
                               
                              // bind neighborCall2: NeighborCallAnnotation
                              fujaba__IterAlgorithmAnnotationsNeighborCall2 = algorithm.iteratorOfAnnotations () ;
                              while ( fujaba__IterAlgorithmAnnotationsNeighborCall2.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsNeighborCall2.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall2 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall2 and algorithm
                                    JavaSDM.ensure ( neighborCall2.hasInElements ("callee", algorithm) ) ;
                                     
                                    // bind overridingMethod4: OverridingMethodAnnotation
                                    fujaba__IterAlgorithmAnnotationsOverridingMethod4 = algorithm.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAlgorithmAnnotationsOverridingMethod4.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod4.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                          overridingMethod4 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between overridingMethod4 and algorithm
                                          JavaSDM.ensure ( overridingMethod4.hasInElements ("overridden", algorithm) ) ;
                                           
                                          // bind request: UMLMethod
                                          fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
                                          while ( fujaba__IterContextMethodsRequest.hasNext () )
                                          {
                                             try
                                             {
                                                request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(algorithm.equals (request)) && !(setStrategy.equals (request)) ) ;
                                                 
                                                // check To-Many-Link 'elements' between neighborCall2 and request
                                                JavaSDM.ensure ( neighborCall2.hasInElements ("caller", request) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstractStrategy is really bound
                                                      JavaSDM.ensure ( abstractStrategy != null ) ;
                                                       
                                                      // check object context is really bound
                                                      JavaSDM.ensure ( context != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                       
                                                      // bind strategy: StrategyAnnotation
                                                      fujaba__IterAbstractStrategyAnnotationsStrategy = abstractStrategy.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterAbstractStrategyAnnotationsStrategy.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsStrategy.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyAnnotation ) ;
                                                            strategy = (StrategyAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between strategy and abstractStrategy
                                                            JavaSDM.ensure ( strategy.hasInElements ("strategy", abstractStrategy) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between strategy and context
                                                            JavaSDM.ensure ( strategy.hasInElements ("context", context) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstractStrategy is really bound
                                                         JavaSDM.ensure ( abstractStrategy != null ) ;
                                                          
                                                         // check object context is really bound
                                                         JavaSDM.ensure ( context != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                          
                                                         // check object algorithm is really bound
                                                         JavaSDM.ensure ( algorithm != null ) ;
                                                          
                                                         // check object request is really bound
                                                         JavaSDM.ensure ( request != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                          
                                                         // check object setStrategy is really bound
                                                         JavaSDM.ensure ( setStrategy != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                          
                                                         // create object
                                                         strategy = new StrategyAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         strategy.setClassification (1);
                                                          
                                                         // create link
                                                         strategy.addToElements ("strategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategy.addToElements ("context", context);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("algorithm", algorithm);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("context", context);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("request", request);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("setStrategy", setStrategy);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object reference1 is really bound
                                                         JavaSDM.ensure ( reference1 != null ) ;
                                                          
                                                         // check object neighborCall2 is really bound
                                                         JavaSDM.ensure ( neighborCall2 != null ) ;
                                                          
                                                         // check object overridingMethod4 is really bound
                                                         JavaSDM.ensure ( overridingMethod4 != null ) ;
                                                          
                                                         // check object strategy is really bound
                                                         JavaSDM.ensure ( strategy != null ) ;
                                                          
                                                         // create link
                                                         strategy.addToAntecedentAnnos (reference1);
                                                          
                                                         // create link
                                                         strategy.addToAntecedentAnnos (neighborCall2);
                                                          
                                                         // create link
                                                         strategy.addToAntecedentAnnos (overridingMethod4);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (strategy) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategy is really bound
            JavaSDM.ensure ( strategy != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("strategy", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategy) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam15 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod16 = null ;
      Iterator fujaba__IterContextAnnotationsReference13 = null ;
      Iterator fujaba__IterContextAnnotationsStrategy = null ;
      Iterator fujaba__IterContextMethodsSetStrategy = null ;
      Iterator fujaba__IterNeighborCall14ElementsAlgorithm = null ;
      Iterator fujaba__IterNeighborCall14ElementsRequest = null ;
      NeighborCallAnnotation neighborCall14 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod16 = null ;
      ReferenceAnnotation reference13 = null ;
      StrategyAnnotation strategy = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam15 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall14 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterNeighborCall14ElementsRequest = neighborCall14.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall14ElementsRequest.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall14ElementsRequest.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  request = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind context: UMLClass
                  context = request.getParent () ;
                  JavaSDM.ensure ( context != null ) ;
                   
                  // bind algorithm: UMLMethod
                  fujaba__IterNeighborCall14ElementsAlgorithm = neighborCall14.iteratorOfElements ("callee") ;
                  while ( fujaba__IterNeighborCall14ElementsAlgorithm.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNeighborCall14ElementsAlgorithm.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        algorithm = (UMLMethod) fujaba__TmpObject ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(request.equals (algorithm)) ) ;
                         
                        // bind abstractStrategy: UMLClass
                        abstractStrategy = algorithm.getParent () ;
                        JavaSDM.ensure ( abstractStrategy != null ) ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(context.equals (abstractStrategy)) ) ;
                         
                        // bind setStrategy: UMLMethod
                        fujaba__IterContextMethodsSetStrategy = context.iteratorOfMethods () ;
                        while ( fujaba__IterContextMethodsSetStrategy.hasNext () )
                        {
                           try
                           {
                              setStrategy = (UMLMethod) fujaba__IterContextMethodsSetStrategy.next () ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                               
                              // bind reference13: ReferenceAnnotation
                              fujaba__IterContextAnnotationsReference13 = context.iteratorOfAnnotations () ;
                              while ( fujaba__IterContextAnnotationsReference13.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterContextAnnotationsReference13.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                                    reference13 = (ReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between reference13 and context
                                    JavaSDM.ensure ( reference13.hasInElements ("referencingClass", context) ) ;
                                     
                                    // check To-Many-Link 'elements' between reference13 and abstractStrategy
                                    JavaSDM.ensure ( reference13.hasInElements ("references", abstractStrategy) ) ;
                                     
                                    // bind overridingMethod16: OverridingMethodAnnotation
                                    fujaba__IterAlgorithmAnnotationsOverridingMethod16 = algorithm.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAlgorithmAnnotationsOverridingMethod16.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod16.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                          overridingMethod16 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between overridingMethod16 and algorithm
                                          JavaSDM.ensure ( overridingMethod16.hasInElements ("overridden", algorithm) ) ;
                                           
                                          // bind uMLParam15: UMLParam
                                          fujaba__IterAbstractStrategyRevParamTypeUMLParam15 = abstractStrategy.iteratorOfRevParamType () ;
                                          while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam15.hasNext () )
                                          {
                                             try
                                             {
                                                uMLParam15 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam15.next () ;
                                                 
                                                // check To-One-Link 'revParam' between uMLParam15 and setStrategy
                                                JavaSDM.ensure ( (uMLParam15.getRevParam () != null) && uMLParam15.getRevParam ().equals (setStrategy) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstractStrategy is really bound
                                                      JavaSDM.ensure ( abstractStrategy != null ) ;
                                                       
                                                      // check object context is really bound
                                                      JavaSDM.ensure ( context != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                       
                                                      // bind strategy: StrategyAnnotation
                                                      fujaba__IterContextAnnotationsStrategy = context.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterContextAnnotationsStrategy.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterContextAnnotationsStrategy.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyAnnotation ) ;
                                                            strategy = (StrategyAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between strategy and context
                                                            JavaSDM.ensure ( strategy.hasInElements ("context", context) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between strategy and abstractStrategy
                                                            JavaSDM.ensure ( strategy.hasInElements ("strategy", abstractStrategy) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstractStrategy is really bound
                                                         JavaSDM.ensure ( abstractStrategy != null ) ;
                                                          
                                                         // check object context is really bound
                                                         JavaSDM.ensure ( context != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                          
                                                         // check object algorithm is really bound
                                                         JavaSDM.ensure ( algorithm != null ) ;
                                                          
                                                         // check object request is really bound
                                                         JavaSDM.ensure ( request != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                          
                                                         // check object setStrategy is really bound
                                                         JavaSDM.ensure ( setStrategy != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                          
                                                         // create object
                                                         strategy = new StrategyAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         strategy.setClassification (1);
                                                          
                                                         // create link
                                                         strategy.addToElements ("strategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategy.addToElements ("context", context);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("algorithm", algorithm);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("context", context);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("request", request);
                                                          
                                                         // create link
                                                         strategy.addToBoundObjects ("setStrategy", setStrategy);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object reference13 is really bound
                                                         JavaSDM.ensure ( reference13 != null ) ;
                                                          
                                                         // check object neighborCall14 is really bound
                                                         JavaSDM.ensure ( neighborCall14 != null ) ;
                                                          
                                                         // check object overridingMethod16 is really bound
                                                         JavaSDM.ensure ( overridingMethod16 != null ) ;
                                                          
                                                         // check object strategy is really bound
                                                         JavaSDM.ensure ( strategy != null ) ;
                                                          
                                                         // create link
                                                         strategy.addToAntecedentAnnos (reference13);
                                                          
                                                         // create link
                                                         strategy.addToAntecedentAnnos (neighborCall14);
                                                          
                                                         // create link
                                                         strategy.addToAntecedentAnnos (overridingMethod16);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (strategy) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategy is really bound
            JavaSDM.ensure ( strategy != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategy) ;
   }


   private GFRNAnnotation annotateUsingTrigger_OverridingMethodRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyAnnotationsReference17 = null ;
      Iterator fujaba__IterAbstractStrategyAnnotationsStrategy = null ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam19 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsNeighborCall18 = null ;
      Iterator fujaba__IterNeighborCall18ElementsRequest = null ;
      Iterator fujaba__IterOverridingMethod20ElementsAlgorithm = null ;
      NeighborCallAnnotation neighborCall18 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod20 = null ;
      ReferenceAnnotation reference17 = null ;
      StrategyAnnotation strategy = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam19 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod20 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterOverridingMethod20ElementsAlgorithm = overridingMethod20.iteratorOfElements ("overridden") ;
            while ( fujaba__IterOverridingMethod20ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod20ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                   
                  // bind abstractStrategy: UMLClass
                  abstractStrategy = algorithm.getParent () ;
                  JavaSDM.ensure ( abstractStrategy != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
                   
                  // bind neighborCall18: NeighborCallAnnotation
                  fujaba__IterAlgorithmAnnotationsNeighborCall18 = algorithm.iteratorOfAnnotations () ;
                  while ( fujaba__IterAlgorithmAnnotationsNeighborCall18.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsNeighborCall18.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall18 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall18 and algorithm
                        JavaSDM.ensure ( neighborCall18.hasInElements ("callee", algorithm) ) ;
                         
                        // bind reference17: ReferenceAnnotation
                        fujaba__IterAbstractStrategyAnnotationsReference17 = abstractStrategy.iteratorOfAnnotations () ;
                        while ( fujaba__IterAbstractStrategyAnnotationsReference17.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsReference17.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference17 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference17 and abstractStrategy
                              JavaSDM.ensure ( reference17.hasInElements ("references", abstractStrategy) ) ;
                               
                              // bind uMLParam19: UMLParam
                              fujaba__IterAbstractStrategyRevParamTypeUMLParam19 = abstractStrategy.iteratorOfRevParamType () ;
                              while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam19.hasNext () )
                              {
                                 try
                                 {
                                    uMLParam19 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam19.next () ;
                                     
                                    // bind setStrategy: UMLMethod
                                    setStrategy = uMLParam19.getRevParam () ;
                                    JavaSDM.ensure ( setStrategy != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(algorithm.equals (setStrategy)) ) ;
                                     
                                    // bind context: UMLClass
                                    context = setStrategy.getParent () ;
                                    JavaSDM.ensure ( context != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                     
                                    // check To-Many-Link 'elements' between reference17 and context
                                    JavaSDM.ensure ( reference17.hasInElements ("referencingClass", context) ) ;
                                     
                                    // bind request: UMLMethod
                                    fujaba__IterNeighborCall18ElementsRequest = neighborCall18.iteratorOfElements ("caller") ;
                                    while ( fujaba__IterNeighborCall18ElementsRequest.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterNeighborCall18ElementsRequest.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                          request = (UMLMethod) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(algorithm.equals (request)) && !(setStrategy.equals (request)) ) ;
                                           
                                          // check To-One-Link 'parent' between request and context
                                          JavaSDM.ensure ( (request.getParent () != null) && request.getParent ().equals (context) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object abstractStrategy is really bound
                                                JavaSDM.ensure ( abstractStrategy != null ) ;
                                                 
                                                // check object context is really bound
                                                JavaSDM.ensure ( context != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                 
                                                // bind strategy: StrategyAnnotation
                                                fujaba__IterAbstractStrategyAnnotationsStrategy = abstractStrategy.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterAbstractStrategyAnnotationsStrategy.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsStrategy.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyAnnotation ) ;
                                                      strategy = (StrategyAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between strategy and abstractStrategy
                                                      JavaSDM.ensure ( strategy.hasInElements ("strategy", abstractStrategy) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between strategy and context
                                                      JavaSDM.ensure ( strategy.hasInElements ("context", context) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object abstractStrategy is really bound
                                                   JavaSDM.ensure ( abstractStrategy != null ) ;
                                                    
                                                   // check object context is really bound
                                                   JavaSDM.ensure ( context != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                    
                                                   // check object algorithm is really bound
                                                   JavaSDM.ensure ( algorithm != null ) ;
                                                    
                                                   // check object request is really bound
                                                   JavaSDM.ensure ( request != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                    
                                                   // check object setStrategy is really bound
                                                   JavaSDM.ensure ( setStrategy != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                    
                                                   // create object
                                                   strategy = new StrategyAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   strategy.setClassification (1);
                                                    
                                                   // create link
                                                   strategy.addToElements ("strategy", abstractStrategy);
                                                    
                                                   // create link
                                                   strategy.addToElements ("context", context);
                                                    
                                                   // create link
                                                   strategy.addToBoundObjects ("algorithm", algorithm);
                                                    
                                                   // create link
                                                   strategy.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                    
                                                   // create link
                                                   strategy.addToBoundObjects ("context", context);
                                                    
                                                   // create link
                                                   strategy.addToBoundObjects ("request", request);
                                                    
                                                   // create link
                                                   strategy.addToBoundObjects ("setStrategy", setStrategy);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object reference17 is really bound
                                                   JavaSDM.ensure ( reference17 != null ) ;
                                                    
                                                   // check object neighborCall18 is really bound
                                                   JavaSDM.ensure ( neighborCall18 != null ) ;
                                                    
                                                   // check object overridingMethod20 is really bound
                                                   JavaSDM.ensure ( overridingMethod20 != null ) ;
                                                    
                                                   // check object strategy is really bound
                                                   JavaSDM.ensure ( strategy != null ) ;
                                                    
                                                   // create link
                                                   strategy.addToAntecedentAnnos (reference17);
                                                    
                                                   // create link
                                                   strategy.addToAntecedentAnnos (neighborCall18);
                                                    
                                                   // create link
                                                   strategy.addToAntecedentAnnos (overridingMethod20);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (strategy) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategy is really bound
            JavaSDM.ensure ( strategy != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_OverridingMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategy) ;
   }


   private GFRNAnnotation annotateUsingTrigger_ReferenceRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyMethodsAlgorithm = null ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam7 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsNeighborCall6 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod8 = null ;
      Iterator fujaba__IterContextAnnotationsStrategy = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      Iterator fujaba__IterReference5ElementsAbstractStrategy = null ;
      Iterator fujaba__IterReference5ElementsContext = null ;
      NeighborCallAnnotation neighborCall6 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod8 = null ;
      ReferenceAnnotation reference5 = null ;
      StrategyAnnotation strategy = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam7 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference5 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstractStrategy: UMLClass
            fujaba__IterReference5ElementsAbstractStrategy = reference5.iteratorOfElements ("references") ;
            while ( fujaba__IterReference5ElementsAbstractStrategy.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference5ElementsAbstractStrategy.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstractStrategy = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
                   
                  // bind context: UMLClass
                  fujaba__IterReference5ElementsContext = reference5.iteratorOfElements ("referencingClass") ;
                  while ( fujaba__IterReference5ElementsContext.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReference5ElementsContext.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        context = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                         
                        // bind algorithm: UMLMethod
                        fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
                        while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
                        {
                           try
                           {
                              algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                               
                              // attribute condition
                              JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                               
                              // bind uMLParam7: UMLParam
                              fujaba__IterAbstractStrategyRevParamTypeUMLParam7 = abstractStrategy.iteratorOfRevParamType () ;
                              while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam7.hasNext () )
                              {
                                 try
                                 {
                                    uMLParam7 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam7.next () ;
                                     
                                    // bind setStrategy: UMLMethod
                                    setStrategy = uMLParam7.getRevParam () ;
                                    JavaSDM.ensure ( setStrategy != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(algorithm.equals (setStrategy)) ) ;
                                     
                                    // check To-One-Link 'parent' between setStrategy and context
                                    JavaSDM.ensure ( (setStrategy.getParent () != null) && setStrategy.getParent ().equals (context) ) ;
                                     
                                    // bind request: UMLMethod
                                    fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
                                    while ( fujaba__IterContextMethodsRequest.hasNext () )
                                    {
                                       try
                                       {
                                          request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(algorithm.equals (request)) && !(setStrategy.equals (request)) ) ;
                                           
                                          // bind neighborCall6: NeighborCallAnnotation
                                          fujaba__IterAlgorithmAnnotationsNeighborCall6 = algorithm.iteratorOfAnnotations () ;
                                          while ( fujaba__IterAlgorithmAnnotationsNeighborCall6.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsNeighborCall6.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                neighborCall6 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between neighborCall6 and algorithm
                                                JavaSDM.ensure ( neighborCall6.hasInElements ("callee", algorithm) ) ;
                                                 
                                                // check To-Many-Link 'elements' between neighborCall6 and request
                                                JavaSDM.ensure ( neighborCall6.hasInElements ("caller", request) ) ;
                                                 
                                                // bind overridingMethod8: OverridingMethodAnnotation
                                                fujaba__IterAlgorithmAnnotationsOverridingMethod8 = algorithm.iteratorOfAnnotations () ;
                                                while ( fujaba__IterAlgorithmAnnotationsOverridingMethod8.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod8.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                                      overridingMethod8 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between overridingMethod8 and algorithm
                                                      JavaSDM.ensure ( overridingMethod8.hasInElements ("overridden", algorithm) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object abstractStrategy is really bound
                                                            JavaSDM.ensure ( abstractStrategy != null ) ;
                                                             
                                                            // check object context is really bound
                                                            JavaSDM.ensure ( context != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                             
                                                            // bind strategy: StrategyAnnotation
                                                            fujaba__IterContextAnnotationsStrategy = context.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterContextAnnotationsStrategy.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterContextAnnotationsStrategy.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyAnnotation ) ;
                                                                  strategy = (StrategyAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between strategy and context
                                                                  JavaSDM.ensure ( strategy.hasInElements ("context", context) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between strategy and abstractStrategy
                                                                  JavaSDM.ensure ( strategy.hasInElements ("strategy", abstractStrategy) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object abstractStrategy is really bound
                                                               JavaSDM.ensure ( abstractStrategy != null ) ;
                                                                
                                                               // check object context is really bound
                                                               JavaSDM.ensure ( context != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                                
                                                               // check object algorithm is really bound
                                                               JavaSDM.ensure ( algorithm != null ) ;
                                                                
                                                               // check object request is really bound
                                                               JavaSDM.ensure ( request != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                                
                                                               // check object setStrategy is really bound
                                                               JavaSDM.ensure ( setStrategy != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                                
                                                               // create object
                                                               strategy = new StrategyAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               strategy.setClassification (1);
                                                                
                                                               // create link
                                                               strategy.addToElements ("strategy", abstractStrategy);
                                                                
                                                               // create link
                                                               strategy.addToElements ("context", context);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("algorithm", algorithm);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("context", context);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("request", request);
                                                                
                                                               // create link
                                                               strategy.addToBoundObjects ("setStrategy", setStrategy);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object reference5 is really bound
                                                               JavaSDM.ensure ( reference5 != null ) ;
                                                                
                                                               // check object neighborCall6 is really bound
                                                               JavaSDM.ensure ( neighborCall6 != null ) ;
                                                                
                                                               // check object overridingMethod8 is really bound
                                                               JavaSDM.ensure ( overridingMethod8 != null ) ;
                                                                
                                                               // check object strategy is really bound
                                                               JavaSDM.ensure ( strategy != null ) ;
                                                                
                                                               // create link
                                                               strategy.addToAntecedentAnnos (reference5);
                                                                
                                                               // create link
                                                               strategy.addToAntecedentAnnos (neighborCall6);
                                                                
                                                               // create link
                                                               strategy.addToAntecedentAnnos (overridingMethod8);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (strategy) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategy is really bound
            JavaSDM.ensure ( strategy != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Reference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategy) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("strategy", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("context", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof ReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof OverridingMethodAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyMethodsAlgorithm = null ;
      Iterator fujaba__IterAlgorithmAnnotationsNeighborCall21 = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      Iterator fujaba__IterContextMethodsSetStrategy = null ;
      Iterator fujaba__IterNeighborCall18ElementsRequest = null ;
      Iterator fujaba__IterNeighborCall21ElementsRequest = null ;
      Iterator fujaba__IterNeighborCall22ElementsAlgorithm = null ;
      Iterator fujaba__IterNeighborCall22ElementsRequest = null ;
      Iterator fujaba__IterOverridingMethod20ElementsAlgorithm = null ;
      Iterator fujaba__IterReference17ElementsAbstractStrategy = null ;
      Iterator fujaba__IterRequestAnnotationsNeighborCall22 = null ;
      Iterator fujaba__IterSetStrategyParamUMLParam23 = null ;
      NeighborCallAnnotation neighborCall18 = null ;
      NeighborCallAnnotation neighborCall21 = null ;
      NeighborCallAnnotation neighborCall22 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod20 = null ;
      ReferenceAnnotation reference17 = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam23 = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("Reference") || annotation.equals ("MultiReference") || annotation.equals ("ArrayReference") || annotation.equals ("SingleReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstractStrategy);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (context);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall18 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterNeighborCall18ElementsRequest = neighborCall18.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall18ElementsRequest.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall18ElementsRequest.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  request = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind context: UMLClass
                  context = request.getParent () ;
                  JavaSDM.ensure ( context != null ) ;
                   
                  {
                     //  for each flow
                     set.add (context);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod20 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterOverridingMethod20ElementsAlgorithm = overridingMethod20.iteratorOfElements ("overridden") ;
            while ( fujaba__IterOverridingMethod20ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod20ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                   
                  // bind neighborCall21: NeighborCallAnnotation
                  fujaba__IterAlgorithmAnnotationsNeighborCall21 = algorithm.iteratorOfAnnotations () ;
                  while ( fujaba__IterAlgorithmAnnotationsNeighborCall21.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsNeighborCall21.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall21 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall21 and algorithm
                        JavaSDM.ensure ( neighborCall21.hasInElements ("callee", algorithm) ) ;
                         
                        // bind request: UMLMethod
                        fujaba__IterNeighborCall21ElementsRequest = neighborCall21.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall21ElementsRequest.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall21ElementsRequest.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              request = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                               
                              // bind context: UMLClass
                              context = request.getParent () ;
                              JavaSDM.ensure ( context != null ) ;
                               
                              {
                                 //  for each flow
                                 set.add (context);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
            while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
            {
               try
               {
                  algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (algorithm);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
            while ( fujaba__IterContextMethodsRequest.hasNext () )
            {
               try
               {
                  request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                   
                  {
                     //  for each flow
                     set.add (request);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference17 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstractStrategy: UMLClass
            fujaba__IterReference17ElementsAbstractStrategy = reference17.iteratorOfElements ("references") ;
            while ( fujaba__IterReference17ElementsAbstractStrategy.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference17ElementsAbstractStrategy.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstractStrategy = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
                   
                  // bind algorithm: UMLMethod
                  fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
                  while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
                  {
                     try
                     {
                        algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                         
                        {
                           //  for each flow
                           set.add (algorithm);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod20 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterOverridingMethod20ElementsAlgorithm = overridingMethod20.iteratorOfElements ("overridden") ;
            while ( fujaba__IterOverridingMethod20ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod20ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (algorithm);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("OverridingMethod") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
            while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
            {
               try
               {
                  algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (algorithm);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
            while ( fujaba__IterContextMethodsRequest.hasNext () )
            {
               try
               {
                  request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                   
                  // bind neighborCall22: NeighborCallAnnotation
                  fujaba__IterRequestAnnotationsNeighborCall22 = request.iteratorOfAnnotations () ;
                  while ( fujaba__IterRequestAnnotationsNeighborCall22.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterRequestAnnotationsNeighborCall22.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall22 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall22 and request
                        JavaSDM.ensure ( neighborCall22.hasInElements ("caller", request) ) ;
                         
                        // bind algorithm: UMLMethod
                        fujaba__IterNeighborCall22ElementsAlgorithm = neighborCall22.iteratorOfElements ("callee") ;
                        while ( fujaba__IterNeighborCall22ElementsAlgorithm.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall22ElementsAlgorithm.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              algorithm = (UMLMethod) fujaba__TmpObject ;
                               
                              // attribute condition
                              JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(request.equals (algorithm)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (algorithm);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference17 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind abstractStrategy: UMLClass
            fujaba__IterReference17ElementsAbstractStrategy = reference17.iteratorOfElements ("references") ;
            while ( fujaba__IterReference17ElementsAbstractStrategy.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference17ElementsAbstractStrategy.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  abstractStrategy = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
                   
                  // bind algorithm: UMLMethod
                  fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
                  while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
                  {
                     try
                     {
                        algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                         
                        {
                           //  for each flow
                           set.add (algorithm);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall22 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterNeighborCall22ElementsRequest = neighborCall22.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall22ElementsRequest.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall22ElementsRequest.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  request = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind context: UMLClass
                  context = request.getParent () ;
                  JavaSDM.ensure ( context != null ) ;
                   
                  // bind setStrategy: UMLMethod
                  fujaba__IterContextMethodsSetStrategy = context.iteratorOfMethods () ;
                  while ( fujaba__IterContextMethodsSetStrategy.hasNext () )
                  {
                     try
                     {
                        setStrategy = (UMLMethod) fujaba__IterContextMethodsSetStrategy.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(request.equals (setStrategy)) ) ;
                         
                        // bind uMLParam23: UMLParam
                        fujaba__IterSetStrategyParamUMLParam23 = setStrategy.iteratorOfParam () ;
                        while ( fujaba__IterSetStrategyParamUMLParam23.hasNext () )
                        {
                           try
                           {
                              uMLParam23 = (UMLParam) fujaba__IterSetStrategyParamUMLParam23.next () ;
                               
                              // bind abstractStrategy: UMLClass
                              fujaba__TmpObject = uMLParam23.getParamType () ;
                              JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              abstractStrategy = (UMLClass) fujaba__TmpObject ;
                               
                              // attribute condition
                              JavaSDM.ensure ( (abstractStrategy.isAbstract () == true) ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(context.equals (abstractStrategy)) ) ;
                               
                              // bind algorithm: UMLMethod
                              fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
                              while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
                              {
                                 try
                                 {
                                    algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                                     
                                    // attribute condition
                                    JavaSDM.ensure ( (algorithm.isAbstract () == true) ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(request.equals (algorithm)) && !(setStrategy.equals (algorithm)) ) ;
                                     
                                    {
                                       //  for each flow
                                       set.add (algorithm);
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
