package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLClass;

public class BroadcastMediatorEngine
extends GFRNEngine
{
   private  BroadcastMediatorEngine()
   {
   }

   private static BroadcastMediatorEngine theBroadcastMediatorEngine;

   public static BroadcastMediatorEngine get()
   {
      if (theBroadcastMediatorEngine == null)
      {
         theBroadcastMediatorEngine = new BroadcastMediatorEngine ();
      }
      return theBroadcastMediatorEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation broadcastMediator = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         broadcastMediator = this.annotateUsingColleagueRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( broadcastMediator != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (broadcastMediator) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            broadcastMediator = this.annotateUsingTrigger_NeighborCallRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( broadcastMediator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (broadcastMediator) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               broadcastMediator = this.annotateUsingTrigger_OneToManyAssociationRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( broadcastMediator != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (broadcastMediator) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  broadcastMediator = this.annotateUsingMediatorRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( broadcastMediator != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (broadcastMediator) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     broadcastMediator = this.annotateUsingTrigger_NeighborCallRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (broadcastMediator) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingColleagueRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BroadcastMediatorAnnotation broadcastMediator = null ;
      Iterator fujaba__IterColleagueAnnotationsBroadcastMediator = null ;
      Iterator fujaba__IterColleagueAnnotationsOneToManyAssociation6 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod1 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod3 = null ;
      Iterator fujaba__IterNeighborCall5ElementsUMLMethod4 = null ;
      Iterator fujaba__IterNeighborCall7ElementsUMLMethod2 = null ;
      Iterator fujaba__IterOneToManyAssociation6ElementsMediator = null ;
      Iterator fujaba__IterUMLMethod1AnnotationsNeighborCall7 = null ;
      Iterator fujaba__IterUMLMethod3AnnotationsNeighborCall5 = null ;
      NeighborCallAnnotation neighborCall5 = null ;
      NeighborCallAnnotation neighborCall7 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OneToManyAssociationAnnotation oneToManyAssociation6 = null ;
      UMLClass colleague = null ;
      UMLClass mediator = null ;
      UMLMethod uMLMethod1 = null ;
      UMLMethod uMLMethod2 = null ;
      UMLMethod uMLMethod3 = null ;
      UMLMethod uMLMethod4 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("colleague", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            colleague = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
             
            // bind uMLMethod1: UMLMethod
            fujaba__IterColleagueMethodsUMLMethod1 = colleague.iteratorOfMethods () ;
            while ( fujaba__IterColleagueMethodsUMLMethod1.hasNext () )
            {
               try
               {
                  uMLMethod1 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod1.next () ;
                   
                  // bind uMLMethod3: UMLMethod
                  fujaba__IterColleagueMethodsUMLMethod3 = colleague.iteratorOfMethods () ;
                  while ( fujaba__IterColleagueMethodsUMLMethod3.hasNext () )
                  {
                     try
                     {
                        uMLMethod3 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod3.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(uMLMethod1.equals (uMLMethod3)) ) ;
                         
                        // bind oneToManyAssociation6: OneToManyAssociationAnnotation
                        fujaba__IterColleagueAnnotationsOneToManyAssociation6 = colleague.iteratorOfAnnotations () ;
                        while ( fujaba__IterColleagueAnnotationsOneToManyAssociation6.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterColleagueAnnotationsOneToManyAssociation6.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OneToManyAssociationAnnotation ) ;
                              oneToManyAssociation6 = (OneToManyAssociationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between oneToManyAssociation6 and colleague
                              JavaSDM.ensure ( oneToManyAssociation6.hasInElements ("many", colleague) ) ;
                               
                              // bind neighborCall7: NeighborCallAnnotation
                              fujaba__IterUMLMethod1AnnotationsNeighborCall7 = uMLMethod1.iteratorOfAnnotations () ;
                              while ( fujaba__IterUMLMethod1AnnotationsNeighborCall7.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterUMLMethod1AnnotationsNeighborCall7.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall7 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall7 and uMLMethod1
                                    JavaSDM.ensure ( neighborCall7.hasInElements ("caller", uMLMethod1) ) ;
                                     
                                    // bind neighborCall5: NeighborCallAnnotation
                                    fujaba__IterUMLMethod3AnnotationsNeighborCall5 = uMLMethod3.iteratorOfAnnotations () ;
                                    while ( fujaba__IterUMLMethod3AnnotationsNeighborCall5.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterUMLMethod3AnnotationsNeighborCall5.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                          neighborCall5 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between neighborCall5 and uMLMethod3
                                          JavaSDM.ensure ( neighborCall5.hasInElements ("callee", uMLMethod3) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(neighborCall7.equals (neighborCall5)) ) ;
                                           
                                          // bind mediator: UMLClass
                                          fujaba__IterOneToManyAssociation6ElementsMediator = oneToManyAssociation6.iteratorOfElements ("one") ;
                                          while ( fujaba__IterOneToManyAssociation6ElementsMediator.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterOneToManyAssociation6ElementsMediator.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                mediator = (UMLClass) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(colleague.equals (mediator)) ) ;
                                                 
                                                // bind uMLMethod2: UMLMethod
                                                fujaba__IterNeighborCall7ElementsUMLMethod2 = neighborCall7.iteratorOfElements ("callee") ;
                                                while ( fujaba__IterNeighborCall7ElementsUMLMethod2.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterNeighborCall7ElementsUMLMethod2.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      uMLMethod2 = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(uMLMethod1.equals (uMLMethod2)) && !(uMLMethod3.equals (uMLMethod2)) ) ;
                                                       
                                                      // check To-One-Link 'parent' between uMLMethod2 and mediator
                                                      JavaSDM.ensure ( (uMLMethod2.getParent () != null) && uMLMethod2.getParent ().equals (mediator) ) ;
                                                       
                                                      // bind uMLMethod4: UMLMethod
                                                      fujaba__IterNeighborCall5ElementsUMLMethod4 = neighborCall5.iteratorOfElements ("caller") ;
                                                      while ( fujaba__IterNeighborCall5ElementsUMLMethod4.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterNeighborCall5ElementsUMLMethod4.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                            uMLMethod4 = (UMLMethod) fujaba__TmpObject ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(uMLMethod1.equals (uMLMethod4)) && !(uMLMethod2.equals (uMLMethod4)) && !(uMLMethod3.equals (uMLMethod4)) ) ;
                                                             
                                                            // check To-One-Link 'parent' between uMLMethod4 and mediator
                                                            JavaSDM.ensure ( (uMLMethod4.getParent () != null) && uMLMethod4.getParent ().equals (mediator) ) ;
                                                             
                                                            {
                                                               //  for each flow
                                                               try
                                                               {
                                                                  fujaba__Success = false ;
                                                                   
                                                                  // check object mediator is really bound
                                                                  JavaSDM.ensure ( mediator != null ) ;
                                                                   
                                                                  // check object colleague is really bound
                                                                  JavaSDM.ensure ( colleague != null ) ;
                                                                   
                                                                  // check isomorphic binding
                                                                  JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                                   
                                                                  // bind broadcastMediator: BroadcastMediatorAnnotation
                                                                  fujaba__IterColleagueAnnotationsBroadcastMediator = colleague.iteratorOfAnnotations () ;
                                                                  while ( !(fujaba__Success) && fujaba__IterColleagueAnnotationsBroadcastMediator.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        fujaba__TmpObject = fujaba__IterColleagueAnnotationsBroadcastMediator.next () ;
                                                                        JavaSDM.ensure ( fujaba__TmpObject instanceof BroadcastMediatorAnnotation ) ;
                                                                        broadcastMediator = (BroadcastMediatorAnnotation) fujaba__TmpObject ;
                                                                         
                                                                        // check Reverse-Qualified-Link 'elements' between broadcastMediator and colleague
                                                                        JavaSDM.ensure ( broadcastMediator.hasInElements ("colleague", colleague) ) ;
                                                                         
                                                                        // check To-Many-Link 'elements' between broadcastMediator and mediator
                                                                        JavaSDM.ensure ( broadcastMediator.hasInElements ("mediator", mediator) ) ;
                                                                         
                                                                        fujaba__Success = true ;
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                                  fujaba__Success = false ;
                                                               }
                                                                
                                                               if ( !(fujaba__Success) )
                                                               {
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object mediator is really bound
                                                                     JavaSDM.ensure ( mediator != null ) ;
                                                                      
                                                                     // check object colleague is really bound
                                                                     JavaSDM.ensure ( colleague != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                                      
                                                                     // create object
                                                                     broadcastMediator = new BroadcastMediatorAnnotation ( ) ;
                                                                      
                                                                     // assign statement
                                                                     broadcastMediator.setClassification (1);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToElements ("mediator", mediator);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToElements ("colleague", colleague);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToBoundObjects ("colleague", colleague);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToBoundObjects ("mediator", mediator);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object neighborCall5 is really bound
                                                                     JavaSDM.ensure ( neighborCall5 != null ) ;
                                                                      
                                                                     // check object oneToManyAssociation6 is really bound
                                                                     JavaSDM.ensure ( oneToManyAssociation6 != null ) ;
                                                                      
                                                                     // check object neighborCall7 is really bound
                                                                     JavaSDM.ensure ( neighborCall7 != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(neighborCall5.equals (neighborCall7)) ) ;
                                                                      
                                                                     // check object broadcastMediator is really bound
                                                                     JavaSDM.ensure ( broadcastMediator != null ) ;
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (neighborCall5);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (oneToManyAssociation6);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (neighborCall7);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  return (broadcastMediator) ;
                                                               }
                                                            } //  end for each flow
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object broadcastMediator is really bound
            JavaSDM.ensure ( broadcastMediator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("colleague", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (broadcastMediator) ;
   }


   private GFRNAnnotation annotateUsingMediatorRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BroadcastMediatorAnnotation broadcastMediator = null ;
      Iterator fujaba__IterMediatorAnnotationsBroadcastMediator = null ;
      Iterator fujaba__IterMediatorAnnotationsOneToManyAssociation27 = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod23 = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod25 = null ;
      Iterator fujaba__IterNeighborCall26ElementsUMLMethod24 = null ;
      Iterator fujaba__IterNeighborCall28ElementsUMLMethod22 = null ;
      Iterator fujaba__IterOneToManyAssociation27ElementsColleague = null ;
      Iterator fujaba__IterUMLMethod23AnnotationsNeighborCall28 = null ;
      Iterator fujaba__IterUMLMethod25AnnotationsNeighborCall26 = null ;
      NeighborCallAnnotation neighborCall26 = null ;
      NeighborCallAnnotation neighborCall28 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OneToManyAssociationAnnotation oneToManyAssociation27 = null ;
      UMLClass colleague = null ;
      UMLClass mediator = null ;
      UMLMethod uMLMethod22 = null ;
      UMLMethod uMLMethod23 = null ;
      UMLMethod uMLMethod24 = null ;
      UMLMethod uMLMethod25 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("mediator", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            mediator = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod23: UMLMethod
            fujaba__IterMediatorMethodsUMLMethod23 = mediator.iteratorOfMethods () ;
            while ( fujaba__IterMediatorMethodsUMLMethod23.hasNext () )
            {
               try
               {
                  uMLMethod23 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod23.next () ;
                   
                  // bind uMLMethod25: UMLMethod
                  fujaba__IterMediatorMethodsUMLMethod25 = mediator.iteratorOfMethods () ;
                  while ( fujaba__IterMediatorMethodsUMLMethod25.hasNext () )
                  {
                     try
                     {
                        uMLMethod25 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod25.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(uMLMethod23.equals (uMLMethod25)) ) ;
                         
                        // bind oneToManyAssociation27: OneToManyAssociationAnnotation
                        fujaba__IterMediatorAnnotationsOneToManyAssociation27 = mediator.iteratorOfAnnotations () ;
                        while ( fujaba__IterMediatorAnnotationsOneToManyAssociation27.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterMediatorAnnotationsOneToManyAssociation27.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OneToManyAssociationAnnotation ) ;
                              oneToManyAssociation27 = (OneToManyAssociationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between oneToManyAssociation27 and mediator
                              JavaSDM.ensure ( oneToManyAssociation27.hasInElements ("one", mediator) ) ;
                               
                              // bind neighborCall28: NeighborCallAnnotation
                              fujaba__IterUMLMethod23AnnotationsNeighborCall28 = uMLMethod23.iteratorOfAnnotations () ;
                              while ( fujaba__IterUMLMethod23AnnotationsNeighborCall28.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterUMLMethod23AnnotationsNeighborCall28.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall28 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall28 and uMLMethod23
                                    JavaSDM.ensure ( neighborCall28.hasInElements ("callee", uMLMethod23) ) ;
                                     
                                    // bind neighborCall26: NeighborCallAnnotation
                                    fujaba__IterUMLMethod25AnnotationsNeighborCall26 = uMLMethod25.iteratorOfAnnotations () ;
                                    while ( fujaba__IterUMLMethod25AnnotationsNeighborCall26.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterUMLMethod25AnnotationsNeighborCall26.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                          neighborCall26 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between neighborCall26 and uMLMethod25
                                          JavaSDM.ensure ( neighborCall26.hasInElements ("caller", uMLMethod25) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(neighborCall28.equals (neighborCall26)) ) ;
                                           
                                          // bind colleague: UMLClass
                                          fujaba__IterOneToManyAssociation27ElementsColleague = oneToManyAssociation27.iteratorOfElements ("many") ;
                                          while ( fujaba__IterOneToManyAssociation27ElementsColleague.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterOneToManyAssociation27ElementsColleague.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                colleague = (UMLClass) fujaba__TmpObject ;
                                                 
                                                // attribute condition
                                                JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                 
                                                // bind uMLMethod22: UMLMethod
                                                fujaba__IterNeighborCall28ElementsUMLMethod22 = neighborCall28.iteratorOfElements ("caller") ;
                                                while ( fujaba__IterNeighborCall28ElementsUMLMethod22.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterNeighborCall28ElementsUMLMethod22.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      uMLMethod22 = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(uMLMethod23.equals (uMLMethod22)) && !(uMLMethod25.equals (uMLMethod22)) ) ;
                                                       
                                                      // check To-One-Link 'parent' between uMLMethod22 and colleague
                                                      JavaSDM.ensure ( (uMLMethod22.getParent () != null) && uMLMethod22.getParent ().equals (colleague) ) ;
                                                       
                                                      // bind uMLMethod24: UMLMethod
                                                      fujaba__IterNeighborCall26ElementsUMLMethod24 = neighborCall26.iteratorOfElements ("callee") ;
                                                      while ( fujaba__IterNeighborCall26ElementsUMLMethod24.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterNeighborCall26ElementsUMLMethod24.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                            uMLMethod24 = (UMLMethod) fujaba__TmpObject ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(uMLMethod22.equals (uMLMethod24)) && !(uMLMethod23.equals (uMLMethod24)) && !(uMLMethod25.equals (uMLMethod24)) ) ;
                                                             
                                                            // check To-One-Link 'parent' between uMLMethod24 and colleague
                                                            JavaSDM.ensure ( (uMLMethod24.getParent () != null) && uMLMethod24.getParent ().equals (colleague) ) ;
                                                             
                                                            {
                                                               //  for each flow
                                                               try
                                                               {
                                                                  fujaba__Success = false ;
                                                                   
                                                                  // check object mediator is really bound
                                                                  JavaSDM.ensure ( mediator != null ) ;
                                                                   
                                                                  // check object colleague is really bound
                                                                  JavaSDM.ensure ( colleague != null ) ;
                                                                   
                                                                  // check isomorphic binding
                                                                  JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                                   
                                                                  // bind broadcastMediator: BroadcastMediatorAnnotation
                                                                  fujaba__IterMediatorAnnotationsBroadcastMediator = mediator.iteratorOfAnnotations () ;
                                                                  while ( !(fujaba__Success) && fujaba__IterMediatorAnnotationsBroadcastMediator.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        fujaba__TmpObject = fujaba__IterMediatorAnnotationsBroadcastMediator.next () ;
                                                                        JavaSDM.ensure ( fujaba__TmpObject instanceof BroadcastMediatorAnnotation ) ;
                                                                        broadcastMediator = (BroadcastMediatorAnnotation) fujaba__TmpObject ;
                                                                         
                                                                        // check Reverse-Qualified-Link 'elements' between broadcastMediator and mediator
                                                                        JavaSDM.ensure ( broadcastMediator.hasInElements ("mediator", mediator) ) ;
                                                                         
                                                                        // check To-Many-Link 'elements' between broadcastMediator and colleague
                                                                        JavaSDM.ensure ( broadcastMediator.hasInElements ("colleague", colleague) ) ;
                                                                         
                                                                        fujaba__Success = true ;
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                                  fujaba__Success = false ;
                                                               }
                                                                
                                                               if ( !(fujaba__Success) )
                                                               {
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object mediator is really bound
                                                                     JavaSDM.ensure ( mediator != null ) ;
                                                                      
                                                                     // check object colleague is really bound
                                                                     JavaSDM.ensure ( colleague != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                                      
                                                                     // create object
                                                                     broadcastMediator = new BroadcastMediatorAnnotation ( ) ;
                                                                      
                                                                     // assign statement
                                                                     broadcastMediator.setClassification (1);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToElements ("mediator", mediator);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToElements ("colleague", colleague);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToBoundObjects ("colleague", colleague);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToBoundObjects ("mediator", mediator);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object neighborCall26 is really bound
                                                                     JavaSDM.ensure ( neighborCall26 != null ) ;
                                                                      
                                                                     // check object oneToManyAssociation27 is really bound
                                                                     JavaSDM.ensure ( oneToManyAssociation27 != null ) ;
                                                                      
                                                                     // check object neighborCall28 is really bound
                                                                     JavaSDM.ensure ( neighborCall28 != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(neighborCall26.equals (neighborCall28)) ) ;
                                                                      
                                                                     // check object broadcastMediator is really bound
                                                                     JavaSDM.ensure ( broadcastMediator != null ) ;
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (neighborCall26);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (oneToManyAssociation27);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (neighborCall28);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  return (broadcastMediator) ;
                                                               }
                                                            } //  end for each flow
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object broadcastMediator is really bound
            JavaSDM.ensure ( broadcastMediator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("mediator", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (broadcastMediator) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BroadcastMediatorAnnotation broadcastMediator = null ;
      Iterator fujaba__IterColleagueAnnotationsOneToManyAssociation13 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod8 = null ;
      Iterator fujaba__IterMediatorAnnotationsBroadcastMediator = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod9 = null ;
      Iterator fujaba__IterNeighborCall12ElementsUMLMethod10 = null ;
      Iterator fujaba__IterNeighborCall12ElementsUMLMethod11 = null ;
      Iterator fujaba__IterUMLMethod8AnnotationsNeighborCall14 = null ;
      NeighborCallAnnotation neighborCall12 = null ;
      NeighborCallAnnotation neighborCall14 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OneToManyAssociationAnnotation oneToManyAssociation13 = null ;
      UMLClass colleague = null ;
      UMLClass mediator = null ;
      UMLMethod uMLMethod10 = null ;
      UMLMethod uMLMethod11 = null ;
      UMLMethod uMLMethod8 = null ;
      UMLMethod uMLMethod9 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall12 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod10: UMLMethod
            fujaba__IterNeighborCall12ElementsUMLMethod10 = neighborCall12.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall12ElementsUMLMethod10.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall12ElementsUMLMethod10.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  uMLMethod10 = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind colleague: UMLClass
                  colleague = uMLMethod10.getParent () ;
                  JavaSDM.ensure ( colleague != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  // bind uMLMethod11: UMLMethod
                  fujaba__IterNeighborCall12ElementsUMLMethod11 = neighborCall12.iteratorOfElements ("caller") ;
                  while ( fujaba__IterNeighborCall12ElementsUMLMethod11.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNeighborCall12ElementsUMLMethod11.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        uMLMethod11 = (UMLMethod) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(uMLMethod10.equals (uMLMethod11)) ) ;
                         
                        // bind mediator: UMLClass
                        mediator = uMLMethod11.getParent () ;
                        JavaSDM.ensure ( mediator != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(colleague.equals (mediator)) ) ;
                         
                        // bind uMLMethod8: UMLMethod
                        fujaba__IterColleagueMethodsUMLMethod8 = colleague.iteratorOfMethods () ;
                        while ( fujaba__IterColleagueMethodsUMLMethod8.hasNext () )
                        {
                           try
                           {
                              uMLMethod8 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod8.next () ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(uMLMethod10.equals (uMLMethod8)) && !(uMLMethod11.equals (uMLMethod8)) ) ;
                               
                              // bind oneToManyAssociation13: OneToManyAssociationAnnotation
                              fujaba__IterColleagueAnnotationsOneToManyAssociation13 = colleague.iteratorOfAnnotations () ;
                              while ( fujaba__IterColleagueAnnotationsOneToManyAssociation13.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterColleagueAnnotationsOneToManyAssociation13.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof OneToManyAssociationAnnotation ) ;
                                    oneToManyAssociation13 = (OneToManyAssociationAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between oneToManyAssociation13 and colleague
                                    JavaSDM.ensure ( oneToManyAssociation13.hasInElements ("many", colleague) ) ;
                                     
                                    // check To-Many-Link 'elements' between oneToManyAssociation13 and mediator
                                    JavaSDM.ensure ( oneToManyAssociation13.hasInElements ("one", mediator) ) ;
                                     
                                    // bind uMLMethod9: UMLMethod
                                    fujaba__IterMediatorMethodsUMLMethod9 = mediator.iteratorOfMethods () ;
                                    while ( fujaba__IterMediatorMethodsUMLMethod9.hasNext () )
                                    {
                                       try
                                       {
                                          uMLMethod9 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod9.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(uMLMethod8.equals (uMLMethod9)) && !(uMLMethod10.equals (uMLMethod9)) && !(uMLMethod11.equals (uMLMethod9)) ) ;
                                           
                                          // bind neighborCall14: NeighborCallAnnotation
                                          fujaba__IterUMLMethod8AnnotationsNeighborCall14 = uMLMethod8.iteratorOfAnnotations () ;
                                          while ( fujaba__IterUMLMethod8AnnotationsNeighborCall14.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterUMLMethod8AnnotationsNeighborCall14.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                neighborCall14 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between neighborCall14 and uMLMethod8
                                                JavaSDM.ensure ( neighborCall14.hasInElements ("caller", uMLMethod8) ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(neighborCall12.equals (neighborCall14)) ) ;
                                                 
                                                // check To-Many-Link 'elements' between neighborCall14 and uMLMethod9
                                                JavaSDM.ensure ( neighborCall14.hasInElements ("callee", uMLMethod9) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object mediator is really bound
                                                      JavaSDM.ensure ( mediator != null ) ;
                                                       
                                                      // check object colleague is really bound
                                                      JavaSDM.ensure ( colleague != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                       
                                                      // bind broadcastMediator: BroadcastMediatorAnnotation
                                                      fujaba__IterMediatorAnnotationsBroadcastMediator = mediator.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterMediatorAnnotationsBroadcastMediator.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterMediatorAnnotationsBroadcastMediator.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof BroadcastMediatorAnnotation ) ;
                                                            broadcastMediator = (BroadcastMediatorAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between broadcastMediator and mediator
                                                            JavaSDM.ensure ( broadcastMediator.hasInElements ("mediator", mediator) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between broadcastMediator and colleague
                                                            JavaSDM.ensure ( broadcastMediator.hasInElements ("colleague", colleague) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object mediator is really bound
                                                         JavaSDM.ensure ( mediator != null ) ;
                                                          
                                                         // check object colleague is really bound
                                                         JavaSDM.ensure ( colleague != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                          
                                                         // create object
                                                         broadcastMediator = new BroadcastMediatorAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         broadcastMediator.setClassification (1);
                                                          
                                                         // create link
                                                         broadcastMediator.addToElements ("mediator", mediator);
                                                          
                                                         // create link
                                                         broadcastMediator.addToElements ("colleague", colleague);
                                                          
                                                         // create link
                                                         broadcastMediator.addToBoundObjects ("colleague", colleague);
                                                          
                                                         // create link
                                                         broadcastMediator.addToBoundObjects ("mediator", mediator);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object neighborCall12 is really bound
                                                         JavaSDM.ensure ( neighborCall12 != null ) ;
                                                          
                                                         // check object oneToManyAssociation13 is really bound
                                                         JavaSDM.ensure ( oneToManyAssociation13 != null ) ;
                                                          
                                                         // check object neighborCall14 is really bound
                                                         JavaSDM.ensure ( neighborCall14 != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(neighborCall12.equals (neighborCall14)) ) ;
                                                          
                                                         // check object broadcastMediator is really bound
                                                         JavaSDM.ensure ( broadcastMediator != null ) ;
                                                          
                                                         // create link
                                                         broadcastMediator.addToAntecedentAnnos (neighborCall12);
                                                          
                                                         // create link
                                                         broadcastMediator.addToAntecedentAnnos (oneToManyAssociation13);
                                                          
                                                         // create link
                                                         broadcastMediator.addToAntecedentAnnos (neighborCall14);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (broadcastMediator) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object broadcastMediator is really bound
            JavaSDM.ensure ( broadcastMediator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (broadcastMediator) ;
   }


   private GFRNAnnotation annotateUsingTrigger_OneToManyAssociationRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      BroadcastMediatorAnnotation broadcastMediator = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod15 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod17 = null ;
      Iterator fujaba__IterMediatorAnnotationsBroadcastMediator = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod16 = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod18 = null ;
      Iterator fujaba__IterOneToManyAssociation20ElementsColleague = null ;
      Iterator fujaba__IterOneToManyAssociation20ElementsMediator = null ;
      Iterator fujaba__IterUMLMethod15AnnotationsNeighborCall21 = null ;
      Iterator fujaba__IterUMLMethod17AnnotationsNeighborCall19 = null ;
      NeighborCallAnnotation neighborCall19 = null ;
      NeighborCallAnnotation neighborCall21 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OneToManyAssociationAnnotation oneToManyAssociation20 = null ;
      UMLClass colleague = null ;
      UMLClass mediator = null ;
      UMLMethod uMLMethod15 = null ;
      UMLMethod uMLMethod16 = null ;
      UMLMethod uMLMethod17 = null ;
      UMLMethod uMLMethod18 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OneToManyAssociation", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OneToManyAssociationAnnotation ) ;
             
            // explicit type cast
            oneToManyAssociation20 = (OneToManyAssociationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind colleague: UMLClass
            fujaba__IterOneToManyAssociation20ElementsColleague = oneToManyAssociation20.iteratorOfElements ("many") ;
            while ( fujaba__IterOneToManyAssociation20ElementsColleague.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOneToManyAssociation20ElementsColleague.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  colleague = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  // bind mediator: UMLClass
                  fujaba__IterOneToManyAssociation20ElementsMediator = oneToManyAssociation20.iteratorOfElements ("one") ;
                  while ( fujaba__IterOneToManyAssociation20ElementsMediator.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOneToManyAssociation20ElementsMediator.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        mediator = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(colleague.equals (mediator)) ) ;
                         
                        // bind uMLMethod15: UMLMethod
                        fujaba__IterColleagueMethodsUMLMethod15 = colleague.iteratorOfMethods () ;
                        while ( fujaba__IterColleagueMethodsUMLMethod15.hasNext () )
                        {
                           try
                           {
                              uMLMethod15 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod15.next () ;
                               
                              // bind uMLMethod17: UMLMethod
                              fujaba__IterColleagueMethodsUMLMethod17 = colleague.iteratorOfMethods () ;
                              while ( fujaba__IterColleagueMethodsUMLMethod17.hasNext () )
                              {
                                 try
                                 {
                                    uMLMethod17 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod17.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(uMLMethod15.equals (uMLMethod17)) ) ;
                                     
                                    // bind uMLMethod16: UMLMethod
                                    fujaba__IterMediatorMethodsUMLMethod16 = mediator.iteratorOfMethods () ;
                                    while ( fujaba__IterMediatorMethodsUMLMethod16.hasNext () )
                                    {
                                       try
                                       {
                                          uMLMethod16 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod16.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(uMLMethod15.equals (uMLMethod16)) && !(uMLMethod17.equals (uMLMethod16)) ) ;
                                           
                                          // bind uMLMethod18: UMLMethod
                                          fujaba__IterMediatorMethodsUMLMethod18 = mediator.iteratorOfMethods () ;
                                          while ( fujaba__IterMediatorMethodsUMLMethod18.hasNext () )
                                          {
                                             try
                                             {
                                                uMLMethod18 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod18.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(uMLMethod15.equals (uMLMethod18)) && !(uMLMethod16.equals (uMLMethod18)) && !(uMLMethod17.equals (uMLMethod18)) ) ;
                                                 
                                                // bind neighborCall21: NeighborCallAnnotation
                                                fujaba__IterUMLMethod15AnnotationsNeighborCall21 = uMLMethod15.iteratorOfAnnotations () ;
                                                while ( fujaba__IterUMLMethod15AnnotationsNeighborCall21.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterUMLMethod15AnnotationsNeighborCall21.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                      neighborCall21 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between neighborCall21 and uMLMethod15
                                                      JavaSDM.ensure ( neighborCall21.hasInElements ("caller", uMLMethod15) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between neighborCall21 and uMLMethod16
                                                      JavaSDM.ensure ( neighborCall21.hasInElements ("callee", uMLMethod16) ) ;
                                                       
                                                      // bind neighborCall19: NeighborCallAnnotation
                                                      fujaba__IterUMLMethod17AnnotationsNeighborCall19 = uMLMethod17.iteratorOfAnnotations () ;
                                                      while ( fujaba__IterUMLMethod17AnnotationsNeighborCall19.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterUMLMethod17AnnotationsNeighborCall19.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                            neighborCall19 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between neighborCall19 and uMLMethod17
                                                            JavaSDM.ensure ( neighborCall19.hasInElements ("callee", uMLMethod17) ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(neighborCall21.equals (neighborCall19)) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between neighborCall19 and uMLMethod18
                                                            JavaSDM.ensure ( neighborCall19.hasInElements ("caller", uMLMethod18) ) ;
                                                             
                                                            {
                                                               //  for each flow
                                                               try
                                                               {
                                                                  fujaba__Success = false ;
                                                                   
                                                                  // check object mediator is really bound
                                                                  JavaSDM.ensure ( mediator != null ) ;
                                                                   
                                                                  // check object colleague is really bound
                                                                  JavaSDM.ensure ( colleague != null ) ;
                                                                   
                                                                  // check isomorphic binding
                                                                  JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                                   
                                                                  // bind broadcastMediator: BroadcastMediatorAnnotation
                                                                  fujaba__IterMediatorAnnotationsBroadcastMediator = mediator.iteratorOfAnnotations () ;
                                                                  while ( !(fujaba__Success) && fujaba__IterMediatorAnnotationsBroadcastMediator.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        fujaba__TmpObject = fujaba__IterMediatorAnnotationsBroadcastMediator.next () ;
                                                                        JavaSDM.ensure ( fujaba__TmpObject instanceof BroadcastMediatorAnnotation ) ;
                                                                        broadcastMediator = (BroadcastMediatorAnnotation) fujaba__TmpObject ;
                                                                         
                                                                        // check Reverse-Qualified-Link 'elements' between broadcastMediator and mediator
                                                                        JavaSDM.ensure ( broadcastMediator.hasInElements ("mediator", mediator) ) ;
                                                                         
                                                                        // check To-Many-Link 'elements' between broadcastMediator and colleague
                                                                        JavaSDM.ensure ( broadcastMediator.hasInElements ("colleague", colleague) ) ;
                                                                         
                                                                        fujaba__Success = true ;
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                                  fujaba__Success = false ;
                                                               }
                                                                
                                                               if ( !(fujaba__Success) )
                                                               {
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object mediator is really bound
                                                                     JavaSDM.ensure ( mediator != null ) ;
                                                                      
                                                                     // check object colleague is really bound
                                                                     JavaSDM.ensure ( colleague != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                                                                      
                                                                     // create object
                                                                     broadcastMediator = new BroadcastMediatorAnnotation ( ) ;
                                                                      
                                                                     // assign statement
                                                                     broadcastMediator.setClassification (1);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToElements ("mediator", mediator);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToElements ("colleague", colleague);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToBoundObjects ("colleague", colleague);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToBoundObjects ("mediator", mediator);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object neighborCall19 is really bound
                                                                     JavaSDM.ensure ( neighborCall19 != null ) ;
                                                                      
                                                                     // check object oneToManyAssociation20 is really bound
                                                                     JavaSDM.ensure ( oneToManyAssociation20 != null ) ;
                                                                      
                                                                     // check object neighborCall21 is really bound
                                                                     JavaSDM.ensure ( neighborCall21 != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(neighborCall19.equals (neighborCall21)) ) ;
                                                                      
                                                                     // check object broadcastMediator is really bound
                                                                     JavaSDM.ensure ( broadcastMediator != null ) ;
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (neighborCall19);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (oneToManyAssociation20);
                                                                      
                                                                     // create link
                                                                     broadcastMediator.addToAntecedentAnnos (neighborCall21);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  return (broadcastMediator) ;
                                                               }
                                                            } //  end for each flow
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object broadcastMediator is really bound
            JavaSDM.ensure ( broadcastMediator != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_OneToManyAssociation", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (broadcastMediator) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("mediator", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("colleague", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof OneToManyAssociationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OneToManyAssociation", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterColleagueMethodsUMLMethod39 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod40 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod44 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod49 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod53 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod55 = null ;
      Iterator fujaba__IterColleagueMethodsUMLMethod56 = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod36 = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod43 = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod47 = null ;
      Iterator fujaba__IterMediatorMethodsUMLMethod52 = null ;
      Iterator fujaba__IterNeighborCall33ElementsUMLMethod50 = null ;
      Iterator fujaba__IterNeighborCall33ElementsUMLMethod54 = null ;
      Iterator fujaba__IterNeighborCall37ElementsUMLMethod38 = null ;
      Iterator fujaba__IterNeighborCall41ElementsUMLMethod42 = null ;
      Iterator fujaba__IterNeighborCall45ElementsUMLMethod46 = null ;
      Iterator fujaba__IterNeighborCall45ElementsUMLMethod48 = null ;
      Iterator fujaba__IterNeighborCall45ElementsUMLMethod51 = null ;
      Iterator fujaba__IterOneToManyAssociation34ElementsColleague = null ;
      Iterator fujaba__IterUMLMethod36AnnotationsNeighborCall37 = null ;
      Iterator fujaba__IterUMLMethod40AnnotationsNeighborCall41 = null ;
      Iterator fujaba__IterUMLMethod44AnnotationsNeighborCall45 = null ;
      NeighborCallAnnotation neighborCall33 = null ;
      NeighborCallAnnotation neighborCall37 = null ;
      NeighborCallAnnotation neighborCall41 = null ;
      NeighborCallAnnotation neighborCall45 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OneToManyAssociationAnnotation oneToManyAssociation34 = null ;
      UMLClass colleague = null ;
      UMLClass mediator = null ;
      UMLMethod uMLMethod36 = null ;
      UMLMethod uMLMethod38 = null ;
      UMLMethod uMLMethod39 = null ;
      UMLMethod uMLMethod40 = null ;
      UMLMethod uMLMethod42 = null ;
      UMLMethod uMLMethod43 = null ;
      UMLMethod uMLMethod44 = null ;
      UMLMethod uMLMethod46 = null ;
      UMLMethod uMLMethod47 = null ;
      UMLMethod uMLMethod48 = null ;
      UMLMethod uMLMethod49 = null ;
      UMLMethod uMLMethod50 = null ;
      UMLMethod uMLMethod51 = null ;
      UMLMethod uMLMethod52 = null ;
      UMLMethod uMLMethod53 = null ;
      UMLMethod uMLMethod54 = null ;
      UMLMethod uMLMethod55 = null ;
      UMLMethod uMLMethod56 = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            mediator = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod36: UMLMethod
            fujaba__IterMediatorMethodsUMLMethod36 = mediator.iteratorOfMethods () ;
            while ( fujaba__IterMediatorMethodsUMLMethod36.hasNext () )
            {
               try
               {
                  uMLMethod36 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod36.next () ;
                   
                  // bind neighborCall37: NeighborCallAnnotation
                  fujaba__IterUMLMethod36AnnotationsNeighborCall37 = uMLMethod36.iteratorOfAnnotations () ;
                  while ( fujaba__IterUMLMethod36AnnotationsNeighborCall37.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterUMLMethod36AnnotationsNeighborCall37.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall37 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall37 and uMLMethod36
                        JavaSDM.ensure ( neighborCall37.hasInElements ("callee", uMLMethod36) ) ;
                         
                        // bind uMLMethod38: UMLMethod
                        fujaba__IterNeighborCall37ElementsUMLMethod38 = neighborCall37.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall37ElementsUMLMethod38.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall37ElementsUMLMethod38.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              uMLMethod38 = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(uMLMethod36.equals (uMLMethod38)) ) ;
                               
                              // bind colleague: UMLClass
                              colleague = uMLMethod38.getParent () ;
                              JavaSDM.ensure ( colleague != null ) ;
                               
                              // attribute condition
                              JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(mediator.equals (colleague)) ) ;
                               
                              // bind uMLMethod39: UMLMethod
                              fujaba__IterColleagueMethodsUMLMethod39 = colleague.iteratorOfMethods () ;
                              while ( fujaba__IterColleagueMethodsUMLMethod39.hasNext () )
                              {
                                 try
                                 {
                                    uMLMethod39 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod39.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(uMLMethod36.equals (uMLMethod39)) && !(uMLMethod38.equals (uMLMethod39)) ) ;
                                     
                                    {
                                       //  for each flow
                                       set.add (uMLMethod39);
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            colleague = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod40: UMLMethod
            fujaba__IterColleagueMethodsUMLMethod40 = colleague.iteratorOfMethods () ;
            while ( fujaba__IterColleagueMethodsUMLMethod40.hasNext () )
            {
               try
               {
                  uMLMethod40 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod40.next () ;
                   
                  // bind neighborCall41: NeighborCallAnnotation
                  fujaba__IterUMLMethod40AnnotationsNeighborCall41 = uMLMethod40.iteratorOfAnnotations () ;
                  while ( fujaba__IterUMLMethod40AnnotationsNeighborCall41.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterUMLMethod40AnnotationsNeighborCall41.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall41 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall41 and uMLMethod40
                        JavaSDM.ensure ( neighborCall41.hasInElements ("caller", uMLMethod40) ) ;
                         
                        // bind uMLMethod42: UMLMethod
                        fujaba__IterNeighborCall41ElementsUMLMethod42 = neighborCall41.iteratorOfElements ("callee") ;
                        while ( fujaba__IterNeighborCall41ElementsUMLMethod42.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall41ElementsUMLMethod42.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              uMLMethod42 = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(uMLMethod40.equals (uMLMethod42)) ) ;
                               
                              // bind mediator: UMLClass
                              mediator = uMLMethod42.getParent () ;
                              JavaSDM.ensure ( mediator != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(colleague.equals (mediator)) ) ;
                               
                              // bind uMLMethod43: UMLMethod
                              fujaba__IterMediatorMethodsUMLMethod43 = mediator.iteratorOfMethods () ;
                              while ( fujaba__IterMediatorMethodsUMLMethod43.hasNext () )
                              {
                                 try
                                 {
                                    uMLMethod43 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod43.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(uMLMethod40.equals (uMLMethod43)) && !(uMLMethod42.equals (uMLMethod43)) ) ;
                                     
                                    {
                                       //  for each flow
                                       set.add (uMLMethod43);
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OneToManyAssociationAnnotation ) ;
             
            // explicit type cast
            oneToManyAssociation34 = (OneToManyAssociationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind colleague: UMLClass
            fujaba__IterOneToManyAssociation34ElementsColleague = oneToManyAssociation34.iteratorOfElements ("many") ;
            while ( fujaba__IterOneToManyAssociation34ElementsColleague.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOneToManyAssociation34ElementsColleague.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  colleague = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  // bind uMLMethod44: UMLMethod
                  fujaba__IterColleagueMethodsUMLMethod44 = colleague.iteratorOfMethods () ;
                  while ( fujaba__IterColleagueMethodsUMLMethod44.hasNext () )
                  {
                     try
                     {
                        uMLMethod44 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod44.next () ;
                         
                        // bind neighborCall45: NeighborCallAnnotation
                        fujaba__IterUMLMethod44AnnotationsNeighborCall45 = uMLMethod44.iteratorOfAnnotations () ;
                        while ( fujaba__IterUMLMethod44AnnotationsNeighborCall45.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterUMLMethod44AnnotationsNeighborCall45.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                              neighborCall45 = (NeighborCallAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between neighborCall45 and uMLMethod44
                              JavaSDM.ensure ( neighborCall45.hasInElements ("caller", uMLMethod44) ) ;
                               
                              // bind uMLMethod46: UMLMethod
                              fujaba__IterNeighborCall45ElementsUMLMethod46 = neighborCall45.iteratorOfElements ("callee") ;
                              while ( fujaba__IterNeighborCall45ElementsUMLMethod46.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterNeighborCall45ElementsUMLMethod46.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    uMLMethod46 = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(uMLMethod44.equals (uMLMethod46)) ) ;
                                     
                                    // bind mediator: UMLClass
                                    mediator = uMLMethod46.getParent () ;
                                    JavaSDM.ensure ( mediator != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(colleague.equals (mediator)) ) ;
                                     
                                    // bind uMLMethod47: UMLMethod
                                    fujaba__IterMediatorMethodsUMLMethod47 = mediator.iteratorOfMethods () ;
                                    while ( fujaba__IterMediatorMethodsUMLMethod47.hasNext () )
                                    {
                                       try
                                       {
                                          uMLMethod47 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod47.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(uMLMethod44.equals (uMLMethod47)) && !(uMLMethod46.equals (uMLMethod47)) ) ;
                                           
                                          {
                                             //  for each flow
                                             set.add (uMLMethod47);
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall45 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod48: UMLMethod
            fujaba__IterNeighborCall45ElementsUMLMethod48 = neighborCall45.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall45ElementsUMLMethod48.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall45ElementsUMLMethod48.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  uMLMethod48 = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind colleague: UMLClass
                  colleague = uMLMethod48.getParent () ;
                  JavaSDM.ensure ( colleague != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  // bind uMLMethod49: UMLMethod
                  fujaba__IterColleagueMethodsUMLMethod49 = colleague.iteratorOfMethods () ;
                  while ( fujaba__IterColleagueMethodsUMLMethod49.hasNext () )
                  {
                     try
                     {
                        uMLMethod49 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod49.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(uMLMethod48.equals (uMLMethod49)) ) ;
                         
                        {
                           //  for each flow
                           set.add (uMLMethod49);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("OneToManyAssociation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            mediator = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (mediator);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            colleague = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (colleague);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall33 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod50: UMLMethod
            fujaba__IterNeighborCall33ElementsUMLMethod50 = neighborCall33.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall33ElementsUMLMethod50.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall33ElementsUMLMethod50.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  uMLMethod50 = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind colleague: UMLClass
                  colleague = uMLMethod50.getParent () ;
                  JavaSDM.ensure ( colleague != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (colleague);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall45 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod51: UMLMethod
            fujaba__IterNeighborCall45ElementsUMLMethod51 = neighborCall45.iteratorOfElements ("caller") ;
            while ( fujaba__IterNeighborCall45ElementsUMLMethod51.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall45ElementsUMLMethod51.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  uMLMethod51 = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind colleague: UMLClass
                  colleague = uMLMethod51.getParent () ;
                  JavaSDM.ensure ( colleague != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  {
                     //  for each flow
                     set.add (colleague);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            mediator = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod52: UMLMethod
            fujaba__IterMediatorMethodsUMLMethod52 = mediator.iteratorOfMethods () ;
            while ( fujaba__IterMediatorMethodsUMLMethod52.hasNext () )
            {
               try
               {
                  uMLMethod52 = (UMLMethod) fujaba__IterMediatorMethodsUMLMethod52.next () ;
                   
                  {
                     //  for each flow
                     set.add (uMLMethod52);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            colleague = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod53: UMLMethod
            fujaba__IterColleagueMethodsUMLMethod53 = colleague.iteratorOfMethods () ;
            while ( fujaba__IterColleagueMethodsUMLMethod53.hasNext () )
            {
               try
               {
                  uMLMethod53 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod53.next () ;
                   
                  {
                     //  for each flow
                     set.add (uMLMethod53);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall33 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod54: UMLMethod
            fujaba__IterNeighborCall33ElementsUMLMethod54 = neighborCall33.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall33ElementsUMLMethod54.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall33ElementsUMLMethod54.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  uMLMethod54 = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind colleague: UMLClass
                  colleague = uMLMethod54.getParent () ;
                  JavaSDM.ensure ( colleague != null ) ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  // bind uMLMethod55: UMLMethod
                  fujaba__IterColleagueMethodsUMLMethod55 = colleague.iteratorOfMethods () ;
                  while ( fujaba__IterColleagueMethodsUMLMethod55.hasNext () )
                  {
                     try
                     {
                        uMLMethod55 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod55.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(uMLMethod54.equals (uMLMethod55)) ) ;
                         
                        {
                           //  for each flow
                           set.add (uMLMethod55);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OneToManyAssociationAnnotation ) ;
             
            // explicit type cast
            oneToManyAssociation34 = (OneToManyAssociationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind colleague: UMLClass
            fujaba__IterOneToManyAssociation34ElementsColleague = oneToManyAssociation34.iteratorOfElements ("many") ;
            while ( fujaba__IterOneToManyAssociation34ElementsColleague.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOneToManyAssociation34ElementsColleague.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  colleague = (UMLClass) fujaba__TmpObject ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (colleague.isAbstract () == true) ) ;
                   
                  // bind uMLMethod56: UMLMethod
                  fujaba__IterColleagueMethodsUMLMethod56 = colleague.iteratorOfMethods () ;
                  while ( fujaba__IterColleagueMethodsUMLMethod56.hasNext () )
                  {
                     try
                     {
                        uMLMethod56 = (UMLMethod) fujaba__IterColleagueMethodsUMLMethod56.next () ;
                         
                        {
                           //  for each flow
                           set.add (uMLMethod56);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
