package de.upb.inferenceengine.engines;

import de.upb.inferenceengine.visitors.*;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.ASTRootNode;
import de.upb.javaast.methodast.MethodCallNode;
import de.upb.javaast.methodast.IdentifierNode;
import de.uni_paderborn.fujaba.uml.UMLStereotype;

public class ClassAdapterEngine
extends GFRNEngine
{
   private  ClassAdapterEngine()
   {
   }

   private static ClassAdapterEngine theClassAdapterEngine;

   public static ClassAdapterEngine get()
   {
      if (theClassAdapterEngine == null)
      {
         theClassAdapterEngine = new ClassAdapterEngine ();
      }
      return theClassAdapterEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation classAdapter = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         classAdapter = this.annotateUsingTrigger_OverridingMethodRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( classAdapter != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (classAdapter) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            classAdapter = this.annotateUsingAdapteeRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( classAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (classAdapter) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               classAdapter = this.annotateUsingTrigger_GeneralizationRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( classAdapter != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (classAdapter) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  classAdapter = this.annotateUsingAdapterRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( classAdapter != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (classAdapter) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     classAdapter = this.annotateUsingTrigger_GeneralizationRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  try
                  {
                     fujaba__Success = false ;
                      
                     // constraint
                     JavaSDM.ensure ( classAdapter != null ) ;
                      
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  if ( fujaba__Success )
                  {
                     return (classAdapter) ;
                  }
                  else
                  {
                     try
                     {
                        fujaba__Success = false ;
                         
                        // collabStatBegin 1 is empty !
                        classAdapter = this.annotateUsingTargetRole(asgElement);
                         
                        // collabStatEnd
                        fujaba__Success = true ;
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     return (classAdapter) ;
                  }
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingAdapteeRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToMethodCallNode9 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      ClassAdapterAnnotation classAdapter = null ;
      Iterator fujaba__IterAdapteeAnnotationsGeneralization8 = null ;
      Iterator fujaba__IterAdapteeMethodsCallee = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization10 = null ;
      Iterator fujaba__IterAdapterMethodsCaller = null ;
      Iterator fujaba__IterCallerAnnotationsOverridingMethod7 = null ;
      Iterator fujaba__IterGeneralization10ElementsTarget = null ;
      Iterator fujaba__IterGeneralization8ElementsAdapter = null ;
      Iterator fujaba__IterOverridingMethod7ElementsUMLMethod11 = null ;
      Iterator fujaba__IterTargetAnnotationsClassAdapter = null ;
      Iterator fujaba__IterTargetStereotypesUMLStereotype12 = null ;
      GeneralizationAnnotation generalization10 = null ;
      GeneralizationAnnotation generalization8 = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode9 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod7 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod11 = null ;
      UMLStereotype uMLStereotype12 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("adaptee", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
            while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                   
                  // bind generalization8: GeneralizationAnnotation
                  fujaba__IterAdapteeAnnotationsGeneralization8 = adaptee.iteratorOfAnnotations () ;
                  while ( fujaba__IterAdapteeAnnotationsGeneralization8.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAdapteeAnnotationsGeneralization8.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization8 = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization8 and adaptee
                        JavaSDM.ensure ( generalization8.hasInElements ("superClass", adaptee) ) ;
                         
                        // bind adapter: UMLClass
                        fujaba__IterGeneralization8ElementsAdapter = generalization8.iteratorOfElements ("subClass") ;
                        while ( fujaba__IterGeneralization8ElementsAdapter.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterGeneralization8ElementsAdapter.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              adapter = (UMLClass) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(adaptee.equals (adapter)) ) ;
                               
                              // bind caller: UMLMethod
                              fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
                              while ( fujaba__IterAdapterMethodsCaller.hasNext () )
                              {
                                 try
                                 {
                                    caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                                     
                                    // bind root: ASTRootNode
                                    root = caller.getASTRootNode () ;
                                    JavaSDM.ensure ( root != null ) ;
                                     
                                    // bind generalization10: GeneralizationAnnotation
                                    fujaba__IterAdapterAnnotationsGeneralization10 = adapter.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAdapterAnnotationsGeneralization10.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization10.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                          generalization10 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between generalization10 and adapter
                                          JavaSDM.ensure ( generalization10.hasInElements ("subClass", adapter) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(generalization8.equals (generalization10)) ) ;
                                           
                                          // bind overridingMethod7: OverridingMethodAnnotation
                                          fujaba__IterCallerAnnotationsOverridingMethod7 = caller.iteratorOfAnnotations () ;
                                          while ( fujaba__IterCallerAnnotationsOverridingMethod7.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterCallerAnnotationsOverridingMethod7.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                                overridingMethod7 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between overridingMethod7 and caller
                                                JavaSDM.ensure ( overridingMethod7.hasInElements ("overriding", caller) ) ;
                                                 
                                                // bind target: UMLClass
                                                fujaba__IterGeneralization10ElementsTarget = generalization10.iteratorOfElements ("superClass") ;
                                                while ( fujaba__IterGeneralization10ElementsTarget.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterGeneralization10ElementsTarget.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                      target = (UMLClass) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(adaptee.equals (target)) && !(adapter.equals (target)) ) ;
                                                       
                                                      // bind uMLMethod11: UMLMethod
                                                      fujaba__IterOverridingMethod7ElementsUMLMethod11 = overridingMethod7.iteratorOfElements ("overridden") ;
                                                      while ( fujaba__IterOverridingMethod7ElementsUMLMethod11.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterOverridingMethod7ElementsUMLMethod11.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                            uMLMethod11 = (UMLMethod) fujaba__TmpObject ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(caller.equals (uMLMethod11)) && !(callee.equals (uMLMethod11)) ) ;
                                                             
                                                            // check To-One-Link 'parent' between uMLMethod11 and target
                                                            JavaSDM.ensure ( (uMLMethod11.getParent () != null) && uMLMethod11.getParent ().equals (target) ) ;
                                                             
                                                            // bind uMLStereotype12: UMLStereotype
                                                            fujaba__IterTargetStereotypesUMLStereotype12 = target.iteratorOfStereotypes () ;
                                                            while ( fujaba__IterTargetStereotypesUMLStereotype12.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  uMLStereotype12 = (UMLStereotype) fujaba__IterTargetStereotypesUMLStereotype12.next () ;
                                                                   
                                                                  // attribute condition
                                                                  JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype12.getText (), "interface") == 0) ) ;
                                                                   
                                                                  // Path search between ASTRootNode and MethodCallNode
                                                                  // Bind methodCallNode9 : MethodCallNode
                                                                  fujaba__IterRootToMethodCallNode9 = new ASTPathVisitor (root, MethodCallNode.class ) ;
                                                                  while ( fujaba__IterRootToMethodCallNode9.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        methodCallNode9 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterRootToMethodCallNode9.next () ;
                                                                         
                                                                        // bind id: IdentifierNode
                                                                        id = methodCallNode9.getIdentifier () ;
                                                                        JavaSDM.ensure ( id != null ) ;
                                                                         
                                                                        // constraint
                                                                        JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                                         
                                                                        {
                                                                           //  for each flow
                                                                           try
                                                                           {
                                                                              fujaba__Success = false ;
                                                                               
                                                                              // check object adaptee is really bound
                                                                              JavaSDM.ensure ( adaptee != null ) ;
                                                                               
                                                                              // check object target is really bound
                                                                              JavaSDM.ensure ( target != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                               
                                                                              // check object adapter is really bound
                                                                              JavaSDM.ensure ( adapter != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                               
                                                                              // bind classAdapter: ClassAdapterAnnotation
                                                                              fujaba__IterTargetAnnotationsClassAdapter = target.iteratorOfAnnotations () ;
                                                                              while ( !(fujaba__Success) && fujaba__IterTargetAnnotationsClassAdapter.hasNext () )
                                                                              {
                                                                                 try
                                                                                 {
                                                                                    fujaba__TmpObject = fujaba__IterTargetAnnotationsClassAdapter.next () ;
                                                                                    JavaSDM.ensure ( fujaba__TmpObject instanceof ClassAdapterAnnotation ) ;
                                                                                    classAdapter = (ClassAdapterAnnotation) fujaba__TmpObject ;
                                                                                     
                                                                                    // check Reverse-Qualified-Link 'elements' between classAdapter and target
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("target", target) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and adaptee
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and adapter
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adapter", adapter) ) ;
                                                                                     
                                                                                    fujaba__Success = true ;
                                                                                 }
                                                                                 catch ( JavaSDMException fujaba__InternalException )
                                                                                 {
                                                                                 }
                                                                              }
                                                                           }
                                                                           catch ( JavaSDMException fujaba__InternalException )
                                                                           {
                                                                              fujaba__Success = false ;
                                                                           }
                                                                            
                                                                           if ( !(fujaba__Success) )
                                                                           {
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object adaptee is really bound
                                                                                 JavaSDM.ensure ( adaptee != null ) ;
                                                                                  
                                                                                 // check object target is really bound
                                                                                 JavaSDM.ensure ( target != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                                  
                                                                                 // check object adapter is really bound
                                                                                 JavaSDM.ensure ( adapter != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                                  
                                                                                 // check object caller is really bound
                                                                                 JavaSDM.ensure ( caller != null ) ;
                                                                                  
                                                                                 // check object root is really bound
                                                                                 JavaSDM.ensure ( root != null ) ;
                                                                                  
                                                                                 // check object id is really bound
                                                                                 JavaSDM.ensure ( id != null ) ;
                                                                                  
                                                                                 // check object callee is really bound
                                                                                 JavaSDM.ensure ( callee != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                                  
                                                                                 // create object
                                                                                 classAdapter = new ClassAdapterAnnotation ( ) ;
                                                                                  
                                                                                 // assign statement
                                                                                 classAdapter.setClassification (1);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("caller", caller);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("root", root);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("id", id);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("callee", callee);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object overridingMethod7 is really bound
                                                                                 JavaSDM.ensure ( overridingMethod7 != null ) ;
                                                                                  
                                                                                 // check object generalization8 is really bound
                                                                                 JavaSDM.ensure ( generalization8 != null ) ;
                                                                                  
                                                                                 // check object generalization10 is really bound
                                                                                 JavaSDM.ensure ( generalization10 != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(generalization8.equals (generalization10)) ) ;
                                                                                  
                                                                                 // check object classAdapter is really bound
                                                                                 JavaSDM.ensure ( classAdapter != null ) ;
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (overridingMethod7);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization8);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization10);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              return (classAdapter) ;
                                                                           }
                                                                        } //  end for each flow
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object classAdapter is really bound
            JavaSDM.ensure ( classAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("adaptee", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (classAdapter) ;
   }


   private GFRNAnnotation annotateUsingAdapterRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToMethodCallNode21 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      ClassAdapterAnnotation classAdapter = null ;
      Iterator fujaba__IterAdapteeAnnotationsClassAdapter = null ;
      Iterator fujaba__IterAdapteeMethodsCallee = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization20 = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization22 = null ;
      Iterator fujaba__IterAdapterMethodsCaller = null ;
      Iterator fujaba__IterCallerAnnotationsOverridingMethod19 = null ;
      Iterator fujaba__IterGeneralization20ElementsAdaptee = null ;
      Iterator fujaba__IterGeneralization22ElementsTarget = null ;
      Iterator fujaba__IterOverridingMethod19ElementsUMLMethod23 = null ;
      Iterator fujaba__IterTargetStereotypesUMLStereotype24 = null ;
      GeneralizationAnnotation generalization20 = null ;
      GeneralizationAnnotation generalization22 = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode21 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod19 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod23 = null ;
      UMLStereotype uMLStereotype24 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("adapter", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
            while ( fujaba__IterAdapterMethodsCaller.hasNext () )
            {
               try
               {
                  caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                   
                  // bind root: ASTRootNode
                  root = caller.getASTRootNode () ;
                  JavaSDM.ensure ( root != null ) ;
                   
                  // bind generalization20: GeneralizationAnnotation
                  fujaba__IterAdapterAnnotationsGeneralization20 = adapter.iteratorOfAnnotations () ;
                  while ( fujaba__IterAdapterAnnotationsGeneralization20.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization20.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                        generalization20 = (GeneralizationAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between generalization20 and adapter
                        JavaSDM.ensure ( generalization20.hasInElements ("subClass", adapter) ) ;
                         
                        // bind generalization22: GeneralizationAnnotation
                        fujaba__IterAdapterAnnotationsGeneralization22 = adapter.iteratorOfAnnotations () ;
                        while ( fujaba__IterAdapterAnnotationsGeneralization22.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization22.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization22 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization22 and adapter
                              JavaSDM.ensure ( generalization22.hasInElements ("subClass", adapter) ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(generalization20.equals (generalization22)) ) ;
                               
                              // bind overridingMethod19: OverridingMethodAnnotation
                              fujaba__IterCallerAnnotationsOverridingMethod19 = caller.iteratorOfAnnotations () ;
                              while ( fujaba__IterCallerAnnotationsOverridingMethod19.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterCallerAnnotationsOverridingMethod19.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                    overridingMethod19 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between overridingMethod19 and caller
                                    JavaSDM.ensure ( overridingMethod19.hasInElements ("overriding", caller) ) ;
                                     
                                    // bind adaptee: UMLClass
                                    fujaba__IterGeneralization20ElementsAdaptee = generalization20.iteratorOfElements ("superClass") ;
                                    while ( fujaba__IterGeneralization20ElementsAdaptee.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterGeneralization20ElementsAdaptee.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          adaptee = (UMLClass) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(adapter.equals (adaptee)) ) ;
                                           
                                          // bind target: UMLClass
                                          fujaba__IterGeneralization22ElementsTarget = generalization22.iteratorOfElements ("superClass") ;
                                          while ( fujaba__IterGeneralization22ElementsTarget.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterGeneralization22ElementsTarget.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                target = (UMLClass) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(adaptee.equals (target)) && !(adapter.equals (target)) ) ;
                                                 
                                                // bind uMLMethod23: UMLMethod
                                                fujaba__IterOverridingMethod19ElementsUMLMethod23 = overridingMethod19.iteratorOfElements ("overridden") ;
                                                while ( fujaba__IterOverridingMethod19ElementsUMLMethod23.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterOverridingMethod19ElementsUMLMethod23.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                      uMLMethod23 = (UMLMethod) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (uMLMethod23)) ) ;
                                                       
                                                      // check To-One-Link 'parent' between uMLMethod23 and target
                                                      JavaSDM.ensure ( (uMLMethod23.getParent () != null) && uMLMethod23.getParent ().equals (target) ) ;
                                                       
                                                      // bind callee: UMLMethod
                                                      fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
                                                      while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(caller.equals (callee)) && !(uMLMethod23.equals (callee)) ) ;
                                                             
                                                            // bind uMLStereotype24: UMLStereotype
                                                            fujaba__IterTargetStereotypesUMLStereotype24 = target.iteratorOfStereotypes () ;
                                                            while ( fujaba__IterTargetStereotypesUMLStereotype24.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  uMLStereotype24 = (UMLStereotype) fujaba__IterTargetStereotypesUMLStereotype24.next () ;
                                                                   
                                                                  // attribute condition
                                                                  JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype24.getText (), "interface") == 0) ) ;
                                                                   
                                                                  // Path search between ASTRootNode and MethodCallNode
                                                                  // Bind methodCallNode21 : MethodCallNode
                                                                  fujaba__IterRootToMethodCallNode21 = new ASTPathVisitor (root, MethodCallNode.class ) ;
                                                                  while ( fujaba__IterRootToMethodCallNode21.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        methodCallNode21 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterRootToMethodCallNode21.next () ;
                                                                         
                                                                        // bind id: IdentifierNode
                                                                        id = methodCallNode21.getIdentifier () ;
                                                                        JavaSDM.ensure ( id != null ) ;
                                                                         
                                                                        // constraint
                                                                        JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                                         
                                                                        {
                                                                           //  for each flow
                                                                           try
                                                                           {
                                                                              fujaba__Success = false ;
                                                                               
                                                                              // check object adaptee is really bound
                                                                              JavaSDM.ensure ( adaptee != null ) ;
                                                                               
                                                                              // check object target is really bound
                                                                              JavaSDM.ensure ( target != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                               
                                                                              // check object adapter is really bound
                                                                              JavaSDM.ensure ( adapter != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                               
                                                                              // bind classAdapter: ClassAdapterAnnotation
                                                                              fujaba__IterAdapteeAnnotationsClassAdapter = adaptee.iteratorOfAnnotations () ;
                                                                              while ( !(fujaba__Success) && fujaba__IterAdapteeAnnotationsClassAdapter.hasNext () )
                                                                              {
                                                                                 try
                                                                                 {
                                                                                    fujaba__TmpObject = fujaba__IterAdapteeAnnotationsClassAdapter.next () ;
                                                                                    JavaSDM.ensure ( fujaba__TmpObject instanceof ClassAdapterAnnotation ) ;
                                                                                    classAdapter = (ClassAdapterAnnotation) fujaba__TmpObject ;
                                                                                     
                                                                                    // check Reverse-Qualified-Link 'elements' between classAdapter and adaptee
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and target
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("target", target) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and adapter
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adapter", adapter) ) ;
                                                                                     
                                                                                    fujaba__Success = true ;
                                                                                 }
                                                                                 catch ( JavaSDMException fujaba__InternalException )
                                                                                 {
                                                                                 }
                                                                              }
                                                                           }
                                                                           catch ( JavaSDMException fujaba__InternalException )
                                                                           {
                                                                              fujaba__Success = false ;
                                                                           }
                                                                            
                                                                           if ( !(fujaba__Success) )
                                                                           {
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object adaptee is really bound
                                                                                 JavaSDM.ensure ( adaptee != null ) ;
                                                                                  
                                                                                 // check object target is really bound
                                                                                 JavaSDM.ensure ( target != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                                  
                                                                                 // check object adapter is really bound
                                                                                 JavaSDM.ensure ( adapter != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                                  
                                                                                 // check object caller is really bound
                                                                                 JavaSDM.ensure ( caller != null ) ;
                                                                                  
                                                                                 // check object root is really bound
                                                                                 JavaSDM.ensure ( root != null ) ;
                                                                                  
                                                                                 // check object id is really bound
                                                                                 JavaSDM.ensure ( id != null ) ;
                                                                                  
                                                                                 // check object callee is really bound
                                                                                 JavaSDM.ensure ( callee != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                                  
                                                                                 // create object
                                                                                 classAdapter = new ClassAdapterAnnotation ( ) ;
                                                                                  
                                                                                 // assign statement
                                                                                 classAdapter.setClassification (1);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("caller", caller);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("root", root);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("id", id);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("callee", callee);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object overridingMethod19 is really bound
                                                                                 JavaSDM.ensure ( overridingMethod19 != null ) ;
                                                                                  
                                                                                 // check object generalization20 is really bound
                                                                                 JavaSDM.ensure ( generalization20 != null ) ;
                                                                                  
                                                                                 // check object generalization22 is really bound
                                                                                 JavaSDM.ensure ( generalization22 != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(generalization20.equals (generalization22)) ) ;
                                                                                  
                                                                                 // check object classAdapter is really bound
                                                                                 JavaSDM.ensure ( classAdapter != null ) ;
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (overridingMethod19);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization20);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization22);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              return (classAdapter) ;
                                                                           }
                                                                        } //  end for each flow
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object classAdapter is really bound
            JavaSDM.ensure ( classAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("adapter", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (classAdapter) ;
   }


   private GFRNAnnotation annotateUsingTargetRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToMethodCallNode33 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      ClassAdapterAnnotation classAdapter = null ;
      Iterator fujaba__IterAdapteeAnnotationsClassAdapter = null ;
      Iterator fujaba__IterAdapteeMethodsCallee = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization32 = null ;
      Iterator fujaba__IterGeneralization32ElementsAdaptee = null ;
      Iterator fujaba__IterGeneralization34ElementsAdapter = null ;
      Iterator fujaba__IterOverridingMethod31ElementsCaller = null ;
      Iterator fujaba__IterTargetAnnotationsGeneralization34 = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod35 = null ;
      Iterator fujaba__IterTargetStereotypesUMLStereotype36 = null ;
      Iterator fujaba__IterUMLMethod35AnnotationsOverridingMethod31 = null ;
      GeneralizationAnnotation generalization32 = null ;
      GeneralizationAnnotation generalization34 = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode33 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod31 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod35 = null ;
      UMLStereotype uMLStereotype36 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("target", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod35: UMLMethod
            fujaba__IterTargetMethodsUMLMethod35 = target.iteratorOfMethods () ;
            while ( fujaba__IterTargetMethodsUMLMethod35.hasNext () )
            {
               try
               {
                  uMLMethod35 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod35.next () ;
                   
                  // bind uMLStereotype36: UMLStereotype
                  fujaba__IterTargetStereotypesUMLStereotype36 = target.iteratorOfStereotypes () ;
                  while ( fujaba__IterTargetStereotypesUMLStereotype36.hasNext () )
                  {
                     try
                     {
                        uMLStereotype36 = (UMLStereotype) fujaba__IterTargetStereotypesUMLStereotype36.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype36.getText (), "interface") == 0) ) ;
                         
                        // bind generalization34: GeneralizationAnnotation
                        fujaba__IterTargetAnnotationsGeneralization34 = target.iteratorOfAnnotations () ;
                        while ( fujaba__IterTargetAnnotationsGeneralization34.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterTargetAnnotationsGeneralization34.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization34 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization34 and target
                              JavaSDM.ensure ( generalization34.hasInElements ("superClass", target) ) ;
                               
                              // bind overridingMethod31: OverridingMethodAnnotation
                              fujaba__IterUMLMethod35AnnotationsOverridingMethod31 = uMLMethod35.iteratorOfAnnotations () ;
                              while ( fujaba__IterUMLMethod35AnnotationsOverridingMethod31.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterUMLMethod35AnnotationsOverridingMethod31.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                    overridingMethod31 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between overridingMethod31 and uMLMethod35
                                    JavaSDM.ensure ( overridingMethod31.hasInElements ("overridden", uMLMethod35) ) ;
                                     
                                    // bind adapter: UMLClass
                                    fujaba__IterGeneralization34ElementsAdapter = generalization34.iteratorOfElements ("subClass") ;
                                    while ( fujaba__IterGeneralization34ElementsAdapter.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterGeneralization34ElementsAdapter.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          adapter = (UMLClass) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                                           
                                          // bind caller: UMLMethod
                                          fujaba__IterOverridingMethod31ElementsCaller = overridingMethod31.iteratorOfElements ("overriding") ;
                                          while ( fujaba__IterOverridingMethod31ElementsCaller.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterOverridingMethod31ElementsCaller.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                caller = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(uMLMethod35.equals (caller)) ) ;
                                                 
                                                // check To-One-Link 'parent' between caller and adapter
                                                JavaSDM.ensure ( (caller.getParent () != null) && caller.getParent ().equals (adapter) ) ;
                                                 
                                                // bind root: ASTRootNode
                                                root = caller.getASTRootNode () ;
                                                JavaSDM.ensure ( root != null ) ;
                                                 
                                                // bind generalization32: GeneralizationAnnotation
                                                fujaba__IterAdapterAnnotationsGeneralization32 = adapter.iteratorOfAnnotations () ;
                                                while ( fujaba__IterAdapterAnnotationsGeneralization32.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization32.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                                      generalization32 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between generalization32 and adapter
                                                      JavaSDM.ensure ( generalization32.hasInElements ("subClass", adapter) ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(generalization34.equals (generalization32)) ) ;
                                                       
                                                      // bind adaptee: UMLClass
                                                      fujaba__IterGeneralization32ElementsAdaptee = generalization32.iteratorOfElements ("superClass") ;
                                                      while ( fujaba__IterGeneralization32ElementsAdaptee.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterGeneralization32ElementsAdaptee.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                            adaptee = (UMLClass) fujaba__TmpObject ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(adapter.equals (adaptee)) && !(target.equals (adaptee)) ) ;
                                                             
                                                            // bind callee: UMLMethod
                                                            fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
                                                            while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                                                                   
                                                                  // check isomorphic binding
                                                                  JavaSDM.ensure ( !(caller.equals (callee)) && !(uMLMethod35.equals (callee)) ) ;
                                                                   
                                                                  // Path search between ASTRootNode and MethodCallNode
                                                                  // Bind methodCallNode33 : MethodCallNode
                                                                  fujaba__IterRootToMethodCallNode33 = new ASTPathVisitor (root, MethodCallNode.class ) ;
                                                                  while ( fujaba__IterRootToMethodCallNode33.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        methodCallNode33 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterRootToMethodCallNode33.next () ;
                                                                         
                                                                        // bind id: IdentifierNode
                                                                        id = methodCallNode33.getIdentifier () ;
                                                                        JavaSDM.ensure ( id != null ) ;
                                                                         
                                                                        // constraint
                                                                        JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                                         
                                                                        {
                                                                           //  for each flow
                                                                           try
                                                                           {
                                                                              fujaba__Success = false ;
                                                                               
                                                                              // check object adaptee is really bound
                                                                              JavaSDM.ensure ( adaptee != null ) ;
                                                                               
                                                                              // check object target is really bound
                                                                              JavaSDM.ensure ( target != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                               
                                                                              // check object adapter is really bound
                                                                              JavaSDM.ensure ( adapter != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                               
                                                                              // bind classAdapter: ClassAdapterAnnotation
                                                                              fujaba__IterAdapteeAnnotationsClassAdapter = adaptee.iteratorOfAnnotations () ;
                                                                              while ( !(fujaba__Success) && fujaba__IterAdapteeAnnotationsClassAdapter.hasNext () )
                                                                              {
                                                                                 try
                                                                                 {
                                                                                    fujaba__TmpObject = fujaba__IterAdapteeAnnotationsClassAdapter.next () ;
                                                                                    JavaSDM.ensure ( fujaba__TmpObject instanceof ClassAdapterAnnotation ) ;
                                                                                    classAdapter = (ClassAdapterAnnotation) fujaba__TmpObject ;
                                                                                     
                                                                                    // check Reverse-Qualified-Link 'elements' between classAdapter and adaptee
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and target
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("target", target) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and adapter
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adapter", adapter) ) ;
                                                                                     
                                                                                    fujaba__Success = true ;
                                                                                 }
                                                                                 catch ( JavaSDMException fujaba__InternalException )
                                                                                 {
                                                                                 }
                                                                              }
                                                                           }
                                                                           catch ( JavaSDMException fujaba__InternalException )
                                                                           {
                                                                              fujaba__Success = false ;
                                                                           }
                                                                            
                                                                           if ( !(fujaba__Success) )
                                                                           {
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object adaptee is really bound
                                                                                 JavaSDM.ensure ( adaptee != null ) ;
                                                                                  
                                                                                 // check object target is really bound
                                                                                 JavaSDM.ensure ( target != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                                  
                                                                                 // check object adapter is really bound
                                                                                 JavaSDM.ensure ( adapter != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                                  
                                                                                 // check object caller is really bound
                                                                                 JavaSDM.ensure ( caller != null ) ;
                                                                                  
                                                                                 // check object root is really bound
                                                                                 JavaSDM.ensure ( root != null ) ;
                                                                                  
                                                                                 // check object id is really bound
                                                                                 JavaSDM.ensure ( id != null ) ;
                                                                                  
                                                                                 // check object callee is really bound
                                                                                 JavaSDM.ensure ( callee != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                                  
                                                                                 // create object
                                                                                 classAdapter = new ClassAdapterAnnotation ( ) ;
                                                                                  
                                                                                 // assign statement
                                                                                 classAdapter.setClassification (1);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("caller", caller);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("root", root);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("id", id);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("callee", callee);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object overridingMethod31 is really bound
                                                                                 JavaSDM.ensure ( overridingMethod31 != null ) ;
                                                                                  
                                                                                 // check object generalization32 is really bound
                                                                                 JavaSDM.ensure ( generalization32 != null ) ;
                                                                                  
                                                                                 // check object generalization34 is really bound
                                                                                 JavaSDM.ensure ( generalization34 != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(generalization32.equals (generalization34)) ) ;
                                                                                  
                                                                                 // check object classAdapter is really bound
                                                                                 JavaSDM.ensure ( classAdapter != null ) ;
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (overridingMethod31);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization32);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization34);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              return (classAdapter) ;
                                                                           }
                                                                        } //  end for each flow
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object classAdapter is really bound
            JavaSDM.ensure ( classAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("target", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (classAdapter) ;
   }


   private GFRNAnnotation annotateUsingTrigger_GeneralizationRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToMethodCallNode15 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      ClassAdapterAnnotation classAdapter = null ;
      Iterator fujaba__IterAdapteeMethodsCallee = null ;
      Iterator fujaba__IterAdapterAnnotationsClassAdapter = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization16 = null ;
      Iterator fujaba__IterAdapterMethodsCaller = null ;
      Iterator fujaba__IterCallerAnnotationsOverridingMethod13 = null ;
      Iterator fujaba__IterGeneralization14ElementsAdaptee = null ;
      Iterator fujaba__IterGeneralization14ElementsAdapter = null ;
      Iterator fujaba__IterGeneralization16ElementsTarget = null ;
      Iterator fujaba__IterOverridingMethod13ElementsUMLMethod17 = null ;
      Iterator fujaba__IterTargetStereotypesUMLStereotype18 = null ;
      GeneralizationAnnotation generalization14 = null ;
      GeneralizationAnnotation generalization16 = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode15 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod13 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod17 = null ;
      UMLStereotype uMLStereotype18 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization14 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind adaptee: UMLClass
            fujaba__IterGeneralization14ElementsAdaptee = generalization14.iteratorOfElements ("superClass") ;
            while ( fujaba__IterGeneralization14ElementsAdaptee.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization14ElementsAdaptee.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  adaptee = (UMLClass) fujaba__TmpObject ;
                   
                  // bind adapter: UMLClass
                  fujaba__IterGeneralization14ElementsAdapter = generalization14.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization14ElementsAdapter.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization14ElementsAdapter.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        adapter = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(adaptee.equals (adapter)) ) ;
                         
                        // bind callee: UMLMethod
                        fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
                        while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
                        {
                           try
                           {
                              callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                               
                              // bind caller: UMLMethod
                              fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
                              while ( fujaba__IterAdapterMethodsCaller.hasNext () )
                              {
                                 try
                                 {
                                    caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                                     
                                    // bind root: ASTRootNode
                                    root = caller.getASTRootNode () ;
                                    JavaSDM.ensure ( root != null ) ;
                                     
                                    // bind generalization16: GeneralizationAnnotation
                                    fujaba__IterAdapterAnnotationsGeneralization16 = adapter.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAdapterAnnotationsGeneralization16.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization16.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                          generalization16 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between generalization16 and adapter
                                          JavaSDM.ensure ( generalization16.hasInElements ("subClass", adapter) ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(generalization14.equals (generalization16)) ) ;
                                           
                                          // bind overridingMethod13: OverridingMethodAnnotation
                                          fujaba__IterCallerAnnotationsOverridingMethod13 = caller.iteratorOfAnnotations () ;
                                          while ( fujaba__IterCallerAnnotationsOverridingMethod13.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterCallerAnnotationsOverridingMethod13.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                                overridingMethod13 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between overridingMethod13 and caller
                                                JavaSDM.ensure ( overridingMethod13.hasInElements ("overriding", caller) ) ;
                                                 
                                                // bind target: UMLClass
                                                fujaba__IterGeneralization16ElementsTarget = generalization16.iteratorOfElements ("superClass") ;
                                                while ( fujaba__IterGeneralization16ElementsTarget.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterGeneralization16ElementsTarget.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                      target = (UMLClass) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(adaptee.equals (target)) && !(adapter.equals (target)) ) ;
                                                       
                                                      // bind uMLMethod17: UMLMethod
                                                      fujaba__IterOverridingMethod13ElementsUMLMethod17 = overridingMethod13.iteratorOfElements ("overridden") ;
                                                      while ( fujaba__IterOverridingMethod13ElementsUMLMethod17.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterOverridingMethod13ElementsUMLMethod17.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                            uMLMethod17 = (UMLMethod) fujaba__TmpObject ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(caller.equals (uMLMethod17)) && !(callee.equals (uMLMethod17)) ) ;
                                                             
                                                            // check To-One-Link 'parent' between uMLMethod17 and target
                                                            JavaSDM.ensure ( (uMLMethod17.getParent () != null) && uMLMethod17.getParent ().equals (target) ) ;
                                                             
                                                            // bind uMLStereotype18: UMLStereotype
                                                            fujaba__IterTargetStereotypesUMLStereotype18 = target.iteratorOfStereotypes () ;
                                                            while ( fujaba__IterTargetStereotypesUMLStereotype18.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  uMLStereotype18 = (UMLStereotype) fujaba__IterTargetStereotypesUMLStereotype18.next () ;
                                                                   
                                                                  // attribute condition
                                                                  JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype18.getText (), "interface") == 0) ) ;
                                                                   
                                                                  // Path search between ASTRootNode and MethodCallNode
                                                                  // Bind methodCallNode15 : MethodCallNode
                                                                  fujaba__IterRootToMethodCallNode15 = new ASTPathVisitor (root, MethodCallNode.class ) ;
                                                                  while ( fujaba__IterRootToMethodCallNode15.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        methodCallNode15 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterRootToMethodCallNode15.next () ;
                                                                         
                                                                        // bind id: IdentifierNode
                                                                        id = methodCallNode15.getIdentifier () ;
                                                                        JavaSDM.ensure ( id != null ) ;
                                                                         
                                                                        // constraint
                                                                        JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                                         
                                                                        {
                                                                           //  for each flow
                                                                           try
                                                                           {
                                                                              fujaba__Success = false ;
                                                                               
                                                                              // check object adaptee is really bound
                                                                              JavaSDM.ensure ( adaptee != null ) ;
                                                                               
                                                                              // check object target is really bound
                                                                              JavaSDM.ensure ( target != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                               
                                                                              // check object adapter is really bound
                                                                              JavaSDM.ensure ( adapter != null ) ;
                                                                               
                                                                              // check isomorphic binding
                                                                              JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                               
                                                                              // bind classAdapter: ClassAdapterAnnotation
                                                                              fujaba__IterAdapterAnnotationsClassAdapter = adapter.iteratorOfAnnotations () ;
                                                                              while ( !(fujaba__Success) && fujaba__IterAdapterAnnotationsClassAdapter.hasNext () )
                                                                              {
                                                                                 try
                                                                                 {
                                                                                    fujaba__TmpObject = fujaba__IterAdapterAnnotationsClassAdapter.next () ;
                                                                                    JavaSDM.ensure ( fujaba__TmpObject instanceof ClassAdapterAnnotation ) ;
                                                                                    classAdapter = (ClassAdapterAnnotation) fujaba__TmpObject ;
                                                                                     
                                                                                    // check Reverse-Qualified-Link 'elements' between classAdapter and adapter
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adapter", adapter) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and adaptee
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                                     
                                                                                    // check To-Many-Link 'elements' between classAdapter and target
                                                                                    JavaSDM.ensure ( classAdapter.hasInElements ("target", target) ) ;
                                                                                     
                                                                                    fujaba__Success = true ;
                                                                                 }
                                                                                 catch ( JavaSDMException fujaba__InternalException )
                                                                                 {
                                                                                 }
                                                                              }
                                                                           }
                                                                           catch ( JavaSDMException fujaba__InternalException )
                                                                           {
                                                                              fujaba__Success = false ;
                                                                           }
                                                                            
                                                                           if ( !(fujaba__Success) )
                                                                           {
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object adaptee is really bound
                                                                                 JavaSDM.ensure ( adaptee != null ) ;
                                                                                  
                                                                                 // check object target is really bound
                                                                                 JavaSDM.ensure ( target != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                                  
                                                                                 // check object adapter is really bound
                                                                                 JavaSDM.ensure ( adapter != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                                  
                                                                                 // check object caller is really bound
                                                                                 JavaSDM.ensure ( caller != null ) ;
                                                                                  
                                                                                 // check object root is really bound
                                                                                 JavaSDM.ensure ( root != null ) ;
                                                                                  
                                                                                 // check object id is really bound
                                                                                 JavaSDM.ensure ( id != null ) ;
                                                                                  
                                                                                 // check object callee is really bound
                                                                                 JavaSDM.ensure ( callee != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                                  
                                                                                 // create object
                                                                                 classAdapter = new ClassAdapterAnnotation ( ) ;
                                                                                  
                                                                                 // assign statement
                                                                                 classAdapter.setClassification (1);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToElements ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("adapter", adapter);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("caller", caller);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("root", root);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("id", id);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("target", target);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToBoundObjects ("callee", callee);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              try
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                                  
                                                                                 // check object overridingMethod13 is really bound
                                                                                 JavaSDM.ensure ( overridingMethod13 != null ) ;
                                                                                  
                                                                                 // check object generalization14 is really bound
                                                                                 JavaSDM.ensure ( generalization14 != null ) ;
                                                                                  
                                                                                 // check object generalization16 is really bound
                                                                                 JavaSDM.ensure ( generalization16 != null ) ;
                                                                                  
                                                                                 // check isomorphic binding
                                                                                 JavaSDM.ensure ( !(generalization14.equals (generalization16)) ) ;
                                                                                  
                                                                                 // check object classAdapter is really bound
                                                                                 JavaSDM.ensure ( classAdapter != null ) ;
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (overridingMethod13);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization14);
                                                                                  
                                                                                 // create link
                                                                                 classAdapter.addToAntecedentAnnos (generalization16);
                                                                                  
                                                                                 fujaba__Success = true ;
                                                                              }
                                                                              catch ( JavaSDMException fujaba__InternalException )
                                                                              {
                                                                                 fujaba__Success = false ;
                                                                              }
                                                                               
                                                                              return (classAdapter) ;
                                                                           }
                                                                        } //  end for each flow
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object classAdapter is really bound
            JavaSDM.ensure ( classAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Generalization", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (classAdapter) ;
   }


   private GFRNAnnotation annotateUsingTrigger_OverridingMethodRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToMethodCallNode3 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      ClassAdapterAnnotation classAdapter = null ;
      Iterator fujaba__IterAdapteeAnnotationsClassAdapter = null ;
      Iterator fujaba__IterAdapteeMethodsCallee = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization2 = null ;
      Iterator fujaba__IterAdapterAnnotationsGeneralization4 = null ;
      Iterator fujaba__IterGeneralization2ElementsAdaptee = null ;
      Iterator fujaba__IterOverridingMethod1ElementsCaller = null ;
      Iterator fujaba__IterOverridingMethod1ElementsUMLMethod5 = null ;
      Iterator fujaba__IterTargetStereotypesUMLStereotype6 = null ;
      GeneralizationAnnotation generalization2 = null ;
      GeneralizationAnnotation generalization4 = null ;
      IdentifierNode id = null ;
      de.upb.javaast.methodast.MethodCallNode methodCallNode3 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod1 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod5 = null ;
      UMLStereotype uMLStereotype6 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod1 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterOverridingMethod1ElementsCaller = overridingMethod1.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod1ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod1ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind root: ASTRootNode
                  root = caller.getASTRootNode () ;
                  JavaSDM.ensure ( root != null ) ;
                   
                  // bind adapter: UMLClass
                  adapter = caller.getParent () ;
                  JavaSDM.ensure ( adapter != null ) ;
                   
                  // bind uMLMethod5: UMLMethod
                  fujaba__IterOverridingMethod1ElementsUMLMethod5 = overridingMethod1.iteratorOfElements ("overridden") ;
                  while ( fujaba__IterOverridingMethod1ElementsUMLMethod5.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterOverridingMethod1ElementsUMLMethod5.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        uMLMethod5 = (UMLMethod) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(caller.equals (uMLMethod5)) ) ;
                         
                        // bind target: UMLClass
                        target = uMLMethod5.getParent () ;
                        JavaSDM.ensure ( target != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(adapter.equals (target)) ) ;
                         
                        // bind generalization2: GeneralizationAnnotation
                        fujaba__IterAdapterAnnotationsGeneralization2 = adapter.iteratorOfAnnotations () ;
                        while ( fujaba__IterAdapterAnnotationsGeneralization2.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization2.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                              generalization2 = (GeneralizationAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between generalization2 and adapter
                              JavaSDM.ensure ( generalization2.hasInElements ("subClass", adapter) ) ;
                               
                              // bind generalization4: GeneralizationAnnotation
                              fujaba__IterAdapterAnnotationsGeneralization4 = adapter.iteratorOfAnnotations () ;
                              while ( fujaba__IterAdapterAnnotationsGeneralization4.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterAdapterAnnotationsGeneralization4.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                                    generalization4 = (GeneralizationAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between generalization4 and adapter
                                    JavaSDM.ensure ( generalization4.hasInElements ("subClass", adapter) ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(generalization2.equals (generalization4)) ) ;
                                     
                                    // check To-Many-Link 'elements' between generalization4 and target
                                    JavaSDM.ensure ( generalization4.hasInElements ("superClass", target) ) ;
                                     
                                    // bind uMLStereotype6: UMLStereotype
                                    fujaba__IterTargetStereotypesUMLStereotype6 = target.iteratorOfStereotypes () ;
                                    while ( fujaba__IterTargetStereotypesUMLStereotype6.hasNext () )
                                    {
                                       try
                                       {
                                          uMLStereotype6 = (UMLStereotype) fujaba__IterTargetStereotypesUMLStereotype6.next () ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype6.getText (), "interface") == 0) ) ;
                                           
                                          // bind adaptee: UMLClass
                                          fujaba__IterGeneralization2ElementsAdaptee = generalization2.iteratorOfElements ("superClass") ;
                                          while ( fujaba__IterGeneralization2ElementsAdaptee.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterGeneralization2ElementsAdaptee.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                                adaptee = (UMLClass) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(adapter.equals (adaptee)) && !(target.equals (adaptee)) ) ;
                                                 
                                                // bind callee: UMLMethod
                                                fujaba__IterAdapteeMethodsCallee = adaptee.iteratorOfMethods () ;
                                                while ( fujaba__IterAdapteeMethodsCallee.hasNext () )
                                                {
                                                   try
                                                   {
                                                      callee = (UMLMethod) fujaba__IterAdapteeMethodsCallee.next () ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) && !(uMLMethod5.equals (callee)) ) ;
                                                       
                                                      // Path search between ASTRootNode and MethodCallNode
                                                      // Bind methodCallNode3 : MethodCallNode
                                                      fujaba__IterRootToMethodCallNode3 = new ASTPathVisitor (root, MethodCallNode.class ) ;
                                                      while ( fujaba__IterRootToMethodCallNode3.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            methodCallNode3 = (de.upb.javaast.methodast.MethodCallNode) fujaba__IterRootToMethodCallNode3.next () ;
                                                             
                                                            // bind id: IdentifierNode
                                                            id = methodCallNode3.getIdentifier () ;
                                                            JavaSDM.ensure ( id != null ) ;
                                                             
                                                            // constraint
                                                            JavaSDM.ensure ( id.getName().equals(callee.getName()) ) ;
                                                             
                                                            {
                                                               //  for each flow
                                                               try
                                                               {
                                                                  fujaba__Success = false ;
                                                                   
                                                                  // check object adaptee is really bound
                                                                  JavaSDM.ensure ( adaptee != null ) ;
                                                                   
                                                                  // check object target is really bound
                                                                  JavaSDM.ensure ( target != null ) ;
                                                                   
                                                                  // check isomorphic binding
                                                                  JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                   
                                                                  // check object adapter is really bound
                                                                  JavaSDM.ensure ( adapter != null ) ;
                                                                   
                                                                  // check isomorphic binding
                                                                  JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                   
                                                                  // bind classAdapter: ClassAdapterAnnotation
                                                                  fujaba__IterAdapteeAnnotationsClassAdapter = adaptee.iteratorOfAnnotations () ;
                                                                  while ( !(fujaba__Success) && fujaba__IterAdapteeAnnotationsClassAdapter.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        fujaba__TmpObject = fujaba__IterAdapteeAnnotationsClassAdapter.next () ;
                                                                        JavaSDM.ensure ( fujaba__TmpObject instanceof ClassAdapterAnnotation ) ;
                                                                        classAdapter = (ClassAdapterAnnotation) fujaba__TmpObject ;
                                                                         
                                                                        // check Reverse-Qualified-Link 'elements' between classAdapter and adaptee
                                                                        JavaSDM.ensure ( classAdapter.hasInElements ("adaptee", adaptee) ) ;
                                                                         
                                                                        // check To-Many-Link 'elements' between classAdapter and target
                                                                        JavaSDM.ensure ( classAdapter.hasInElements ("target", target) ) ;
                                                                         
                                                                        // check To-Many-Link 'elements' between classAdapter and adapter
                                                                        JavaSDM.ensure ( classAdapter.hasInElements ("adapter", adapter) ) ;
                                                                         
                                                                        fujaba__Success = true ;
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                                  fujaba__Success = false ;
                                                               }
                                                                
                                                               if ( !(fujaba__Success) )
                                                               {
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object adaptee is really bound
                                                                     JavaSDM.ensure ( adaptee != null ) ;
                                                                      
                                                                     // check object target is really bound
                                                                     JavaSDM.ensure ( target != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(adaptee.equals (target)) ) ;
                                                                      
                                                                     // check object adapter is really bound
                                                                     JavaSDM.ensure ( adapter != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(adaptee.equals (adapter)) && !(target.equals (adapter)) ) ;
                                                                      
                                                                     // check object caller is really bound
                                                                     JavaSDM.ensure ( caller != null ) ;
                                                                      
                                                                     // check object root is really bound
                                                                     JavaSDM.ensure ( root != null ) ;
                                                                      
                                                                     // check object id is really bound
                                                                     JavaSDM.ensure ( id != null ) ;
                                                                      
                                                                     // check object callee is really bound
                                                                     JavaSDM.ensure ( callee != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                                      
                                                                     // create object
                                                                     classAdapter = new ClassAdapterAnnotation ( ) ;
                                                                      
                                                                     // assign statement
                                                                     classAdapter.setClassification (1);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToElements ("adaptee", adaptee);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToElements ("target", target);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToElements ("adapter", adapter);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToBoundObjects ("adaptee", adaptee);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToBoundObjects ("adapter", adapter);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToBoundObjects ("caller", caller);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToBoundObjects ("root", root);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToBoundObjects ("id", id);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToBoundObjects ("target", target);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToBoundObjects ("callee", callee);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object overridingMethod1 is really bound
                                                                     JavaSDM.ensure ( overridingMethod1 != null ) ;
                                                                      
                                                                     // check object generalization2 is really bound
                                                                     JavaSDM.ensure ( generalization2 != null ) ;
                                                                      
                                                                     // check object generalization4 is really bound
                                                                     JavaSDM.ensure ( generalization4 != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(generalization2.equals (generalization4)) ) ;
                                                                      
                                                                     // check object classAdapter is really bound
                                                                     JavaSDM.ensure ( classAdapter != null ) ;
                                                                      
                                                                     // create link
                                                                     classAdapter.addToAntecedentAnnos (overridingMethod1);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToAntecedentAnnos (generalization2);
                                                                      
                                                                     // create link
                                                                     classAdapter.addToAntecedentAnnos (generalization4);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  return (classAdapter) ;
                                                               }
                                                            } //  end for each flow
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object classAdapter is really bound
            JavaSDM.ensure ( classAdapter != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_OverridingMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (classAdapter) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("adaptee", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("target", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("adapter", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof OverridingMethodAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof GeneralizationAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Generalization", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAdapteeAnnotationsGeneralization37 = null ;
      Iterator fujaba__IterAdapteeAnnotationsGeneralization41 = null ;
      Iterator fujaba__IterAdapterMethodsCaller = null ;
      Iterator fujaba__IterGeneralization34ElementsAdapter = null ;
      Iterator fujaba__IterGeneralization37ElementsAdapter = null ;
      Iterator fujaba__IterGeneralization41ElementsAdapter = null ;
      Iterator fujaba__IterOverridingMethod40ElementsCaller = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod38 = null ;
      Iterator fujaba__IterTargetMethodsUMLMethod39 = null ;
      Iterator fujaba__IterUMLMethod39AnnotationsOverridingMethod40 = null ;
      GeneralizationAnnotation generalization34 = null ;
      GeneralizationAnnotation generalization37 = null ;
      GeneralizationAnnotation generalization41 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod40 = null ;
      UMLClass adaptee = null ;
      UMLClass adapter = null ;
      UMLClass target = null ;
      UMLMethod caller = null ;
      UMLMethod uMLMethod38 = null ;
      UMLMethod uMLMethod39 = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("OverridingMethod") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind generalization37: GeneralizationAnnotation
            fujaba__IterAdapteeAnnotationsGeneralization37 = adaptee.iteratorOfAnnotations () ;
            while ( fujaba__IterAdapteeAnnotationsGeneralization37.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterAdapteeAnnotationsGeneralization37.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                  generalization37 = (GeneralizationAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between generalization37 and adaptee
                  JavaSDM.ensure ( generalization37.hasInElements ("superClass", adaptee) ) ;
                   
                  // bind adapter: UMLClass
                  fujaba__IterGeneralization37ElementsAdapter = generalization37.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization37ElementsAdapter.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization37ElementsAdapter.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        adapter = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(adaptee.equals (adapter)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
                        while ( fujaba__IterAdapterMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                               
                              {
                                 //  for each flow
                                 set.add (caller);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod38: UMLMethod
            fujaba__IterTargetMethodsUMLMethod38 = target.iteratorOfMethods () ;
            while ( fujaba__IterTargetMethodsUMLMethod38.hasNext () )
            {
               try
               {
                  uMLMethod38 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod38.next () ;
                   
                  {
                     //  for each flow
                     set.add (uMLMethod38);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
            while ( fujaba__IterAdapterMethodsCaller.hasNext () )
            {
               try
               {
                  caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                   
                  {
                     //  for each flow
                     set.add (caller);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization37 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind adapter: UMLClass
            fujaba__IterGeneralization37ElementsAdapter = generalization37.iteratorOfElements ("subClass") ;
            while ( fujaba__IterGeneralization37ElementsAdapter.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization37ElementsAdapter.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  adapter = (UMLClass) fujaba__TmpObject ;
                   
                  // bind caller: UMLMethod
                  fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
                  while ( fujaba__IterAdapterMethodsCaller.hasNext () )
                  {
                     try
                     {
                        caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                         
                        {
                           //  for each flow
                           set.add (caller);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization34 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind adapter: UMLClass
            fujaba__IterGeneralization34ElementsAdapter = generalization34.iteratorOfElements ("subClass") ;
            while ( fujaba__IterGeneralization34ElementsAdapter.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization34ElementsAdapter.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  adapter = (UMLClass) fujaba__TmpObject ;
                   
                  // bind caller: UMLMethod
                  fujaba__IterAdapterMethodsCaller = adapter.iteratorOfMethods () ;
                  while ( fujaba__IterAdapterMethodsCaller.hasNext () )
                  {
                     try
                     {
                        caller = (UMLMethod) fujaba__IterAdapterMethodsCaller.next () ;
                         
                        {
                           //  for each flow
                           set.add (caller);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (adaptee);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind uMLMethod39: UMLMethod
            fujaba__IterTargetMethodsUMLMethod39 = target.iteratorOfMethods () ;
            while ( fujaba__IterTargetMethodsUMLMethod39.hasNext () )
            {
               try
               {
                  uMLMethod39 = (UMLMethod) fujaba__IterTargetMethodsUMLMethod39.next () ;
                   
                  // bind overridingMethod40: OverridingMethodAnnotation
                  fujaba__IterUMLMethod39AnnotationsOverridingMethod40 = uMLMethod39.iteratorOfAnnotations () ;
                  while ( fujaba__IterUMLMethod39AnnotationsOverridingMethod40.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterUMLMethod39AnnotationsOverridingMethod40.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                        overridingMethod40 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between overridingMethod40 and uMLMethod39
                        JavaSDM.ensure ( overridingMethod40.hasInElements ("overridden", uMLMethod39) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterOverridingMethod40ElementsCaller = overridingMethod40.iteratorOfElements ("overriding") ;
                        while ( fujaba__IterOverridingMethod40ElementsCaller.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterOverridingMethod40ElementsCaller.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              caller = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(uMLMethod39.equals (caller)) ) ;
                               
                              // bind adapter: UMLClass
                              adapter = caller.getParent () ;
                              JavaSDM.ensure ( adapter != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(target.equals (adapter)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (adapter);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (adapter);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod40 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterOverridingMethod40ElementsCaller = overridingMethod40.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod40ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod40ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind adapter: UMLClass
                  adapter = caller.getParent () ;
                  JavaSDM.ensure ( adapter != null ) ;
                   
                  {
                     //  for each flow
                     set.add (adapter);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization34 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind adapter: UMLClass
            fujaba__IterGeneralization34ElementsAdapter = generalization34.iteratorOfElements ("subClass") ;
            while ( fujaba__IterGeneralization34ElementsAdapter.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization34ElementsAdapter.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  adapter = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (adapter);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Generalization") || annotation.equals ("MultiLevelGeneralization") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adaptee = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind generalization41: GeneralizationAnnotation
            fujaba__IterAdapteeAnnotationsGeneralization41 = adaptee.iteratorOfAnnotations () ;
            while ( fujaba__IterAdapteeAnnotationsGeneralization41.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterAdapteeAnnotationsGeneralization41.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof GeneralizationAnnotation ) ;
                  generalization41 = (GeneralizationAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between generalization41 and adaptee
                  JavaSDM.ensure ( generalization41.hasInElements ("superClass", adaptee) ) ;
                   
                  // bind adapter: UMLClass
                  fujaba__IterGeneralization41ElementsAdapter = generalization41.iteratorOfElements ("subClass") ;
                  while ( fujaba__IterGeneralization41ElementsAdapter.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterGeneralization41ElementsAdapter.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        adapter = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(adaptee.equals (adapter)) ) ;
                         
                        {
                           //  for each flow
                           set.add (adapter);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            target = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (target);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            adapter = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (adapter);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod40 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind caller: UMLMethod
            fujaba__IterOverridingMethod40ElementsCaller = overridingMethod40.iteratorOfElements ("overriding") ;
            while ( fujaba__IterOverridingMethod40ElementsCaller.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod40ElementsCaller.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  caller = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind adapter: UMLClass
                  adapter = caller.getParent () ;
                  JavaSDM.ensure ( adapter != null ) ;
                   
                  {
                     //  for each flow
                     set.add (adapter);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof GeneralizationAnnotation ) ;
             
            // explicit type cast
            generalization41 = (GeneralizationAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind adapter: UMLClass
            fujaba__IterGeneralization41ElementsAdapter = generalization41.iteratorOfElements ("subClass") ;
            while ( fujaba__IterGeneralization41ElementsAdapter.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterGeneralization41ElementsAdapter.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  adapter = (UMLClass) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (adapter);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
