package de.upb.inferenceengine.engines;

import de.upb.inferenceengine.visitors.*;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.upb.javaast.methodast.IdentifierNode;
import de.upb.javaast.methodast.PrimaryExpressionNode;
import de.upb.javaast.methodast.MethodCallNode;
import de.uni_paderborn.fujaba.uml.ASTRootNode;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;

public class DelegationEngine
extends GFRNEngine
{
   private  DelegationEngine()
   {
   }

   private static DelegationEngine theDelegationEngine;

   public static DelegationEngine get()
   {
      if (theDelegationEngine == null)
      {
         theDelegationEngine = new DelegationEngine ();
      }
      return theDelegationEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation delegation = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         delegation = this.annotateUsingTrigger_ReferenceRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( delegation != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (delegation) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            delegation = this.annotateUsingCallerRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( delegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (delegation) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               delegation = this.annotateUsingCallerClassRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( delegation != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (delegation) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  delegation = this.annotateUsingCalleeRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( delegation != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (delegation) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     delegation = this.annotateUsingCalleeClassRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (delegation) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingCalleeClassRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToPrimaryExpressionNode14 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      DelegationAnnotation delegation = null ;
      Iterator fujaba__IterCalleeClassAnnotationsDelegation = null ;
      Iterator fujaba__IterCalleeClassAnnotationsReference13 = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterReference13ElementsRefField = null ;
      IdentifierNode id1 = null ;
      IdentifierNode id2 = null ;
      MethodCallNode methodCallNode15 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      de.upb.javaast.methodast.PrimaryExpressionNode primaryExpressionNode14 = null ;
      ReferenceAnnotation reference13 = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("calleeClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            calleeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind callee: UMLMethod
            fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
            while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
            {
               try
               {
                  callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                   
                  // bind reference13: ReferenceAnnotation
                  fujaba__IterCalleeClassAnnotationsReference13 = calleeClass.iteratorOfAnnotations () ;
                  while ( fujaba__IterCalleeClassAnnotationsReference13.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsReference13.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                        reference13 = (ReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between reference13 and calleeClass
                        JavaSDM.ensure ( reference13.hasInElements ("references", calleeClass) ) ;
                         
                        // bind refField: UMLAttr
                        fujaba__IterReference13ElementsRefField = reference13.iteratorOfElements ("field") ;
                        while ( fujaba__IterReference13ElementsRefField.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReference13ElementsRefField.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                              refField = (UMLAttr) fujaba__TmpObject ;
                               
                              // bind callerClass: UMLClass
                              callerClass = refField.getParent () ;
                              JavaSDM.ensure ( callerClass != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(calleeClass.equals (callerClass)) ) ;
                               
                              // bind caller: UMLMethod
                              fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                              while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                              {
                                 try
                                 {
                                    caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                                     
                                    // bind root: ASTRootNode
                                    root = caller.getASTRootNode () ;
                                    JavaSDM.ensure ( root != null ) ;
                                     
                                    // Path search between ASTRootNode and PrimaryExpressionNode
                                    // Bind primaryExpressionNode14 : PrimaryExpressionNode
                                    fujaba__IterRootToPrimaryExpressionNode14 = new ASTPathVisitor (root, PrimaryExpressionNode.class ) ;
                                    while ( fujaba__IterRootToPrimaryExpressionNode14.hasNext () )
                                    {
                                       try
                                       {
                                          primaryExpressionNode14 = (de.upb.javaast.methodast.PrimaryExpressionNode) fujaba__IterRootToPrimaryExpressionNode14.next () ;
                                           
                                          // bind id1: IdentifierNode
                                          id1 = primaryExpressionNode14.getIdentifier () ;
                                          JavaSDM.ensure ( id1 != null ) ;
                                           
                                          // check To-One-Link 'umlDeclaration' between id1 and refField
                                          JavaSDM.ensure ( (id1.getUmlDeclaration () != null) && id1.getUmlDeclaration ().equals (refField) ) ;
                                           
                                          // bind methodCallNode15: MethodCallNode
                                          fujaba__TmpObject = primaryExpressionNode14.getNextPrimaryExpression () ;
                                          JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.upb.javaast.methodast.MethodCallNode ) ;
                                          methodCallNode15 = (MethodCallNode) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(primaryExpressionNode14.equals (methodCallNode15)) ) ;
                                           
                                          // bind id2: IdentifierNode
                                          id2 = methodCallNode15.getIdentifier () ;
                                          JavaSDM.ensure ( id2 != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( id2.getName().equals(callee.getName()) ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object caller is really bound
                                                JavaSDM.ensure ( caller != null ) ;
                                                 
                                                // check object callee is really bound
                                                JavaSDM.ensure ( callee != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                 
                                                // check object callerClass is really bound
                                                JavaSDM.ensure ( callerClass != null ) ;
                                                 
                                                // check object calleeClass is really bound
                                                JavaSDM.ensure ( calleeClass != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                 
                                                // bind delegation: DelegationAnnotation
                                                fujaba__IterCalleeClassAnnotationsDelegation = calleeClass.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterCalleeClassAnnotationsDelegation.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsDelegation.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof DelegationAnnotation ) ;
                                                      delegation = (DelegationAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between delegation and calleeClass
                                                      JavaSDM.ensure ( delegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and caller
                                                      JavaSDM.ensure ( delegation.hasInElements ("caller", caller) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and callee
                                                      JavaSDM.ensure ( delegation.hasInElements ("callee", callee) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and callerClass
                                                      JavaSDM.ensure ( delegation.hasInElements ("callerClass", callerClass) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // check object callerClass is really bound
                                                   JavaSDM.ensure ( callerClass != null ) ;
                                                    
                                                   // check object calleeClass is really bound
                                                   JavaSDM.ensure ( calleeClass != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                    
                                                   // check object id1 is really bound
                                                   JavaSDM.ensure ( id1 != null ) ;
                                                    
                                                   // check object id2 is really bound
                                                   JavaSDM.ensure ( id2 != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                                    
                                                   // check object root is really bound
                                                   JavaSDM.ensure ( root != null ) ;
                                                    
                                                   // check object refField is really bound
                                                   JavaSDM.ensure ( refField != null ) ;
                                                    
                                                   // create object
                                                   delegation = new DelegationAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   delegation.setClassification (0);
                                                    
                                                   // create link
                                                   delegation.addToElements ("caller", caller);
                                                    
                                                   // create link
                                                   delegation.addToElements ("callee", callee);
                                                    
                                                   // create link
                                                   delegation.addToElements ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   delegation.addToElements ("calleeClass", calleeClass);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("id1", id1);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("id2", id2);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("root", root);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("refField", refField);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("callee", callee);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("calleeClass", calleeClass);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object reference13 is really bound
                                                   JavaSDM.ensure ( reference13 != null ) ;
                                                    
                                                   // check object delegation is really bound
                                                   JavaSDM.ensure ( delegation != null ) ;
                                                    
                                                   // create link
                                                   delegation.addToAntecedentAnnos (reference13);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (delegation) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object delegation is really bound
            JavaSDM.ensure ( delegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("calleeClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (delegation) ;
   }


   private GFRNAnnotation annotateUsingCalleeRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToPrimaryExpressionNode11 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      DelegationAnnotation delegation = null ;
      Iterator fujaba__IterCalleeClassAnnotationsReference10 = null ;
      Iterator fujaba__IterCallerClassAnnotationsDelegation = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterReference10ElementsRefField = null ;
      IdentifierNode id1 = null ;
      IdentifierNode id2 = null ;
      MethodCallNode methodCallNode12 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      de.upb.javaast.methodast.PrimaryExpressionNode primaryExpressionNode11 = null ;
      ReferenceAnnotation reference10 = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("callee", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            callee = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind calleeClass: UMLClass
            calleeClass = callee.getParent () ;
            JavaSDM.ensure ( calleeClass != null ) ;
             
            // bind reference10: ReferenceAnnotation
            fujaba__IterCalleeClassAnnotationsReference10 = calleeClass.iteratorOfAnnotations () ;
            while ( fujaba__IterCalleeClassAnnotationsReference10.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterCalleeClassAnnotationsReference10.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                  reference10 = (ReferenceAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between reference10 and calleeClass
                  JavaSDM.ensure ( reference10.hasInElements ("references", calleeClass) ) ;
                   
                  // bind refField: UMLAttr
                  fujaba__IterReference10ElementsRefField = reference10.iteratorOfElements ("field") ;
                  while ( fujaba__IterReference10ElementsRefField.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReference10ElementsRefField.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                        refField = (UMLAttr) fujaba__TmpObject ;
                         
                        // bind callerClass: UMLClass
                        callerClass = refField.getParent () ;
                        JavaSDM.ensure ( callerClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(calleeClass.equals (callerClass)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                        while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callee.equals (caller)) ) ;
                               
                              // bind root: ASTRootNode
                              root = caller.getASTRootNode () ;
                              JavaSDM.ensure ( root != null ) ;
                               
                              // Path search between ASTRootNode and PrimaryExpressionNode
                              // Bind primaryExpressionNode11 : PrimaryExpressionNode
                              fujaba__IterRootToPrimaryExpressionNode11 = new ASTPathVisitor (root, PrimaryExpressionNode.class ) ;
                              while ( fujaba__IterRootToPrimaryExpressionNode11.hasNext () )
                              {
                                 try
                                 {
                                    primaryExpressionNode11 = (de.upb.javaast.methodast.PrimaryExpressionNode) fujaba__IterRootToPrimaryExpressionNode11.next () ;
                                     
                                    // bind id1: IdentifierNode
                                    id1 = primaryExpressionNode11.getIdentifier () ;
                                    JavaSDM.ensure ( id1 != null ) ;
                                     
                                    // check To-One-Link 'umlDeclaration' between id1 and refField
                                    JavaSDM.ensure ( (id1.getUmlDeclaration () != null) && id1.getUmlDeclaration ().equals (refField) ) ;
                                     
                                    // bind methodCallNode12: MethodCallNode
                                    fujaba__TmpObject = primaryExpressionNode11.getNextPrimaryExpression () ;
                                    JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.upb.javaast.methodast.MethodCallNode ) ;
                                    methodCallNode12 = (MethodCallNode) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(primaryExpressionNode11.equals (methodCallNode12)) ) ;
                                     
                                    // bind id2: IdentifierNode
                                    id2 = methodCallNode12.getIdentifier () ;
                                    JavaSDM.ensure ( id2 != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                     
                                    // constraint
                                    JavaSDM.ensure ( id2.getName().equals(callee.getName()) ) ;
                                     
                                    // constraint
                                    JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                     
                                    {
                                       //  for each flow
                                       try
                                       {
                                          fujaba__Success = false ;
                                           
                                          // check object caller is really bound
                                          JavaSDM.ensure ( caller != null ) ;
                                           
                                          // check object callee is really bound
                                          JavaSDM.ensure ( callee != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                           
                                          // check object callerClass is really bound
                                          JavaSDM.ensure ( callerClass != null ) ;
                                           
                                          // check object calleeClass is really bound
                                          JavaSDM.ensure ( calleeClass != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                           
                                          // bind delegation: DelegationAnnotation
                                          fujaba__IterCallerClassAnnotationsDelegation = callerClass.iteratorOfAnnotations () ;
                                          while ( !(fujaba__Success) && fujaba__IterCallerClassAnnotationsDelegation.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterCallerClassAnnotationsDelegation.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof DelegationAnnotation ) ;
                                                delegation = (DelegationAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between delegation and callerClass
                                                JavaSDM.ensure ( delegation.hasInElements ("callerClass", callerClass) ) ;
                                                 
                                                // check To-Many-Link 'elements' between delegation and caller
                                                JavaSDM.ensure ( delegation.hasInElements ("caller", caller) ) ;
                                                 
                                                // check To-Many-Link 'elements' between delegation and callee
                                                JavaSDM.ensure ( delegation.hasInElements ("callee", callee) ) ;
                                                 
                                                // check To-Many-Link 'elements' between delegation and calleeClass
                                                JavaSDM.ensure ( delegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                 
                                                fujaba__Success = true ;
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                          fujaba__Success = false ;
                                       }
                                        
                                       if ( !(fujaba__Success) )
                                       {
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object caller is really bound
                                             JavaSDM.ensure ( caller != null ) ;
                                              
                                             // check object callee is really bound
                                             JavaSDM.ensure ( callee != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                              
                                             // check object callerClass is really bound
                                             JavaSDM.ensure ( callerClass != null ) ;
                                              
                                             // check object calleeClass is really bound
                                             JavaSDM.ensure ( calleeClass != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                              
                                             // check object id1 is really bound
                                             JavaSDM.ensure ( id1 != null ) ;
                                              
                                             // check object id2 is really bound
                                             JavaSDM.ensure ( id2 != null ) ;
                                              
                                             // check isomorphic binding
                                             JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                              
                                             // check object root is really bound
                                             JavaSDM.ensure ( root != null ) ;
                                              
                                             // check object refField is really bound
                                             JavaSDM.ensure ( refField != null ) ;
                                              
                                             // create object
                                             delegation = new DelegationAnnotation ( ) ;
                                              
                                             // assign statement
                                             delegation.setClassification (0);
                                              
                                             // create link
                                             delegation.addToElements ("caller", caller);
                                              
                                             // create link
                                             delegation.addToElements ("callee", callee);
                                              
                                             // create link
                                             delegation.addToElements ("callerClass", callerClass);
                                              
                                             // create link
                                             delegation.addToElements ("calleeClass", calleeClass);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("caller", caller);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("id1", id1);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("id2", id2);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("root", root);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("refField", refField);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("callerClass", callerClass);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("callee", callee);
                                              
                                             // create link
                                             delegation.addToBoundObjects ("calleeClass", calleeClass);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          try
                                          {
                                             fujaba__Success = false ;
                                              
                                             // check object reference10 is really bound
                                             JavaSDM.ensure ( reference10 != null ) ;
                                              
                                             // check object delegation is really bound
                                             JavaSDM.ensure ( delegation != null ) ;
                                              
                                             // create link
                                             delegation.addToAntecedentAnnos (reference10);
                                              
                                             fujaba__Success = true ;
                                          }
                                          catch ( JavaSDMException fujaba__InternalException )
                                          {
                                             fujaba__Success = false ;
                                          }
                                           
                                          return (delegation) ;
                                       }
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object delegation is really bound
            JavaSDM.ensure ( delegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("callee", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (delegation) ;
   }


   private GFRNAnnotation annotateUsingCallerClassRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToPrimaryExpressionNode8 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      DelegationAnnotation delegation = null ;
      Iterator fujaba__IterCalleeAnnotationsDelegation = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassAttrsRefField = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterRefFieldAnnotationsReference7 = null ;
      Iterator fujaba__IterReference7ElementsCalleeClass = null ;
      IdentifierNode id1 = null ;
      IdentifierNode id2 = null ;
      MethodCallNode methodCallNode9 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      de.upb.javaast.methodast.PrimaryExpressionNode primaryExpressionNode8 = null ;
      ReferenceAnnotation reference7 = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("callerClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            callerClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind refField: UMLAttr
            fujaba__IterCallerClassAttrsRefField = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsRefField.hasNext () )
            {
               try
               {
                  refField = (UMLAttr) fujaba__IterCallerClassAttrsRefField.next () ;
                   
                  // bind caller: UMLMethod
                  fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                  while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                  {
                     try
                     {
                        caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                         
                        // bind root: ASTRootNode
                        root = caller.getASTRootNode () ;
                        JavaSDM.ensure ( root != null ) ;
                         
                        // bind reference7: ReferenceAnnotation
                        fujaba__IterRefFieldAnnotationsReference7 = refField.iteratorOfAnnotations () ;
                        while ( fujaba__IterRefFieldAnnotationsReference7.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterRefFieldAnnotationsReference7.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference7 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference7 and refField
                              JavaSDM.ensure ( reference7.hasInElements ("field", refField) ) ;
                               
                              // bind calleeClass: UMLClass
                              fujaba__IterReference7ElementsCalleeClass = reference7.iteratorOfElements ("references") ;
                              while ( fujaba__IterReference7ElementsCalleeClass.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterReference7ElementsCalleeClass.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                    calleeClass = (UMLClass) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                     
                                    // bind callee: UMLMethod
                                    fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                                    while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                                    {
                                       try
                                       {
                                          callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                           
                                          // Path search between ASTRootNode and PrimaryExpressionNode
                                          // Bind primaryExpressionNode8 : PrimaryExpressionNode
                                          fujaba__IterRootToPrimaryExpressionNode8 = new ASTPathVisitor (root, PrimaryExpressionNode.class ) ;
                                          while ( fujaba__IterRootToPrimaryExpressionNode8.hasNext () )
                                          {
                                             try
                                             {
                                                primaryExpressionNode8 = (de.upb.javaast.methodast.PrimaryExpressionNode) fujaba__IterRootToPrimaryExpressionNode8.next () ;
                                                 
                                                // bind id1: IdentifierNode
                                                id1 = primaryExpressionNode8.getIdentifier () ;
                                                JavaSDM.ensure ( id1 != null ) ;
                                                 
                                                // check To-One-Link 'umlDeclaration' between id1 and refField
                                                JavaSDM.ensure ( (id1.getUmlDeclaration () != null) && id1.getUmlDeclaration ().equals (refField) ) ;
                                                 
                                                // bind methodCallNode9: MethodCallNode
                                                fujaba__TmpObject = primaryExpressionNode8.getNextPrimaryExpression () ;
                                                JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.upb.javaast.methodast.MethodCallNode ) ;
                                                methodCallNode9 = (MethodCallNode) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(primaryExpressionNode8.equals (methodCallNode9)) ) ;
                                                 
                                                // bind id2: IdentifierNode
                                                id2 = methodCallNode9.getIdentifier () ;
                                                JavaSDM.ensure ( id2 != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( id2.getName().equals(callee.getName()) ) ;
                                                 
                                                // constraint
                                                JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object caller is really bound
                                                      JavaSDM.ensure ( caller != null ) ;
                                                       
                                                      // check object callee is really bound
                                                      JavaSDM.ensure ( callee != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                       
                                                      // check object callerClass is really bound
                                                      JavaSDM.ensure ( callerClass != null ) ;
                                                       
                                                      // check object calleeClass is really bound
                                                      JavaSDM.ensure ( calleeClass != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                       
                                                      // bind delegation: DelegationAnnotation
                                                      fujaba__IterCalleeAnnotationsDelegation = callee.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterCalleeAnnotationsDelegation.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterCalleeAnnotationsDelegation.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof DelegationAnnotation ) ;
                                                            delegation = (DelegationAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between delegation and callee
                                                            JavaSDM.ensure ( delegation.hasInElements ("callee", callee) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between delegation and caller
                                                            JavaSDM.ensure ( delegation.hasInElements ("caller", caller) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between delegation and callerClass
                                                            JavaSDM.ensure ( delegation.hasInElements ("callerClass", callerClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between delegation and calleeClass
                                                            JavaSDM.ensure ( delegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object caller is really bound
                                                         JavaSDM.ensure ( caller != null ) ;
                                                          
                                                         // check object callee is really bound
                                                         JavaSDM.ensure ( callee != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                          
                                                         // check object callerClass is really bound
                                                         JavaSDM.ensure ( callerClass != null ) ;
                                                          
                                                         // check object calleeClass is really bound
                                                         JavaSDM.ensure ( calleeClass != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                          
                                                         // check object id1 is really bound
                                                         JavaSDM.ensure ( id1 != null ) ;
                                                          
                                                         // check object id2 is really bound
                                                         JavaSDM.ensure ( id2 != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                                          
                                                         // check object root is really bound
                                                         JavaSDM.ensure ( root != null ) ;
                                                          
                                                         // check object refField is really bound
                                                         JavaSDM.ensure ( refField != null ) ;
                                                          
                                                         // create object
                                                         delegation = new DelegationAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         delegation.setClassification (0);
                                                          
                                                         // create link
                                                         delegation.addToElements ("caller", caller);
                                                          
                                                         // create link
                                                         delegation.addToElements ("callee", callee);
                                                          
                                                         // create link
                                                         delegation.addToElements ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         delegation.addToElements ("calleeClass", calleeClass);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("caller", caller);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("id1", id1);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("id2", id2);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("root", root);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("refField", refField);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("callerClass", callerClass);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("callee", callee);
                                                          
                                                         // create link
                                                         delegation.addToBoundObjects ("calleeClass", calleeClass);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object reference7 is really bound
                                                         JavaSDM.ensure ( reference7 != null ) ;
                                                          
                                                         // check object delegation is really bound
                                                         JavaSDM.ensure ( delegation != null ) ;
                                                          
                                                         // create link
                                                         delegation.addToAntecedentAnnos (reference7);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (delegation) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object delegation is really bound
            JavaSDM.ensure ( delegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("callerClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (delegation) ;
   }


   private GFRNAnnotation annotateUsingCallerRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToPrimaryExpressionNode5 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      DelegationAnnotation delegation = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassAnnotationsDelegation = null ;
      Iterator fujaba__IterCallerClassAttrsRefField = null ;
      Iterator fujaba__IterRefFieldAnnotationsReference4 = null ;
      Iterator fujaba__IterReference4ElementsCalleeClass = null ;
      IdentifierNode id1 = null ;
      IdentifierNode id2 = null ;
      MethodCallNode methodCallNode6 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      de.upb.javaast.methodast.PrimaryExpressionNode primaryExpressionNode5 = null ;
      ReferenceAnnotation reference4 = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("caller", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            caller = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind root: ASTRootNode
            root = caller.getASTRootNode () ;
            JavaSDM.ensure ( root != null ) ;
             
            // bind callerClass: UMLClass
            callerClass = caller.getParent () ;
            JavaSDM.ensure ( callerClass != null ) ;
             
            // bind refField: UMLAttr
            fujaba__IterCallerClassAttrsRefField = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsRefField.hasNext () )
            {
               try
               {
                  refField = (UMLAttr) fujaba__IterCallerClassAttrsRefField.next () ;
                   
                  // bind reference4: ReferenceAnnotation
                  fujaba__IterRefFieldAnnotationsReference4 = refField.iteratorOfAnnotations () ;
                  while ( fujaba__IterRefFieldAnnotationsReference4.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterRefFieldAnnotationsReference4.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                        reference4 = (ReferenceAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between reference4 and refField
                        JavaSDM.ensure ( reference4.hasInElements ("field", refField) ) ;
                         
                        // bind calleeClass: UMLClass
                        fujaba__IterReference4ElementsCalleeClass = reference4.iteratorOfElements ("references") ;
                        while ( fujaba__IterReference4ElementsCalleeClass.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterReference4ElementsCalleeClass.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              calleeClass = (UMLClass) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                               
                              // bind callee: UMLMethod
                              fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                              while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                              {
                                 try
                                 {
                                    callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                     
                                    // Path search between ASTRootNode and PrimaryExpressionNode
                                    // Bind primaryExpressionNode5 : PrimaryExpressionNode
                                    fujaba__IterRootToPrimaryExpressionNode5 = new ASTPathVisitor (root, PrimaryExpressionNode.class ) ;
                                    while ( fujaba__IterRootToPrimaryExpressionNode5.hasNext () )
                                    {
                                       try
                                       {
                                          primaryExpressionNode5 = (de.upb.javaast.methodast.PrimaryExpressionNode) fujaba__IterRootToPrimaryExpressionNode5.next () ;
                                           
                                          // bind id1: IdentifierNode
                                          id1 = primaryExpressionNode5.getIdentifier () ;
                                          JavaSDM.ensure ( id1 != null ) ;
                                           
                                          // check To-One-Link 'umlDeclaration' between id1 and refField
                                          JavaSDM.ensure ( (id1.getUmlDeclaration () != null) && id1.getUmlDeclaration ().equals (refField) ) ;
                                           
                                          // bind methodCallNode6: MethodCallNode
                                          fujaba__TmpObject = primaryExpressionNode5.getNextPrimaryExpression () ;
                                          JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.upb.javaast.methodast.MethodCallNode ) ;
                                          methodCallNode6 = (MethodCallNode) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(primaryExpressionNode5.equals (methodCallNode6)) ) ;
                                           
                                          // bind id2: IdentifierNode
                                          id2 = methodCallNode6.getIdentifier () ;
                                          JavaSDM.ensure ( id2 != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( id2.getName().equals(callee.getName()) ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object caller is really bound
                                                JavaSDM.ensure ( caller != null ) ;
                                                 
                                                // check object callee is really bound
                                                JavaSDM.ensure ( callee != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                 
                                                // check object callerClass is really bound
                                                JavaSDM.ensure ( callerClass != null ) ;
                                                 
                                                // check object calleeClass is really bound
                                                JavaSDM.ensure ( calleeClass != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                 
                                                // bind delegation: DelegationAnnotation
                                                fujaba__IterCallerClassAnnotationsDelegation = callerClass.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterCallerClassAnnotationsDelegation.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterCallerClassAnnotationsDelegation.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof DelegationAnnotation ) ;
                                                      delegation = (DelegationAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between delegation and callerClass
                                                      JavaSDM.ensure ( delegation.hasInElements ("callerClass", callerClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and caller
                                                      JavaSDM.ensure ( delegation.hasInElements ("caller", caller) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and callee
                                                      JavaSDM.ensure ( delegation.hasInElements ("callee", callee) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and calleeClass
                                                      JavaSDM.ensure ( delegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // check object callerClass is really bound
                                                   JavaSDM.ensure ( callerClass != null ) ;
                                                    
                                                   // check object calleeClass is really bound
                                                   JavaSDM.ensure ( calleeClass != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                    
                                                   // check object id1 is really bound
                                                   JavaSDM.ensure ( id1 != null ) ;
                                                    
                                                   // check object id2 is really bound
                                                   JavaSDM.ensure ( id2 != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                                    
                                                   // check object root is really bound
                                                   JavaSDM.ensure ( root != null ) ;
                                                    
                                                   // check object refField is really bound
                                                   JavaSDM.ensure ( refField != null ) ;
                                                    
                                                   // create object
                                                   delegation = new DelegationAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   delegation.setClassification (0);
                                                    
                                                   // create link
                                                   delegation.addToElements ("caller", caller);
                                                    
                                                   // create link
                                                   delegation.addToElements ("callee", callee);
                                                    
                                                   // create link
                                                   delegation.addToElements ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   delegation.addToElements ("calleeClass", calleeClass);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("id1", id1);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("id2", id2);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("root", root);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("refField", refField);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("callee", callee);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("calleeClass", calleeClass);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object reference4 is really bound
                                                   JavaSDM.ensure ( reference4 != null ) ;
                                                    
                                                   // check object delegation is really bound
                                                   JavaSDM.ensure ( delegation != null ) ;
                                                    
                                                   // create link
                                                   delegation.addToAntecedentAnnos (reference4);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (delegation) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object delegation is really bound
            JavaSDM.ensure ( delegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("caller", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (delegation) ;
   }


   private GFRNAnnotation annotateUsingTrigger_ReferenceRole(ASGElement asgElement)
   {
      ASTPathVisitor fujaba__IterRootToPrimaryExpressionNode2 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      DelegationAnnotation delegation = null ;
      Iterator fujaba__IterCalleeClassMethodsCallee = null ;
      Iterator fujaba__IterCallerClassAnnotationsDelegation = null ;
      Iterator fujaba__IterCallerClassMethodsCaller = null ;
      Iterator fujaba__IterReference1ElementsCalleeClass = null ;
      Iterator fujaba__IterReference1ElementsRefField = null ;
      IdentifierNode id1 = null ;
      IdentifierNode id2 = null ;
      MethodCallNode methodCallNode3 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      de.upb.javaast.methodast.PrimaryExpressionNode primaryExpressionNode2 = null ;
      ReferenceAnnotation reference1 = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference1 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind refField: UMLAttr
            fujaba__IterReference1ElementsRefField = reference1.iteratorOfElements ("field") ;
            while ( fujaba__IterReference1ElementsRefField.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference1ElementsRefField.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                  refField = (UMLAttr) fujaba__TmpObject ;
                   
                  // bind callerClass: UMLClass
                  callerClass = refField.getParent () ;
                  JavaSDM.ensure ( callerClass != null ) ;
                   
                  // bind calleeClass: UMLClass
                  fujaba__IterReference1ElementsCalleeClass = reference1.iteratorOfElements ("references") ;
                  while ( fujaba__IterReference1ElementsCalleeClass.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReference1ElementsCalleeClass.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        calleeClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                         
                        // bind caller: UMLMethod
                        fujaba__IterCallerClassMethodsCaller = callerClass.iteratorOfMethods () ;
                        while ( fujaba__IterCallerClassMethodsCaller.hasNext () )
                        {
                           try
                           {
                              caller = (UMLMethod) fujaba__IterCallerClassMethodsCaller.next () ;
                               
                              // bind root: ASTRootNode
                              root = caller.getASTRootNode () ;
                              JavaSDM.ensure ( root != null ) ;
                               
                              // bind callee: UMLMethod
                              fujaba__IterCalleeClassMethodsCallee = calleeClass.iteratorOfMethods () ;
                              while ( fujaba__IterCalleeClassMethodsCallee.hasNext () )
                              {
                                 try
                                 {
                                    callee = (UMLMethod) fujaba__IterCalleeClassMethodsCallee.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                     
                                    // Path search between ASTRootNode and PrimaryExpressionNode
                                    // Bind primaryExpressionNode2 : PrimaryExpressionNode
                                    fujaba__IterRootToPrimaryExpressionNode2 = new ASTPathVisitor (root, PrimaryExpressionNode.class ) ;
                                    while ( fujaba__IterRootToPrimaryExpressionNode2.hasNext () )
                                    {
                                       try
                                       {
                                          primaryExpressionNode2 = (de.upb.javaast.methodast.PrimaryExpressionNode) fujaba__IterRootToPrimaryExpressionNode2.next () ;
                                           
                                          // bind id1: IdentifierNode
                                          id1 = primaryExpressionNode2.getIdentifier () ;
                                          JavaSDM.ensure ( id1 != null ) ;
                                           
                                          // check To-One-Link 'umlDeclaration' between id1 and refField
                                          JavaSDM.ensure ( (id1.getUmlDeclaration () != null) && id1.getUmlDeclaration ().equals (refField) ) ;
                                           
                                          // bind methodCallNode3: MethodCallNode
                                          fujaba__TmpObject = primaryExpressionNode2.getNextPrimaryExpression () ;
                                          JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.upb.javaast.methodast.MethodCallNode ) ;
                                          methodCallNode3 = (MethodCallNode) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(primaryExpressionNode2.equals (methodCallNode3)) ) ;
                                           
                                          // bind id2: IdentifierNode
                                          id2 = methodCallNode3.getIdentifier () ;
                                          JavaSDM.ensure ( id2 != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( id2.getName().equals(callee.getName()) ) ;
                                           
                                          // constraint
                                          JavaSDM.ensure ( caller.getName().equals(callee.getName()) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object caller is really bound
                                                JavaSDM.ensure ( caller != null ) ;
                                                 
                                                // check object callee is really bound
                                                JavaSDM.ensure ( callee != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                 
                                                // check object callerClass is really bound
                                                JavaSDM.ensure ( callerClass != null ) ;
                                                 
                                                // check object calleeClass is really bound
                                                JavaSDM.ensure ( calleeClass != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                 
                                                // bind delegation: DelegationAnnotation
                                                fujaba__IterCallerClassAnnotationsDelegation = callerClass.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterCallerClassAnnotationsDelegation.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterCallerClassAnnotationsDelegation.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof DelegationAnnotation ) ;
                                                      delegation = (DelegationAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between delegation and callerClass
                                                      JavaSDM.ensure ( delegation.hasInElements ("callerClass", callerClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and caller
                                                      JavaSDM.ensure ( delegation.hasInElements ("caller", caller) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and callee
                                                      JavaSDM.ensure ( delegation.hasInElements ("callee", callee) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between delegation and calleeClass
                                                      JavaSDM.ensure ( delegation.hasInElements ("calleeClass", calleeClass) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object caller is really bound
                                                   JavaSDM.ensure ( caller != null ) ;
                                                    
                                                   // check object callee is really bound
                                                   JavaSDM.ensure ( callee != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(caller.equals (callee)) ) ;
                                                    
                                                   // check object callerClass is really bound
                                                   JavaSDM.ensure ( callerClass != null ) ;
                                                    
                                                   // check object calleeClass is really bound
                                                   JavaSDM.ensure ( calleeClass != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(callerClass.equals (calleeClass)) ) ;
                                                    
                                                   // check object id1 is really bound
                                                   JavaSDM.ensure ( id1 != null ) ;
                                                    
                                                   // check object id2 is really bound
                                                   JavaSDM.ensure ( id2 != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(id1.equals (id2)) ) ;
                                                    
                                                   // check object root is really bound
                                                   JavaSDM.ensure ( root != null ) ;
                                                    
                                                   // check object refField is really bound
                                                   JavaSDM.ensure ( refField != null ) ;
                                                    
                                                   // create object
                                                   delegation = new DelegationAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   delegation.setClassification (0);
                                                    
                                                   // create link
                                                   delegation.addToElements ("caller", caller);
                                                    
                                                   // create link
                                                   delegation.addToElements ("callee", callee);
                                                    
                                                   // create link
                                                   delegation.addToElements ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   delegation.addToElements ("calleeClass", calleeClass);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("caller", caller);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("id1", id1);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("id2", id2);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("root", root);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("refField", refField);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("callerClass", callerClass);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("callee", callee);
                                                    
                                                   // create link
                                                   delegation.addToBoundObjects ("calleeClass", calleeClass);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object reference1 is really bound
                                                   JavaSDM.ensure ( reference1 != null ) ;
                                                    
                                                   // check object delegation is really bound
                                                   JavaSDM.ensure ( delegation != null ) ;
                                                    
                                                   // create link
                                                   delegation.addToAntecedentAnnos (reference1);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (delegation) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object delegation is really bound
            JavaSDM.ensure ( delegation != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Reference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (delegation) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("caller", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("callee", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("callerClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("calleeClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof ReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      ASTPathVisitor fujaba__IterRootToPrimaryExpressionNode16 = null ;
      ASTRootNode root = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterCallerClassAttrsRefField = null ;
      IdentifierNode id1 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      de.upb.javaast.methodast.PrimaryExpressionNode primaryExpressionNode16 = null ;
      UMLAttr refField = null ;
      UMLClass calleeClass = null ;
      UMLClass callerClass = null ;
      UMLMethod callee = null ;
      UMLMethod caller = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("Reference") || annotation.equals ("MultiReference") || annotation.equals ("ArrayReference") || annotation.equals ("SingleReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            caller = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind root: ASTRootNode
            root = caller.getASTRootNode () ;
            JavaSDM.ensure ( root != null ) ;
             
            // Path search between ASTRootNode and PrimaryExpressionNode
            // Bind primaryExpressionNode16 : PrimaryExpressionNode
            fujaba__IterRootToPrimaryExpressionNode16 = new ASTPathVisitor (root, PrimaryExpressionNode.class ) ;
            while ( fujaba__IterRootToPrimaryExpressionNode16.hasNext () )
            {
               try
               {
                  primaryExpressionNode16 = (de.upb.javaast.methodast.PrimaryExpressionNode) fujaba__IterRootToPrimaryExpressionNode16.next () ;
                   
                  // bind id1: IdentifierNode
                  id1 = primaryExpressionNode16.getIdentifier () ;
                  JavaSDM.ensure ( id1 != null ) ;
                   
                  // bind refField: UMLAttr
                  fujaba__TmpObject = id1.getUmlDeclaration () ;
                  JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                  refField = (UMLAttr) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (refField);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            callee = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // bind calleeClass: UMLClass
            calleeClass = callee.getParent () ;
            JavaSDM.ensure ( calleeClass != null ) ;
             
            {
               //  for each flow
               set.add (calleeClass);
            } //  end for each flow
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            callerClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind refField: UMLAttr
            fujaba__IterCallerClassAttrsRefField = callerClass.iteratorOfAttrs () ;
            while ( fujaba__IterCallerClassAttrsRefField.hasNext () )
            {
               try
               {
                  refField = (UMLAttr) fujaba__IterCallerClassAttrsRefField.next () ;
                   
                  {
                     //  for each flow
                     set.add (refField);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            calleeClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (calleeClass);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
