package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLAttr;

public class MultiReferenceEngine
extends GFRNEngine
{
   private  MultiReferenceEngine()
   {
   }

   private static MultiReferenceEngine theMultiReferenceEngine;

   public static MultiReferenceEngine get()
   {
      if (theMultiReferenceEngine == null)
      {
         theMultiReferenceEngine = new MultiReferenceEngine ();
      }
      return theMultiReferenceEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation multiReference = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         multiReference = this.annotateUsingReferencesRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( multiReference != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (multiReference) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            multiReference = this.annotateUsingTrigger_AssignmentToContainerRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( multiReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (multiReference) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               multiReference = this.annotateUsingFieldRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( multiReference != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (multiReference) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  multiReference = this.annotateUsingReferencingClassRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               return (multiReference) ;
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingFieldRole(ASGElement asgElement)
   {
      AssignmentToContainerAnnotation assignmentToContainer3 = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAssignmentToContainer3ElementsParam = null ;
      Iterator fujaba__IterReferencingClassAnnotationsMultiReference = null ;
      Iterator fujaba__IterReferencingFieldAnnotationsAssignmentToContainer3 = null ;
      MultiReferenceAnnotation multiReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
      UMLParam param = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
             
            // explicit type cast
            referencingField = (UMLAttr) fujaba__tmpTypeCastObject ;
             
            // bind referencingClass: UMLClass
            referencingClass = referencingField.getParent () ;
            JavaSDM.ensure ( referencingClass != null ) ;
             
            // bind assignmentToContainer3: AssignmentToContainerAnnotation
            fujaba__IterReferencingFieldAnnotationsAssignmentToContainer3 = referencingField.iteratorOfAnnotations () ;
            while ( fujaba__IterReferencingFieldAnnotationsAssignmentToContainer3.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsAssignmentToContainer3.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof AssignmentToContainerAnnotation ) ;
                  assignmentToContainer3 = (AssignmentToContainerAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between assignmentToContainer3 and referencingField
                  JavaSDM.ensure ( assignmentToContainer3.hasInElements ("field", referencingField) ) ;
                   
                  // bind param: UMLParam
                  fujaba__IterAssignmentToContainer3ElementsParam = assignmentToContainer3.iteratorOfElements ("param") ;
                  while ( fujaba__IterAssignmentToContainer3ElementsParam.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAssignmentToContainer3ElementsParam.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                        param = (UMLParam) fujaba__TmpObject ;
                         
                        // bind referredClass: UMLClass
                        fujaba__TmpObject = param.getParamType () ;
                        JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        referredClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                         
                        {
                           //  for each flow
                           try
                           {
                              fujaba__Success = false ;
                               
                              // check object referencingField is really bound
                              JavaSDM.ensure ( referencingField != null ) ;
                               
                              // check object referredClass is really bound
                              JavaSDM.ensure ( referredClass != null ) ;
                               
                              // check object referencingClass is really bound
                              JavaSDM.ensure ( referencingClass != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                               
                              // bind multiReference: MultiReferenceAnnotation
                              fujaba__IterReferencingClassAnnotationsMultiReference = referencingClass.iteratorOfAnnotations () ;
                              while ( !(fujaba__Success) && fujaba__IterReferencingClassAnnotationsMultiReference.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterReferencingClassAnnotationsMultiReference.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                                    multiReference = (MultiReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between multiReference and referencingClass
                                    JavaSDM.ensure ( multiReference.hasInElements ("referencingClass", referencingClass) ) ;
                                     
                                    // check To-Many-Link 'elements' between multiReference and referencingField
                                    JavaSDM.ensure ( multiReference.hasInElements ("field", referencingField) ) ;
                                     
                                    // check To-Many-Link 'elements' between multiReference and referredClass
                                    JavaSDM.ensure ( multiReference.hasInElements ("references", referredClass) ) ;
                                     
                                    fujaba__Success = true ;
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                              fujaba__Success = false ;
                           }
                            
                           if ( !(fujaba__Success) )
                           {
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 // check object referencingField is really bound
                                 JavaSDM.ensure ( referencingField != null ) ;
                                  
                                 // check object referredClass is really bound
                                 JavaSDM.ensure ( referredClass != null ) ;
                                  
                                 // check object referencingClass is really bound
                                 JavaSDM.ensure ( referencingClass != null ) ;
                                  
                                 // check isomorphic binding
                                 JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                                  
                                 // check object param is really bound
                                 JavaSDM.ensure ( param != null ) ;
                                  
                                 // create object
                                 multiReference = new MultiReferenceAnnotation ( ) ;
                                  
                                 // assign statement
                                 multiReference.setClassification (0);
                                  
                                 // create link
                                 multiReference.addToElements ("field", referencingField);
                                  
                                 // create link
                                 multiReference.addToElements ("references", referredClass);
                                  
                                 // create link
                                 multiReference.addToElements ("referencingClass", referencingClass);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("param", param);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("referredClass", referredClass);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("referencingField", referencingField);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("referencingClass", referencingClass);
                                  
                                 fujaba__Success = true ;
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 // check object assignmentToContainer3 is really bound
                                 JavaSDM.ensure ( assignmentToContainer3 != null ) ;
                                  
                                 // check object multiReference is really bound
                                 JavaSDM.ensure ( multiReference != null ) ;
                                  
                                 // create link
                                 multiReference.addToAntecedentAnnos (assignmentToContainer3);
                                  
                                 fujaba__Success = true ;
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              return (multiReference) ;
                           }
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiReference is really bound
            JavaSDM.ensure ( multiReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("field", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiReference) ;
   }


   private GFRNAnnotation annotateUsingReferencesRole(ASGElement asgElement)
   {
      AssignmentToContainerAnnotation assignmentToContainer1 = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAssignmentToContainer1ElementsReferencingField = null ;
      Iterator fujaba__IterParamAnnotationsAssignmentToContainer1 = null ;
      Iterator fujaba__IterReferencingClassAnnotationsMultiReference = null ;
      Iterator fujaba__IterReferredClassRevParamTypeParam = null ;
      MultiReferenceAnnotation multiReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
      UMLParam param = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referredClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind param: UMLParam
            fujaba__IterReferredClassRevParamTypeParam = referredClass.iteratorOfRevParamType () ;
            while ( fujaba__IterReferredClassRevParamTypeParam.hasNext () )
            {
               try
               {
                  param = (UMLParam) fujaba__IterReferredClassRevParamTypeParam.next () ;
                   
                  // bind assignmentToContainer1: AssignmentToContainerAnnotation
                  fujaba__IterParamAnnotationsAssignmentToContainer1 = param.iteratorOfAnnotations () ;
                  while ( fujaba__IterParamAnnotationsAssignmentToContainer1.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterParamAnnotationsAssignmentToContainer1.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof AssignmentToContainerAnnotation ) ;
                        assignmentToContainer1 = (AssignmentToContainerAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between assignmentToContainer1 and param
                        JavaSDM.ensure ( assignmentToContainer1.hasInElements ("param", param) ) ;
                         
                        // bind referencingField: UMLAttr
                        fujaba__IterAssignmentToContainer1ElementsReferencingField = assignmentToContainer1.iteratorOfElements ("field") ;
                        while ( fujaba__IterAssignmentToContainer1ElementsReferencingField.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAssignmentToContainer1ElementsReferencingField.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                              referencingField = (UMLAttr) fujaba__TmpObject ;
                               
                              // bind referencingClass: UMLClass
                              referencingClass = referencingField.getParent () ;
                              JavaSDM.ensure ( referencingClass != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                               
                              {
                                 //  for each flow
                                 try
                                 {
                                    fujaba__Success = false ;
                                     
                                    // check object referencingField is really bound
                                    JavaSDM.ensure ( referencingField != null ) ;
                                     
                                    // check object referredClass is really bound
                                    JavaSDM.ensure ( referredClass != null ) ;
                                     
                                    // check object referencingClass is really bound
                                    JavaSDM.ensure ( referencingClass != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                                     
                                    // bind multiReference: MultiReferenceAnnotation
                                    fujaba__IterReferencingClassAnnotationsMultiReference = referencingClass.iteratorOfAnnotations () ;
                                    while ( !(fujaba__Success) && fujaba__IterReferencingClassAnnotationsMultiReference.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterReferencingClassAnnotationsMultiReference.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                                          multiReference = (MultiReferenceAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between multiReference and referencingClass
                                          JavaSDM.ensure ( multiReference.hasInElements ("referencingClass", referencingClass) ) ;
                                           
                                          // check To-Many-Link 'elements' between multiReference and referencingField
                                          JavaSDM.ensure ( multiReference.hasInElements ("field", referencingField) ) ;
                                           
                                          // check To-Many-Link 'elements' between multiReference and referredClass
                                          JavaSDM.ensure ( multiReference.hasInElements ("references", referredClass) ) ;
                                           
                                          fujaba__Success = true ;
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                    fujaba__Success = false ;
                                 }
                                  
                                 if ( !(fujaba__Success) )
                                 {
                                    try
                                    {
                                       fujaba__Success = false ;
                                        
                                       // check object referencingField is really bound
                                       JavaSDM.ensure ( referencingField != null ) ;
                                        
                                       // check object referredClass is really bound
                                       JavaSDM.ensure ( referredClass != null ) ;
                                        
                                       // check object referencingClass is really bound
                                       JavaSDM.ensure ( referencingClass != null ) ;
                                        
                                       // check isomorphic binding
                                       JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                                        
                                       // check object param is really bound
                                       JavaSDM.ensure ( param != null ) ;
                                        
                                       // create object
                                       multiReference = new MultiReferenceAnnotation ( ) ;
                                        
                                       // assign statement
                                       multiReference.setClassification (0);
                                        
                                       // create link
                                       multiReference.addToElements ("field", referencingField);
                                        
                                       // create link
                                       multiReference.addToElements ("references", referredClass);
                                        
                                       // create link
                                       multiReference.addToElements ("referencingClass", referencingClass);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("param", param);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("referredClass", referredClass);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("referencingField", referencingField);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("referencingClass", referencingClass);
                                        
                                       fujaba__Success = true ;
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                       fujaba__Success = false ;
                                    }
                                     
                                    try
                                    {
                                       fujaba__Success = false ;
                                        
                                       // check object assignmentToContainer1 is really bound
                                       JavaSDM.ensure ( assignmentToContainer1 != null ) ;
                                        
                                       // check object multiReference is really bound
                                       JavaSDM.ensure ( multiReference != null ) ;
                                        
                                       // create link
                                       multiReference.addToAntecedentAnnos (assignmentToContainer1);
                                        
                                       fujaba__Success = true ;
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                       fujaba__Success = false ;
                                    }
                                     
                                    return (multiReference) ;
                                 }
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiReference is really bound
            JavaSDM.ensure ( multiReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("references", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiReference) ;
   }


   private GFRNAnnotation annotateUsingReferencingClassRole(ASGElement asgElement)
   {
      AssignmentToContainerAnnotation assignmentToContainer4 = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAssignmentToContainer4ElementsParam = null ;
      Iterator fujaba__IterReferencingClassAttrsReferencingField = null ;
      Iterator fujaba__IterReferencingFieldAnnotationsAssignmentToContainer4 = null ;
      Iterator fujaba__IterReferencingFieldAnnotationsMultiReference = null ;
      MultiReferenceAnnotation multiReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
      UMLParam param = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("referencingClass", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referencingClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind referencingField: UMLAttr
            fujaba__IterReferencingClassAttrsReferencingField = referencingClass.iteratorOfAttrs () ;
            while ( fujaba__IterReferencingClassAttrsReferencingField.hasNext () )
            {
               try
               {
                  referencingField = (UMLAttr) fujaba__IterReferencingClassAttrsReferencingField.next () ;
                   
                  // bind assignmentToContainer4: AssignmentToContainerAnnotation
                  fujaba__IterReferencingFieldAnnotationsAssignmentToContainer4 = referencingField.iteratorOfAnnotations () ;
                  while ( fujaba__IterReferencingFieldAnnotationsAssignmentToContainer4.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsAssignmentToContainer4.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof AssignmentToContainerAnnotation ) ;
                        assignmentToContainer4 = (AssignmentToContainerAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between assignmentToContainer4 and referencingField
                        JavaSDM.ensure ( assignmentToContainer4.hasInElements ("field", referencingField) ) ;
                         
                        // bind param: UMLParam
                        fujaba__IterAssignmentToContainer4ElementsParam = assignmentToContainer4.iteratorOfElements ("param") ;
                        while ( fujaba__IterAssignmentToContainer4ElementsParam.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAssignmentToContainer4ElementsParam.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                              param = (UMLParam) fujaba__TmpObject ;
                               
                              // bind referredClass: UMLClass
                              fujaba__TmpObject = param.getParamType () ;
                              JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                              referredClass = (UMLClass) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(referencingClass.equals (referredClass)) ) ;
                               
                              {
                                 //  for each flow
                                 try
                                 {
                                    fujaba__Success = false ;
                                     
                                    // check object referencingField is really bound
                                    JavaSDM.ensure ( referencingField != null ) ;
                                     
                                    // check object referredClass is really bound
                                    JavaSDM.ensure ( referredClass != null ) ;
                                     
                                    // check object referencingClass is really bound
                                    JavaSDM.ensure ( referencingClass != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                                     
                                    // bind multiReference: MultiReferenceAnnotation
                                    fujaba__IterReferencingFieldAnnotationsMultiReference = referencingField.iteratorOfAnnotations () ;
                                    while ( !(fujaba__Success) && fujaba__IterReferencingFieldAnnotationsMultiReference.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsMultiReference.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                                          multiReference = (MultiReferenceAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between multiReference and referencingField
                                          JavaSDM.ensure ( multiReference.hasInElements ("field", referencingField) ) ;
                                           
                                          // check To-Many-Link 'elements' between multiReference and referredClass
                                          JavaSDM.ensure ( multiReference.hasInElements ("references", referredClass) ) ;
                                           
                                          // check To-Many-Link 'elements' between multiReference and referencingClass
                                          JavaSDM.ensure ( multiReference.hasInElements ("referencingClass", referencingClass) ) ;
                                           
                                          fujaba__Success = true ;
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                    fujaba__Success = false ;
                                 }
                                  
                                 if ( !(fujaba__Success) )
                                 {
                                    try
                                    {
                                       fujaba__Success = false ;
                                        
                                       // check object referencingField is really bound
                                       JavaSDM.ensure ( referencingField != null ) ;
                                        
                                       // check object referredClass is really bound
                                       JavaSDM.ensure ( referredClass != null ) ;
                                        
                                       // check object referencingClass is really bound
                                       JavaSDM.ensure ( referencingClass != null ) ;
                                        
                                       // check isomorphic binding
                                       JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                                        
                                       // check object param is really bound
                                       JavaSDM.ensure ( param != null ) ;
                                        
                                       // create object
                                       multiReference = new MultiReferenceAnnotation ( ) ;
                                        
                                       // assign statement
                                       multiReference.setClassification (0);
                                        
                                       // create link
                                       multiReference.addToElements ("field", referencingField);
                                        
                                       // create link
                                       multiReference.addToElements ("references", referredClass);
                                        
                                       // create link
                                       multiReference.addToElements ("referencingClass", referencingClass);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("param", param);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("referredClass", referredClass);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("referencingField", referencingField);
                                        
                                       // create link
                                       multiReference.addToBoundObjects ("referencingClass", referencingClass);
                                        
                                       fujaba__Success = true ;
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                       fujaba__Success = false ;
                                    }
                                     
                                    try
                                    {
                                       fujaba__Success = false ;
                                        
                                       // check object assignmentToContainer4 is really bound
                                       JavaSDM.ensure ( assignmentToContainer4 != null ) ;
                                        
                                       // check object multiReference is really bound
                                       JavaSDM.ensure ( multiReference != null ) ;
                                        
                                       // create link
                                       multiReference.addToAntecedentAnnos (assignmentToContainer4);
                                        
                                       fujaba__Success = true ;
                                    }
                                    catch ( JavaSDMException fujaba__InternalException )
                                    {
                                       fujaba__Success = false ;
                                    }
                                     
                                    return (multiReference) ;
                                 }
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiReference is really bound
            JavaSDM.ensure ( multiReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("referencingClass", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiReference) ;
   }


   private GFRNAnnotation annotateUsingTrigger_AssignmentToContainerRole(ASGElement asgElement)
   {
      AssignmentToContainerAnnotation assignmentToContainer2 = null ;
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAssignmentToContainer2ElementsParam = null ;
      Iterator fujaba__IterAssignmentToContainer2ElementsReferencingField = null ;
      Iterator fujaba__IterReferencingFieldAnnotationsMultiReference = null ;
      MultiReferenceAnnotation multiReference = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
      UMLParam param = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_AssignmentToContainer", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof AssignmentToContainerAnnotation ) ;
             
            // explicit type cast
            assignmentToContainer2 = (AssignmentToContainerAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind param: UMLParam
            fujaba__IterAssignmentToContainer2ElementsParam = assignmentToContainer2.iteratorOfElements ("param") ;
            while ( fujaba__IterAssignmentToContainer2ElementsParam.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterAssignmentToContainer2ElementsParam.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                  param = (UMLParam) fujaba__TmpObject ;
                   
                  // bind referredClass: UMLClass
                  fujaba__TmpObject = param.getParamType () ;
                  JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  referredClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind referencingField: UMLAttr
                  fujaba__IterAssignmentToContainer2ElementsReferencingField = assignmentToContainer2.iteratorOfElements ("field") ;
                  while ( fujaba__IterAssignmentToContainer2ElementsReferencingField.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAssignmentToContainer2ElementsReferencingField.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                        referencingField = (UMLAttr) fujaba__TmpObject ;
                         
                        // bind referencingClass: UMLClass
                        referencingClass = referencingField.getParent () ;
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                         
                        {
                           //  for each flow
                           try
                           {
                              fujaba__Success = false ;
                               
                              // check object referencingField is really bound
                              JavaSDM.ensure ( referencingField != null ) ;
                               
                              // check object referredClass is really bound
                              JavaSDM.ensure ( referredClass != null ) ;
                               
                              // check object referencingClass is really bound
                              JavaSDM.ensure ( referencingClass != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                               
                              // bind multiReference: MultiReferenceAnnotation
                              fujaba__IterReferencingFieldAnnotationsMultiReference = referencingField.iteratorOfAnnotations () ;
                              while ( !(fujaba__Success) && fujaba__IterReferencingFieldAnnotationsMultiReference.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsMultiReference.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof MultiReferenceAnnotation ) ;
                                    multiReference = (MultiReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between multiReference and referencingField
                                    JavaSDM.ensure ( multiReference.hasInElements ("field", referencingField) ) ;
                                     
                                    // check To-Many-Link 'elements' between multiReference and referredClass
                                    JavaSDM.ensure ( multiReference.hasInElements ("references", referredClass) ) ;
                                     
                                    // check To-Many-Link 'elements' between multiReference and referencingClass
                                    JavaSDM.ensure ( multiReference.hasInElements ("referencingClass", referencingClass) ) ;
                                     
                                    fujaba__Success = true ;
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                              fujaba__Success = false ;
                           }
                            
                           if ( !(fujaba__Success) )
                           {
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 // check object referencingField is really bound
                                 JavaSDM.ensure ( referencingField != null ) ;
                                  
                                 // check object referredClass is really bound
                                 JavaSDM.ensure ( referredClass != null ) ;
                                  
                                 // check object referencingClass is really bound
                                 JavaSDM.ensure ( referencingClass != null ) ;
                                  
                                 // check isomorphic binding
                                 JavaSDM.ensure ( !(referredClass.equals (referencingClass)) ) ;
                                  
                                 // check object param is really bound
                                 JavaSDM.ensure ( param != null ) ;
                                  
                                 // create object
                                 multiReference = new MultiReferenceAnnotation ( ) ;
                                  
                                 // assign statement
                                 multiReference.setClassification (0);
                                  
                                 // create link
                                 multiReference.addToElements ("field", referencingField);
                                  
                                 // create link
                                 multiReference.addToElements ("references", referredClass);
                                  
                                 // create link
                                 multiReference.addToElements ("referencingClass", referencingClass);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("param", param);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("referredClass", referredClass);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("referencingField", referencingField);
                                  
                                 // create link
                                 multiReference.addToBoundObjects ("referencingClass", referencingClass);
                                  
                                 fujaba__Success = true ;
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 // check object assignmentToContainer2 is really bound
                                 JavaSDM.ensure ( assignmentToContainer2 != null ) ;
                                  
                                 // check object multiReference is really bound
                                 JavaSDM.ensure ( multiReference != null ) ;
                                  
                                 // create link
                                 multiReference.addToAntecedentAnnos (assignmentToContainer2);
                                  
                                 fujaba__Success = true ;
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              return (multiReference) ;
                           }
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object multiReference is really bound
            JavaSDM.ensure ( multiReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_AssignmentToContainer", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (multiReference) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLAttr )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("referencingClass", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof AssignmentToContainerAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_AssignmentToContainer", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterReferencingClassAttrsReferencingField = null ;
      Iterator fujaba__IterReferredClassRevParamTypeParam = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr referencingField = null ;
      UMLClass referencingClass = null ;
      UMLClass referredClass = null ;
      UMLParam param = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("AssignmentToContainer") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
             
            // explicit type cast
            referencingField = (UMLAttr) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (referencingField);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referredClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind param: UMLParam
            fujaba__IterReferredClassRevParamTypeParam = referredClass.iteratorOfRevParamType () ;
            while ( fujaba__IterReferredClassRevParamTypeParam.hasNext () )
            {
               try
               {
                  param = (UMLParam) fujaba__IterReferredClassRevParamTypeParam.next () ;
                   
                  {
                     //  for each flow
                     set.add (param);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referencingClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind referencingField: UMLAttr
            fujaba__IterReferencingClassAttrsReferencingField = referencingClass.iteratorOfAttrs () ;
            while ( fujaba__IterReferencingClassAttrsReferencingField.hasNext () )
            {
               try
               {
                  referencingField = (UMLAttr) fujaba__IterReferencingClassAttrsReferencingField.next () ;
                   
                  {
                     //  for each flow
                     set.add (referencingField);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
