package de.upb.inferenceengine.engines;

import de.upb.tools.fca.FEmptyIterator;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;

public class SingletonEngine
extends GFRNEngine
{
   private  SingletonEngine()
   {
   }

   private static SingletonEngine theSingletonEngine;

   public static SingletonEngine get()
   {
      if (theSingletonEngine == null)
      {
         theSingletonEngine = new SingletonEngine ();
      }
      return theSingletonEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation singleton = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         singleton = this.annotateUsingInstanceRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( singleton != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (singleton) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            singleton = this.annotateUsingSingletonRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( singleton != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (singleton) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               singleton = this.annotateUsingGetInstanceRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            return (singleton) ;
         }
      }
   }


   private GFRNAnnotation annotateUsingGetInstanceRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterGetInstanceAnnotationsSingleton = null ;
      Iterator fujaba__IterSingletonClassAttrsInstance = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingletonAnnotation singleton = null ;
      UMLAttr instance = null ;
      UMLClass singletonClass = null ;
      UMLMethod getInstance = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("getInstance", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
             
            // explicit type cast
            getInstance = (UMLMethod) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (getInstance.isStatic () == true) && (getInstance.getVisibility () != UMLMethod.PRIVATE) ) ;
             
            // bind singletonClass: UMLClass
            fujaba__TmpObject = getInstance.getResultType () ;
            JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
            singletonClass = (UMLClass) fujaba__TmpObject ;
             
            // check To-One-Link 'parent' between getInstance and singletonClass
            JavaSDM.ensure ( (getInstance.getParent () != null) && getInstance.getParent ().equals (singletonClass) ) ;
             
            // bind instance: UMLAttr
            fujaba__IterSingletonClassAttrsInstance = singletonClass.iteratorOfAttrs () ;
            while ( fujaba__IterSingletonClassAttrsInstance.hasNext () )
            {
               try
               {
                  instance = (UMLAttr) fujaba__IterSingletonClassAttrsInstance.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (instance.isStatic () == true) ) ;
                   
                  // check To-One-Link 'attrType' between instance and singletonClass
                  JavaSDM.ensure ( (instance.getAttrType () != null) && instance.getAttrType ().equals (singletonClass) ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object instance is really bound
                        JavaSDM.ensure ( instance != null ) ;
                         
                        // check object getInstance is really bound
                        JavaSDM.ensure ( getInstance != null ) ;
                         
                        // check object singletonClass is really bound
                        JavaSDM.ensure ( singletonClass != null ) ;
                         
                        // bind singleton: SingletonAnnotation
                        fujaba__IterGetInstanceAnnotationsSingleton = getInstance.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterGetInstanceAnnotationsSingleton.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterGetInstanceAnnotationsSingleton.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof SingletonAnnotation ) ;
                              singleton = (SingletonAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between singleton and getInstance
                              JavaSDM.ensure ( singleton.hasInElements ("getInstance", getInstance) ) ;
                               
                              // check To-Many-Link 'elements' between singleton and instance
                              JavaSDM.ensure ( singleton.hasInElements ("instance", instance) ) ;
                               
                              // check To-Many-Link 'elements' between singleton and singletonClass
                              JavaSDM.ensure ( singleton.hasInElements ("singleton", singletonClass) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object instance is really bound
                           JavaSDM.ensure ( instance != null ) ;
                            
                           // check object getInstance is really bound
                           JavaSDM.ensure ( getInstance != null ) ;
                            
                           // check object singletonClass is really bound
                           JavaSDM.ensure ( singletonClass != null ) ;
                            
                           // create object
                           singleton = new SingletonAnnotation ( ) ;
                            
                           // assign statement
                           singleton.setClassification (1);
                            
                           // create link
                           singleton.addToElements ("instance", instance);
                            
                           // create link
                           singleton.addToElements ("getInstance", getInstance);
                            
                           // create link
                           singleton.addToElements ("singleton", singletonClass);
                            
                           // create link
                           singleton.addToBoundObjects ("instance", instance);
                            
                           // create link
                           singleton.addToBoundObjects ("singletonClass", singletonClass);
                            
                           // create link
                           singleton.addToBoundObjects ("getInstance", getInstance);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (singleton) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object singleton is really bound
            JavaSDM.ensure ( singleton != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("getInstance", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (singleton) ;
   }


   private GFRNAnnotation annotateUsingInstanceRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterGetInstanceAnnotationsSingleton = null ;
      Iterator fujaba__IterSingletonClassMethodsGetInstance = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingletonAnnotation singleton = null ;
      UMLAttr instance = null ;
      UMLClass singletonClass = null ;
      UMLMethod getInstance = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("instance", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
             
            // explicit type cast
            instance = (UMLAttr) fujaba__tmpTypeCastObject ;
             
            // attribute condition
            JavaSDM.ensure ( (instance.isStatic () == true) ) ;
             
            // bind singletonClass: UMLClass
            fujaba__TmpObject = instance.getAttrType () ;
            JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
            singletonClass = (UMLClass) fujaba__TmpObject ;
             
            // check To-One-Link 'parent' between instance and singletonClass
            JavaSDM.ensure ( (instance.getParent () != null) && instance.getParent ().equals (singletonClass) ) ;
             
            // bind getInstance: UMLMethod
            fujaba__IterSingletonClassMethodsGetInstance = singletonClass.iteratorOfMethods () ;
            while ( fujaba__IterSingletonClassMethodsGetInstance.hasNext () )
            {
               try
               {
                  getInstance = (UMLMethod) fujaba__IterSingletonClassMethodsGetInstance.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (getInstance.isStatic () == true) && (getInstance.getVisibility () != UMLMethod.PRIVATE) ) ;
                   
                  // check To-One-Link 'resultType' between getInstance and singletonClass
                  JavaSDM.ensure ( (getInstance.getResultType () != null) && getInstance.getResultType ().equals (singletonClass) ) ;
                   
                  {
                     //  for each flow
                     try
                     {
                        fujaba__Success = false ;
                         
                        // check object instance is really bound
                        JavaSDM.ensure ( instance != null ) ;
                         
                        // check object getInstance is really bound
                        JavaSDM.ensure ( getInstance != null ) ;
                         
                        // check object singletonClass is really bound
                        JavaSDM.ensure ( singletonClass != null ) ;
                         
                        // bind singleton: SingletonAnnotation
                        fujaba__IterGetInstanceAnnotationsSingleton = getInstance.iteratorOfAnnotations () ;
                        while ( !(fujaba__Success) && fujaba__IterGetInstanceAnnotationsSingleton.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterGetInstanceAnnotationsSingleton.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof SingletonAnnotation ) ;
                              singleton = (SingletonAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between singleton and getInstance
                              JavaSDM.ensure ( singleton.hasInElements ("getInstance", getInstance) ) ;
                               
                              // check To-Many-Link 'elements' between singleton and instance
                              JavaSDM.ensure ( singleton.hasInElements ("instance", instance) ) ;
                               
                              // check To-Many-Link 'elements' between singleton and singletonClass
                              JavaSDM.ensure ( singleton.hasInElements ("singleton", singletonClass) ) ;
                               
                              fujaba__Success = true ;
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                        fujaba__Success = false ;
                     }
                      
                     if ( !(fujaba__Success) )
                     {
                        try
                        {
                           fujaba__Success = false ;
                            
                           // check object instance is really bound
                           JavaSDM.ensure ( instance != null ) ;
                            
                           // check object getInstance is really bound
                           JavaSDM.ensure ( getInstance != null ) ;
                            
                           // check object singletonClass is really bound
                           JavaSDM.ensure ( singletonClass != null ) ;
                            
                           // create object
                           singleton = new SingletonAnnotation ( ) ;
                            
                           // assign statement
                           singleton.setClassification (1);
                            
                           // create link
                           singleton.addToElements ("instance", instance);
                            
                           // create link
                           singleton.addToElements ("getInstance", getInstance);
                            
                           // create link
                           singleton.addToElements ("singleton", singletonClass);
                            
                           // create link
                           singleton.addToBoundObjects ("instance", instance);
                            
                           // create link
                           singleton.addToBoundObjects ("singletonClass", singletonClass);
                            
                           // create link
                           singleton.addToBoundObjects ("getInstance", getInstance);
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        try
                        {
                           fujaba__Success = false ;
                            
                           fujaba__Success = true ;
                        }
                        catch ( JavaSDMException fujaba__InternalException )
                        {
                           fujaba__Success = false ;
                        }
                         
                        return (singleton) ;
                     }
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object singleton is really bound
            JavaSDM.ensure ( singleton != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("instance", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (singleton) ;
   }


   private GFRNAnnotation annotateUsingSingletonRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterInstanceAnnotationsSingleton = null ;
      Iterator fujaba__IterSingletonClassAttrsInstance = null ;
      Iterator fujaba__IterSingletonClassMethodsGetInstance = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      SingletonAnnotation singleton = null ;
      UMLAttr instance = null ;
      UMLClass singletonClass = null ;
      UMLMethod getInstance = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("singleton", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            singletonClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind instance: UMLAttr
            fujaba__IterSingletonClassAttrsInstance = singletonClass.iteratorOfAttrs () ;
            while ( fujaba__IterSingletonClassAttrsInstance.hasNext () )
            {
               try
               {
                  instance = (UMLAttr) fujaba__IterSingletonClassAttrsInstance.next () ;
                   
                  // attribute condition
                  JavaSDM.ensure ( (instance.isStatic () == true) ) ;
                   
                  // check To-One-Link 'attrType' between instance and singletonClass
                  JavaSDM.ensure ( (instance.getAttrType () != null) && instance.getAttrType ().equals (singletonClass) ) ;
                   
                  // bind getInstance: UMLMethod
                  fujaba__IterSingletonClassMethodsGetInstance = singletonClass.iteratorOfMethods () ;
                  while ( fujaba__IterSingletonClassMethodsGetInstance.hasNext () )
                  {
                     try
                     {
                        getInstance = (UMLMethod) fujaba__IterSingletonClassMethodsGetInstance.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (getInstance.isStatic () == true) && (getInstance.getVisibility () != UMLMethod.PRIVATE) ) ;
                         
                        // check To-One-Link 'resultType' between getInstance and singletonClass
                        JavaSDM.ensure ( (getInstance.getResultType () != null) && getInstance.getResultType ().equals (singletonClass) ) ;
                         
                        {
                           //  for each flow
                           try
                           {
                              fujaba__Success = false ;
                               
                              // check object instance is really bound
                              JavaSDM.ensure ( instance != null ) ;
                               
                              // check object getInstance is really bound
                              JavaSDM.ensure ( getInstance != null ) ;
                               
                              // check object singletonClass is really bound
                              JavaSDM.ensure ( singletonClass != null ) ;
                               
                              // bind singleton: SingletonAnnotation
                              fujaba__IterInstanceAnnotationsSingleton = instance.iteratorOfAnnotations () ;
                              while ( !(fujaba__Success) && fujaba__IterInstanceAnnotationsSingleton.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterInstanceAnnotationsSingleton.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof SingletonAnnotation ) ;
                                    singleton = (SingletonAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between singleton and instance
                                    JavaSDM.ensure ( singleton.hasInElements ("instance", instance) ) ;
                                     
                                    // check To-Many-Link 'elements' between singleton and getInstance
                                    JavaSDM.ensure ( singleton.hasInElements ("getInstance", getInstance) ) ;
                                     
                                    // check To-Many-Link 'elements' between singleton and singletonClass
                                    JavaSDM.ensure ( singleton.hasInElements ("singleton", singletonClass) ) ;
                                     
                                    fujaba__Success = true ;
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                              fujaba__Success = false ;
                           }
                            
                           if ( !(fujaba__Success) )
                           {
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 // check object instance is really bound
                                 JavaSDM.ensure ( instance != null ) ;
                                  
                                 // check object getInstance is really bound
                                 JavaSDM.ensure ( getInstance != null ) ;
                                  
                                 // check object singletonClass is really bound
                                 JavaSDM.ensure ( singletonClass != null ) ;
                                  
                                 // create object
                                 singleton = new SingletonAnnotation ( ) ;
                                  
                                 // assign statement
                                 singleton.setClassification (1);
                                  
                                 // create link
                                 singleton.addToElements ("instance", instance);
                                  
                                 // create link
                                 singleton.addToElements ("getInstance", getInstance);
                                  
                                 // create link
                                 singleton.addToElements ("singleton", singletonClass);
                                  
                                 // create link
                                 singleton.addToBoundObjects ("instance", instance);
                                  
                                 // create link
                                 singleton.addToBoundObjects ("singletonClass", singletonClass);
                                  
                                 // create link
                                 singleton.addToBoundObjects ("getInstance", getInstance);
                                  
                                 fujaba__Success = true ;
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              try
                              {
                                 fujaba__Success = false ;
                                  
                                 fujaba__Success = true ;
                              }
                              catch ( JavaSDMException fujaba__InternalException )
                              {
                                 fujaba__Success = false ;
                              }
                               
                              return (singleton) ;
                           }
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object singleton is really bound
            JavaSDM.ensure ( singleton != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("singleton", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (singleton) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLAttr )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("instance", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLMethod )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("getInstance", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("singleton", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      return (FEmptyIterator.get()) ;
   }


}
