package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLStereotype;

public class StrategyInterfaceEngine
extends GFRNEngine
{
   private  StrategyInterfaceEngine()
   {
   }

   private static StrategyInterfaceEngine theStrategyInterfaceEngine;

   public static StrategyInterfaceEngine get()
   {
      if (theStrategyInterfaceEngine == null)
      {
         theStrategyInterfaceEngine = new StrategyInterfaceEngine ();
      }
      return theStrategyInterfaceEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation strategyInterface = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         strategyInterface = this.annotateUsingStrategyRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( strategyInterface != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (strategyInterface) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            strategyInterface = this.annotateUsingTrigger_NeighborCallRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( strategyInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (strategyInterface) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               strategyInterface = this.annotateUsingContextRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( strategyInterface != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (strategyInterface) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  strategyInterface = this.annotateUsingTrigger_ReferenceRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               try
               {
                  fujaba__Success = false ;
                   
                  // constraint
                  JavaSDM.ensure ( strategyInterface != null ) ;
                   
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               if ( fujaba__Success )
               {
                  return (strategyInterface) ;
               }
               else
               {
                  try
                  {
                     fujaba__Success = false ;
                      
                     // collabStatBegin 1 is empty !
                     strategyInterface = this.annotateUsingTrigger_OverridingMethodRole(asgElement);
                      
                     // collabStatEnd
                     fujaba__Success = true ;
                  }
                  catch ( JavaSDMException fujaba__InternalException )
                  {
                     fujaba__Success = false ;
                  }
                   
                  return (strategyInterface) ;
               }
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingContextRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyStereotypesUMLStereotype15 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod14 = null ;
      Iterator fujaba__IterContextAnnotationsReference12 = null ;
      Iterator fujaba__IterContextAnnotationsStrategyInterface = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      Iterator fujaba__IterContextMethodsSetStrategy = null ;
      Iterator fujaba__IterNeighborCall11ElementsAlgorithm = null ;
      Iterator fujaba__IterRequestAnnotationsNeighborCall11 = null ;
      Iterator fujaba__IterSetStrategyParamUMLParam13 = null ;
      NeighborCallAnnotation neighborCall11 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod14 = null ;
      ReferenceAnnotation reference12 = null ;
      StrategyInterfaceAnnotation strategyInterface = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam13 = null ;
      UMLStereotype uMLStereotype15 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("context", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
            while ( fujaba__IterContextMethodsRequest.hasNext () )
            {
               try
               {
                  request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                   
                  // bind setStrategy: UMLMethod
                  fujaba__IterContextMethodsSetStrategy = context.iteratorOfMethods () ;
                  while ( fujaba__IterContextMethodsSetStrategy.hasNext () )
                  {
                     try
                     {
                        setStrategy = (UMLMethod) fujaba__IterContextMethodsSetStrategy.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(request.equals (setStrategy)) ) ;
                         
                        // bind reference12: ReferenceAnnotation
                        fujaba__IterContextAnnotationsReference12 = context.iteratorOfAnnotations () ;
                        while ( fujaba__IterContextAnnotationsReference12.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterContextAnnotationsReference12.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference12 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference12 and context
                              JavaSDM.ensure ( reference12.hasInElements ("referencingClass", context) ) ;
                               
                              // bind neighborCall11: NeighborCallAnnotation
                              fujaba__IterRequestAnnotationsNeighborCall11 = request.iteratorOfAnnotations () ;
                              while ( fujaba__IterRequestAnnotationsNeighborCall11.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterRequestAnnotationsNeighborCall11.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                    neighborCall11 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between neighborCall11 and request
                                    JavaSDM.ensure ( neighborCall11.hasInElements ("caller", request) ) ;
                                     
                                    // bind uMLParam13: UMLParam
                                    fujaba__IterSetStrategyParamUMLParam13 = setStrategy.iteratorOfParam () ;
                                    while ( fujaba__IterSetStrategyParamUMLParam13.hasNext () )
                                    {
                                       try
                                       {
                                          uMLParam13 = (UMLParam) fujaba__IterSetStrategyParamUMLParam13.next () ;
                                           
                                          // bind abstractStrategy: UMLClass
                                          fujaba__TmpObject = uMLParam13.getParamType () ;
                                          JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                                          abstractStrategy = (UMLClass) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(context.equals (abstractStrategy)) ) ;
                                           
                                          // check To-Many-Link 'elements' between reference12 and abstractStrategy
                                          JavaSDM.ensure ( reference12.hasInElements ("references", abstractStrategy) ) ;
                                           
                                          // bind algorithm: UMLMethod
                                          fujaba__IterNeighborCall11ElementsAlgorithm = neighborCall11.iteratorOfElements ("callee") ;
                                          while ( fujaba__IterNeighborCall11ElementsAlgorithm.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall11ElementsAlgorithm.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                algorithm = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(request.equals (algorithm)) && !(setStrategy.equals (algorithm)) ) ;
                                                 
                                                // check To-One-Link 'parent' between algorithm and abstractStrategy
                                                JavaSDM.ensure ( (algorithm.getParent () != null) && algorithm.getParent ().equals (abstractStrategy) ) ;
                                                 
                                                // bind uMLStereotype15: UMLStereotype
                                                fujaba__IterAbstractStrategyStereotypesUMLStereotype15 = abstractStrategy.iteratorOfStereotypes () ;
                                                while ( fujaba__IterAbstractStrategyStereotypesUMLStereotype15.hasNext () )
                                                {
                                                   try
                                                   {
                                                      uMLStereotype15 = (UMLStereotype) fujaba__IterAbstractStrategyStereotypesUMLStereotype15.next () ;
                                                       
                                                      // attribute condition
                                                      JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype15.getText (), "interface") == 0) ) ;
                                                       
                                                      // bind overridingMethod14: OverridingMethodAnnotation
                                                      fujaba__IterAlgorithmAnnotationsOverridingMethod14 = algorithm.iteratorOfAnnotations () ;
                                                      while ( fujaba__IterAlgorithmAnnotationsOverridingMethod14.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod14.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                                            overridingMethod14 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between overridingMethod14 and algorithm
                                                            JavaSDM.ensure ( overridingMethod14.hasInElements ("overridden", algorithm) ) ;
                                                             
                                                            {
                                                               //  for each flow
                                                               try
                                                               {
                                                                  fujaba__Success = false ;
                                                                   
                                                                  // check object abstractStrategy is really bound
                                                                  JavaSDM.ensure ( abstractStrategy != null ) ;
                                                                   
                                                                  // check object context is really bound
                                                                  JavaSDM.ensure ( context != null ) ;
                                                                   
                                                                  // check isomorphic binding
                                                                  JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                                   
                                                                  // bind strategyInterface: StrategyInterfaceAnnotation
                                                                  fujaba__IterContextAnnotationsStrategyInterface = context.iteratorOfAnnotations () ;
                                                                  while ( !(fujaba__Success) && fujaba__IterContextAnnotationsStrategyInterface.hasNext () )
                                                                  {
                                                                     try
                                                                     {
                                                                        fujaba__TmpObject = fujaba__IterContextAnnotationsStrategyInterface.next () ;
                                                                        JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyInterfaceAnnotation ) ;
                                                                        strategyInterface = (StrategyInterfaceAnnotation) fujaba__TmpObject ;
                                                                         
                                                                        // check Reverse-Qualified-Link 'elements' between strategyInterface and context
                                                                        JavaSDM.ensure ( strategyInterface.hasInElements ("context", context) ) ;
                                                                         
                                                                        // check To-Many-Link 'elements' between strategyInterface and abstractStrategy
                                                                        JavaSDM.ensure ( strategyInterface.hasInElements ("strategy", abstractStrategy) ) ;
                                                                         
                                                                        fujaba__Success = true ;
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                     }
                                                                  }
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                                  fujaba__Success = false ;
                                                               }
                                                                
                                                               if ( !(fujaba__Success) )
                                                               {
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object abstractStrategy is really bound
                                                                     JavaSDM.ensure ( abstractStrategy != null ) ;
                                                                      
                                                                     // check object context is really bound
                                                                     JavaSDM.ensure ( context != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                                      
                                                                     // check object algorithm is really bound
                                                                     JavaSDM.ensure ( algorithm != null ) ;
                                                                      
                                                                     // check object request is really bound
                                                                     JavaSDM.ensure ( request != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                                      
                                                                     // check object setStrategy is really bound
                                                                     JavaSDM.ensure ( setStrategy != null ) ;
                                                                      
                                                                     // check isomorphic binding
                                                                     JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                                      
                                                                     // create object
                                                                     strategyInterface = new StrategyInterfaceAnnotation ( ) ;
                                                                      
                                                                     // assign statement
                                                                     strategyInterface.setClassification (1);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToElements ("strategy", abstractStrategy);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToElements ("context", context);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToBoundObjects ("algorithm", algorithm);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToBoundObjects ("request", request);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToBoundObjects ("context", context);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToBoundObjects ("setStrategy", setStrategy);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  try
                                                                  {
                                                                     fujaba__Success = false ;
                                                                      
                                                                     // check object neighborCall11 is really bound
                                                                     JavaSDM.ensure ( neighborCall11 != null ) ;
                                                                      
                                                                     // check object reference12 is really bound
                                                                     JavaSDM.ensure ( reference12 != null ) ;
                                                                      
                                                                     // check object overridingMethod14 is really bound
                                                                     JavaSDM.ensure ( overridingMethod14 != null ) ;
                                                                      
                                                                     // check object strategyInterface is really bound
                                                                     JavaSDM.ensure ( strategyInterface != null ) ;
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToAntecedentAnnos (neighborCall11);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToAntecedentAnnos (reference12);
                                                                      
                                                                     // create link
                                                                     strategyInterface.addToAntecedentAnnos (overridingMethod14);
                                                                      
                                                                     fujaba__Success = true ;
                                                                  }
                                                                  catch ( JavaSDMException fujaba__InternalException )
                                                                  {
                                                                     fujaba__Success = false ;
                                                                  }
                                                                   
                                                                  return (strategyInterface) ;
                                                               }
                                                            } //  end for each flow
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategyInterface is really bound
            JavaSDM.ensure ( strategyInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("context", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategyInterface) ;
   }


   private GFRNAnnotation annotateUsingStrategyRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyAnnotationsReference2 = null ;
      Iterator fujaba__IterAbstractStrategyAnnotationsStrategyInterface = null ;
      Iterator fujaba__IterAbstractStrategyMethodsAlgorithm = null ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam3 = null ;
      Iterator fujaba__IterAbstractStrategyStereotypesUMLStereotype5 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsNeighborCall1 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod4 = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      NeighborCallAnnotation neighborCall1 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod4 = null ;
      ReferenceAnnotation reference2 = null ;
      StrategyInterfaceAnnotation strategyInterface = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam3 = null ;
      UMLStereotype uMLStereotype5 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("strategy", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
            while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
            {
               try
               {
                  algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                   
                  // bind uMLStereotype5: UMLStereotype
                  fujaba__IterAbstractStrategyStereotypesUMLStereotype5 = abstractStrategy.iteratorOfStereotypes () ;
                  while ( fujaba__IterAbstractStrategyStereotypesUMLStereotype5.hasNext () )
                  {
                     try
                     {
                        uMLStereotype5 = (UMLStereotype) fujaba__IterAbstractStrategyStereotypesUMLStereotype5.next () ;
                         
                        // attribute condition
                        JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype5.getText (), "interface") == 0) ) ;
                         
                        // bind reference2: ReferenceAnnotation
                        fujaba__IterAbstractStrategyAnnotationsReference2 = abstractStrategy.iteratorOfAnnotations () ;
                        while ( fujaba__IterAbstractStrategyAnnotationsReference2.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsReference2.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                              reference2 = (ReferenceAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between reference2 and abstractStrategy
                              JavaSDM.ensure ( reference2.hasInElements ("references", abstractStrategy) ) ;
                               
                              // bind uMLParam3: UMLParam
                              fujaba__IterAbstractStrategyRevParamTypeUMLParam3 = abstractStrategy.iteratorOfRevParamType () ;
                              while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam3.hasNext () )
                              {
                                 try
                                 {
                                    uMLParam3 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam3.next () ;
                                     
                                    // bind setStrategy: UMLMethod
                                    setStrategy = uMLParam3.getRevParam () ;
                                    JavaSDM.ensure ( setStrategy != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(algorithm.equals (setStrategy)) ) ;
                                     
                                    // bind context: UMLClass
                                    context = setStrategy.getParent () ;
                                    JavaSDM.ensure ( context != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                     
                                    // check To-Many-Link 'elements' between reference2 and context
                                    JavaSDM.ensure ( reference2.hasInElements ("referencingClass", context) ) ;
                                     
                                    // bind neighborCall1: NeighborCallAnnotation
                                    fujaba__IterAlgorithmAnnotationsNeighborCall1 = algorithm.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAlgorithmAnnotationsNeighborCall1.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsNeighborCall1.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                          neighborCall1 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between neighborCall1 and algorithm
                                          JavaSDM.ensure ( neighborCall1.hasInElements ("callee", algorithm) ) ;
                                           
                                          // bind overridingMethod4: OverridingMethodAnnotation
                                          fujaba__IterAlgorithmAnnotationsOverridingMethod4 = algorithm.iteratorOfAnnotations () ;
                                          while ( fujaba__IterAlgorithmAnnotationsOverridingMethod4.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod4.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                                overridingMethod4 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                                 
                                                // check Reverse-Qualified-Link 'elements' between overridingMethod4 and algorithm
                                                JavaSDM.ensure ( overridingMethod4.hasInElements ("overridden", algorithm) ) ;
                                                 
                                                // bind request: UMLMethod
                                                fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
                                                while ( fujaba__IterContextMethodsRequest.hasNext () )
                                                {
                                                   try
                                                   {
                                                      request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(algorithm.equals (request)) && !(setStrategy.equals (request)) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between neighborCall1 and request
                                                      JavaSDM.ensure ( neighborCall1.hasInElements ("caller", request) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object abstractStrategy is really bound
                                                            JavaSDM.ensure ( abstractStrategy != null ) ;
                                                             
                                                            // check object context is really bound
                                                            JavaSDM.ensure ( context != null ) ;
                                                             
                                                            // check isomorphic binding
                                                            JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                             
                                                            // bind strategyInterface: StrategyInterfaceAnnotation
                                                            fujaba__IterAbstractStrategyAnnotationsStrategyInterface = abstractStrategy.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterAbstractStrategyAnnotationsStrategyInterface.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsStrategyInterface.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyInterfaceAnnotation ) ;
                                                                  strategyInterface = (StrategyInterfaceAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between strategyInterface and abstractStrategy
                                                                  JavaSDM.ensure ( strategyInterface.hasInElements ("strategy", abstractStrategy) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between strategyInterface and context
                                                                  JavaSDM.ensure ( strategyInterface.hasInElements ("context", context) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object abstractStrategy is really bound
                                                               JavaSDM.ensure ( abstractStrategy != null ) ;
                                                                
                                                               // check object context is really bound
                                                               JavaSDM.ensure ( context != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                                
                                                               // check object algorithm is really bound
                                                               JavaSDM.ensure ( algorithm != null ) ;
                                                                
                                                               // check object request is really bound
                                                               JavaSDM.ensure ( request != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                                
                                                               // check object setStrategy is really bound
                                                               JavaSDM.ensure ( setStrategy != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                                
                                                               // create object
                                                               strategyInterface = new StrategyInterfaceAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               strategyInterface.setClassification (1);
                                                                
                                                               // create link
                                                               strategyInterface.addToElements ("strategy", abstractStrategy);
                                                                
                                                               // create link
                                                               strategyInterface.addToElements ("context", context);
                                                                
                                                               // create link
                                                               strategyInterface.addToBoundObjects ("algorithm", algorithm);
                                                                
                                                               // create link
                                                               strategyInterface.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                                
                                                               // create link
                                                               strategyInterface.addToBoundObjects ("request", request);
                                                                
                                                               // create link
                                                               strategyInterface.addToBoundObjects ("context", context);
                                                                
                                                               // create link
                                                               strategyInterface.addToBoundObjects ("setStrategy", setStrategy);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object neighborCall1 is really bound
                                                               JavaSDM.ensure ( neighborCall1 != null ) ;
                                                                
                                                               // check object reference2 is really bound
                                                               JavaSDM.ensure ( reference2 != null ) ;
                                                                
                                                               // check object overridingMethod4 is really bound
                                                               JavaSDM.ensure ( overridingMethod4 != null ) ;
                                                                
                                                               // check object strategyInterface is really bound
                                                               JavaSDM.ensure ( strategyInterface != null ) ;
                                                                
                                                               // create link
                                                               strategyInterface.addToAntecedentAnnos (neighborCall1);
                                                                
                                                               // create link
                                                               strategyInterface.addToAntecedentAnnos (reference2);
                                                                
                                                               // create link
                                                               strategyInterface.addToAntecedentAnnos (overridingMethod4);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (strategyInterface) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategyInterface is really bound
            JavaSDM.ensure ( strategyInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("strategy", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategyInterface) ;
   }


   private GFRNAnnotation annotateUsingTrigger_NeighborCallRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyAnnotationsReference7 = null ;
      Iterator fujaba__IterAbstractStrategyAnnotationsStrategyInterface = null ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam8 = null ;
      Iterator fujaba__IterAbstractStrategyStereotypesUMLStereotype10 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod9 = null ;
      Iterator fujaba__IterNeighborCall6ElementsAlgorithm = null ;
      Iterator fujaba__IterNeighborCall6ElementsRequest = null ;
      NeighborCallAnnotation neighborCall6 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod9 = null ;
      ReferenceAnnotation reference7 = null ;
      StrategyInterfaceAnnotation strategyInterface = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam8 = null ;
      UMLStereotype uMLStereotype10 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall6 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterNeighborCall6ElementsAlgorithm = neighborCall6.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall6ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall6ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind abstractStrategy: UMLClass
                  abstractStrategy = algorithm.getParent () ;
                  JavaSDM.ensure ( abstractStrategy != null ) ;
                   
                  // bind request: UMLMethod
                  fujaba__IterNeighborCall6ElementsRequest = neighborCall6.iteratorOfElements ("caller") ;
                  while ( fujaba__IterNeighborCall6ElementsRequest.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterNeighborCall6ElementsRequest.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        request = (UMLMethod) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                         
                        // bind context: UMLClass
                        context = request.getParent () ;
                        JavaSDM.ensure ( context != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                         
                        // bind overridingMethod9: OverridingMethodAnnotation
                        fujaba__IterAlgorithmAnnotationsOverridingMethod9 = algorithm.iteratorOfAnnotations () ;
                        while ( fujaba__IterAlgorithmAnnotationsOverridingMethod9.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod9.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                              overridingMethod9 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between overridingMethod9 and algorithm
                              JavaSDM.ensure ( overridingMethod9.hasInElements ("overridden", algorithm) ) ;
                               
                              // bind uMLStereotype10: UMLStereotype
                              fujaba__IterAbstractStrategyStereotypesUMLStereotype10 = abstractStrategy.iteratorOfStereotypes () ;
                              while ( fujaba__IterAbstractStrategyStereotypesUMLStereotype10.hasNext () )
                              {
                                 try
                                 {
                                    uMLStereotype10 = (UMLStereotype) fujaba__IterAbstractStrategyStereotypesUMLStereotype10.next () ;
                                     
                                    // attribute condition
                                    JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype10.getText (), "interface") == 0) ) ;
                                     
                                    // bind reference7: ReferenceAnnotation
                                    fujaba__IterAbstractStrategyAnnotationsReference7 = abstractStrategy.iteratorOfAnnotations () ;
                                    while ( fujaba__IterAbstractStrategyAnnotationsReference7.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsReference7.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                                          reference7 = (ReferenceAnnotation) fujaba__TmpObject ;
                                           
                                          // check Reverse-Qualified-Link 'elements' between reference7 and abstractStrategy
                                          JavaSDM.ensure ( reference7.hasInElements ("references", abstractStrategy) ) ;
                                           
                                          // check To-Many-Link 'elements' between reference7 and context
                                          JavaSDM.ensure ( reference7.hasInElements ("referencingClass", context) ) ;
                                           
                                          // bind uMLParam8: UMLParam
                                          fujaba__IterAbstractStrategyRevParamTypeUMLParam8 = abstractStrategy.iteratorOfRevParamType () ;
                                          while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam8.hasNext () )
                                          {
                                             try
                                             {
                                                uMLParam8 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam8.next () ;
                                                 
                                                // bind setStrategy: UMLMethod
                                                setStrategy = uMLParam8.getRevParam () ;
                                                JavaSDM.ensure ( setStrategy != null ) ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                 
                                                // check To-One-Link 'parent' between setStrategy and context
                                                JavaSDM.ensure ( (setStrategy.getParent () != null) && setStrategy.getParent ().equals (context) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstractStrategy is really bound
                                                      JavaSDM.ensure ( abstractStrategy != null ) ;
                                                       
                                                      // check object context is really bound
                                                      JavaSDM.ensure ( context != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                       
                                                      // bind strategyInterface: StrategyInterfaceAnnotation
                                                      fujaba__IterAbstractStrategyAnnotationsStrategyInterface = abstractStrategy.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterAbstractStrategyAnnotationsStrategyInterface.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsStrategyInterface.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyInterfaceAnnotation ) ;
                                                            strategyInterface = (StrategyInterfaceAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between strategyInterface and abstractStrategy
                                                            JavaSDM.ensure ( strategyInterface.hasInElements ("strategy", abstractStrategy) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between strategyInterface and context
                                                            JavaSDM.ensure ( strategyInterface.hasInElements ("context", context) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstractStrategy is really bound
                                                         JavaSDM.ensure ( abstractStrategy != null ) ;
                                                          
                                                         // check object context is really bound
                                                         JavaSDM.ensure ( context != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                          
                                                         // check object algorithm is really bound
                                                         JavaSDM.ensure ( algorithm != null ) ;
                                                          
                                                         // check object request is really bound
                                                         JavaSDM.ensure ( request != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                          
                                                         // check object setStrategy is really bound
                                                         JavaSDM.ensure ( setStrategy != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                          
                                                         // create object
                                                         strategyInterface = new StrategyInterfaceAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         strategyInterface.setClassification (1);
                                                          
                                                         // create link
                                                         strategyInterface.addToElements ("strategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategyInterface.addToElements ("context", context);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("algorithm", algorithm);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("request", request);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("context", context);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("setStrategy", setStrategy);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object neighborCall6 is really bound
                                                         JavaSDM.ensure ( neighborCall6 != null ) ;
                                                          
                                                         // check object reference7 is really bound
                                                         JavaSDM.ensure ( reference7 != null ) ;
                                                          
                                                         // check object overridingMethod9 is really bound
                                                         JavaSDM.ensure ( overridingMethod9 != null ) ;
                                                          
                                                         // check object strategyInterface is really bound
                                                         JavaSDM.ensure ( strategyInterface != null ) ;
                                                          
                                                         // create link
                                                         strategyInterface.addToAntecedentAnnos (neighborCall6);
                                                          
                                                         // create link
                                                         strategyInterface.addToAntecedentAnnos (reference7);
                                                          
                                                         // create link
                                                         strategyInterface.addToAntecedentAnnos (overridingMethod9);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (strategyInterface) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategyInterface is really bound
            JavaSDM.ensure ( strategyInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_NeighborCall", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategyInterface) ;
   }


   private GFRNAnnotation annotateUsingTrigger_OverridingMethodRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyAnnotationsReference22 = null ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam23 = null ;
      Iterator fujaba__IterAbstractStrategyStereotypesUMLStereotype25 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsNeighborCall21 = null ;
      Iterator fujaba__IterContextAnnotationsStrategyInterface = null ;
      Iterator fujaba__IterNeighborCall21ElementsRequest = null ;
      Iterator fujaba__IterOverridingMethod24ElementsAlgorithm = null ;
      NeighborCallAnnotation neighborCall21 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod24 = null ;
      ReferenceAnnotation reference22 = null ;
      StrategyInterfaceAnnotation strategyInterface = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam23 = null ;
      UMLStereotype uMLStereotype25 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod24 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterOverridingMethod24ElementsAlgorithm = overridingMethod24.iteratorOfElements ("overridden") ;
            while ( fujaba__IterOverridingMethod24ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod24ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind abstractStrategy: UMLClass
                  abstractStrategy = algorithm.getParent () ;
                  JavaSDM.ensure ( abstractStrategy != null ) ;
                   
                  // bind neighborCall21: NeighborCallAnnotation
                  fujaba__IterAlgorithmAnnotationsNeighborCall21 = algorithm.iteratorOfAnnotations () ;
                  while ( fujaba__IterAlgorithmAnnotationsNeighborCall21.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsNeighborCall21.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall21 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall21 and algorithm
                        JavaSDM.ensure ( neighborCall21.hasInElements ("callee", algorithm) ) ;
                         
                        // bind uMLStereotype25: UMLStereotype
                        fujaba__IterAbstractStrategyStereotypesUMLStereotype25 = abstractStrategy.iteratorOfStereotypes () ;
                        while ( fujaba__IterAbstractStrategyStereotypesUMLStereotype25.hasNext () )
                        {
                           try
                           {
                              uMLStereotype25 = (UMLStereotype) fujaba__IterAbstractStrategyStereotypesUMLStereotype25.next () ;
                               
                              // attribute condition
                              JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype25.getText (), "interface") == 0) ) ;
                               
                              // bind reference22: ReferenceAnnotation
                              fujaba__IterAbstractStrategyAnnotationsReference22 = abstractStrategy.iteratorOfAnnotations () ;
                              while ( fujaba__IterAbstractStrategyAnnotationsReference22.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterAbstractStrategyAnnotationsReference22.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof ReferenceAnnotation ) ;
                                    reference22 = (ReferenceAnnotation) fujaba__TmpObject ;
                                     
                                    // check Reverse-Qualified-Link 'elements' between reference22 and abstractStrategy
                                    JavaSDM.ensure ( reference22.hasInElements ("references", abstractStrategy) ) ;
                                     
                                    // bind uMLParam23: UMLParam
                                    fujaba__IterAbstractStrategyRevParamTypeUMLParam23 = abstractStrategy.iteratorOfRevParamType () ;
                                    while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam23.hasNext () )
                                    {
                                       try
                                       {
                                          uMLParam23 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam23.next () ;
                                           
                                          // bind setStrategy: UMLMethod
                                          setStrategy = uMLParam23.getRevParam () ;
                                          JavaSDM.ensure ( setStrategy != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(algorithm.equals (setStrategy)) ) ;
                                           
                                          // bind context: UMLClass
                                          context = setStrategy.getParent () ;
                                          JavaSDM.ensure ( context != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                           
                                          // check To-Many-Link 'elements' between reference22 and context
                                          JavaSDM.ensure ( reference22.hasInElements ("referencingClass", context) ) ;
                                           
                                          // bind request: UMLMethod
                                          fujaba__IterNeighborCall21ElementsRequest = neighborCall21.iteratorOfElements ("caller") ;
                                          while ( fujaba__IterNeighborCall21ElementsRequest.hasNext () )
                                          {
                                             try
                                             {
                                                fujaba__TmpObject = fujaba__IterNeighborCall21ElementsRequest.next () ;
                                                JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                                request = (UMLMethod) fujaba__TmpObject ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(algorithm.equals (request)) && !(setStrategy.equals (request)) ) ;
                                                 
                                                // check To-One-Link 'parent' between request and context
                                                JavaSDM.ensure ( (request.getParent () != null) && request.getParent ().equals (context) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object abstractStrategy is really bound
                                                      JavaSDM.ensure ( abstractStrategy != null ) ;
                                                       
                                                      // check object context is really bound
                                                      JavaSDM.ensure ( context != null ) ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                       
                                                      // bind strategyInterface: StrategyInterfaceAnnotation
                                                      fujaba__IterContextAnnotationsStrategyInterface = context.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterContextAnnotationsStrategyInterface.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterContextAnnotationsStrategyInterface.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyInterfaceAnnotation ) ;
                                                            strategyInterface = (StrategyInterfaceAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between strategyInterface and context
                                                            JavaSDM.ensure ( strategyInterface.hasInElements ("context", context) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between strategyInterface and abstractStrategy
                                                            JavaSDM.ensure ( strategyInterface.hasInElements ("strategy", abstractStrategy) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object abstractStrategy is really bound
                                                         JavaSDM.ensure ( abstractStrategy != null ) ;
                                                          
                                                         // check object context is really bound
                                                         JavaSDM.ensure ( context != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                          
                                                         // check object algorithm is really bound
                                                         JavaSDM.ensure ( algorithm != null ) ;
                                                          
                                                         // check object request is really bound
                                                         JavaSDM.ensure ( request != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                          
                                                         // check object setStrategy is really bound
                                                         JavaSDM.ensure ( setStrategy != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                          
                                                         // create object
                                                         strategyInterface = new StrategyInterfaceAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         strategyInterface.setClassification (1);
                                                          
                                                         // create link
                                                         strategyInterface.addToElements ("strategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategyInterface.addToElements ("context", context);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("algorithm", algorithm);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("request", request);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("context", context);
                                                          
                                                         // create link
                                                         strategyInterface.addToBoundObjects ("setStrategy", setStrategy);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object neighborCall21 is really bound
                                                         JavaSDM.ensure ( neighborCall21 != null ) ;
                                                          
                                                         // check object reference22 is really bound
                                                         JavaSDM.ensure ( reference22 != null ) ;
                                                          
                                                         // check object overridingMethod24 is really bound
                                                         JavaSDM.ensure ( overridingMethod24 != null ) ;
                                                          
                                                         // check object strategyInterface is really bound
                                                         JavaSDM.ensure ( strategyInterface != null ) ;
                                                          
                                                         // create link
                                                         strategyInterface.addToAntecedentAnnos (neighborCall21);
                                                          
                                                         // create link
                                                         strategyInterface.addToAntecedentAnnos (reference22);
                                                          
                                                         // create link
                                                         strategyInterface.addToAntecedentAnnos (overridingMethod24);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (strategyInterface) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategyInterface is really bound
            JavaSDM.ensure ( strategyInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_OverridingMethod", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategyInterface) ;
   }


   private GFRNAnnotation annotateUsingTrigger_ReferenceRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyMethodsAlgorithm = null ;
      Iterator fujaba__IterAbstractStrategyRevParamTypeUMLParam18 = null ;
      Iterator fujaba__IterAbstractStrategyStereotypesUMLStereotype20 = null ;
      Iterator fujaba__IterAlgorithmAnnotationsOverridingMethod19 = null ;
      Iterator fujaba__IterContextAnnotationsStrategyInterface = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      Iterator fujaba__IterContextMethodsSetStrategy = null ;
      Iterator fujaba__IterReference17ElementsAbstractStrategy = null ;
      Iterator fujaba__IterReference17ElementsContext = null ;
      Iterator fujaba__IterRequestAnnotationsNeighborCall16 = null ;
      NeighborCallAnnotation neighborCall16 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod19 = null ;
      ReferenceAnnotation reference17 = null ;
      StrategyInterfaceAnnotation strategyInterface = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
      UMLMethod setStrategy = null ;
      UMLParam uMLParam18 = null ;
      UMLStereotype uMLStereotype20 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference17 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind context: UMLClass
            fujaba__IterReference17ElementsContext = reference17.iteratorOfElements ("referencingClass") ;
            while ( fujaba__IterReference17ElementsContext.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference17ElementsContext.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  context = (UMLClass) fujaba__TmpObject ;
                   
                  // bind abstractStrategy: UMLClass
                  fujaba__IterReference17ElementsAbstractStrategy = reference17.iteratorOfElements ("references") ;
                  while ( fujaba__IterReference17ElementsAbstractStrategy.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterReference17ElementsAbstractStrategy.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        abstractStrategy = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(context.equals (abstractStrategy)) ) ;
                         
                        // bind request: UMLMethod
                        fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
                        while ( fujaba__IterContextMethodsRequest.hasNext () )
                        {
                           try
                           {
                              request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                               
                              // bind setStrategy: UMLMethod
                              fujaba__IterContextMethodsSetStrategy = context.iteratorOfMethods () ;
                              while ( fujaba__IterContextMethodsSetStrategy.hasNext () )
                              {
                                 try
                                 {
                                    setStrategy = (UMLMethod) fujaba__IterContextMethodsSetStrategy.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(request.equals (setStrategy)) ) ;
                                     
                                    // bind uMLStereotype20: UMLStereotype
                                    fujaba__IterAbstractStrategyStereotypesUMLStereotype20 = abstractStrategy.iteratorOfStereotypes () ;
                                    while ( fujaba__IterAbstractStrategyStereotypesUMLStereotype20.hasNext () )
                                    {
                                       try
                                       {
                                          uMLStereotype20 = (UMLStereotype) fujaba__IterAbstractStrategyStereotypesUMLStereotype20.next () ;
                                           
                                          // attribute condition
                                          JavaSDM.ensure ( (JavaSDM.stringCompare (uMLStereotype20.getText (), "interface") == 0) ) ;
                                           
                                          // bind algorithm: UMLMethod
                                          fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
                                          while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
                                          {
                                             try
                                             {
                                                algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(request.equals (algorithm)) && !(setStrategy.equals (algorithm)) ) ;
                                                 
                                                // bind uMLParam18: UMLParam
                                                fujaba__IterAbstractStrategyRevParamTypeUMLParam18 = abstractStrategy.iteratorOfRevParamType () ;
                                                while ( fujaba__IterAbstractStrategyRevParamTypeUMLParam18.hasNext () )
                                                {
                                                   try
                                                   {
                                                      uMLParam18 = (UMLParam) fujaba__IterAbstractStrategyRevParamTypeUMLParam18.next () ;
                                                       
                                                      // check To-One-Link 'revParam' between uMLParam18 and setStrategy
                                                      JavaSDM.ensure ( (uMLParam18.getRevParam () != null) && uMLParam18.getRevParam ().equals (setStrategy) ) ;
                                                       
                                                      // bind neighborCall16: NeighborCallAnnotation
                                                      fujaba__IterRequestAnnotationsNeighborCall16 = request.iteratorOfAnnotations () ;
                                                      while ( fujaba__IterRequestAnnotationsNeighborCall16.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterRequestAnnotationsNeighborCall16.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                                                            neighborCall16 = (NeighborCallAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between neighborCall16 and request
                                                            JavaSDM.ensure ( neighborCall16.hasInElements ("caller", request) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between neighborCall16 and algorithm
                                                            JavaSDM.ensure ( neighborCall16.hasInElements ("callee", algorithm) ) ;
                                                             
                                                            // bind overridingMethod19: OverridingMethodAnnotation
                                                            fujaba__IterAlgorithmAnnotationsOverridingMethod19 = algorithm.iteratorOfAnnotations () ;
                                                            while ( fujaba__IterAlgorithmAnnotationsOverridingMethod19.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsOverridingMethod19.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof OverridingMethodAnnotation ) ;
                                                                  overridingMethod19 = (OverridingMethodAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between overridingMethod19 and algorithm
                                                                  JavaSDM.ensure ( overridingMethod19.hasInElements ("overridden", algorithm) ) ;
                                                                   
                                                                  {
                                                                     //  for each flow
                                                                     try
                                                                     {
                                                                        fujaba__Success = false ;
                                                                         
                                                                        // check object abstractStrategy is really bound
                                                                        JavaSDM.ensure ( abstractStrategy != null ) ;
                                                                         
                                                                        // check object context is really bound
                                                                        JavaSDM.ensure ( context != null ) ;
                                                                         
                                                                        // check isomorphic binding
                                                                        JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                                         
                                                                        // bind strategyInterface: StrategyInterfaceAnnotation
                                                                        fujaba__IterContextAnnotationsStrategyInterface = context.iteratorOfAnnotations () ;
                                                                        while ( !(fujaba__Success) && fujaba__IterContextAnnotationsStrategyInterface.hasNext () )
                                                                        {
                                                                           try
                                                                           {
                                                                              fujaba__TmpObject = fujaba__IterContextAnnotationsStrategyInterface.next () ;
                                                                              JavaSDM.ensure ( fujaba__TmpObject instanceof StrategyInterfaceAnnotation ) ;
                                                                              strategyInterface = (StrategyInterfaceAnnotation) fujaba__TmpObject ;
                                                                               
                                                                              // check Reverse-Qualified-Link 'elements' between strategyInterface and context
                                                                              JavaSDM.ensure ( strategyInterface.hasInElements ("context", context) ) ;
                                                                               
                                                                              // check To-Many-Link 'elements' between strategyInterface and abstractStrategy
                                                                              JavaSDM.ensure ( strategyInterface.hasInElements ("strategy", abstractStrategy) ) ;
                                                                               
                                                                              fujaba__Success = true ;
                                                                           }
                                                                           catch ( JavaSDMException fujaba__InternalException )
                                                                           {
                                                                           }
                                                                        }
                                                                     }
                                                                     catch ( JavaSDMException fujaba__InternalException )
                                                                     {
                                                                        fujaba__Success = false ;
                                                                     }
                                                                      
                                                                     if ( !(fujaba__Success) )
                                                                     {
                                                                        try
                                                                        {
                                                                           fujaba__Success = false ;
                                                                            
                                                                           // check object abstractStrategy is really bound
                                                                           JavaSDM.ensure ( abstractStrategy != null ) ;
                                                                            
                                                                           // check object context is really bound
                                                                           JavaSDM.ensure ( context != null ) ;
                                                                            
                                                                           // check isomorphic binding
                                                                           JavaSDM.ensure ( !(abstractStrategy.equals (context)) ) ;
                                                                            
                                                                           // check object algorithm is really bound
                                                                           JavaSDM.ensure ( algorithm != null ) ;
                                                                            
                                                                           // check object request is really bound
                                                                           JavaSDM.ensure ( request != null ) ;
                                                                            
                                                                           // check isomorphic binding
                                                                           JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                                                                            
                                                                           // check object setStrategy is really bound
                                                                           JavaSDM.ensure ( setStrategy != null ) ;
                                                                            
                                                                           // check isomorphic binding
                                                                           JavaSDM.ensure ( !(algorithm.equals (setStrategy)) && !(request.equals (setStrategy)) ) ;
                                                                            
                                                                           // create object
                                                                           strategyInterface = new StrategyInterfaceAnnotation ( ) ;
                                                                            
                                                                           // assign statement
                                                                           strategyInterface.setClassification (1);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToElements ("strategy", abstractStrategy);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToElements ("context", context);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToBoundObjects ("algorithm", algorithm);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToBoundObjects ("abstractStrategy", abstractStrategy);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToBoundObjects ("request", request);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToBoundObjects ("context", context);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToBoundObjects ("setStrategy", setStrategy);
                                                                            
                                                                           fujaba__Success = true ;
                                                                        }
                                                                        catch ( JavaSDMException fujaba__InternalException )
                                                                        {
                                                                           fujaba__Success = false ;
                                                                        }
                                                                         
                                                                        try
                                                                        {
                                                                           fujaba__Success = false ;
                                                                            
                                                                           // check object neighborCall16 is really bound
                                                                           JavaSDM.ensure ( neighborCall16 != null ) ;
                                                                            
                                                                           // check object reference17 is really bound
                                                                           JavaSDM.ensure ( reference17 != null ) ;
                                                                            
                                                                           // check object overridingMethod19 is really bound
                                                                           JavaSDM.ensure ( overridingMethod19 != null ) ;
                                                                            
                                                                           // check object strategyInterface is really bound
                                                                           JavaSDM.ensure ( strategyInterface != null ) ;
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToAntecedentAnnos (neighborCall16);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToAntecedentAnnos (reference17);
                                                                            
                                                                           // create link
                                                                           strategyInterface.addToAntecedentAnnos (overridingMethod19);
                                                                            
                                                                           fujaba__Success = true ;
                                                                        }
                                                                        catch ( JavaSDMException fujaba__InternalException )
                                                                        {
                                                                           fujaba__Success = false ;
                                                                        }
                                                                         
                                                                        return (strategyInterface) ;
                                                                     }
                                                                  } //  end for each flow
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object strategyInterface is really bound
            JavaSDM.ensure ( strategyInterface != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_Reference", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (strategyInterface) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("strategy", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("context", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof NeighborCallAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_NeighborCall", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof ReferenceAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_Reference", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof OverridingMethodAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_OverridingMethod", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterAbstractStrategyMethodsAlgorithm = null ;
      Iterator fujaba__IterAlgorithmAnnotationsNeighborCall26 = null ;
      Iterator fujaba__IterContextMethodsRequest = null ;
      Iterator fujaba__IterNeighborCall21ElementsAlgorithm = null ;
      Iterator fujaba__IterNeighborCall26ElementsRequest = null ;
      Iterator fujaba__IterNeighborCall27ElementsAlgorithm = null ;
      Iterator fujaba__IterNeighborCall28ElementsAlgorithm = null ;
      Iterator fujaba__IterOverridingMethod24ElementsAlgorithm = null ;
      Iterator fujaba__IterReference22ElementsContext = null ;
      Iterator fujaba__IterRequestAnnotationsNeighborCall27 = null ;
      Iterator fujaba__IterRequestAnnotationsNeighborCall28 = null ;
      NeighborCallAnnotation neighborCall21 = null ;
      NeighborCallAnnotation neighborCall26 = null ;
      NeighborCallAnnotation neighborCall27 = null ;
      NeighborCallAnnotation neighborCall28 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      OverridingMethodAnnotation overridingMethod24 = null ;
      ReferenceAnnotation reference22 = null ;
      UMLClass abstractStrategy = null ;
      UMLClass context = null ;
      UMLMethod algorithm = null ;
      UMLMethod request = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("NeighborCall") || annotation.equals ("Delegation") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
            while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
            {
               try
               {
                  algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                   
                  {
                     //  for each flow
                     set.add (algorithm);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
            while ( fujaba__IterContextMethodsRequest.hasNext () )
            {
               try
               {
                  request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                   
                  {
                     //  for each flow
                     set.add (request);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference22 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind context: UMLClass
            fujaba__IterReference22ElementsContext = reference22.iteratorOfElements ("referencingClass") ;
            while ( fujaba__IterReference22ElementsContext.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference22ElementsContext.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  context = (UMLClass) fujaba__TmpObject ;
                   
                  // bind request: UMLMethod
                  fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
                  while ( fujaba__IterContextMethodsRequest.hasNext () )
                  {
                     try
                     {
                        request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                         
                        {
                           //  for each flow
                           set.add (request);
                        } //  end for each flow
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod24 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterOverridingMethod24ElementsAlgorithm = overridingMethod24.iteratorOfElements ("overridden") ;
            while ( fujaba__IterOverridingMethod24ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod24ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (algorithm);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("Reference") || annotation.equals ("MultiReference") || annotation.equals ("ArrayReference") || annotation.equals ("SingleReference") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (abstractStrategy);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (context);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall21 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterNeighborCall21ElementsAlgorithm = neighborCall21.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall21ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall21ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind abstractStrategy: UMLClass
                  abstractStrategy = algorithm.getParent () ;
                  JavaSDM.ensure ( abstractStrategy != null ) ;
                   
                  {
                     //  for each flow
                     set.add (abstractStrategy);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof OverridingMethodAnnotation ) ;
             
            // explicit type cast
            overridingMethod24 = (OverridingMethodAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterOverridingMethod24ElementsAlgorithm = overridingMethod24.iteratorOfElements ("overridden") ;
            while ( fujaba__IterOverridingMethod24ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterOverridingMethod24ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  // bind neighborCall26: NeighborCallAnnotation
                  fujaba__IterAlgorithmAnnotationsNeighborCall26 = algorithm.iteratorOfAnnotations () ;
                  while ( fujaba__IterAlgorithmAnnotationsNeighborCall26.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterAlgorithmAnnotationsNeighborCall26.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall26 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall26 and algorithm
                        JavaSDM.ensure ( neighborCall26.hasInElements ("callee", algorithm) ) ;
                         
                        // bind request: UMLMethod
                        fujaba__IterNeighborCall26ElementsRequest = neighborCall26.iteratorOfElements ("caller") ;
                        while ( fujaba__IterNeighborCall26ElementsRequest.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall26ElementsRequest.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              request = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(algorithm.equals (request)) ) ;
                               
                              // bind context: UMLClass
                              context = request.getParent () ;
                              JavaSDM.ensure ( context != null ) ;
                               
                              {
                                 //  for each flow
                                 set.add (context);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      if ( annotation.equals ("OverridingMethod") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            abstractStrategy = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterAbstractStrategyMethodsAlgorithm = abstractStrategy.iteratorOfMethods () ;
            while ( fujaba__IterAbstractStrategyMethodsAlgorithm.hasNext () )
            {
               try
               {
                  algorithm = (UMLMethod) fujaba__IterAbstractStrategyMethodsAlgorithm.next () ;
                   
                  {
                     //  for each flow
                     set.add (algorithm);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            context = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind request: UMLMethod
            fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
            while ( fujaba__IterContextMethodsRequest.hasNext () )
            {
               try
               {
                  request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                   
                  // bind neighborCall27: NeighborCallAnnotation
                  fujaba__IterRequestAnnotationsNeighborCall27 = request.iteratorOfAnnotations () ;
                  while ( fujaba__IterRequestAnnotationsNeighborCall27.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterRequestAnnotationsNeighborCall27.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                        neighborCall27 = (NeighborCallAnnotation) fujaba__TmpObject ;
                         
                        // check Reverse-Qualified-Link 'elements' between neighborCall27 and request
                        JavaSDM.ensure ( neighborCall27.hasInElements ("caller", request) ) ;
                         
                        // bind algorithm: UMLMethod
                        fujaba__IterNeighborCall27ElementsAlgorithm = neighborCall27.iteratorOfElements ("callee") ;
                        while ( fujaba__IterNeighborCall27ElementsAlgorithm.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterNeighborCall27ElementsAlgorithm.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                              algorithm = (UMLMethod) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(request.equals (algorithm)) ) ;
                               
                              {
                                 //  for each flow
                                 set.add (algorithm);
                              } //  end for each flow
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof NeighborCallAnnotation ) ;
             
            // explicit type cast
            neighborCall27 = (NeighborCallAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind algorithm: UMLMethod
            fujaba__IterNeighborCall27ElementsAlgorithm = neighborCall27.iteratorOfElements ("callee") ;
            while ( fujaba__IterNeighborCall27ElementsAlgorithm.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterNeighborCall27ElementsAlgorithm.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                  algorithm = (UMLMethod) fujaba__TmpObject ;
                   
                  {
                     //  for each flow
                     set.add (algorithm);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof ReferenceAnnotation ) ;
             
            // explicit type cast
            reference22 = (ReferenceAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind context: UMLClass
            fujaba__IterReference22ElementsContext = reference22.iteratorOfElements ("referencingClass") ;
            while ( fujaba__IterReference22ElementsContext.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReference22ElementsContext.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  context = (UMLClass) fujaba__TmpObject ;
                   
                  // bind request: UMLMethod
                  fujaba__IterContextMethodsRequest = context.iteratorOfMethods () ;
                  while ( fujaba__IterContextMethodsRequest.hasNext () )
                  {
                     try
                     {
                        request = (UMLMethod) fujaba__IterContextMethodsRequest.next () ;
                         
                        // bind neighborCall28: NeighborCallAnnotation
                        fujaba__IterRequestAnnotationsNeighborCall28 = request.iteratorOfAnnotations () ;
                        while ( fujaba__IterRequestAnnotationsNeighborCall28.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterRequestAnnotationsNeighborCall28.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof NeighborCallAnnotation ) ;
                              neighborCall28 = (NeighborCallAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between neighborCall28 and request
                              JavaSDM.ensure ( neighborCall28.hasInElements ("caller", request) ) ;
                               
                              // bind algorithm: UMLMethod
                              fujaba__IterNeighborCall28ElementsAlgorithm = neighborCall28.iteratorOfElements ("callee") ;
                              while ( fujaba__IterNeighborCall28ElementsAlgorithm.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterNeighborCall28ElementsAlgorithm.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    algorithm = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(request.equals (algorithm)) ) ;
                                     
                                    {
                                       //  for each flow
                                       set.add (algorithm);
                                    } //  end for each flow
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
