package de.upb.inferenceengine.engines;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.sdm.*;
import java.util.*;
import de.upb.tools.fca.*;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLType;

public class QualifiedReferenceEngine
extends GFRNEngine
{
   private  QualifiedReferenceEngine()
   {
   }

   private static QualifiedReferenceEngine theQualifiedReferenceEngine;

   public static QualifiedReferenceEngine get()
   {
      if (theQualifiedReferenceEngine == null)
      {
         theQualifiedReferenceEngine = new QualifiedReferenceEngine ();
      }
      return theQualifiedReferenceEngine;
   }

   public GFRNAnnotation annotate(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      GFRNAnnotation qualifiedReference = null;
      try
      {
         fujaba__Success = false ;
          
         // collabStatBegin 1 is empty !
         qualifiedReference = this.annotateUsingFieldRole(asgElement);
          
         // collabStatEnd
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      try
      {
         fujaba__Success = false ;
          
         // constraint
         JavaSDM.ensure ( qualifiedReference != null ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
         return (qualifiedReference) ;
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            // collabStatBegin 1 is empty !
            qualifiedReference = this.annotateUsingTrigger_DoubleContainerAccessRole(asgElement);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // constraint
            JavaSDM.ensure ( qualifiedReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
            return (qualifiedReference) ;
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // collabStatBegin 1 is empty !
               qualifiedReference = this.annotateUsingReferencesRole(asgElement);
                
               // collabStatEnd
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            try
            {
               fujaba__Success = false ;
                
               // constraint
               JavaSDM.ensure ( qualifiedReference != null ) ;
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
            if ( fujaba__Success )
            {
               return (qualifiedReference) ;
            }
            else
            {
               try
               {
                  fujaba__Success = false ;
                   
                  // collabStatBegin 1 is empty !
                  qualifiedReference = this.annotateUsingKeyParamRole(asgElement);
                   
                  // collabStatEnd
                  fujaba__Success = true ;
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
                  fujaba__Success = false ;
               }
                
               return (qualifiedReference) ;
            }
         }
      }
   }


   private GFRNAnnotation annotateUsingFieldRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DoubleContainerAccessAnnotation doubleContainerAccess1 = null ;
      Iterator fujaba__IterDoubleContainerAccess1ElementsAddKey = null ;
      Iterator fujaba__IterDoubleContainerAccess1ElementsValue = null ;
      Iterator fujaba__IterGetMethodParamGetKey = null ;
      Iterator fujaba__IterReferencedClassAnnotationsQualifiedReference = null ;
      Iterator fujaba__IterReferencingClassMethodsAddMethod = null ;
      Iterator fujaba__IterReferencingClassMethodsGetMethod = null ;
      Iterator fujaba__IterReferencingFieldAnnotationsDoubleContainerAccess1 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      QualifiedReferenceAnnotation qualifiedReference = null ;
      UMLAttr referencingField = null ;
      UMLClass referencedClass = null ;
      UMLClass referencingClass = null ;
      UMLMethod addMethod = null ;
      UMLMethod getMethod = null ;
      UMLParam addKey = null ;
      UMLParam getKey = null ;
      UMLParam value = null ;
      UMLType uMLType2 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
             
            // explicit type cast
            referencingField = (UMLAttr) fujaba__tmpTypeCastObject ;
             
            // bind referencingClass: UMLClass
            referencingClass = referencingField.getParent () ;
            JavaSDM.ensure ( referencingClass != null ) ;
             
            // bind doubleContainerAccess1: DoubleContainerAccessAnnotation
            fujaba__IterReferencingFieldAnnotationsDoubleContainerAccess1 = referencingField.iteratorOfAnnotations () ;
            while ( fujaba__IterReferencingFieldAnnotationsDoubleContainerAccess1.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterReferencingFieldAnnotationsDoubleContainerAccess1.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof DoubleContainerAccessAnnotation ) ;
                  doubleContainerAccess1 = (DoubleContainerAccessAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between doubleContainerAccess1 and referencingField
                  JavaSDM.ensure ( doubleContainerAccess1.hasInElements ("field", referencingField) ) ;
                   
                  // bind getMethod: UMLMethod
                  fujaba__IterReferencingClassMethodsGetMethod = referencingClass.iteratorOfMethods () ;
                  while ( fujaba__IterReferencingClassMethodsGetMethod.hasNext () )
                  {
                     try
                     {
                        getMethod = (UMLMethod) fujaba__IterReferencingClassMethodsGetMethod.next () ;
                         
                        // bind referencedClass: UMLClass
                        fujaba__TmpObject = getMethod.getResultType () ;
                        JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        referencedClass = (UMLClass) fujaba__TmpObject ;
                         
                        // bind addMethod: UMLMethod
                        fujaba__IterReferencingClassMethodsAddMethod = referencingClass.iteratorOfMethods () ;
                        while ( fujaba__IterReferencingClassMethodsAddMethod.hasNext () )
                        {
                           try
                           {
                              addMethod = (UMLMethod) fujaba__IterReferencingClassMethodsAddMethod.next () ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(getMethod.equals (addMethod)) ) ;
                               
                              // check To-Many-Link 'elements' between doubleContainerAccess1 and addMethod
                              JavaSDM.ensure ( doubleContainerAccess1.hasInElements ("method", addMethod) ) ;
                               
                              // bind value: UMLParam
                              fujaba__IterDoubleContainerAccess1ElementsValue = doubleContainerAccess1.iteratorOfElements ("param") ;
                              while ( fujaba__IterDoubleContainerAccess1ElementsValue.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterDoubleContainerAccess1ElementsValue.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                                    value = (UMLParam) fujaba__TmpObject ;
                                     
                                    // check To-One-Link 'paramType' between value and referencedClass
                                    JavaSDM.ensure ( (value.getParamType () != null) && value.getParamType ().equals (referencedClass) ) ;
                                     
                                    // bind addKey: UMLParam
                                    fujaba__IterDoubleContainerAccess1ElementsAddKey = doubleContainerAccess1.iteratorOfElements ("param") ;
                                    while ( fujaba__IterDoubleContainerAccess1ElementsAddKey.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterDoubleContainerAccess1ElementsAddKey.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                                          addKey = (UMLParam) fujaba__TmpObject ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(value.equals (addKey)) ) ;
                                           
                                          // bind uMLType2: UMLType
                                          uMLType2 = addKey.getParamType () ;
                                          JavaSDM.ensure ( uMLType2 != null ) ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(referencingClass.equals (uMLType2)) && !(referencedClass.equals (uMLType2)) ) ;
                                           
                                          // bind getKey: UMLParam
                                          fujaba__IterGetMethodParamGetKey = getMethod.iteratorOfParam () ;
                                          while ( fujaba__IterGetMethodParamGetKey.hasNext () )
                                          {
                                             try
                                             {
                                                getKey = (UMLParam) fujaba__IterGetMethodParamGetKey.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(value.equals (getKey)) && !(addKey.equals (getKey)) ) ;
                                                 
                                                // check To-One-Link 'paramType' between getKey and uMLType2
                                                JavaSDM.ensure ( (getKey.getParamType () != null) && getKey.getParamType ().equals (uMLType2) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object referencingField is really bound
                                                      JavaSDM.ensure ( referencingField != null ) ;
                                                       
                                                      // check object referencedClass is really bound
                                                      JavaSDM.ensure ( referencedClass != null ) ;
                                                       
                                                      // check object addKey is really bound
                                                      JavaSDM.ensure ( addKey != null ) ;
                                                       
                                                      // bind qualifiedReference: QualifiedReferenceAnnotation
                                                      fujaba__IterReferencedClassAnnotationsQualifiedReference = referencedClass.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterReferencedClassAnnotationsQualifiedReference.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterReferencedClassAnnotationsQualifiedReference.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof QualifiedReferenceAnnotation ) ;
                                                            qualifiedReference = (QualifiedReferenceAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between qualifiedReference and referencedClass
                                                            JavaSDM.ensure ( qualifiedReference.hasInElements ("references", referencedClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between qualifiedReference and referencingField
                                                            JavaSDM.ensure ( qualifiedReference.hasInElements ("field", referencingField) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between qualifiedReference and addKey
                                                            JavaSDM.ensure ( qualifiedReference.hasInElements ("keyParam", addKey) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object referencingField is really bound
                                                         JavaSDM.ensure ( referencingField != null ) ;
                                                          
                                                         // check object referencedClass is really bound
                                                         JavaSDM.ensure ( referencedClass != null ) ;
                                                          
                                                         // check object addKey is really bound
                                                         JavaSDM.ensure ( addKey != null ) ;
                                                          
                                                         // check object value is really bound
                                                         JavaSDM.ensure ( value != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(addKey.equals (value)) ) ;
                                                          
                                                         // check object getMethod is really bound
                                                         JavaSDM.ensure ( getMethod != null ) ;
                                                          
                                                         // check object addMethod is really bound
                                                         JavaSDM.ensure ( addMethod != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(getMethod.equals (addMethod)) ) ;
                                                          
                                                         // check object referencingClass is really bound
                                                         JavaSDM.ensure ( referencingClass != null ) ;
                                                          
                                                         // check object getKey is really bound
                                                         JavaSDM.ensure ( getKey != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(addKey.equals (getKey)) && !(value.equals (getKey)) ) ;
                                                          
                                                         // create object
                                                         qualifiedReference = new QualifiedReferenceAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         qualifiedReference.setClassification (0);
                                                          
                                                         // create link
                                                         qualifiedReference.addToElements ("field", referencingField);
                                                          
                                                         // create link
                                                         qualifiedReference.addToElements ("references", referencedClass);
                                                          
                                                         // create link
                                                         qualifiedReference.addToElements ("keyParam", addKey);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("referencingField", referencingField);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("value", value);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("getMethod", getMethod);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("addMethod", addMethod);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("referencingClass", referencingClass);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("referencedClass", referencedClass);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("getKey", getKey);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("addKey", addKey);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object doubleContainerAccess1 is really bound
                                                         JavaSDM.ensure ( doubleContainerAccess1 != null ) ;
                                                          
                                                         // check object qualifiedReference is really bound
                                                         JavaSDM.ensure ( qualifiedReference != null ) ;
                                                          
                                                         // create link
                                                         qualifiedReference.addToAntecedentAnnos (doubleContainerAccess1);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (qualifiedReference) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object qualifiedReference is really bound
            JavaSDM.ensure ( qualifiedReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("field", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (qualifiedReference) ;
   }


   private GFRNAnnotation annotateUsingKeyParamRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DoubleContainerAccessAnnotation doubleContainerAccess7 = null ;
      Iterator fujaba__IterAddKeyAnnotationsDoubleContainerAccess7 = null ;
      Iterator fujaba__IterDoubleContainerAccess7ElementsAddMethod = null ;
      Iterator fujaba__IterDoubleContainerAccess7ElementsReferencingField = null ;
      Iterator fujaba__IterDoubleContainerAccess7ElementsValue = null ;
      Iterator fujaba__IterReferencedClassAnnotationsQualifiedReference = null ;
      Iterator fujaba__IterUMLType8RevParamTypeGetKey = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      QualifiedReferenceAnnotation qualifiedReference = null ;
      UMLAttr referencingField = null ;
      UMLClass referencedClass = null ;
      UMLClass referencingClass = null ;
      UMLMethod addMethod = null ;
      UMLMethod getMethod = null ;
      UMLParam addKey = null ;
      UMLParam getKey = null ;
      UMLParam value = null ;
      UMLType uMLType8 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("keyParam", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
             
            // explicit type cast
            addKey = (UMLParam) fujaba__tmpTypeCastObject ;
             
            // bind uMLType8: UMLType
            uMLType8 = addKey.getParamType () ;
            JavaSDM.ensure ( uMLType8 != null ) ;
             
            // bind doubleContainerAccess7: DoubleContainerAccessAnnotation
            fujaba__IterAddKeyAnnotationsDoubleContainerAccess7 = addKey.iteratorOfAnnotations () ;
            while ( fujaba__IterAddKeyAnnotationsDoubleContainerAccess7.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterAddKeyAnnotationsDoubleContainerAccess7.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof DoubleContainerAccessAnnotation ) ;
                  doubleContainerAccess7 = (DoubleContainerAccessAnnotation) fujaba__TmpObject ;
                   
                  // check Reverse-Qualified-Link 'elements' between doubleContainerAccess7 and addKey
                  JavaSDM.ensure ( doubleContainerAccess7.hasInElements ("param", addKey) ) ;
                   
                  // bind getKey: UMLParam
                  fujaba__IterUMLType8RevParamTypeGetKey = uMLType8.iteratorOfRevParamType () ;
                  while ( fujaba__IterUMLType8RevParamTypeGetKey.hasNext () )
                  {
                     try
                     {
                        getKey = (UMLParam) fujaba__IterUMLType8RevParamTypeGetKey.next () ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(addKey.equals (getKey)) ) ;
                         
                        // bind getMethod: UMLMethod
                        getMethod = getKey.getRevParam () ;
                        JavaSDM.ensure ( getMethod != null ) ;
                         
                        // bind referencedClass: UMLClass
                        fujaba__TmpObject = getMethod.getResultType () ;
                        JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                        referencedClass = (UMLClass) fujaba__TmpObject ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(uMLType8.equals (referencedClass)) ) ;
                         
                        // bind referencingClass: UMLClass
                        referencingClass = getMethod.getParent () ;
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // check isomorphic binding
                        JavaSDM.ensure ( !(uMLType8.equals (referencingClass)) ) ;
                         
                        // bind value: UMLParam
                        fujaba__IterDoubleContainerAccess7ElementsValue = doubleContainerAccess7.iteratorOfElements ("param") ;
                        while ( fujaba__IterDoubleContainerAccess7ElementsValue.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterDoubleContainerAccess7ElementsValue.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                              value = (UMLParam) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(getKey.equals (value)) && !(addKey.equals (value)) ) ;
                               
                              // check To-One-Link 'paramType' between value and referencedClass
                              JavaSDM.ensure ( (value.getParamType () != null) && value.getParamType ().equals (referencedClass) ) ;
                               
                              // bind addMethod: UMLMethod
                              fujaba__IterDoubleContainerAccess7ElementsAddMethod = doubleContainerAccess7.iteratorOfElements ("method") ;
                              while ( fujaba__IterDoubleContainerAccess7ElementsAddMethod.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterDoubleContainerAccess7ElementsAddMethod.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                                    addMethod = (UMLMethod) fujaba__TmpObject ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(getMethod.equals (addMethod)) ) ;
                                     
                                    // check To-One-Link 'parent' between addMethod and referencingClass
                                    JavaSDM.ensure ( (addMethod.getParent () != null) && addMethod.getParent ().equals (referencingClass) ) ;
                                     
                                    // bind referencingField: UMLAttr
                                    fujaba__IterDoubleContainerAccess7ElementsReferencingField = doubleContainerAccess7.iteratorOfElements ("field") ;
                                    while ( fujaba__IterDoubleContainerAccess7ElementsReferencingField.hasNext () )
                                    {
                                       try
                                       {
                                          fujaba__TmpObject = fujaba__IterDoubleContainerAccess7ElementsReferencingField.next () ;
                                          JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                                          referencingField = (UMLAttr) fujaba__TmpObject ;
                                           
                                          // check To-One-Link 'parent' between referencingField and referencingClass
                                          JavaSDM.ensure ( (referencingField.getParent () != null) && referencingField.getParent ().equals (referencingClass) ) ;
                                           
                                          {
                                             //  for each flow
                                             try
                                             {
                                                fujaba__Success = false ;
                                                 
                                                // check object referencingField is really bound
                                                JavaSDM.ensure ( referencingField != null ) ;
                                                 
                                                // check object referencedClass is really bound
                                                JavaSDM.ensure ( referencedClass != null ) ;
                                                 
                                                // check object addKey is really bound
                                                JavaSDM.ensure ( addKey != null ) ;
                                                 
                                                // bind qualifiedReference: QualifiedReferenceAnnotation
                                                fujaba__IterReferencedClassAnnotationsQualifiedReference = referencedClass.iteratorOfAnnotations () ;
                                                while ( !(fujaba__Success) && fujaba__IterReferencedClassAnnotationsQualifiedReference.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterReferencedClassAnnotationsQualifiedReference.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof QualifiedReferenceAnnotation ) ;
                                                      qualifiedReference = (QualifiedReferenceAnnotation) fujaba__TmpObject ;
                                                       
                                                      // check Reverse-Qualified-Link 'elements' between qualifiedReference and referencedClass
                                                      JavaSDM.ensure ( qualifiedReference.hasInElements ("references", referencedClass) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between qualifiedReference and referencingField
                                                      JavaSDM.ensure ( qualifiedReference.hasInElements ("field", referencingField) ) ;
                                                       
                                                      // check To-Many-Link 'elements' between qualifiedReference and addKey
                                                      JavaSDM.ensure ( qualifiedReference.hasInElements ("keyParam", addKey) ) ;
                                                       
                                                      fujaba__Success = true ;
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                                fujaba__Success = false ;
                                             }
                                              
                                             if ( !(fujaba__Success) )
                                             {
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object referencingField is really bound
                                                   JavaSDM.ensure ( referencingField != null ) ;
                                                    
                                                   // check object referencedClass is really bound
                                                   JavaSDM.ensure ( referencedClass != null ) ;
                                                    
                                                   // check object addKey is really bound
                                                   JavaSDM.ensure ( addKey != null ) ;
                                                    
                                                   // check object value is really bound
                                                   JavaSDM.ensure ( value != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(addKey.equals (value)) ) ;
                                                    
                                                   // check object getMethod is really bound
                                                   JavaSDM.ensure ( getMethod != null ) ;
                                                    
                                                   // check object addMethod is really bound
                                                   JavaSDM.ensure ( addMethod != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(getMethod.equals (addMethod)) ) ;
                                                    
                                                   // check object referencingClass is really bound
                                                   JavaSDM.ensure ( referencingClass != null ) ;
                                                    
                                                   // check object getKey is really bound
                                                   JavaSDM.ensure ( getKey != null ) ;
                                                    
                                                   // check isomorphic binding
                                                   JavaSDM.ensure ( !(addKey.equals (getKey)) && !(value.equals (getKey)) ) ;
                                                    
                                                   // create object
                                                   qualifiedReference = new QualifiedReferenceAnnotation ( ) ;
                                                    
                                                   // assign statement
                                                   qualifiedReference.setClassification (0);
                                                    
                                                   // create link
                                                   qualifiedReference.addToElements ("field", referencingField);
                                                    
                                                   // create link
                                                   qualifiedReference.addToElements ("references", referencedClass);
                                                    
                                                   // create link
                                                   qualifiedReference.addToElements ("keyParam", addKey);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("referencingField", referencingField);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("value", value);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("getMethod", getMethod);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("addMethod", addMethod);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("referencingClass", referencingClass);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("referencedClass", referencedClass);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("getKey", getKey);
                                                    
                                                   // create link
                                                   qualifiedReference.addToBoundObjects ("addKey", addKey);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                try
                                                {
                                                   fujaba__Success = false ;
                                                    
                                                   // check object doubleContainerAccess7 is really bound
                                                   JavaSDM.ensure ( doubleContainerAccess7 != null ) ;
                                                    
                                                   // check object qualifiedReference is really bound
                                                   JavaSDM.ensure ( qualifiedReference != null ) ;
                                                    
                                                   // create link
                                                   qualifiedReference.addToAntecedentAnnos (doubleContainerAccess7);
                                                    
                                                   fujaba__Success = true ;
                                                }
                                                catch ( JavaSDMException fujaba__InternalException )
                                                {
                                                   fujaba__Success = false ;
                                                }
                                                 
                                                return (qualifiedReference) ;
                                             }
                                          } //  end for each flow
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object qualifiedReference is really bound
            JavaSDM.ensure ( qualifiedReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("keyParam", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (qualifiedReference) ;
   }


   private GFRNAnnotation annotateUsingReferencesRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DoubleContainerAccessAnnotation doubleContainerAccess5 = null ;
      Iterator fujaba__IterAddKeyAnnotationsQualifiedReference = null ;
      Iterator fujaba__IterDoubleContainerAccess5ElementsAddKey = null ;
      Iterator fujaba__IterGetMethodParamGetKey = null ;
      Iterator fujaba__IterReferencedClassRevParamTypeValue = null ;
      Iterator fujaba__IterReferencedClassRevResultTypeGetMethod = null ;
      Iterator fujaba__IterReferencingClassAttrsReferencingField = null ;
      Iterator fujaba__IterReferencingClassMethodsAddMethod = null ;
      Iterator fujaba__IterValueAnnotationsDoubleContainerAccess5 = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      QualifiedReferenceAnnotation qualifiedReference = null ;
      UMLAttr referencingField = null ;
      UMLClass referencedClass = null ;
      UMLClass referencingClass = null ;
      UMLMethod addMethod = null ;
      UMLMethod getMethod = null ;
      UMLParam addKey = null ;
      UMLParam getKey = null ;
      UMLParam value = null ;
      UMLType uMLType6 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referencedClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind value: UMLParam
            fujaba__IterReferencedClassRevParamTypeValue = referencedClass.iteratorOfRevParamType () ;
            while ( fujaba__IterReferencedClassRevParamTypeValue.hasNext () )
            {
               try
               {
                  value = (UMLParam) fujaba__IterReferencedClassRevParamTypeValue.next () ;
                   
                  // bind getMethod: UMLMethod
                  fujaba__IterReferencedClassRevResultTypeGetMethod = referencedClass.iteratorOfRevResultType () ;
                  while ( fujaba__IterReferencedClassRevResultTypeGetMethod.hasNext () )
                  {
                     try
                     {
                        getMethod = (UMLMethod) fujaba__IterReferencedClassRevResultTypeGetMethod.next () ;
                         
                        // bind referencingClass: UMLClass
                        referencingClass = getMethod.getParent () ;
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // bind doubleContainerAccess5: DoubleContainerAccessAnnotation
                        fujaba__IterValueAnnotationsDoubleContainerAccess5 = value.iteratorOfAnnotations () ;
                        while ( fujaba__IterValueAnnotationsDoubleContainerAccess5.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterValueAnnotationsDoubleContainerAccess5.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof DoubleContainerAccessAnnotation ) ;
                              doubleContainerAccess5 = (DoubleContainerAccessAnnotation) fujaba__TmpObject ;
                               
                              // check Reverse-Qualified-Link 'elements' between doubleContainerAccess5 and value
                              JavaSDM.ensure ( doubleContainerAccess5.hasInElements ("param", value) ) ;
                               
                              // bind getKey: UMLParam
                              fujaba__IterGetMethodParamGetKey = getMethod.iteratorOfParam () ;
                              while ( fujaba__IterGetMethodParamGetKey.hasNext () )
                              {
                                 try
                                 {
                                    getKey = (UMLParam) fujaba__IterGetMethodParamGetKey.next () ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(value.equals (getKey)) ) ;
                                     
                                    // bind uMLType6: UMLType
                                    uMLType6 = getKey.getParamType () ;
                                    JavaSDM.ensure ( uMLType6 != null ) ;
                                     
                                    // check isomorphic binding
                                    JavaSDM.ensure ( !(referencingClass.equals (uMLType6)) && !(referencedClass.equals (uMLType6)) ) ;
                                     
                                    // bind referencingField: UMLAttr
                                    fujaba__IterReferencingClassAttrsReferencingField = referencingClass.iteratorOfAttrs () ;
                                    while ( fujaba__IterReferencingClassAttrsReferencingField.hasNext () )
                                    {
                                       try
                                       {
                                          referencingField = (UMLAttr) fujaba__IterReferencingClassAttrsReferencingField.next () ;
                                           
                                          // check To-Many-Link 'elements' between doubleContainerAccess5 and referencingField
                                          JavaSDM.ensure ( doubleContainerAccess5.hasInElements ("field", referencingField) ) ;
                                           
                                          // bind addMethod: UMLMethod
                                          fujaba__IterReferencingClassMethodsAddMethod = referencingClass.iteratorOfMethods () ;
                                          while ( fujaba__IterReferencingClassMethodsAddMethod.hasNext () )
                                          {
                                             try
                                             {
                                                addMethod = (UMLMethod) fujaba__IterReferencingClassMethodsAddMethod.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(getMethod.equals (addMethod)) ) ;
                                                 
                                                // check To-Many-Link 'elements' between doubleContainerAccess5 and addMethod
                                                JavaSDM.ensure ( doubleContainerAccess5.hasInElements ("method", addMethod) ) ;
                                                 
                                                // bind addKey: UMLParam
                                                fujaba__IterDoubleContainerAccess5ElementsAddKey = doubleContainerAccess5.iteratorOfElements ("param") ;
                                                while ( fujaba__IterDoubleContainerAccess5ElementsAddKey.hasNext () )
                                                {
                                                   try
                                                   {
                                                      fujaba__TmpObject = fujaba__IterDoubleContainerAccess5ElementsAddKey.next () ;
                                                      JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                                                      addKey = (UMLParam) fujaba__TmpObject ;
                                                       
                                                      // check isomorphic binding
                                                      JavaSDM.ensure ( !(value.equals (addKey)) && !(getKey.equals (addKey)) ) ;
                                                       
                                                      // check To-One-Link 'paramType' between addKey and uMLType6
                                                      JavaSDM.ensure ( (addKey.getParamType () != null) && addKey.getParamType ().equals (uMLType6) ) ;
                                                       
                                                      {
                                                         //  for each flow
                                                         try
                                                         {
                                                            fujaba__Success = false ;
                                                             
                                                            // check object referencingField is really bound
                                                            JavaSDM.ensure ( referencingField != null ) ;
                                                             
                                                            // check object referencedClass is really bound
                                                            JavaSDM.ensure ( referencedClass != null ) ;
                                                             
                                                            // check object addKey is really bound
                                                            JavaSDM.ensure ( addKey != null ) ;
                                                             
                                                            // bind qualifiedReference: QualifiedReferenceAnnotation
                                                            fujaba__IterAddKeyAnnotationsQualifiedReference = addKey.iteratorOfAnnotations () ;
                                                            while ( !(fujaba__Success) && fujaba__IterAddKeyAnnotationsQualifiedReference.hasNext () )
                                                            {
                                                               try
                                                               {
                                                                  fujaba__TmpObject = fujaba__IterAddKeyAnnotationsQualifiedReference.next () ;
                                                                  JavaSDM.ensure ( fujaba__TmpObject instanceof QualifiedReferenceAnnotation ) ;
                                                                  qualifiedReference = (QualifiedReferenceAnnotation) fujaba__TmpObject ;
                                                                   
                                                                  // check Reverse-Qualified-Link 'elements' between qualifiedReference and addKey
                                                                  JavaSDM.ensure ( qualifiedReference.hasInElements ("keyParam", addKey) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between qualifiedReference and referencingField
                                                                  JavaSDM.ensure ( qualifiedReference.hasInElements ("field", referencingField) ) ;
                                                                   
                                                                  // check To-Many-Link 'elements' between qualifiedReference and referencedClass
                                                                  JavaSDM.ensure ( qualifiedReference.hasInElements ("references", referencedClass) ) ;
                                                                   
                                                                  fujaba__Success = true ;
                                                               }
                                                               catch ( JavaSDMException fujaba__InternalException )
                                                               {
                                                               }
                                                            }
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                            fujaba__Success = false ;
                                                         }
                                                          
                                                         if ( !(fujaba__Success) )
                                                         {
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object referencingField is really bound
                                                               JavaSDM.ensure ( referencingField != null ) ;
                                                                
                                                               // check object referencedClass is really bound
                                                               JavaSDM.ensure ( referencedClass != null ) ;
                                                                
                                                               // check object addKey is really bound
                                                               JavaSDM.ensure ( addKey != null ) ;
                                                                
                                                               // check object value is really bound
                                                               JavaSDM.ensure ( value != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(addKey.equals (value)) ) ;
                                                                
                                                               // check object getMethod is really bound
                                                               JavaSDM.ensure ( getMethod != null ) ;
                                                                
                                                               // check object addMethod is really bound
                                                               JavaSDM.ensure ( addMethod != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(getMethod.equals (addMethod)) ) ;
                                                                
                                                               // check object referencingClass is really bound
                                                               JavaSDM.ensure ( referencingClass != null ) ;
                                                                
                                                               // check object getKey is really bound
                                                               JavaSDM.ensure ( getKey != null ) ;
                                                                
                                                               // check isomorphic binding
                                                               JavaSDM.ensure ( !(addKey.equals (getKey)) && !(value.equals (getKey)) ) ;
                                                                
                                                               // create object
                                                               qualifiedReference = new QualifiedReferenceAnnotation ( ) ;
                                                                
                                                               // assign statement
                                                               qualifiedReference.setClassification (0);
                                                                
                                                               // create link
                                                               qualifiedReference.addToElements ("field", referencingField);
                                                                
                                                               // create link
                                                               qualifiedReference.addToElements ("references", referencedClass);
                                                                
                                                               // create link
                                                               qualifiedReference.addToElements ("keyParam", addKey);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("referencingField", referencingField);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("value", value);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("getMethod", getMethod);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("addMethod", addMethod);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("referencingClass", referencingClass);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("referencedClass", referencedClass);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("getKey", getKey);
                                                                
                                                               // create link
                                                               qualifiedReference.addToBoundObjects ("addKey", addKey);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            try
                                                            {
                                                               fujaba__Success = false ;
                                                                
                                                               // check object doubleContainerAccess5 is really bound
                                                               JavaSDM.ensure ( doubleContainerAccess5 != null ) ;
                                                                
                                                               // check object qualifiedReference is really bound
                                                               JavaSDM.ensure ( qualifiedReference != null ) ;
                                                                
                                                               // create link
                                                               qualifiedReference.addToAntecedentAnnos (doubleContainerAccess5);
                                                                
                                                               fujaba__Success = true ;
                                                            }
                                                            catch ( JavaSDMException fujaba__InternalException )
                                                            {
                                                               fujaba__Success = false ;
                                                            }
                                                             
                                                            return (qualifiedReference) ;
                                                         }
                                                      } //  end for each flow
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                   }
                                                }
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object qualifiedReference is really bound
            JavaSDM.ensure ( qualifiedReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("references", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (qualifiedReference) ;
   }


   private GFRNAnnotation annotateUsingTrigger_DoubleContainerAccessRole(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
      DoubleContainerAccessAnnotation doubleContainerAccess3 = null ;
      Iterator fujaba__IterDoubleContainerAccess3ElementsAddKey = null ;
      Iterator fujaba__IterDoubleContainerAccess3ElementsAddMethod = null ;
      Iterator fujaba__IterDoubleContainerAccess3ElementsReferencingField = null ;
      Iterator fujaba__IterDoubleContainerAccess3ElementsValue = null ;
      Iterator fujaba__IterReferencedClassAnnotationsQualifiedReference = null ;
      Iterator fujaba__IterReferencedClassRevResultTypeGetMethod = null ;
      Iterator fujaba__IterUMLType4RevParamTypeGetKey = null ;
      Object fujaba__TmpObject = null ;
      Object fujaba__tmpTypeCastObject = null ;
      QualifiedReferenceAnnotation qualifiedReference = null ;
      UMLAttr referencingField = null ;
      UMLClass referencedClass = null ;
      UMLClass referencingClass = null ;
      UMLMethod addMethod = null ;
      UMLMethod getMethod = null ;
      UMLParam addKey = null ;
      UMLParam getKey = null ;
      UMLParam value = null ;
      UMLType uMLType4 = null ;
       
      try
      {
         fujaba__Success = false ;
          
         // check object asgElement is really bound
         JavaSDM.ensure ( asgElement != null ) ;
          
         // check To-Many-Link 'failedApplications' between this and asgElement
         JavaSDM.ensure ( this.hasInFailedApplications ("trigger_DoubleContainerAccess", asgElement) ) ;
          
         fujaba__Success = true ;
      }
      catch ( JavaSDMException fujaba__InternalException )
      {
         fujaba__Success = false ;
      }
       
      if ( fujaba__Success )
      {
      }
      else
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof DoubleContainerAccessAnnotation ) ;
             
            // explicit type cast
            doubleContainerAccess3 = (DoubleContainerAccessAnnotation) fujaba__tmpTypeCastObject ;
             
            // bind value: UMLParam
            fujaba__IterDoubleContainerAccess3ElementsValue = doubleContainerAccess3.iteratorOfElements ("param") ;
            while ( fujaba__IterDoubleContainerAccess3ElementsValue.hasNext () )
            {
               try
               {
                  fujaba__TmpObject = fujaba__IterDoubleContainerAccess3ElementsValue.next () ;
                  JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                  value = (UMLParam) fujaba__TmpObject ;
                   
                  // bind referencedClass: UMLClass
                  fujaba__TmpObject = value.getParamType () ;
                  JavaSDM.ensure ( (fujaba__TmpObject != null) && fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
                  referencedClass = (UMLClass) fujaba__TmpObject ;
                   
                  // bind addMethod: UMLMethod
                  fujaba__IterDoubleContainerAccess3ElementsAddMethod = doubleContainerAccess3.iteratorOfElements ("method") ;
                  while ( fujaba__IterDoubleContainerAccess3ElementsAddMethod.hasNext () )
                  {
                     try
                     {
                        fujaba__TmpObject = fujaba__IterDoubleContainerAccess3ElementsAddMethod.next () ;
                        JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLMethod ) ;
                        addMethod = (UMLMethod) fujaba__TmpObject ;
                         
                        // bind referencingClass: UMLClass
                        referencingClass = addMethod.getParent () ;
                        JavaSDM.ensure ( referencingClass != null ) ;
                         
                        // bind addKey: UMLParam
                        fujaba__IterDoubleContainerAccess3ElementsAddKey = doubleContainerAccess3.iteratorOfElements ("param") ;
                        while ( fujaba__IterDoubleContainerAccess3ElementsAddKey.hasNext () )
                        {
                           try
                           {
                              fujaba__TmpObject = fujaba__IterDoubleContainerAccess3ElementsAddKey.next () ;
                              JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
                              addKey = (UMLParam) fujaba__TmpObject ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(value.equals (addKey)) ) ;
                               
                              // bind uMLType4: UMLType
                              uMLType4 = addKey.getParamType () ;
                              JavaSDM.ensure ( uMLType4 != null ) ;
                               
                              // check isomorphic binding
                              JavaSDM.ensure ( !(referencingClass.equals (uMLType4)) && !(referencedClass.equals (uMLType4)) ) ;
                               
                              // bind referencingField: UMLAttr
                              fujaba__IterDoubleContainerAccess3ElementsReferencingField = doubleContainerAccess3.iteratorOfElements ("field") ;
                              while ( fujaba__IterDoubleContainerAccess3ElementsReferencingField.hasNext () )
                              {
                                 try
                                 {
                                    fujaba__TmpObject = fujaba__IterDoubleContainerAccess3ElementsReferencingField.next () ;
                                    JavaSDM.ensure ( fujaba__TmpObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
                                    referencingField = (UMLAttr) fujaba__TmpObject ;
                                     
                                    // check To-One-Link 'parent' between referencingField and referencingClass
                                    JavaSDM.ensure ( (referencingField.getParent () != null) && referencingField.getParent ().equals (referencingClass) ) ;
                                     
                                    // bind getMethod: UMLMethod
                                    fujaba__IterReferencedClassRevResultTypeGetMethod = referencedClass.iteratorOfRevResultType () ;
                                    while ( fujaba__IterReferencedClassRevResultTypeGetMethod.hasNext () )
                                    {
                                       try
                                       {
                                          getMethod = (UMLMethod) fujaba__IterReferencedClassRevResultTypeGetMethod.next () ;
                                           
                                          // check isomorphic binding
                                          JavaSDM.ensure ( !(addMethod.equals (getMethod)) ) ;
                                           
                                          // check To-One-Link 'parent' between getMethod and referencingClass
                                          JavaSDM.ensure ( (getMethod.getParent () != null) && getMethod.getParent ().equals (referencingClass) ) ;
                                           
                                          // bind getKey: UMLParam
                                          fujaba__IterUMLType4RevParamTypeGetKey = uMLType4.iteratorOfRevParamType () ;
                                          while ( fujaba__IterUMLType4RevParamTypeGetKey.hasNext () )
                                          {
                                             try
                                             {
                                                getKey = (UMLParam) fujaba__IterUMLType4RevParamTypeGetKey.next () ;
                                                 
                                                // check isomorphic binding
                                                JavaSDM.ensure ( !(value.equals (getKey)) && !(addKey.equals (getKey)) ) ;
                                                 
                                                // check To-One-Link 'revParam' between getKey and getMethod
                                                JavaSDM.ensure ( (getKey.getRevParam () != null) && getKey.getRevParam ().equals (getMethod) ) ;
                                                 
                                                {
                                                   //  for each flow
                                                   try
                                                   {
                                                      fujaba__Success = false ;
                                                       
                                                      // check object referencingField is really bound
                                                      JavaSDM.ensure ( referencingField != null ) ;
                                                       
                                                      // check object referencedClass is really bound
                                                      JavaSDM.ensure ( referencedClass != null ) ;
                                                       
                                                      // check object addKey is really bound
                                                      JavaSDM.ensure ( addKey != null ) ;
                                                       
                                                      // bind qualifiedReference: QualifiedReferenceAnnotation
                                                      fujaba__IterReferencedClassAnnotationsQualifiedReference = referencedClass.iteratorOfAnnotations () ;
                                                      while ( !(fujaba__Success) && fujaba__IterReferencedClassAnnotationsQualifiedReference.hasNext () )
                                                      {
                                                         try
                                                         {
                                                            fujaba__TmpObject = fujaba__IterReferencedClassAnnotationsQualifiedReference.next () ;
                                                            JavaSDM.ensure ( fujaba__TmpObject instanceof QualifiedReferenceAnnotation ) ;
                                                            qualifiedReference = (QualifiedReferenceAnnotation) fujaba__TmpObject ;
                                                             
                                                            // check Reverse-Qualified-Link 'elements' between qualifiedReference and referencedClass
                                                            JavaSDM.ensure ( qualifiedReference.hasInElements ("references", referencedClass) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between qualifiedReference and referencingField
                                                            JavaSDM.ensure ( qualifiedReference.hasInElements ("field", referencingField) ) ;
                                                             
                                                            // check To-Many-Link 'elements' between qualifiedReference and addKey
                                                            JavaSDM.ensure ( qualifiedReference.hasInElements ("keyParam", addKey) ) ;
                                                             
                                                            fujaba__Success = true ;
                                                         }
                                                         catch ( JavaSDMException fujaba__InternalException )
                                                         {
                                                         }
                                                      }
                                                   }
                                                   catch ( JavaSDMException fujaba__InternalException )
                                                   {
                                                      fujaba__Success = false ;
                                                   }
                                                    
                                                   if ( !(fujaba__Success) )
                                                   {
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object referencingField is really bound
                                                         JavaSDM.ensure ( referencingField != null ) ;
                                                          
                                                         // check object referencedClass is really bound
                                                         JavaSDM.ensure ( referencedClass != null ) ;
                                                          
                                                         // check object addKey is really bound
                                                         JavaSDM.ensure ( addKey != null ) ;
                                                          
                                                         // check object value is really bound
                                                         JavaSDM.ensure ( value != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(addKey.equals (value)) ) ;
                                                          
                                                         // check object getMethod is really bound
                                                         JavaSDM.ensure ( getMethod != null ) ;
                                                          
                                                         // check object addMethod is really bound
                                                         JavaSDM.ensure ( addMethod != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(getMethod.equals (addMethod)) ) ;
                                                          
                                                         // check object referencingClass is really bound
                                                         JavaSDM.ensure ( referencingClass != null ) ;
                                                          
                                                         // check object getKey is really bound
                                                         JavaSDM.ensure ( getKey != null ) ;
                                                          
                                                         // check isomorphic binding
                                                         JavaSDM.ensure ( !(addKey.equals (getKey)) && !(value.equals (getKey)) ) ;
                                                          
                                                         // create object
                                                         qualifiedReference = new QualifiedReferenceAnnotation ( ) ;
                                                          
                                                         // assign statement
                                                         qualifiedReference.setClassification (0);
                                                          
                                                         // create link
                                                         qualifiedReference.addToElements ("field", referencingField);
                                                          
                                                         // create link
                                                         qualifiedReference.addToElements ("references", referencedClass);
                                                          
                                                         // create link
                                                         qualifiedReference.addToElements ("keyParam", addKey);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("referencingField", referencingField);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("value", value);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("getMethod", getMethod);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("addMethod", addMethod);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("referencingClass", referencingClass);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("referencedClass", referencedClass);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("getKey", getKey);
                                                          
                                                         // create link
                                                         qualifiedReference.addToBoundObjects ("addKey", addKey);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      try
                                                      {
                                                         fujaba__Success = false ;
                                                          
                                                         // check object doubleContainerAccess3 is really bound
                                                         JavaSDM.ensure ( doubleContainerAccess3 != null ) ;
                                                          
                                                         // check object qualifiedReference is really bound
                                                         JavaSDM.ensure ( qualifiedReference != null ) ;
                                                          
                                                         // create link
                                                         qualifiedReference.addToAntecedentAnnos (doubleContainerAccess3);
                                                          
                                                         fujaba__Success = true ;
                                                      }
                                                      catch ( JavaSDMException fujaba__InternalException )
                                                      {
                                                         fujaba__Success = false ;
                                                      }
                                                       
                                                      return (qualifiedReference) ;
                                                   }
                                                } //  end for each flow
                                             }
                                             catch ( JavaSDMException fujaba__InternalException )
                                             {
                                             }
                                          }
                                       }
                                       catch ( JavaSDMException fujaba__InternalException )
                                       {
                                       }
                                    }
                                 }
                                 catch ( JavaSDMException fujaba__InternalException )
                                 {
                                 }
                              }
                           }
                           catch ( JavaSDMException fujaba__InternalException )
                           {
                           }
                        }
                     }
                     catch ( JavaSDMException fujaba__InternalException )
                     {
                     }
                  }
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            // check object qualifiedReference is really bound
            JavaSDM.ensure ( qualifiedReference != null ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            try
            {
               fujaba__Success = false ;
                
               // check object asgElement is really bound
               JavaSDM.ensure ( asgElement != null ) ;
                
               // create link
               this.addToFailedApplications ("trigger_DoubleContainerAccess", asgElement);
                
               fujaba__Success = true ;
            }
            catch ( JavaSDMException fujaba__InternalException )
            {
               fujaba__Success = false ;
            }
             
         }
      }
      return (qualifiedReference) ;
   }


   public boolean applicationAlreadyFailed(ASGElement asgElement)
   {
      boolean fujaba__Success = false ;
       
      boolean result = true;
      if ( asgElement instanceof UMLAttr )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("field", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLClass )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("references", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof UMLParam )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("keyParam", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      if ( asgElement instanceof DoubleContainerAccessAnnotation )
      {
         try
         {
            fujaba__Success = false ;
             
            // check object asgElement is really bound
            JavaSDM.ensure ( asgElement != null ) ;
             
            // check To-Many-Link 'failedApplications' between this and asgElement
            JavaSDM.ensure ( this.hasInFailedApplications ("trigger_DoubleContainerAccess", asgElement) ) ;
             
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         if ( fujaba__Success )
         {
         }
         else
         {
            result = false;
         }
      }
      return (result) ;
   }


   public Iterator getTrigger(ASGElement asgElement, String annotation)
   {
      boolean fujaba__Success = false ;
      Iterator fujaba__IterReferencedClassRevParamTypeValue = null ;
      Object fujaba__tmpTypeCastObject = null ;
      UMLAttr referencingField = null ;
      UMLClass referencedClass = null ;
      UMLParam addKey = null ;
      UMLParam value = null ;
       
      TreeSet set = new TreeSet ();
      if ( annotation.equals ("DoubleContainerAccess") )
      {
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLAttr ) ;
             
            // explicit type cast
            referencingField = (UMLAttr) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (referencingField);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLClass ) ;
             
            // explicit type cast
            referencedClass = (UMLClass) fujaba__tmpTypeCastObject ;
             
            // bind value: UMLParam
            fujaba__IterReferencedClassRevParamTypeValue = referencedClass.iteratorOfRevParamType () ;
            while ( fujaba__IterReferencedClassRevParamTypeValue.hasNext () )
            {
               try
               {
                  value = (UMLParam) fujaba__IterReferencedClassRevParamTypeValue.next () ;
                   
                  {
                     //  for each flow
                     set.add (value);
                  } //  end for each flow
               }
               catch ( JavaSDMException fujaba__InternalException )
               {
               }
            }
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
         try
         {
            fujaba__Success = false ;
             
            fujaba__tmpTypeCastObject = asgElement ;
            // ensure correct type and really bound
            JavaSDM.ensure ( fujaba__tmpTypeCastObject instanceof de.uni_paderborn.fujaba.uml.UMLParam ) ;
             
            // explicit type cast
            addKey = (UMLParam) fujaba__tmpTypeCastObject ;
             
            // collabStatBegin 1 is empty !
            set.add (addKey);
             
            // collabStatEnd
            fujaba__Success = true ;
         }
         catch ( JavaSDMException fujaba__InternalException )
         {
            fujaba__Success = false ;
         }
          
      }
      return (set.iterator ()) ;
   }


}
