/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.classloader;

import java.io.File;
import java.lang.reflect.*;
import java.util.*;


/**
 * The main method of this class loads all jars in the current directory and its subdirectories,
 * afterwards it runs the main method of the class specified as first argument of the main
 * method.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.13 $
 */
public class UPBBootstrap
{
   /**
    * The main method of this class loads all jars in the current directory and its subdirectories,
    * afterwards it runs the main method of the class specified as first argument of the main
    * method.
    *
    * @param args  MainClass to run, followed by arguments to the called main method
    */
   public static void main (String[] args)
   {

      //let the UPBClassLoader load from System classpath, too.
      String classPath = System.getProperty ("java.class.path");
      String mainClassName = "de.uni_paderborn.fujaba.app.FujabaApp";
      String jarPath = "-." + File.pathSeparator + "+./libs";
      String classLoaderName = UPBClassLoader.DEFAULT_CLASSLOADER;
      Vector newArgs = new Vector();

      for (int i = 0; i < args.length; i++)
      {
         if (args[i].equals ("-M"))
         {
            // main class is provided as param
            mainClassName = args[++i];
         }
         else if (args[i].equals ("-J"))
         {
            jarPath = args[++i];
         }
         else if (args[i].equals ("-C"))
         {
            classPath = args[++i];
         }
         else if (args[i].equals ("-L"))
         {
            classLoaderName = args[++i];
         }
         else
         {
            newArgs.add (args[i]);
         }
      }

      UPBClassLoader classLoader = UPBClassLoader.get (classLoaderName);
      //set system classloader
      try
      {
         Class cl = ClassLoader.class;
         Field scl = cl.getDeclaredField ("scl");
         scl.setAccessible (true);
         scl.set (null, classLoader);

         /*
          *  Field parent = cl.getDeclaredField ("parent");
          *  parent.setAccessible (true);
          *  parent.set (sysCl, classLoader);
          *  parent.set (classLoader, null);
          */
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }

      //add dirs to classpath
      StringTokenizer token = new StringTokenizer (classPath, File.pathSeparator);
      while (token.hasMoreTokens())
      {
         String dir = token.nextToken();
         classLoader.addClassPath (dir);
         System.out.println ("loading path: " + dir);
      }

      // add libraries to classpath
      token = new StringTokenizer (jarPath, File.pathSeparator);
      while (token.hasMoreTokens())
      {
         String jar = token.nextToken();
         boolean recursive = false;
         if (jar.startsWith ("-"))
         {
            jar = jar.substring (1);
         }
         else if (jar.startsWith ("+"))
         {
            jar = jar.substring (1);
            recursive = true;
         }
         loadJars (new File (jar), recursive, classLoader);
      }

      try
      {
         System.out.println ("Starting " + mainClassName);
         Class[] paramTypes = {String[].class};
         Class cls = classLoader.loadClass (mainClassName);
         Method mainMethod = cls.getMethod ("main", paramTypes);
         Object[] params = {newArgs.toArray (new String[0])};
         mainMethod.invoke (null, params);
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }


   /**
    * Add all jars in the directory to the UPBClassLoader path
    *
    * @param libsDir    directory to search
    * @param recursive  when true all subdirectories are processed too
    * @param loader     UPBClassLoader that should load the jars
    */
   public static void loadJars (File libsDir, boolean recursive, UPBClassLoader loader)
   {
      String[] files = libsDir.list();
      if (files != null)
      {
         for (int i = 0; i < files.length; ++i)
         {
            File file = new File (libsDir, files[i]);
            if (files[i].endsWith (".jar"))
            {
               String libname = file.getAbsolutePath();
               System.out.println ("loading jar : " + libname);
               loader.addClassPath (libname);
            }
            else if (recursive && file.isDirectory())
            {
               loadJars (file, true, loader);
            }
         }
      }
   }
}

/*
 * $Log: UPBBootstrap.java,v $
 * Revision 1.13  2004/04/26 15:45:18  lowende
 * Better readable error mesages in sax parser.
 *
 */
