/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.classloader;



/**
 * stores the byte code of the classes which are handled by the UPBClassLoader
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.5 $
 * @see       de.uni_paderborn.lib.classloader.UPBClassLoader
 */
public class UPBByteCode
{
   /**
    * stores the byte code of a class.
    *
    * @see   UPBByteCode#setCode
    * @see   UPBByteCode#getCode
    */
   private byte[] code = null;

   /**
    * the full qualified class name.
    *
    * @see   UPBByteCode#setClassName
    * @see   UPBByteCode#getClassName
    */
   private String className = null;


   /**
    * The default constructor is empty.
    */
   public UPBByteCode() { }


   /**
    * access method to get the full qualified class name.
    *
    * @return   the full qualified class name
    * @see      UPBByteCode#className
    */
   public String getClassName()
   {
      return className;
   }


   /**
    * set the full qualified class name. this method is called by the UPBClassLoader.
    *
    * @param className  the new class name
    * @return           the value of the attribute className
    * @see              UPBByteCode#className
    */
   public String setClassName (String className)
   {
      if ( (this.className == null) ||
          (this.className != null &&
         !this.className.equals (className)))
      {
         this.className = className;
      } // if
      return this.className;
   }


   /**
    * access method to get the byte code of the class.
    *
    * @return   the byte code of this class
    * @see      UPBByteCode#code
    */
   public byte[] getCode()
   {
      return code;
   }


   /**
    * set the byte code of the class.
    *
    * @param code  the new byte code
    * @return      the value of the attribute code
    * @see         UPBByteCode#code
    */
   public byte[] setCode (byte[] code)
   {
      if (this.code != code)
      {
         this.code = code;
      } // if

      return this.code;
   }


   /**
    * left role of the 'classes' assoziation between UPBClassLoader and UPBByteCode. <pre>
    *                ------------- 0..1   classes   0..1
    * UPBClassLoader | className |----------------------- UPBByteCode
    *                ------------- loader        classes
    * </pre>
    *
    * @see   UPBByteCode#setLoader
    * @see   UPBByteCode#getLoader
    */
   private UPBClassLoader loader;


   /**
    * set the parent class loader.
    *
    * @param value  the new class loader
    * @return       true if the loader was changed
    * @see          UPBByteCode#loader
    */
   public boolean setLoader (UPBClassLoader value)
   {
      boolean changed = false;
      if (this.loader != value)
      {
         if (this.loader != null)
         {
            UPBClassLoader oldValue = this.loader;
            this.loader = null;
            oldValue.removeFromClasses (this);
         }
         this.loader = value;
         if (value != null)
         {
            value.addToClasses (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * get the parent class loader.
    *
    * @return   the parent class loader
    * @see      UPBByteCode#loader
    */
   public UPBClassLoader getLoader()
   {
      return this.loader;
   }


   /**
    * access method to remove all references so that the garbage collector can free this object.
    */
   public void removeYou()
   {
      UPBClassLoader tmpLoader = getLoader();
      if (tmpLoader != null)
      {
         setLoader (null);
      } // if
   }
}

/*
 * $Log: UPBByteCode.java,v $
 * Revision 1.5  2004/07/27 07:58:49  lowende
 * Javadoc corrected.
 *
 */
