/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.java.io;

import java.io.*;


/**
 * Implementation of a file filter for property files.
 *
 * @author    student research group Reddmom
 * @version   $Revision: 1.7 $
 */
public class PropertyFileFilter implements FileFilter
{
   /**
    * PROPERTY_SUFFIX = ".properties". A property file always ends with the suffix ".properties".
    */
   public final static String PROPERTY_SUFFIX = ".properties";


   /**
    * The default constructor is empty.
    */
   public PropertyFileFilter() { }


   /**
    * Overrides the method accept of the interface FileFilter. The name of the parameter pathName
    * must end with with the property suffix.
    *
    * @param pathName  which is analyzed.
    * @return          true if the given file is a file and its name ends with PROPERTY_SUFFIX.
    * @see             PropertyFileFilter#PROPERTY_SUFFIX
    */
   public boolean accept (File pathName)
   {
      return  (pathName != null &&
         pathName.isFile() &&
         pathName.getName() != null &&
         pathName.getName().endsWith (PROPERTY_SUFFIX));
   }


   /**
    * Returns the name of the file without the PROPERTY_SUFFIX.
    *
    * @param file  the given file
    * @return      the file name without the suffix as string.
    * @see         PropertyFileFilter#PROPERTY_SUFFIX
    */
   public String cutExtension (File file)
   {
      String fileName = null;
      int cutPos = 0;

      if (accept (file))
      {
         fileName = file.getPath();
         cutPos = fileName.indexOf (PROPERTY_SUFFIX);
         fileName = fileName.substring (0, cutPos);
      } // end of if ()
      return fileName;
   }

}

/*
 * $Log: PropertyFileFilter.java,v $
 * Revision 1.7  2004/08/02 07:34:12  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
