/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.uni_paderborn.lib.javax.swing.table;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;


/**
 * an implementation of the TableCellEditor interface.
 *
 * @author    Fujaba Development Group
 * @version   $Revision: 1.5 $
 * @see       javax.swing.CellEditor
 */
public class CheckBoxCellEditor extends BasicTableCellEditor
{
   /**
    * shows the current boolean value.
    */
   private JCheckBox checkbox = new JCheckBox();

   /**
    * the root label of the editor. This instance is returned by getTableCellEditorComponent.
    *
    * @see   CheckBoxCellEditor#getTableCellEditorComponent
    * @see   javax.swing.table.TableCellEditor#getTableCellEditorComponent
    */
   private JLabel label = new JLabel();

   /**
    * is needed to center the checkbox.
    */
   private JLabel left = new JLabel();

   /**
    * is needed to center the checkbox.
    */
   private JLabel right = new JLabel();


   /**
    * initializes the components of this editor.
    */
   public CheckBoxCellEditor()
   {
      GridBagLayout gridbag = new GridBagLayout();
      label.setLayout (gridbag);

      GridBagConstraints constraints = new GridBagConstraints();
      constraints.fill = GridBagConstraints.BOTH;
      constraints.anchor = GridBagConstraints.CENTER;
      constraints.gridwidth = 1;
      constraints.weightx = 1;
      constraints.weighty = 0;
      constraints.gridx = 0;
      constraints.gridy = 0;
      constraints.insets = new Insets (2, 0, 2, 0);

      left.setOpaque (true);
      label.add (left, constraints);

      checkbox.addActionListener (createCheckBoxListener());
      constraints.weightx = 0;
      constraints.gridx = 1;
      label.add (checkbox, constraints);

      constraints.weightx = 1;
      constraints.gridx = 2;
      right.setOpaque (true);
      label.add (right, constraints);

   }


   /**
    * overrides getTableCellEditorComponent of the interface TableCellEditor.
    *
    * @param table       the table of the editor
    * @param value       the value which must be edited
    * @param isSelected  is the cell selected ?
    * @param row         the current row in the table
    * @param column      the current column in the table
    * @return            the editor component
    * @see               javax.swing.table.TableCellEditor#getTableCellEditorComponent
    */
   public Component getTableCellEditorComponent (JTable table,
                                                 Object value,
                                                 boolean isSelected,
                                                 int row,
                                                 int column)
   {
      label.setBackground (table.getSelectionBackground());
      left.setBackground (label.getBackground());
      checkbox.setBackground (label.getBackground());
      right.setBackground (label.getBackground());

      checkbox.setSelected ( ((Boolean) value).booleanValue());

      return label;
   }


   /**
    * overrides getCellEditorValue of the interface TableCellEditor.
    *
    * @return   the editor value
    * @see      javax.swing.CellEditor#getCellEditorValue
    * @see      javax.swing.CellEditor
    */
   public Object getCellEditorValue()
   {
      return new Boolean (checkbox.isSelected());
   }


   /**
    * internal used listener to get changes from the internal used check box. This method is
    * called by the standard constructor of this class.
    *
    * @return   the ActionListener for the checkbox.
    */
   private ActionListener createCheckBoxListener()
   {
      ActionListener listener =
         new ActionListener()
         {
            public void actionPerformed (ActionEvent event)
            {
               stopCellEditing();
            }
         };
      return listener;
   }

}

/*
 * $Log: CheckBoxCellEditor.java,v $
 * Revision 1.5  2004/08/02 07:34:13  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
