/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.plugins;




/**
 * The interface for an application plugin.
 *
 * @author    Student research group Fujaba
 * @version   $Revision: 1.10 $
 */
public interface PluginInterface
{
   /**
    * Returns the plugins initialization path.
    *
    * @return       The initialization path
    * @deprecated   use public String getInstallationPath()
    */
   public String getInitializationPath();


   /**
    * Get the installationPath attribute of the PluginInterface object
    *
    * @return   The installationPath value
    */
   public String getInstallationPath();


   /**
    * Sets the initialitization path of the plugin.
    *
    * @param initPath  the new initialization path for the plugin.
    * @deprecated      use public void setInstallationPath(String newPath)
    */
   public void setInitializationPath (String initPath);


   /**
    * Sets the installationPath attribute of the PluginInterface object
    *
    * @param installationPath  The new installationPath value
    */
   public void setInstallationPath (String installationPath);


   /**
    * Get the key attribute of the PluginInterface object
    *
    * @return   The key value
    */
   public String getKey();


   /**
    * Sets the key attribute of the PluginInterface object
    *
    * @param key  The new key value
    */
   public void setKey (String key);


   /**
    * Initialize the plugin after creation. All properties as initialization path have to be
    * set before this method is called.
    *
    * @return   true if the initialization was successfull
    */
   public boolean initialize();


   /**
    * Terminate the plugin before application exit.
    */
   public void terminate();

}

/*
 * $Log: PluginInterface.java,v $
 * Revision 1.10  2004/08/02 07:34:14  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
