/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.upb.lib.plugins;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author$
 * @version   $Revision$ $Date$
 */
public class PluginList
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name;


   /**
    * Get the name attribute of the PluginList object
    *
    * @return   The name value
    */
   public String getName()
   {
      return this.name;
   }


   /**
    * Sets the name attribute of the PluginList object
    *
    * @param value  The new name value
    */
   public void setName (String value)
   {
      if (this.name != value)
      {

         this.name = value;

      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String url;


   /**
    * Get the url attribute of the PluginList object
    *
    * @return   The url value
    */
   public String getUrl()
   {
      return this.url;
   }


   /**
    * Sets the url attribute of the PluginList object
    *
    * @param value  The new url value
    */
   public void setUrl (String value)
   {
      if (this.url != value)
      {

         this.url = value;

      }
   }


   /**
    * If an error occured parsing this plugin list
    * it will be stored in here, so it can be displayed
    * in the GUI. If no error occured, this attribute is null.
    */
   private Exception parseException;


   /**
    * Get the parseException attribute of the PluginList object
    *
    * @return   The parseException value
    */
   public Exception getParseException()
   {
      return this.parseException;
   }


   /**
    * Sets the parseException attribute of the PluginList object
    *
    * @param value  The new parseException value
    */
   public void setParseException (Exception value)
   {
      if (this.parseException != value)
      {

         this.parseException = value;

      }
   }

}

/*
 * $Log$
 * Revision 1.1  2006/02/07 17:04:13  lowende
 * Applied patch send by Felix Klar: Connection error handling in plugin download dialog enhanced.
 *
 */
