/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.userinterface;

import java.util.Iterator;

import de.upb.tools.fca.*;


/**
 * <h2>Associations</h2> <pre>
 *                  ------ 0..1        sections         0..1
 * SectionContainer | id |----------------------------------- Section
 *                  ------ container   {ordered}    sections
 *
 *         ------ 0..1       items        0..1
 * Section | id |------------------------------ SectionItem
 *         ------ section   {ordered}    items
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.7 $
 */
/*
 *  package
 */
class Section
{
   /**
    * Constructor for class Section
    *
    * @param id  No description provided
    */
   public Section (String id)
   {
      this.id = id;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String id;


   /**
    * Get the id attribute of the Section object
    *
    * @return   The id value
    */
   public String getId()
   {
      return this.id;
   }


   /**
    * Sets the id attribute of the Section object
    *
    * @param newId  The new id value
    */
   public void setId (String newId)
   {
      if ( (this.id == null) ||  (this.id != null && !this.id.equals (newId)))
      {
         this.id = newId;
      }
   }


   /**
    * <pre>
    *                  ------ 0..1        sections         0..1
    * SectionContainer | id |----------------------------------- Section
    *                  ------ container   {ordered}    sections
    * </pre>
    */
   private SectionContainer container;


   /**
    * Sets the container attribute of the Section object
    *
    * @param value  The new container value
    * @return       No description provided
    */
   public boolean setContainer (SectionContainer value)
   {
      boolean changed = false;
      if (this.container != value)
      {
         if (this.container != null)
         {
            SectionContainer oldValue = this.container;
            this.container = null;
            oldValue.removeFromSections (this);
         }
         this.container = value;
         if (value != null)
         {
            value.addToSections (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * Get the container attribute of the Section object
    *
    * @return   The container value
    */
   public SectionContainer getContainer()
   {
      return this.container;
   }


   /**
    * <pre>
    *         ------ 0..1       items        0..1
    * Section | id |------------------------------ SectionItem
    *         ------ section   {ordered}    items
    * </pre>
    */
   private FHashMap items;


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToItems (SectionItem value)
   {
      boolean changed = false;
      if ( (value != null) &&  (value.getId() != null))
      {
         if (this.items == null)
         {
            this.items = new FHashMap();
         }
         SectionItem oldValue = (SectionItem) this.items.put (value.getId(), value);
         if (oldValue != value)
         {
            if (oldValue != null)
            {
               oldValue.setSection (null);
            }
            value.setSection (this);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInItems (SectionItem value)
   {
      return  ( (this.items != null) &&
          (value != null) &&  (value.getId() != null) &&
          (this.items.get (value.getId()) == value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean hasKeyInItems (String key)
   {
      return  ( (this.items != null) &&
          (key != null) &&
         this.items.containsKey (key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfItems()
   {
      return  ( (this.items == null)
         ? FEmptyIterator.get()
         : this.items.values().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator keysOfItems()
   {
      return  ( (this.items == null)
         ? FEmptyIterator.get()
         : this.items.keySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator entriesOfItems()
   {
      return  ( (this.items == null)
         ? FEmptyIterator.get()
         : this.items.entrySet().iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfItems()
   {
      return  ( (this.items == null)
         ? 0
         : this.items.size());
   }


   /**
    * Get the fromItems attribute of the Section object
    *
    * @param key  No description provided
    * @return     The fromItems value
    */
   public SectionItem getFromItems (String key)
   {
      return  ( ( (this.items == null) ||  (key == null))
         ? null
         : (SectionItem) this.items.get (key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromItems (SectionItem value)
   {
      boolean changed = false;
      if ( (this.items != null) &&  (value != null) &&  (value.getId() != null))
      {
         SectionItem oldValue = (SectionItem) this.items.get (value.getId());
         if (oldValue == value)
         {
            this.items.remove (value.getId());
            value.setSection (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public boolean removeKeyFromItems (String key)
   {
      boolean changed = false;
      if ( (this.items != null) &&  (key != null))
      {
         SectionItem tmpValue = (SectionItem) this.items.get (key);
         if (tmpValue != null)
         {
            this.items.remove (key);
            tmpValue.setSection (null);
            changed = true;
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromItems()
   {
      SectionItem tmpValue;
      Iterator iter = this.iteratorOfItems();
      while (iter.hasNext())
      {
         tmpValue = (SectionItem) iter.next();
         this.removeFromItems (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      removeAllFromItems();

      SectionContainer tmpContainer = getContainer();
      if (tmpContainer != null)
      {
         setContainer (null);
      }
   }

}

/*
 * $Log: Section.java,v $
 * Revision 1.7  2004/08/02 07:34:15  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
