/*
 * The FUJABA [Just Draw It!] project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2002 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: fujaba@upb.de
 *
 */
package de.upb.lib.userinterface;

import javax.swing.JComponent;


/**
 * <h2>Associations</h2> <pre>
 *         ------ 0..1       items        0..1
 * Section | id |------------------------------ SectionItem
 *         ------ section   {ordered}    items
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.6 $
 */
/*
 *  package
 */
abstract class SectionItem
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract JComponent generateComponent();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String id = "";


   /**
    * Get the id attribute of the SectionItem object
    *
    * @return   The id value
    */
   public String getId()
   {
      return this.id;
   }


   /**
    * Sets the id attribute of the SectionItem object
    *
    * @param newId  The new id value
    */
   public void setId (String newId)
   {
      if ( (this.id == null) ||  (this.id != null && !this.id.equals (newId)))
      {
         this.id = newId;
      }
   }


   /**
    * <pre>
    *         ------ 0..1       items        0..1
    * Section | id |------------------------------ SectionItem
    *         ------ section   {ordered}    items
    * </pre>
    */
   private Section section;


   /**
    * Sets the section attribute of the SectionItem object
    *
    * @param value  The new section value
    * @return       No description provided
    */
   public boolean setSection (Section value)
   {
      boolean changed = false;
      if (this.section != value)
      {
         if (this.section != null)
         {
            Section oldValue = this.section;
            this.section = null;
            oldValue.removeFromItems (this);
         }
         this.section = value;
         if (value != null)
         {
            value.addToItems (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * Get the section attribute of the SectionItem object
    *
    * @return   The section value
    */
   public Section getSection()
   {
      return this.section;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      Section tmpSection = getSection();
      if (tmpSection != null)
      {
         setSection (null);
      }
   }

}

/*
 * $Log: SectionItem.java,v $
 * Revision 1.6  2004/08/02 07:34:15  lowende
 * Getter method for class loader chain of UPBClassloader added. Javadoc corrected.
 *
 */
